/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.mservice.formula.single.param;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Row;
import kd.fi.ict.enums.PuchType;
import kd.fi.ict.mservice.formula.common.facct.AcctFetchType;

public class FormulaParam {
    private String key;
    private String fetchType;
    private AcctFetchType.AmtCaluatorField formulaCalulator;
    private BigDecimal amtResult;
    private String formulaDc;
    private boolean isBalDc;
    private boolean isReclass;
    private boolean isLeafAcctSum;
    private boolean isJBal;
    private Map<String, BigDecimal> leafAcctToAmtMap = new HashMap<String, BigDecimal>(32);
    private Map<String, Integer> leafAcctToStyleMap;
    private boolean contraAccount = false;
    Map<Map<String, Object>, BigDecimal> assgrpToAmountMap = new HashMap<Map<String, Object>, BigDecimal>(64);
    private Set<String> allFlexs = new HashSet<String>(8);

    public FormulaParam(String key, PuchType puchType, String fetchType, int acctReClass, String formulaDc, Set<String> allFlexs, Map<String, Integer> leafAcctToStyleMap, boolean isBaseCurrency) {
        this.key = key;
        this.fetchType = fetchType;
        if (AcctFetchType.getFetchTypeField().containsKey(PuchType.getPrefix((PuchType)puchType) + this.fetchType) || isBaseCurrency) {
            this.formulaCalulator = AcctFetchType.getAmtFieldByType(puchType, fetchType, isBaseCurrency);
        } else {
            this.fetchType = fetchType;
            this.formulaCalulator = AcctFetchType.getFetchTypeForField().get(PuchType.getPrefix((PuchType)puchType) + this.fetchType);
        }
        this.formulaDc = formulaDc;
        this.allFlexs = allFlexs;
        this.isReclass = AcctFetchType.getFetchTypeReclass().contains(fetchType);
        if (this.isReclass) {
            this.leafAcctToStyleMap = leafAcctToStyleMap;
            this.isLeafAcctSum = acctReClass == 4 || acctReClass == 5;
            this.isJBal = !AcctFetchType.getFetchTypeD().contains(fetchType);
        }
        this.isBalDc();
    }

    private void isBalDc() {
        this.isBalDc = AcctFetchType.getFetchType_y().contains(this.fetchType);
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getFetchType() {
        return this.fetchType;
    }

    public void setFetchType(String fetchType) {
        this.fetchType = fetchType;
    }

    private void isContraAccount(String contraAccount) {
        if ("Y".equalsIgnoreCase(contraAccount)) {
            this.contraAccount = true;
        }
    }

    public void setAllFlexs(Set<String> allFlexs) {
        this.allFlexs = allFlexs;
    }

    public void addValue(Row rowData) {
        this.amtResult = this.amtResult == null ? new BigDecimal("0") : this.amtResult;
        BigDecimal amtRow = AcctFetchType.rowCountByFetchType(rowData, this.formulaCalulator);
        if (this.isReclass) {
            this.reClassAmt(rowData, amtRow);
        } else {
            this.amtResult = this.amtResult.add(amtRow);
        }
    }

    private void reClassAmt(Row rowData, BigDecimal amtRow) {
        String leafAcctId = rowData.getString("account");
        int assistStyle = this.leafAcctToStyleMap.get(leafAcctId);
        if (this.contraAccount) {
            HashMap<String, Object> flexMap = new HashMap<String, Object>(8);
            if (assistStyle == 1) {
                BigDecimal amtAcct = this.leafAcctToAmtMap.computeIfAbsent(leafAcctId, x -> new BigDecimal("0"));
                amtAcct = amtAcct.add(amtRow);
                this.leafAcctToAmtMap.put(leafAcctId, amtAcct);
            } else {
                if (assistStyle == 2) {
                    for (String f : this.allFlexs) {
                        Object fval = rowData.get(f);
                        flexMap.put(f, fval);
                    }
                } else if (assistStyle == 3) {
                    long hgId = rowData.getLong("hg");
                    flexMap.put(hgId + "", null);
                }
                BigDecimal bigDecimal = this.assgrpToAmountMap.computeIfAbsent(flexMap, x -> new BigDecimal("0"));
                bigDecimal = bigDecimal.add(amtRow);
                this.assgrpToAmountMap.put(flexMap, bigDecimal);
            }
        } else if (assistStyle == 1) {
            BigDecimal amtAcct = this.leafAcctToAmtMap.computeIfAbsent(leafAcctId, x -> new BigDecimal("0"));
            amtAcct = amtAcct.add(amtRow);
            this.leafAcctToAmtMap.put(leafAcctId, amtAcct);
        } else if (assistStyle == 2) {
            if (this.isLeafAcctSum) {
                BigDecimal amtAcct = this.leafAcctToAmtMap.computeIfAbsent(leafAcctId, x -> new BigDecimal("0"));
                amtAcct = amtAcct.add(amtRow);
                this.leafAcctToAmtMap.put(leafAcctId, amtAcct);
            } else if (this.isJBal) {
                if (amtRow.compareTo(BigDecimal.ZERO) > 0) {
                    this.amtResult = this.amtResult.add(amtRow);
                }
            } else if (amtRow.compareTo(BigDecimal.ZERO) < 0) {
                this.amtResult = this.amtResult.add(amtRow);
            }
        } else if (assistStyle == 3) {
            if (this.isJBal) {
                if (amtRow.compareTo(BigDecimal.ZERO) > 0) {
                    this.amtResult = this.amtResult.add(amtRow);
                }
            } else if (amtRow.compareTo(BigDecimal.ZERO) < 0) {
                this.amtResult = this.amtResult.add(amtRow);
            }
        }
    }

    public Object getAmtResult() {
        if (this.amtResult == null) {
            if (this.leafAcctToAmtMap.isEmpty() && this.assgrpToAmountMap.isEmpty()) {
                return null;
            }
            this.amtResult = new BigDecimal("0");
        }
        this.reClassSum();
        if (this.isBalDc) {
            this.amtResult = this.amtResult.multiply(new BigDecimal(this.formulaDc));
        }
        return this.amtResult;
    }

    private void reClassSum() {
        Collection<BigDecimal> amountColl = this.leafAcctToAmtMap.values();
        ArrayList<BigDecimal> amountList = new ArrayList<BigDecimal>(amountColl);
        amountList.addAll(this.assgrpToAmountMap.values());
        for (BigDecimal amount : amountList) {
            if (this.isJBal && amount.compareTo(BigDecimal.ZERO) > 0) {
                this.amtResult = this.amtResult.add(amount);
                continue;
            }
            if (this.isJBal || amount.compareTo(BigDecimal.ZERO) >= 0) continue;
            this.amtResult = this.amtResult.add(amount);
        }
        if (this.isReclass && !this.isJBal) {
            this.amtResult = this.amtResult.negate();
        }
    }
}

