/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.mservice.statistics;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.fi.ict.business.statistics.StatisticsCache;
import kd.fi.ict.business.statistics.StatisticsType;
import kd.fi.ict.business.statistics.VerifyStatistics;
import kd.fi.ict.business.statistics.VerifyStatisticsParam;
import kd.fi.ict.business.statistics.VerifyStatisticsRow;
import kd.fi.ict.enums.VerifyType;
import kd.fi.ict.service.statistics.VerifyStatisticsService;

public class VerifyStatisticsServiceImpl
implements VerifyStatisticsService {
    public static final String ACCOUNT_KEY = "account";
    public static final String CASH_FLOW_KEY = "cash_flow";
    public static final String DIFF_AMOUNT_KEY = "diff_amount";
    public static final String DIFF_COUNT_KEY = "diff_count";
    public static final String RESULT_KEY = "result";

    public String getVerifyStatistics(long orgId, long accountTableId, long periodId) {
        HashMap<String, Map<Long, Map<String, Object>>> resultMap = new HashMap<String, Map<Long, Map<String, Object>>>(2);
        resultMap.put(ACCOUNT_KEY, this.toResult(StatisticsCache.updateStatisticsCacheData((VerifyStatisticsParam)this.getParam(orgId, accountTableId, periodId, VerifyType.ACCT)).getVerifyStatistics()));
        resultMap.put(CASH_FLOW_KEY, this.toResult(StatisticsCache.updateStatisticsCacheData((VerifyStatisticsParam)this.getParam(orgId, accountTableId, periodId, VerifyType.CF)).getVerifyStatistics()));
        return SerializationUtils.toJsonString(resultMap);
    }

    private VerifyStatisticsParam getParam(long orgId, long accountTableId, long periodId, VerifyType type) {
        VerifyStatisticsParam param = new VerifyStatisticsParam();
        param.setOrgId(orgId);
        param.setAccountTableId(accountTableId);
        param.setPeriodId(periodId);
        param.setVerifyType(type);
        return param;
    }

    private Map<Long, Map<String, Object>> toResult(VerifyStatistics statistics) {
        Map verifyStatisticsRows = statistics.getVerifyStatisticsRows();
        HashMap<Long, Map<String, Object>> resultMap = new HashMap<Long, Map<String, Object>>(verifyStatisticsRows.size());
        for (Map.Entry entry : verifyStatisticsRows.entrySet()) {
            HashMap<String, Comparable<BigDecimal>> detailMap = new HashMap<String, Comparable<BigDecimal>>(2);
            VerifyStatisticsRow value = (VerifyStatisticsRow)entry.getValue();
            BigDecimal diff_amount = ((BigDecimal)value.getDifferentData().get(StatisticsType.AMOUNT)).abs();
            BigDecimal diff_count = ((BigDecimal)value.getDifferentData().get(StatisticsType.COUNT)).abs();
            detailMap.put(DIFF_AMOUNT_KEY, diff_amount);
            detailMap.put(DIFF_COUNT_KEY, diff_count);
            detailMap.put(RESULT_KEY, Boolean.valueOf(diff_amount.compareTo(BigDecimal.ZERO) == 0 && diff_count.compareTo(BigDecimal.ZERO) == 0));
            resultMap.put((Long)entry.getKey(), (Map<String, Object>)detailMap);
        }
        return resultMap;
    }
}

