/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.mservice.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.ict.mservice.AcctAmtQueryParam;
import kd.fi.ict.puchamt.AcctPuchAmtQueryExecutor;
import kd.fi.ict.puchamt.acct.AcctPuchAmtQueryParam;
import kd.fi.ict.report.ReportUtils;

public class AcctAndAssistHelper {
    private Log log = LogFactory.getLog((String)this.getClass().getName());

    public DataSet getAssFilterAndAssDs(String sels, AcctAmtQueryParam param, Map<Long, List<Map<String, Long>>> accountAssgrp, Map<String, Object> deriveMap) {
        if (accountAssgrp == null) {
            accountAssgrp = new HashMap<Long, List<Map<String, Long>>>();
        }
        Map<String, Set<Long>> flexToIdsMap = this.collectFlexsAndVal(accountAssgrp);
        HashMap<Map<String, Long>, Set<Long>> flexsAcctIdsMap = new HashMap<Map<String, Long>, Set<Long>>();
        this.putFlexsToDsMap(accountAssgrp, flexToIdsMap, flexsAcctIdsMap);
        Map<Set<String>, Set<Long>> allFlexsToLeafAcctMap = this.getLeafAcctByFlexs(flexsAcctIdsMap, param);
        this.log.info("\u4f59\u989d\u8868\u53d6\u6570accountAssgrp\uff1a" + accountAssgrp.toString());
        this.log.info("\u4f59\u989d\u8868\u53d6\u6570flexToIdsMap\uff1a" + flexToIdsMap.toString());
        this.log.info("\u4f59\u989d\u8868\u53d6\u6570flexsAcctIdsMap\uff1a" + ((Object)flexsAcctIdsMap).toString());
        this.log.info("\u4f59\u989d\u8868\u53d6\u6570allFlexsToLeafAcctMap: " + allFlexsToLeafAcctMap.toString());
        DataSet resultSet = this.joinAssistSet(param, sels, allFlexsToLeafAcctMap, flexsAcctIdsMap, deriveMap, flexToIdsMap);
        return resultSet;
    }

    private DataSet joinAssistSet(AcctAmtQueryParam param, String sels, Map<Set<String>, Set<Long>> allFlexsToLeafAcctMap, Map<Map<String, Long>, Set<Long>> flexsAcctIdsMap, Map<String, Object> deriveMap, Map<String, Set<Long>> flexToIdsMap) {
        Map<String, DataSet> flexToDSMap = this.putFlexToDSMap(flexToIdsMap);
        Set<String> allFlexs = flexToIdsMap.keySet();
        DataSet resultSet = null;
        List resultList = new ArrayList();
        String acctKey = (String)deriveMap.get("aliasAcct");
        String hgKey = (String)deriveMap.get("aliasAssgrp");
        for (Map.Entry<Set<String>, Set<Long>> allFlexEntry : allFlexsToLeafAcctMap.entrySet()) {
            Set<String> allFlexsSet = allFlexEntry.getKey();
            Set<Long> leafAcctSet = allFlexEntry.getValue();
            AcctPuchAmtQueryParam queryParam = param.toQueryParam(sels);
            AcctPuchAmtQueryParam.AcctParam acctParam = queryParam.getAcctParam();
            acctParam.setAccountFilter(new QFilter("id", "in", leafAcctSet));
            acctParam.setSpecialAccount(false);
            acctParam.setOnlyLeafAcctAmt(false);
            DataSet balanceSet = this.queryBalance(queryParam);
            List balList = ReportUtils.getSetField((DataSet)balanceSet);
            for (Map.Entry<Map<String, Long>, Set<Long>> entry : flexsAcctIdsMap.entrySet()) {
                Map<String, Long> flexMap = entry.getKey();
                Set<Long> acctIds = entry.getValue();
                Set<String> flexs = flexMap.keySet();
                if (!allFlexsSet.equals(flexs) || acctIds == null || acctIds.isEmpty()) continue;
                HashMap<String, Set<Long>> acctIdsMap = new HashMap<String, Set<Long>>();
                acctIdsMap.put("acctIds", acctIds);
                DataSet assistBalSet = balanceSet.filter(acctKey + " in acctIds", acctIdsMap);
                if (flexMap.isEmpty()) {
                    assistBalSet = assistBalSet.addNullField(allFlexs.toArray(new String[0]));
                } else {
                    for (Map.Entry<String, Long> entry2 : flexMap.entrySet()) {
                        JoinType joinType;
                        String flex = entry2.getKey();
                        DataSet flexSet = flexToDSMap.get(flex);
                        if (entry2.getValue() != null) {
                            flexSet = flexSet.filter(flex + "=" + entry2.getValue());
                            joinType = JoinType.INNER;
                        } else {
                            joinType = JoinType.LEFT;
                        }
                        List balFields = ReportUtils.getSetField((DataSet)assistBalSet);
                        assistBalSet = assistBalSet.join(flexSet, joinType).on(hgKey, "id").select(balFields.toArray(new String[0]), new String[]{flex}).finish();
                    }
                    ArrayList<String> selNull = new ArrayList<String>(balList.size() + flexs.size());
                    selNull.addAll(balList);
                    for (String flex : flexs) {
                        selNull.add("case when " + flex + "=null then 0L else " + flex + " end as " + flex);
                    }
                    assistBalSet = assistBalSet.select(selNull.toArray(new String[0]));
                    ArrayList<String> arrayList = new ArrayList<String>();
                    arrayList.addAll(allFlexs);
                    arrayList.removeAll(flexs);
                    assistBalSet = assistBalSet.addNullField(arrayList.toArray(new String[0]));
                }
                if (resultSet != null) {
                    if (resultList.isEmpty()) {
                        resultList = ReportUtils.getSetField((DataSet)resultSet);
                    }
                    assistBalSet = assistBalSet.select(resultList.toArray(new String[0]));
                    resultSet = resultSet.union(assistBalSet);
                    continue;
                }
                resultSet = assistBalSet;
            }
        }
        return resultSet;
    }

    private DataSet queryBalance(AcctPuchAmtQueryParam queryParam) {
        DataSet balanceSet = AcctPuchAmtQueryExecutor.getInstance().getPuchAmt(queryParam);
        return balanceSet;
    }

    public Long[] toLongArray(long[] values) {
        Long[] value = new Long[values.length];
        for (int i = 0; i < values.length; ++i) {
            value[i] = values[i];
        }
        return value;
    }

    private Map<String, Set<Long>> collectFlexsAndVal(Map<Long, List<Map<String, Long>>> accountAssgrp) {
        HashMap<String, Set<Long>> flexToIdsMap = new HashMap<String, Set<Long>>();
        for (Map.Entry<Long, List<Map<String, Long>>> entry : accountAssgrp.entrySet()) {
            List<Map<String, Long>> listFlexs = entry.getValue();
            if (listFlexs == null) continue;
            for (Map<String, Long> map : listFlexs) {
                for (Map.Entry<String, Long> entryFlex : map.entrySet()) {
                    String flex = entryFlex.getKey();
                    if (flexToIdsMap.get(flex) == null) {
                        HashSet<Long> ids = new HashSet<Long>();
                        if (entryFlex.getValue() != null && entryFlex.getValue() != 0L) {
                            ids.add(entryFlex.getValue());
                        }
                        flexToIdsMap.put(flex, ids);
                        continue;
                    }
                    if (((Set)flexToIdsMap.get(flex)).isEmpty()) continue;
                    if (entryFlex.getValue() != null && entryFlex.getValue() != 0L) {
                        ((Set)flexToIdsMap.get(flex)).add(entryFlex.getValue());
                        continue;
                    }
                    flexToIdsMap.put(flex, new HashSet());
                }
            }
        }
        return flexToIdsMap;
    }

    private Map<Set<String>, Set<Long>> flexsToAcct(Map<Map<String, Long>, Set<Long>> flexsAcctIdsMap) {
        HashMap<Set<String>, Set<Long>> flexsToAcctMap = new HashMap<Set<String>, Set<Long>>();
        for (Map.Entry<Map<String, Long>, Set<Long>> entry : flexsAcctIdsMap.entrySet()) {
            Set<String> flexs = entry.getKey().keySet();
            Set acctIds = flexsToAcctMap.computeIfAbsent(flexs, x -> new HashSet());
            acctIds.addAll((Collection)entry.getValue());
        }
        return flexsToAcctMap;
    }

    private Map<Set<String>, Set<Long>> getLeafAcctByFlexs(Map<Map<String, Long>, Set<Long>> flexsAcctIdsMap, AcctAmtQueryParam param) {
        if (flexsAcctIdsMap.isEmpty()) {
            return new HashMap<Set<String>, Set<Long>>();
        }
        long orgId = param.getOrgIds() != null && param.getOrgIds().length > 0 ? param.getOrgIds()[0].longValue() : param.getOrgId();
        Map<Set<String>, Set<Long>> flexsToAcctMap = this.flexsToAcct(flexsAcctIdsMap);
        HashSet allFlexs = new HashSet();
        HashSet<Long> allAcctIds = new HashSet<Long>();
        for (Map.Entry<Set<String>, Set<Long>> entry : flexsToAcctMap.entrySet()) {
            allFlexs.addAll(entry.getKey());
            allAcctIds.addAll((Collection)entry.getValue());
        }
        DynamicObjectCollection acttypeColl = QueryServiceHelper.query((String)"bd_asstacttype", (String)"id,flexfield", (QFilter[])new QFilter("flexfield", "in", allFlexs).toArray());
        HashMap<String, Long> typeMap = new HashMap<String, Long>();
        for (DynamicObject acttype : acttypeColl) {
            typeMap.put(acttype.getString("flexfield"), acttype.getLong("id"));
        }
        HashMap<Long, Set<Long>> idToLeafMap = new HashMap<Long, Set<Long>>();
        this.getAcctLeaf(allAcctIds, idToLeafMap, orgId);
        Map<Set<String>, Set<Long>> flexsToLeafAcctMap = this.dbFlexs(flexsToAcctMap, idToLeafMap, typeMap);
        return flexsToLeafAcctMap;
    }

    private Map<Set<String>, Set<Long>> dbFlexs(Map<Set<String>, Set<Long>> flexsToAcctMap, Map<Long, Set<Long>> idToLeafMap, Map<String, Long> typeMap) {
        HashMap<Set<String>, Set<Long>> flexsToLeafAcctMap = new HashMap<Set<String>, Set<Long>>(flexsToAcctMap.size());
        for (Map.Entry<Set<String>, Set<Long>> entry : flexsToAcctMap.entrySet()) {
            HashSet leafAcctIds = new HashSet();
            Set<Long> acctIds = entry.getValue();
            for (Long acctId : acctIds) {
                leafAcctIds.addAll(idToLeafMap.get(acctId));
            }
            Set<String> flexs = entry.getKey();
            StringBuilder sql = new StringBuilder();
            sql.append("select a.fid from T_BD_Account a ");
            StringBuffer where = new StringBuffer();
            ArrayList<Long> sp = new ArrayList<Long>(32);
            where.append(" WHERE a.fid in (");
            for (Long acctId : leafAcctIds) {
                where.append("?,");
                sp.add(acctId);
            }
            where = where.deleteCharAt(where.length() - 1);
            where.append(')');
            HashSet<Long> flexAcctIds = new HashSet<Long>(32);
            int i = 1;
            for (String s : flexs) {
                sql.append(" INNER JOIN T_BD_AccountAsstActItem a").append(i).append(" ON a.fid=a").append(i).append(".fid");
                where.append(" and a").append(i).append(".fasstactitemid = ? ");
                sp.add(typeMap.get(s));
                ++i;
            }
            try (DataSet dataSet = this.queryDataSetMethod(this.getClass().getName(), DBRoute.of((String)"gl"), sql.append(where).toString(), sp.toArray());){
                while (dataSet.hasNext()) {
                    flexAcctIds.add(dataSet.next().getLong("fid"));
                }
            }
            flexsToLeafAcctMap.put(flexs, flexAcctIds);
        }
        return flexsToLeafAcctMap;
    }

    private DataSet queryDataSetMethod(String name, DBRoute gl, String toString, Object[] toArray) {
        return DB.queryDataSet((String)name, (DBRoute)gl, (String)toString, (Object[])toArray);
    }

    private void getAcctLeaf(Set<Long> acctIds, Map<Long, Set<Long>> idToLeafMap, long orgId) {
        HashSet<Long> allAcctIds = new HashSet<Long>();
        allAcctIds.addAll(acctIds);
        HashMap<String, Long> numberToIdMap = new HashMap<String, Long>();
        this.getMidAndNumByAcctId(allAcctIds, numberToIdMap);
        HashMap<Long, Set<Long>> pIdToIdMap = new HashMap<Long, Set<Long>>(allAcctIds.size());
        Iterator iterator = allAcctIds.iterator();
        while (iterator.hasNext()) {
            long acctId = (Long)iterator.next();
            HashSet<Long> idSet = new HashSet<Long>();
            idSet.add(acctId);
            pIdToIdMap.put(acctId, idSet);
        }
        this.queryAcctAllLeaf(allAcctIds, pIdToIdMap, idToLeafMap, 0);
        QFilter fbasedata = BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountview", (Long)orgId);
        this.uLeafAcctIdAndMid(idToLeafMap, fbasedata, numberToIdMap);
        for (long acctId : acctIds) {
            Set allLeafAcctIds = idToLeafMap.computeIfAbsent(acctId, x -> new HashSet());
            if (!allLeafAcctIds.isEmpty()) continue;
            allLeafAcctIds.add(acctId);
        }
    }

    private void getMidAndNumByAcctId(Set<Long> acctIds, Map<String, Long> numberToIdMap) {
        DataSet acctSet = this.queryDataSet(this.getClass().getName(), "bd_accountview", "id, masterid, number", new QFilter[]{new QFilter("id", "in", acctIds)});
        for (Row row : acctSet) {
            long masterId = row.getLong("masterid");
            numberToIdMap.put(row.getString("number"), row.getLong("id"));
            acctIds.add(masterId);
        }
        DataSet numebrAcctSet = this.queryDataSet(this.getClass().getName(), "bd_accountview", "id,number,masterid", new QFilter[]{new QFilter("masterid", "in", acctIds)});
        for (Row row : numebrAcctSet) {
            numberToIdMap.putIfAbsent(row.getString("number"), row.getLong("id"));
            acctIds.add(row.getLong("id"));
        }
    }

    private void uLeafAcctIdAndMid(Map<Long, Set<Long>> idToLeafMap, QFilter fbasedata, Map<String, Long> numberToIdMap) {
        Object number;
        Set<Long> idSet = idToLeafMap.keySet();
        DataSet acctSet = this.queryDataSet(this.getClass().getName(), "bd_accountview", "id, number, masterid, parent", new QFilter[]{new QFilter("id", "in", idSet)});
        HashMap<Long, String> idToNumberMap = new HashMap<Long, String>(16);
        for (Object row : acctSet) {
            idToNumberMap.put(row.getLong("id"), row.getString("number"));
        }
        HashMap<String, Set> numberToLeafMap = new HashMap<String, Set>();
        for (Map.Entry entry : idToLeafMap.entrySet()) {
            number = (String)idToNumberMap.get(entry.getKey());
            Set set = numberToLeafMap.computeIfAbsent((String)number, x -> new HashSet());
            set.addAll((Collection)entry.getValue());
        }
        for (Map.Entry entry : numberToLeafMap.entrySet()) {
            number = (String)entry.getKey();
            long l = numberToIdMap.get(number);
            idToLeafMap.put(l, (Set<Long>)entry.getValue());
        }
        HashSet allLeafSet = new HashSet();
        Collection<Set<Long>> collection = idToLeafMap.values();
        for (Set set : collection) {
            allLeafSet.addAll(set);
        }
        DataSet leafAcctDS = this.queryDataSet(this.getClass().getName(), "bd_accountview", "id, number, masterid, parent", new QFilter[]{new QFilter("id", "in", allLeafSet), fbasedata});
        HashSet<Long> hashSet = new HashSet<Long>();
        for (Row row : leafAcctDS) {
            hashSet.add(row.getLong("id"));
        }
        HashMap<Long, Set<Long>> resultMap = new HashMap<Long, Set<Long>>(idToLeafMap.size());
        for (Map.Entry<Long, Set<Long>> entry : idToLeafMap.entrySet()) {
            Set<Long> leafSet = entry.getValue();
            leafSet.retainAll(hashSet);
            resultMap.put(entry.getKey(), leafSet);
        }
        idToLeafMap.clear();
        idToLeafMap.putAll(resultMap);
    }

    private void queryAcctAllLeaf(Set<Long> acctIds, Map<Long, Set<Long>> leafIdsToAcctIdsMap, Map<Long, Set<Long>> idToAllLeafMap, int isRepeatIndex) {
        try (DataSet acctSet = this.queryDataSet(this.getClass().getName(), "bd_accountview", "id,number, masterid, parent, isleaf", new QFilter[]{new QFilter("parent", "in", acctIds)});){
            acctIds.clear();
            for (Row row : acctSet) {
                long pid = row.getLong("parent");
                long id = row.getLong("id");
                long masterId = row.getLong("masterid");
                Set<Long> acctIdSet = leafIdsToAcctIdsMap.get(pid);
                boolean isLeaf = row.getBoolean("isleaf");
                if (isLeaf) {
                    for (Long acctId : acctIdSet) {
                        Set<Object> allLeaf = idToAllLeafMap.get(acctId) == null ? new HashSet() : idToAllLeafMap.get(acctId);
                        allLeaf.add(id);
                        allLeaf.add(masterId);
                        idToAllLeafMap.put(acctId, allLeaf);
                    }
                    continue;
                }
                acctIds.add(id);
                acctIds.add(masterId);
                HashSet<Long> idSet = leafIdsToAcctIdsMap.get(id) == null ? new HashSet<Long>() : leafIdsToAcctIdsMap.get(id);
                idSet.addAll(acctIdSet);
                leafIdsToAcctIdsMap.put(id, idSet);
                leafIdsToAcctIdsMap.put(masterId, idSet);
            }
            if (!acctIds.isEmpty()) {
                if (isRepeatIndex > 1000) {
                    return;
                }
                this.queryAcctAllLeaf(acctIds, leafIdsToAcctIdsMap, idToAllLeafMap, ++isRepeatIndex);
            }
        }
    }

    private DataSet queryDataSet(String algoKey, String entityId, String sel, QFilter[] filters) {
        DataSet assistSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)entityId, (String)sel, (QFilter[])filters, null);
        return assistSet;
    }

    private void putFlexsToDsMap(Map<Long, List<Map<String, Long>>> accountAssgrp, Map<String, Set<Long>> flexToIdsMap, Map<Map<String, Long>, Set<Long>> flexsAcctIdsMap) {
        for (Map.Entry<Long, List<Map<String, Long>>> entry : accountAssgrp.entrySet()) {
            long acctId = entry.getKey();
            List<Map<String, Long>> mapList = entry.getValue();
            if (mapList == null || mapList.isEmpty()) {
                HashMap<String, Long> flexMap = new HashMap<String, Long>();
                this.putFlexToAcct(flexsAcctIdsMap, flexMap, acctId);
                continue;
            }
            for (Map<String, Long> singFlexs : mapList) {
                if (singFlexs == null || singFlexs.isEmpty()) {
                    HashMap<String, Long> flexMap = new HashMap<String, Long>();
                    this.putFlexToAcct(flexsAcctIdsMap, flexMap, acctId);
                    continue;
                }
                this.putFlexToAcct(flexsAcctIdsMap, singFlexs, acctId);
            }
            if (flexsAcctIdsMap.size() <= 200) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u4e00\u6b21\u67e5\u8be2\u7ef4\u5ea6\u7ec4\u5408\u4e0d\u80fd\u8d85\u8fc7200\u79cd", (String)"AcctAndAssistHelper_0", (String)"fi-gl-mservice", (Object[])new Object[0]));
        }
    }

    private void putFlexToAcct(Map<Map<String, Long>, Set<Long>> flexsAcctIdsMap, Map<String, Long> flexMap, long acctId) {
        Set<Object> acctIds = flexsAcctIdsMap.get(flexMap) == null ? new HashSet() : flexsAcctIdsMap.get(flexMap);
        acctIds.add(acctId);
        flexsAcctIdsMap.put(flexMap, acctIds);
    }

    private Map<String, DataSet> putFlexToDSMap(Map<String, Set<Long>> flexToIdsMap) {
        HashMap<String, DataSet> flexToDSMap = new HashMap<String, DataSet>(flexToIdsMap.size());
        for (Map.Entry<String, Set<Long>> entry : flexToIdsMap.entrySet()) {
            String flex = entry.getKey();
            Set<Long> assVals = entry.getValue();
            String selectFields = "hg id, assval " + flex;
            QFilter fasstype = new QFilter("asstype", "=", (Object)flex);
            QFilter fassval = null;
            if (!assVals.isEmpty()) {
                fassval = new QFilter("assval", "in", assVals);
            }
            DataSet assValSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"gl_assist_bd", (String)selectFields, (QFilter[])fasstype.and(fassval).toArray(), null);
            flexToDSMap.put(flex, assValSet);
        }
        return flexToDSMap;
    }
}

