/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.formplugin;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.ext.fi.accountref.AccountRefUtils;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.ict.accsys.AccSysUtil;
import kd.fi.ict.accsys.AccountBookInfo;
import kd.fi.ict.business.statistics.StatisticsCache;
import kd.fi.ict.business.statistics.StatisticsCacheData;
import kd.fi.ict.business.statistics.VerifyStatisticsParam;
import kd.fi.ict.formplugin.IctHomeViewValueGetter;
import kd.fi.ict.util.PermissonType;
import kd.fi.ict.util.QFBuilder;

public class ICTHomePlugin
extends AbstractFormPlugin
implements ClickListener {
    private static final String RELOAD_DATA = "reloaddata";
    private static final String CACHE_DATE = "cachedate";
    private IctHomeViewValueGetter valueGetter;
    private static final String ORG = "org";
    private static final String ACCOUNT_TABLE = "accounttable";
    private static final String VERIFY_TYPE = "verifytype";
    private static final String PERIOD = "period";
    private static final String GRIDCONTAINERAP = "gridcontainerap";
    private static final String TRIGGER = "trigger";

    private IctHomeViewValueGetter getValueGetter() {
        if (null == this.valueGetter) {
            this.valueGetter = new IctHomeViewValueGetter(this.getModel());
        }
        return this.valueGetter;
    }

    private void setCacheDate() {
        StatisticsCacheData data = this.getValueGetter().getData();
        if (null != data) {
            Date cacheDate = data.getCacheDate();
            this.getModel().setValue(CACHE_DATE, (Object)cacheDate);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        List hasPermOrgIds = AccSysUtil.getAcctOrgPkList((String)this.getView().getEntityId(), (boolean)false, (PermissonType)PermissonType.VIEW);
        if (hasPermOrgIds.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709\u5185\u90e8\u4ea4\u6613\u5bf9\u8d26\u9996\u9875\u6743\u9650\uff0c\u8bf7\u5148\u5206\u914d\u6743\u9650\u3002", (String)"ICTHomePlugin_0", (String)"fi-ict-formplugin", (Object[])new Object[0]));
        }
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add(ORG, "in", (Object)hasPermOrgIds);
        qfBuilder.add("bookstype", "=", (Object)237528347981256704L);
        qfBuilder.add("enable", "=", (Object)"1");
        Map mainBooks = BusinessDataServiceHelper.loadFromCache((String)"gl_accountbook", (String)ORG, (QFilter[])qfBuilder.toArray());
        List mainOrgIds = mainBooks.values().stream().map(x -> x.getLong("org_id")).collect(Collectors.toList());
        if (mainOrgIds.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709\u5df2\u542f\u7528\u7684\u4e3b\u8d26\u7c3f\uff0c\u8bf7\u524d\u5f80\u57fa\u7840\u8d44\u6599\u8bbe\u7f6e\u3002", (String)"ICTHomePlugin_1", (String)"fi-ict-formplugin", (Object[])new Object[0]));
            return;
        }
        Long org = AccSysUtil.getDefaultAcctOrg(mainOrgIds);
        this.getModel().setValue(ORG, (Object)org);
        this.updateCurPeriod();
        this.setCacheDate();
    }

    private void updateCurPeriod() {
        this.getModel().beginInit();
        DynamicObject org = (DynamicObject)this.getModel().getValue(ORG);
        if (org == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"ICTHomePlugin_2", (String)"fi-ict-formplugin", (Object[])new Object[0]));
            return;
        }
        long orgId = org.getLong("id");
        AccountBookInfo bookInfo = AccSysUtil.getBookFromAccSys((long)orgId, (long)237528347981256704L);
        if (bookInfo == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u62e9\u7684\u6838\u7b97\u7ec4\u7ec7\u6ca1\u6709\u5efa\u7acb\u4e3b\u8d26\u7c3f\uff0c\u8bf7\u524d\u5f80\u57fa\u7840\u8d44\u6599\u8bbe\u7f6e\u3002", (String)"ICTHomePlugin_3", (String)"fi-ict-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getModel().setValue(PERIOD, (Object)bookInfo.getCurPeriodId());
        long curPeriodAccountTableId = AccountRefUtils.getCurPeriodAccountTableId((long)orgId, (long)237528347981256704L, (long)bookInfo.getCurPeriodId());
        this.getModel().setValue(ACCOUNT_TABLE, (Object)curPeriodAccountTableId);
        this.getModel().endInit();
        this.getView().updateView(PERIOD);
        this.getView().updateView(ACCOUNT_TABLE);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit orgEdit = (BasedataEdit)this.getView().getControl(ORG);
        orgEdit.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            ArrayList<QFilter> filters = param.getListFilterParameter().getQFilters();
            if (filters == null) {
                filters = new ArrayList<QFilter>(1);
                param.getListFilterParameter().setQFilters(filters);
            }
            List hasPermOrgIds = AccSysUtil.getAcctOrgPkList((String)this.getView().getEntityId(), (boolean)false, (PermissonType)PermissonType.VIEW);
            filters.add(new QFilter("id", "in", (Object)hasPermOrgIds));
        });
        Label label = (Label)this.getControl(RELOAD_DATA);
        label.addClickListener((ClickListener)this);
    }

    public void click(EventObject evt) {
        Label label;
        super.click(evt);
        Object source = evt.getSource();
        if (source instanceof Label && RELOAD_DATA.equals((label = (Label)source).getKey())) {
            StatisticsCache.remove((VerifyStatisticsParam)this.getValueGetter().getParam());
            this.refreshView();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName;
        super.propertyChanged(e);
        switch (propertyName = e.getProperty().getName()) {
            case "org": {
                this.updateCurPeriod();
                this.refreshView();
                break;
            }
            case "verifytype": 
            case "accounttable": {
                this.refreshView();
                break;
            }
        }
    }

    private void refreshView() {
        this.setCacheDate();
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        HashMap dataMap = new HashMap();
        proxy.invokeControlMethod(GRIDCONTAINERAP, TRIGGER, new Object[]{dataMap});
    }
}

