/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.formplugin;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.ict.constant.VerifySchemeField;
import kd.fi.ict.enums.TransactionType;
import kd.fi.ict.util.AccountServiceHelper;
import kd.fi.ict.util.QFBuilder;

public class IctReconSchemaEditPlugin
extends AbstractBillPlugIn {
    private static final String ISPERSONALIZEDATA = "isPersonalizeData";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initSetTransactionItem();
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        this.initSetTransactionItem();
        this.personalizeEnable();
    }

    private void initSetTransactionItem() {
        String type = String.valueOf(this.getModel().getValue("transactiontype"));
        this.setTransactionItem(type);
        this.setAcctEnable();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.accountListener();
        this.cashitemListener();
        this.otherAssgrpListener();
        this.commonAssgrpListener();
    }

    private void otherAssgrpListener() {
        BasedataEdit otherAssgrp = (BasedataEdit)this.getView().getControl("interiorassgrp");
        otherAssgrp.addBeforeF7SelectListener(this::f7Assgrp);
    }

    private void commonAssgrpListener() {
        BasedataEdit commonAssgrp = (BasedataEdit)this.getView().getControl("commonassgrp");
        commonAssgrp.addBeforeF7SelectListener(this::f7Assgrp);
    }

    private void f7Assgrp(BeforeF7SelectEvent evt) {
        List valuesourceList;
        QFilter qfId = null;
        List<Object> idLst = new ArrayList(0);
        String fieldKey = ((BasedataEdit)evt.getSource()).getFieldKey();
        if (TransactionType.CASH_FLOW.getTransactionType().equals(this.getModel().getValue("transactiontype"))) {
            DynamicObject accountOrCashItem = (DynamicObject)this.getModel().getValue("cashflowitem", evt.getRow());
            if (Objects.nonNull(accountOrCashItem)) {
                qfId = new QFilter("id", "=", accountOrCashItem.getPkValue());
                if ("interiorassgrp".equals(fieldKey)) {
                    qfId.and(new QFilter("assistentry.asstypeid.valuesource", "in", IctReconSchemaEditPlugin.getValueSource()));
                }
                if ("commonassgrp".equals(fieldKey)) {
                    qfId.and(new QFilter("assistentry.asstypeid.valuesource", "!=", (Object)""));
                    qfId.and(new QFilter("assistentry.asstypeid.valuesource", "!=", (Object)"bos_assistantdata_detail"));
                }
                idLst = QueryServiceHelper.query((String)"gl_cashflowitem", (String)"assistentry.asstypeid.id", (QFilter[])new QFilter[]{qfId}).stream().map(v -> v.getLong("assistentry.asstypeid.id")).collect(Collectors.toList());
                if ("interiorassgrp".equals(fieldKey) && (idLst.size() == 0 || idLst.isEmpty())) {
                    valuesourceList = AccountServiceHelper.getValueSource();
                    idLst = IctReconSchemaEditPlugin.selectEntryId(valuesourceList);
                }
            }
        } else {
            DynamicObject accountOrCashItem = (DynamicObject)this.getModel().getValue("account", evt.getRow());
            if (Objects.nonNull(accountOrCashItem)) {
                qfId = new QFilter("id", "=", accountOrCashItem.getPkValue());
                if ("interiorassgrp".equals(fieldKey)) {
                    qfId.and(new QFilter("checkitementry.asstactitem.valuesource", "in", IctReconSchemaEditPlugin.getValueSource()));
                }
                if ("commonassgrp".equals(fieldKey)) {
                    qfId.and(new QFilter("checkitementry.asstactitem.valuesource", "!=", (Object)""));
                    qfId.and(new QFilter("checkitementry.asstactitem.valuesource", "!=", (Object)"bos_assistantdata_detail"));
                }
                idLst = QueryServiceHelper.query((String)"bd_accountview", (String)"checkitementry.asstactitem.id", (QFilter[])new QFilter[]{qfId}).stream().map(v -> v.getLong("checkitementry.asstactitem.id")).collect(Collectors.toList());
                if ("interiorassgrp".equals(fieldKey) && (idLst.size() == 0 || idLst.isEmpty())) {
                    valuesourceList = AccountServiceHelper.getValueSource();
                    idLst = IctReconSchemaEditPlugin.selectEntryId(valuesourceList);
                }
            }
        }
        if (Objects.nonNull(qfId)) {
            if (fieldKey.equals("commonassgrp")) {
                idLst.remove((Long)this.getModel().getValue("interiorassgrp_id"));
            }
            if (fieldKey.equals("interiorassgrp")) {
                DynamicObjectCollection commonassgrpColl = (DynamicObjectCollection)this.getModel().getValue("commonassgrp");
                idLst.removeAll(commonassgrpColl.stream().map(value -> value.getLong("fbasedataid_id")).collect(Collectors.toList()));
            }
            qfId = new QFilter("id", "in", idLst);
        } else {
            qfId = new QFilter("id", "=", (Object)0);
        }
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        showParameter.getListFilterParameter().getQFilters().add(qfId);
    }

    private static List<String> getValueSource() {
        return new ArrayList<String>(Arrays.asList("bd_customer", "bd_supplier", "bd_bizpartner", "bos_org"));
    }

    public static List<Long> selectEntryId(List<String> valuesourceList) {
        StringBuilder sqlReadBDInfo = new StringBuilder();
        String valuesources = StringUtils.join((Object[])valuesourceList.toArray(), (String)"', '");
        sqlReadBDInfo.append("select fentryid from t_bas_flex_property ");
        sqlReadBDInfo.append("where fvaluesource in ('").append(valuesources).append("')");
        List idList = (List)DB.query((DBRoute)DBRoute.of((String)"sys"), (String)sqlReadBDInfo.toString(), (ResultSetHandler)new ResultSetHandler<List<Long>>(){

            public List<Long> handle(ResultSet reader) throws Exception {
                ArrayList<Long> rows = new ArrayList<Long>(50);
                while (reader.next()) {
                    Long entryid = reader.getLong("fentryid");
                    rows.add(entryid);
                }
                return rows;
            }
        });
        return idList;
    }

    private void accountListener() {
        BasedataEdit account = (BasedataEdit)this.getView().getControl("account");
        account.addBeforeF7SelectListener(evt -> {
            DynamicObject accounttable = (DynamicObject)this.getModel().getValue("e_accounttable", evt.getRow());
            Long useorgId = (Long)this.getModel().getValue("createorg_id");
            long accountTableId = Objects.isNull(accounttable) ? 0L : (Long)accounttable.getPkValue();
            QFBuilder accountFilter = AccountServiceHelper.getInterAccountFilter((long)useorgId, (long)accountTableId, (boolean)false);
            ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
            List filter = showParameter.getListFilterParameter().getQFilters();
            filter.addAll(accountFilter.toList());
            DynamicObject useOrg = (DynamicObject)this.getModel().getValue("useorg");
            filter.add(BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountview", (Long)useOrg.getLong("id")));
            DynamicObjectCollection idColl = QueryServiceHelper.query((String)"bd_accountview", (String)"id", (QFilter[])filter.toArray(new QFilter[0]));
            HashSet idlst = new HashSet(idColl.size());
            idColl.forEach(v -> idlst.add(v.getLong("id")));
            ArrayList<QFilter> newFilter = new ArrayList<QFilter>(2);
            newFilter.add(new QFilter("id", "in", idlst));
            newFilter.add(new QFilter("accounttable", "=", (Object)accountTableId));
            if (this.getIsPersonalizeData().booleanValue()) {
                Long masterid = (Long)this.getModel().getValue("masterid");
                DynamicObject dynParent = BusinessDataServiceHelper.loadSingle((Object)masterid, (String)"ict_verifyscheme");
                DynamicObjectCollection dynamicObjectCollection = dynParent.getDynamicObjectCollection("entryentity");
                DynamicObject dyn = (DynamicObject)dynamicObjectCollection.get(evt.getRow());
                newFilter.add(new QFilter("id", "in", (Object)AccountServiceHelper.getChildrenIdsByAcctId((long)useorgId, (long)dyn.getLong(VerifySchemeField.id_((String)"account")), (boolean)true, (boolean)false)));
            }
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "account"));
            showParameter.getListFilterParameter().setQFilters(newFilter);
        });
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        RowDataEntity[] rowDataEntities;
        super.afterAddRow(e);
        for (RowDataEntity rowDataEntity : rowDataEntities = e.getRowDataEntities()) {
            int rowIndex = rowDataEntity.getRowIndex();
            this.getView().setEnable(Boolean.valueOf(Objects.nonNull(rowDataEntity.getDataEntity().getDynamicObject("e_accounttable"))), rowIndex, new String[]{"account"});
        }
    }

    private void cashitemListener() {
        BasedataEdit cashitem = (BasedataEdit)this.getView().getControl("cashflowitem");
        cashitem.addBeforeF7SelectListener(evt -> {
            Long useorgId = (Long)this.getModel().getValue("createorg_id");
            QFBuilder cfFilter = AccountServiceHelper.getInterCashItemFilter((long)useorgId, (boolean)false);
            ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
            showParameter.getListFilterParameter().setQFilters(cfFilter.toList());
        });
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        super.propertyChanged(e);
        switch (name = e.getProperty().getName()) {
            case "transactiontype": {
                String oldValue = (String)e.getChangeSet()[0].getOldValue();
                String newValue = (String)e.getChangeSet()[0].getNewValue();
                this.setTransactionItem(newValue);
                List transItem = TransactionType.TransactionTypeByAccount();
                if (transItem.contains(oldValue) && transItem.contains(newValue)) break;
                this.clearAccountOrCFItem(-1);
                break;
            }
            case "e_accounttable": {
                this.clearAccountOrCFItem(e.getChangeSet()[0].getRowIndex());
                break;
            }
            case "account": {
                this.clearAssgrp(e);
            }
        }
        this.personalizeEnable();
    }

    private void clearAccountOrCFItem(int rowIndex) {
        DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
        Consumer<Integer> consumer = index -> {
            this.getModel().setValue("account", null, index.intValue());
            this.getModel().setValue("account", null, index.intValue());
            this.getModel().setValue("cashflowitem", null, index.intValue());
            this.getModel().setValue("interiorassgrp", null, index.intValue());
            this.getModel().setValue("commonassgrp", null, index.intValue());
        };
        if (rowIndex == -1) {
            for (int i = 0; i < entryentity.size(); ++i) {
                this.getModel().setValue("e_accounttable", null, i);
                consumer.accept(i);
            }
            this.setAcctEnable();
        } else {
            consumer.accept(rowIndex);
            this.setAcctEnable(rowIndex);
        }
    }

    private void setAcctEnable() {
        DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
        for (int i = 0; i < entryentity.size(); ++i) {
            this.getView().setEnable(Boolean.valueOf(Objects.nonNull(((DynamicObject)entryentity.get(i)).getDynamicObject("e_accounttable"))), i, new String[]{"account"});
        }
    }

    private void setAcctEnable(int rowIndex) {
        DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
        if (rowIndex < entryentity.size()) {
            this.getView().setEnable(Boolean.valueOf(Objects.nonNull(((DynamicObject)entryentity.get(rowIndex)).getDynamicObject("e_accounttable"))), rowIndex, new String[]{"entryentity", "account"});
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        if (Objects.nonNull(event.getReturnData()) && "account".equals(event.getActionId())) {
            boolean current = true;
            int index = this.getModel().getEntryCurrentRowIndex("entryentity");
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("entryentity", index);
            ListSelectedRowCollection selAcct = (ListSelectedRowCollection)event.getReturnData();
            Object[] acctIds = selAcct.stream().map(x -> x.getPrimaryKeyValue()).collect(Collectors.toList()).toArray();
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"bd_accountview");
            Map dynMap = BusinessDataServiceHelper.loadFromCache((Object[])acctIds, (DynamicObjectType)dataEntityType);
            for (ListSelectedRow listSelectedRow : selAcct) {
                if (current) {
                    this.getModel().setValue("account", listSelectedRow.getPrimaryKeyValue(), index);
                    current = false;
                    continue;
                }
                DynamicObject dynamicObject = (DynamicObject)dynMap.get(listSelectedRow.getPrimaryKeyValue());
                DynamicObject insertRow = (DynamicObject)new CloneUtils(false, false).clone((IDataEntityBase)entryRowEntity);
                insertRow.set("account", (Object)dynamicObject);
                insertRow.set("e_accounttable", (Object)dynamicObject.getDynamicObject("accounttable"));
                this.getModel().createNewEntryRow("entryentity", index++, insertRow);
            }
            this.setAcctEnable();
        }
    }

    private void clearAssgrp(PropertyChangedArgs e) {
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        this.getModel().setValue("interiorassgrp", null, rowIndex);
        this.getModel().setValue("commonassgrp", null, rowIndex);
    }

    private void setTransactionItem(String type) {
        IFormView view = this.getView();
        BasedataEdit acct = (BasedataEdit)this.getControl("account");
        BasedataEdit acctTable = (BasedataEdit)this.getControl("e_accounttable");
        BasedataEdit cashflow = (BasedataEdit)this.getControl("cashflowitem");
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        if (TransactionType.CASH_FLOW.getTransactionType().equals(type)) {
            view.setVisible(Boolean.valueOf(false), new String[]{"e_accounttable", "account", "accountnumber"});
            view.setVisible(Boolean.valueOf(true), new String[]{"cashflowitem", "cfnumber"});
            acctTable.setMustInput(false);
            acct.setMustInput(false);
            cashflow.setMustInput(true);
            if (Objects.nonNull(entryEntity) && entryEntity.size() > 0) {
                this.getModel().setValue("accounttable", null);
            }
        } else {
            view.setVisible(Boolean.valueOf(true), new String[]{"e_accounttable", "account", "accountnumber"});
            view.setVisible(Boolean.valueOf(false), new String[]{"cashflowitem", "cfnumber"});
            acctTable.setMustInput(true);
            acct.setMustInput(true);
            cashflow.setMustInput(false);
            if (Objects.nonNull(entryEntity) && entryEntity.size() > 0) {
                this.getModel().setValue("cashflowitem", null);
            }
        }
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        Map sourceDataMap = e.getSourceData();
        this.sourceDataHandle(sourceDataMap);
    }

    public void sourceDataHandle(Map<String, Object> sourceDataMap) {
        Map orgInfoMap = (Map)sourceDataMap.get("createorg");
        if (orgInfoMap == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u521b\u5efa\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"IctReconSchemaEditPlugin_0", (String)"fi-ict-formplugin", (Object[])new Object[0]));
        }
        String orgNumber = (String)orgInfoMap.get("number");
        if (StringUtils.isBlank((CharSequence)orgNumber)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u521b\u5efa\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"IctReconSchemaEditPlugin_1", (String)"fi-ict-formplugin", (Object[])new Object[0]));
        }
        QFBuilder orgNumberFilter = new QFBuilder("number", "=", (Object)orgNumber);
        DynamicObject orgDynObj = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (String)"id", (QFilter[])orgNumberFilter.toArray());
        if (orgDynObj == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u521b\u5efa\u7ec4\u7ec7\u7f16\u7801\u5bf9\u5e94\u7ec4\u7ec7\u4e0d\u5b58\u5728\u3002", (String)"IctReconSchemaEditPlugin_2", (String)"fi-ict-formplugin", (Object[])new Object[0]));
        }
        long orgId = orgDynObj.getLong("id");
        if (Objects.equals(sourceDataMap.get("transactiontype"), TransactionType.CASH_FLOW.getTransactionType())) {
            List entryentity = (List)sourceDataMap.get("entryentity");
            for (Object entry : entryentity) {
                Map entryMap = (Map)entry;
                Map cashflowitemMap = (Map)entryMap.get("cashflowitem");
                if (!Objects.isNull(cashflowitemMap)) continue;
                throw new KDBizException(ResManager.loadKDString((String)"\u73b0\u91d1\u6d41\u91cf\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"IctReconSchemaEditPlugin_5", (String)"fi-ict-formplugin", (Object[])new Object[0]));
            }
        } else {
            this.checkAccount(orgId, sourceDataMap);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void checkAccount(Long orgId, Map<String, Object> sourceData) {
        Object accounttableMap;
        List entryentity = (List)sourceData.get("entryentity");
        HashMap<String, Map> acctTableMap = new HashMap<String, Map>(entryentity.size());
        for (Object entry : entryentity) {
            Map entryMap = (Map)entry;
            accounttableMap = (Map)entryMap.get("e_accounttable");
            if (Objects.isNull(accounttableMap)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u79d1\u76ee\u8868\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"IctReconSchemaEditPlugin_4", (String)"fi-ict-formplugin", (Object[])new Object[0]));
            }
            Object acctTablenumber = accounttableMap.get("number");
            Map accountMap = (Map)entryMap.get("account");
            if (Objects.isNull(accountMap)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u79d1\u76ee\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"IctReconSchemaEditPlugin_3", (String)"fi-ict-formplugin", (Object[])new Object[0]));
            }
            Object acctNumber = accountMap.get("number");
            if (!Objects.nonNull(acctTablenumber) || !Objects.nonNull(acctNumber)) continue;
            acctTableMap.computeIfAbsent(String.valueOf(acctTablenumber), x -> new HashMap(10)).put(String.valueOf(acctNumber), 0L);
        }
        Set acctTableNumbers = acctTableMap.entrySet().stream().map(x -> (String)x.getKey()).collect(Collectors.toSet());
        QFilter filter = new QFilter("number", "in", acctTableNumbers);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_accounttable", (String)"id, number", (QFilter[])filter.toArray(), null);
        accounttableMap = null;
        try {
            while (dataSet.hasNext()) {
                DataSet accountSet;
                block27: {
                    Row acctTableRow = dataSet.next();
                    Map acctNumberMap = (Map)acctTableMap.get(acctTableRow.getString("number"));
                    QFilter acctFilter = new QFilter("number", "in", acctNumberMap.keySet());
                    accountSet = AccountServiceHelper.getAccountDataSet((long)orgId, (long)acctTableRow.getLong("id"), null, (boolean)false, (QFilter)acctFilter, (String[])new String[]{"id", "number", "accounttable.number", "masterid"});
                    Throwable throwable = null;
                    try {
                        while (accountSet.hasNext()) {
                            Row next = accountSet.next();
                            Map acctMap = (Map)acctTableMap.get(next.getString("accounttable.number"));
                            if (!Objects.nonNull(acctMap)) continue;
                            acctMap.put(next.getString("number"), next.getLong("id"));
                        }
                        if (accountSet == null) continue;
                        if (throwable == null) break block27;
                    }
                    catch (Throwable throwable2) {
                        try {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (accountSet == null) throw throwable3;
                            if (throwable == null) {
                                accountSet.close();
                                throw throwable3;
                            }
                            try {
                                accountSet.close();
                                throw throwable3;
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                                throw throwable3;
                            }
                        }
                    }
                    try {
                        accountSet.close();
                        continue;
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                        continue;
                    }
                }
                accountSet.close();
            }
        }
        catch (Throwable acctTableRow) {
            accounttableMap = acctTableRow;
            throw acctTableRow;
        }
        finally {
            if (dataSet != null) {
                if (accounttableMap != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable acctTableRow) {
                        ((Throwable)accounttableMap).addSuppressed(acctTableRow);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        Iterator iterator = entryentity.iterator();
        while (iterator.hasNext()) {
            Object entry = iterator.next();
            Map entryMap = (Map)entry;
            if (!Objects.nonNull(entryMap)) continue;
            Map accounttableMap2 = (Map)entryMap.get("e_accounttable");
            Map accountMap = (Map)entryMap.get("account");
            if (!Objects.nonNull(accounttableMap2) || !Objects.nonNull(accountMap)) continue;
            accountMap.put("id", ((Map)acctTableMap.get(accounttableMap2.get("number"))).get(accountMap.get("number")));
        }
    }

    private Boolean getIsPersonalizeData() {
        Boolean isPersonalizeData = (Boolean)this.getView().getFormShowParameter().getCustomParam(ISPERSONALIZEDATA);
        return Objects.nonNull(isPersonalizeData) && isPersonalizeData != false;
    }

    private void personalizeEnable() {
        if (this.getIsPersonalizeData().booleanValue()) {
            DynamicObjectCollection dynColl = (DynamicObjectCollection)this.getModel().getValue("entryentity");
            for (int i = 0; i < dynColl.size(); ++i) {
                this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"commonassgrp"});
            }
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"name", "number", "bizdateceron", "days", "transactiontype", "accounttable"});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"adddimline", "deldimline"});
        }
    }
}

