/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.formplugin;

import kd.bos.form.IFormView;
import kd.bos.form.chart.PieChart;
import kd.bos.form.control.Label;
import kd.fi.ict.formplugin.IctHomeCard;
import kd.fi.ict.formplugin.VerifyDataLabelPainter;
import kd.fi.ict.formplugin.VerifyDataPieChartPainter;

public class VerifyDataCard {
    private final IFormView cardView;
    private IctHomeCard homeCard;
    private static final String PIE_CHART = "piechart";
    private static final String DIFF_LAB = "difflab";
    private static final String CHECKED_LAB = "checkedlab";
    private VerifyDataLabelPainter labelPainter;
    private VerifyDataPieChartPainter painter;

    protected VerifyDataCard(IFormView cardView) {
        this.cardView = cardView;
    }

    protected IctHomeCard getIctHomeCard() {
        if (this.homeCard == null) {
            this.homeCard = new IctHomeCard(this.cardView);
        }
        return this.homeCard;
    }

    protected PieChart getPieChart() {
        return (PieChart)this.cardView.getControl(PIE_CHART);
    }

    protected Label getDiffLab() {
        return (Label)this.cardView.getControl(DIFF_LAB);
    }

    protected Label getCheckedLab() {
        return (Label)this.cardView.getControl(CHECKED_LAB);
    }

    protected VerifyDataLabelPainter getLabelPainter() {
        if (null == this.labelPainter) {
            this.labelPainter = new VerifyDataLabelPainter(this.getDiffLab(), this.getCheckedLab());
        }
        return this.labelPainter;
    }

    protected VerifyDataPieChartPainter getPainter() {
        if (null == this.painter) {
            this.painter = new VerifyDataPieChartPainter(this.getPieChart());
        }
        return this.painter;
    }
}

