/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.formplugin;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.control.Label;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.ict.accsys.AccSysUtil;
import kd.fi.ict.accsys.AccountBookInfo;
import kd.fi.ict.business.statistics.StatisticsType;
import kd.fi.ict.business.statistics.VerifyStatistics;
import kd.fi.ict.format.UserFormatter;

public class VerifyDataLabelPainter {
    private final Label differentLable;
    private final Label checkedLable;
    private final UserFormatter userFormatter = new UserFormatter();
    private Map<String, Object> zeroColorMap;

    private Map<String, Object> getZeroColorMap() {
        if (this.zeroColorMap == null) {
            this.zeroColorMap = new HashMap<String, Object>(1);
        }
        this.zeroColorMap.put("fc", "#cccccc");
        return this.zeroColorMap;
    }

    protected VerifyDataLabelPainter(Label differentLable, Label checkedLable) {
        this.differentLable = differentLable;
        this.checkedLable = checkedLable;
    }

    protected void paint(VerifyStatistics verifyStatistics, StatisticsType type) {
        Object[] baseCurrencyInfo = this.getBaseCurrencyInfo(verifyStatistics.getVerifyStatisticsParam().getOrgId());
        String sign = baseCurrencyInfo[0].toString();
        int scale = Integer.parseInt(baseCurrencyInfo[1].toString());
        BigDecimal diffData = ((BigDecimal)verifyStatistics.getTotal().getDifferentData().get(type)).abs();
        if (StatisticsType.AMOUNT == type) {
            this.differentLable.setText(this.userFormatter.formatAmount(diffData, sign, scale));
        } else {
            this.differentLable.setText(this.userFormatter.toStringInt(diffData));
        }
        if (diffData.compareTo(BigDecimal.ZERO) == 0) {
            this.differentLable.getView().updateControlMetadata(this.differentLable.getKey(), this.getZeroColorMap());
        }
        BigDecimal checkedData = ((BigDecimal)verifyStatistics.getTotal().getCheckedData().get(type)).abs();
        if (StatisticsType.AMOUNT == type) {
            this.checkedLable.setText(this.userFormatter.formatAmount(checkedData, sign, scale));
        } else {
            this.checkedLable.setText(this.userFormatter.toStringInt(checkedData));
        }
        if (checkedData.compareTo(BigDecimal.ZERO) == 0) {
            this.checkedLable.getView().updateControlMetadata(this.checkedLable.getKey(), this.getZeroColorMap());
        }
    }

    private Object[] getBaseCurrencyInfo(long orgId) {
        return (Object[])ThreadCache.get((Object)(this.getClass().getName() + "_" + orgId), () -> {
            Object[] objectArray;
            AccountBookInfo bookInfo = AccSysUtil.getBookFromAccSys((long)orgId, (long)237528347981256704L);
            if (null == bookInfo) {
                return new Object[]{"", 4};
            }
            long baseCurrencyId = bookInfo.getBaseCurrencyId();
            if (baseCurrencyId == 0L) {
                return new Object[]{"", 4};
            }
            DynamicObject currencyDynObj = BusinessDataServiceHelper.loadSingleFromCache((Object)baseCurrencyId, (String)"bd_currency", (String)"sign,amtprecision");
            if (currencyDynObj == null) {
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "";
                objectArray = objectArray2;
                objectArray2[1] = 4;
            } else {
                Object[] objectArray3 = new Object[2];
                objectArray3[0] = currencyDynObj.getString("sign");
                objectArray = objectArray3;
                objectArray3[1] = currencyDynObj.getInt("amtprecision");
            }
            return objectArray;
        });
    }
}

