/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.formplugin;

import java.lang.constant.Constable;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.BarChart;
import kd.bos.form.chart.BarSeries;
import kd.bos.form.chart.Position;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.ict.business.statistics.StatisticsType;
import kd.fi.ict.business.statistics.VerifyStatistics;
import kd.fi.ict.business.statistics.VerifyStatisticsRow;

public class VerifyOrderChartPainter {
    private static final String POSITION_TOP = "35px";
    private static final String POSITION_RIGHT = "40px";
    private static final String BAR_WIDTH = "20%";
    private static final String AXIS_TICK = "axisTick";
    private static final String INTERVAL = "interval";
    private static final String SHOW = "show";
    private static final String LINE_STYLE = "lineStyle";
    private static final String COLOR = "color";
    private static final String AXIS_LINE = "axisLine";
    private static final int LIMIT = 10;
    public static final String LINE_COLOR = "#666666";
    private final BarChart chart;

    protected VerifyOrderChartPainter(BarChart chart) {
        this.chart = chart;
    }

    protected BarChart initChart() {
        this.chart.setMargin(Position.top, POSITION_TOP);
        this.chart.setMargin(Position.right, POSITION_RIGHT);
        this.chart.setShowTooltip(true);
        return this.chart;
    }

    protected void paint(StatisticsType statisticsType, VerifyStatistics verifyStatistics) {
        BarChart chart = this.initChart();
        chart.clearData();
        Axis xAxis = this.createXAxis(chart);
        this.createYAxis(chart, statisticsType);
        BarSeries differentBarSeries = this.createDifferentBarSeries(chart, statisticsType);
        BarSeries checkedBarSeries = this.createCheckedBarSeries(chart, statisticsType);
        List topTenData = verifyStatistics.getTopData(statisticsType, 10);
        List<Long> orgIdList = topTenData.stream().map(Map.Entry::getKey).collect(Collectors.toList());
        Map<Long, String> orgIdNameMap = this.getOrgIdNameMap(orgIdList);
        for (Map.Entry data : topTenData) {
            this.paintData(statisticsType, (Long)data.getKey(), (VerifyStatisticsRow)data.getValue(), xAxis, differentBarSeries, checkedBarSeries, orgIdNameMap);
        }
        chart.refresh();
    }

    private Map<Long, String> getOrgIdNameMap(List<Long> orgIdList) {
        return BusinessDataServiceHelper.loadFromCache((String)"bos_org", (String)"name", (QFilter[])new QFilter("id", "in", orgIdList).toArray()).values().stream().collect(Collectors.toMap(x -> x.getLong("id"), x -> x.getString("name")));
    }

    private Axis createXAxis(BarChart chart) {
        Axis xAxis = chart.createXAxis("", AxisType.category);
        this.setAxisStyle(xAxis);
        return xAxis;
    }

    private Axis createYAxis(BarChart chart, StatisticsType statisticsType) {
        Axis yAxis = chart.createYAxis("        " + statisticsType.getName(), AxisType.value);
        this.setAxisStyle(yAxis);
        return yAxis;
    }

    private BarSeries createDifferentBarSeries(BarChart chart, StatisticsType statisticsType) {
        BarSeries differentBarSeries = chart.createBarSeries(ResManager.loadKDString((String)"\u672a\u5bf9\u8d26", (String)"VerifyOrderChartPainter_0", (String)"fi-ict-formplugin", (Object[])new Object[0]));
        differentBarSeries.setBarWidth(BAR_WIDTH);
        differentBarSeries.setStack(ResManager.loadKDString((String)"\u603b", (String)"VerifyOrderChartPainter_3", (String)"fi-ict-formplugin", (Object[])new Object[0]));
        differentBarSeries.setColor("#00CCCC");
        return differentBarSeries;
    }

    private BarSeries createCheckedBarSeries(BarChart chart, StatisticsType statisticsType) {
        BarSeries checkedBarSeries = chart.createBarSeries(ResManager.loadKDString((String)"\u5df2\u5bf9\u8d26", (String)"VerifyOrderChartPainter_1", (String)"fi-ict-formplugin", (Object[])new Object[0]));
        checkedBarSeries.setBarWidth(BAR_WIDTH);
        checkedBarSeries.setStack(ResManager.loadKDString((String)"\u603b", (String)"VerifyOrderChartPainter_3", (String)"fi-ict-formplugin", (Object[])new Object[0]));
        checkedBarSeries.setColor("#098BFF");
        checkedBarSeries.getLabel().setShow(false);
        return checkedBarSeries;
    }

    private void setAxisStyle(Axis axis) {
        HashMap<String, Constable> axisTick = new HashMap<String, Constable>(2);
        axisTick.put(INTERVAL, Integer.valueOf(0));
        axisTick.put(SHOW, Boolean.valueOf(false));
        axis.setPropValue(AXIS_TICK, axisTick);
        HashMap aXisLineMap = new HashMap(1);
        HashMap<String, String> lineStyleMap = new HashMap<String, String>(1);
        lineStyleMap.put(COLOR, LINE_COLOR);
        aXisLineMap.put(LINE_STYLE, lineStyleMap);
        axis.setPropValue(AXIS_LINE, aXisLineMap);
    }

    private void paintData(StatisticsType statisticsType, long orgId, VerifyStatisticsRow rowData, Axis xAxis, BarSeries differentBarSeries, BarSeries checkedBarSeries, Map<Long, String> orgIdNameMap) {
        xAxis.addCategory(orgIdNameMap.getOrDefault(orgId, ""));
        differentBarSeries.addData((Number)((BigDecimal)rowData.getDifferentData().get(statisticsType)).abs());
        checkedBarSeries.addData((Number)((BigDecimal)rowData.getCheckedData().get(statisticsType)).abs());
    }
}

