/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.formplugin.checklog;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.exception.KDBizException;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QEmptyValue;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ict.accsys.AccSysUtil;
import kd.fi.ict.accsys.AccountBookInfo;
import kd.fi.ict.constant.GLField;
import kd.fi.ict.formplugin.checklog.CheckLogListDataProvider;
import kd.fi.ict.listfilter.FilterContainerValues;
import kd.fi.ict.listfilter.FilterValues;
import kd.fi.ict.util.ICTUtils;
import kd.fi.ict.util.PermissonType;
import kd.fi.ict.util.QFBuilder;
import kd.fi.ict.util.VoucherUtils;

public class CheckLogList
extends AbstractListPlugin {
    private static final String CURORG = "curorg";
    private static final String OPORG = "oporg";
    private static final String OP_CANCELCHECK = "cancelcheck";

    private IListView getCurrentListView() {
        return (IListView)this.getView();
    }

    private String getBillEntityId() {
        return this.getCurrentListView().getBillFormId();
    }

    private long getSelectCurOrgId() {
        Long curOrgId = ICTUtils.getCustomFilterId((IFormView)this.getView(), (String)"curorg.id");
        return curOrgId == null ? 0L : curOrgId;
    }

    private AccountBookInfo getSelectMainBook(long curOrgId) {
        return AccSysUtil.getBookFromAccSys((long)curOrgId, (long)237528347981256704L);
    }

    private Map<Long, List<String>> getPeriodTypeId(List<Object> periodIdStrs) {
        List periodIds = periodIdStrs.stream().map(x -> Long.parseLong(x.toString())).collect(Collectors.toList());
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("id", "in", periodIds);
        Map idPeriodMap = BusinessDataServiceHelper.loadFromCache((String)"bd_period", (String)"periodtype", (QFilter[])qfBuilder.toArray());
        return idPeriodMap.entrySet().stream().collect(Collectors.groupingBy(x -> ((DynamicObject)x.getValue()).getLong(GLField.id_((String)"periodtype")), Collectors.mapping(x -> x.getKey().toString(), Collectors.toList())));
    }

    private List<ComboItem> getPeriodComboItems(long periodTypeId, long curPeriodId) {
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("periodtype", "=", (Object)periodTypeId);
        DynamicObject curPeriod = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_period", (String)"periodyear", (QFilter[])new QFBuilder("id", "=", (Object)curPeriodId).toArray());
        int curPeriodYear = curPeriod == null ? 0 : curPeriod.getInt("periodyear");
        Map idPeriodMap = BusinessDataServiceHelper.loadFromCache((String)"bd_period", (String)String.join((CharSequence)",", "periodyear", "name"), (QFilter[])qfBuilder.toArray(), (String)"id");
        Map<Boolean, List<Map.Entry>> yearIdPeriodMap = idPeriodMap.entrySet().stream().collect(Collectors.groupingBy(x -> ((DynamicObject)x.getValue()).getInt("periodyear") >= curPeriodYear));
        return yearIdPeriodMap.entrySet().stream().sorted((o1, o2) -> ((Boolean)o2.getKey()).compareTo((Boolean)o1.getKey())).flatMap(x -> ((List)x.getValue()).stream()).map(idPeriodEntry -> {
            ComboItem comboItem = new ComboItem();
            comboItem.setCaption(new LocaleString(((DynamicObject)idPeriodEntry.getValue()).getString("name")));
            comboItem.setValue(idPeriodEntry.getKey().toString());
            return comboItem;
        }).collect(Collectors.toList());
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        HyperLinkClickEvent evt = args.getHyperLinkClickEvent();
        String fieldName = evt.getFieldName();
        if ("voucherno".equals(fieldName)) {
            args.setCancel(true);
            BillList billList = (BillList)evt.getSource();
            String billFormId = billList.getBillFormId();
            Object selectEntrtId = billList.getCurrentSelectedRowInfo().getEntryPrimaryKeyValue();
            String voucherIdField = String.join((CharSequence)".", "entryentity", "voucherid");
            String orgField = String.join((CharSequence)".", "entryentity", "org");
            String entryIdField = String.join((CharSequence)".", "entryentity", "id");
            String selectFields = String.join((CharSequence)",", voucherIdField, orgField);
            DynamicObject selectData = QueryServiceHelper.queryOne((String)billFormId, (String)selectFields, (QFilter[])new QFilter(entryIdField, "=", selectEntrtId).toArray());
            if (Objects.isNull(selectData)) {
                IListView view = (IListView)this.getView();
                view.refresh();
                return;
            }
            long orgId = selectData.getLong(orgField);
            List voucherIds = QueryServiceHelper.queryPrimaryKeys((String)"gl_voucher", (QFilter[])new QFilter("id", "=", selectData.get(voucherIdField)).toArray(), null, (int)1);
            if (!voucherIds.isEmpty()) {
                VoucherUtils.hyperLinkSingleVoucher((long)orgId, (long)Long.parseLong(voucherIds.get(0).toString()), (IFormView)this.getView());
            }
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent e) {
        AccountBookInfo mainBook;
        super.filterContainerBeforeF7Select(e);
        String fieldName = e.getFieldName();
        if (fieldName.startsWith(CURORG) || fieldName.startsWith(OPORG)) {
            List viewPermOrgIdList = AccSysUtil.getAcctOrgPkList((String)this.getBillEntityId(), (boolean)false, (PermissonType)PermissonType.VIEW);
            e.addCustomQFilter(new QFilter("id", "in", (Object)viewPermOrgIdList));
        } else if (fieldName.startsWith("period") && null != (mainBook = this.getSelectMainBook(this.getSelectCurOrgId()))) {
            e.addCustomQFilter(new QFilter("periodtype", "=", (Object)mainBook.getPeriodTypeId()));
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        FilterContainerValues filterContainerValues = new FilterContainerValues(args.getFilterValues());
        List customFilterValuesList = filterContainerValues.getCustomFilterValuesList();
        if (null == customFilterValuesList || customFilterValuesList.isEmpty()) {
            return;
        }
        for (FilterValues filterValues : customFilterValuesList) {
            List values;
            String fieldName = filterValues.getFieldName();
            if (!fieldName.startsWith("period")) continue;
            AccountBookInfo mainBook = this.getSelectMainBook(this.getSelectCurOrgId());
            if (mainBook == null || !(values = filterValues.getValues()).isEmpty() && values.get(0).equals("")) break;
            Map<Long, List<String>> typeIdMap = this.getPeriodTypeId(values);
            List<String> oldValues = typeIdMap.get(mainBook.getPeriodTypeId());
            values.clear();
            if (oldValues == null || oldValues.isEmpty()) {
                values.add(String.valueOf(mainBook.getCurPeriodId()));
                break;
            }
            values.addAll(oldValues);
            break;
        }
        filterContainerValues.update();
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        long curOrgId = this.getSelectCurOrgId();
        List commonFilterColumns = args.getCommonFilterColumns();
        for (FilterColumn filterColumn : commonFilterColumns) {
            AccountBookInfo mainBook;
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
            FilterField filterField = commonFilterColumn.getFilterField();
            String fieldName = filterField.getFieldName();
            if (fieldName.startsWith(CURORG) || fieldName.startsWith(OPORG)) {
                List orgComboItems = AccSysUtil.getAcctOrgComboItem((String)this.getBillEntityId(), (boolean)false, (PermissonType)PermissonType.VIEW);
                commonFilterColumn.setComboItems(orgComboItems);
                if (!fieldName.startsWith(CURORG) || orgComboItems.size() <= 0) continue;
                commonFilterColumn.setDefaultValues(new Object[]{this.getDefaultOrgId(orgComboItems)});
                List defaultValues = commonFilterColumn.getDefaultValues();
                if (defaultValues.size() <= 0) continue;
                Object defaultValue = defaultValues.get(0);
                if (curOrgId != 0L || !StringUtils.isNotBlank(defaultValue)) continue;
                curOrgId = Long.parseLong(defaultValue.toString());
                continue;
            }
            if (!fieldName.startsWith("period") || (mainBook = this.getSelectMainBook(curOrgId)) == null) continue;
            List<ComboItem> periodComboItems = this.getPeriodComboItems(mainBook.getPeriodTypeId(), mainBook.getCurPeriodId());
            commonFilterColumn.setComboItems(periodComboItems);
            commonFilterColumn.setDefaultValues(new Object[]{String.valueOf(mainBook.getCurPeriodId())});
        }
    }

    private String getDefaultOrgId(List<ComboItem> items) {
        long curOrgId = RequestContext.get().getOrgId();
        for (ComboItem item : items) {
            long nextId;
            if (null == item || null == item.getValue() || item.getValue().length() == 0 || (nextId = Long.parseLong(item.getValue())) != curOrgId) continue;
            return Long.toString(curOrgId);
        }
        return items.get(0).getValue();
    }

    public void setFilter(SetFilterEvent e) {
        long curOrgId = 0L;
        ArrayList<Object> opOrgFilterValueList = new ArrayList<Object>(10);
        QFilter mainOrgFilter = e.getMainOrgQFilter();
        if (null != mainOrgFilter) {
            String property = mainOrgFilter.getProperty();
            if (property.startsWith(CURORG)) {
                curOrgId = this.getCurOrgId(curOrgId, mainOrgFilter);
                e.setMainOrgQFilter(null);
            } else if (property.startsWith(OPORG)) {
                this.getOpOrgFilterValueList(opOrgFilterValueList, mainOrgFilter);
                e.setMainOrgQFilter(null);
            }
        }
        List qFilters = e.getQFilters();
        Iterator iterator = qFilters.iterator();
        while (iterator.hasNext()) {
            QFilter nextFilter = (QFilter)iterator.next();
            String property = nextFilter.getProperty();
            if (property.startsWith(CURORG)) {
                curOrgId = this.getCurOrgId(curOrgId, nextFilter);
                iterator.remove();
                continue;
            }
            if (!property.startsWith(OPORG)) continue;
            this.getOpOrgFilterValueList(opOrgFilterValueList, nextFilter);
            iterator.remove();
        }
        qFilters.add(this.getOrgFilter(curOrgId, opOrgFilterValueList));
    }

    private String isOrgNotIdFilter(String property) {
        String[] split = property.split("\\.");
        if (split.length >= 2 && !"id".equals(split[1])) {
            return property.substring(property.indexOf(".") + 1);
        }
        return "";
    }

    private long getCurOrgId(long curOrgId, QFilter orgFilter) {
        String property = orgFilter.getProperty();
        String orgProperty = this.isOrgNotIdFilter(property);
        boolean isNotIdFilter = StringUtils.isNotBlank((CharSequence)orgProperty);
        Object value = orgFilter.getValue();
        if (Objects.isNull(value)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672c\u65b9\u7ec4\u7ec7\u53ea\u80fd\u5355\u9009\u3002", (String)"CheckLogList_0", (String)"fi-ict-formplugin", (Object[])new Object[0]));
        }
        if (value instanceof QEmptyValue) {
            return 0L;
        }
        String qcp = orgFilter.getCP();
        if (value instanceof Collection) {
            ArrayList valueList = new ArrayList((Collection)value);
            if (valueList.size() > 0) {
                DynamicObject orgDynObj;
                curOrgId = isNotIdFilter ? ((orgDynObj = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (String)"id", (QFilter[])new QFBuilder(orgProperty, qcp, valueList.get(0)).toArray())) == null ? 0L : orgDynObj.getLong("id")) : Long.parseLong(valueList.get(0).toString());
            }
            if (valueList.size() > 1) {
                throw new KDBizException(ResManager.loadKDString((String)"\u672c\u65b9\u7ec4\u7ec7\u53ea\u80fd\u5355\u9009\u3002", (String)"CheckLogList_0", (String)"fi-ict-formplugin", (Object[])new Object[0]));
            }
        } else {
            DynamicObject orgDynObj;
            curOrgId = isNotIdFilter ? ((orgDynObj = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (String)"id", (QFilter[])new QFBuilder(orgProperty, qcp, value).toArray())) == null ? 0L : orgDynObj.getLong("id")) : Long.parseLong(value.toString());
        }
        return curOrgId;
    }

    private void getOpOrgFilterValueList(List<Object> opOrgFilterValueList, QFilter orgFilter) {
        String property = orgFilter.getProperty();
        String orgProperty = this.isOrgNotIdFilter(property);
        boolean isNotIdFilter = StringUtils.isNotBlank((CharSequence)orgProperty);
        Object value = orgFilter.getValue();
        if (value instanceof QEmptyValue) {
            opOrgFilterValueList.add(0L);
            return;
        }
        String cp = orgFilter.getCP();
        if (value instanceof Collection) {
            if (isNotIdFilter) {
                QFBuilder qfBuilder = new QFBuilder(orgProperty, cp, value);
                List orgIds = BusinessDataServiceHelper.loadFromCache((String)"bos_org", (String)"id", (QFilter[])qfBuilder.toArray()).values().stream().map(x -> x.getLong("id")).collect(Collectors.toList());
                opOrgFilterValueList.addAll(orgIds);
            } else {
                opOrgFilterValueList.addAll((Collection)value);
            }
        } else if (isNotIdFilter) {
            QFBuilder qfBuilder = new QFBuilder(orgProperty, cp, value);
            List orgIds = BusinessDataServiceHelper.loadFromCache((String)"bos_org", (String)"id", (QFilter[])qfBuilder.toArray()).values().stream().map(x -> x.getLong("id")).collect(Collectors.toList());
            opOrgFilterValueList.addAll(orgIds);
        } else {
            opOrgFilterValueList.add(value);
        }
    }

    private QFilter getOrgFilter(long curOrgId, List<Object> opOrgFilterValueList) {
        QFilter opOrgFilter;
        QFilter curOrgFilter;
        if (opOrgFilterValueList.isEmpty()) {
            curOrgFilter = new QFilter(CURORG, "=", (Object)curOrgId);
            opOrgFilter = new QFilter(OPORG, "=", (Object)curOrgId);
        } else {
            curOrgFilter = new QFilter(CURORG, "=", (Object)curOrgId).and(new QFilter(OPORG, "in", opOrgFilterValueList));
            opOrgFilter = new QFilter(CURORG, "in", opOrgFilterValueList).and(new QFilter(OPORG, "=", (Object)curOrgId));
        }
        return curOrgFilter.or(opOrgFilter);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (OP_CANCELCHECK.equals(args.getOperateKey())) {
            this.getView().invokeOperation("refresh");
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new CheckLogListDataProvider());
    }
}

