/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.formplugin.formula;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;

public class ForumulaCfAndAssgrpPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    protected static String ENTRY = "assgrpentity";
    public static final String CASHFLOWITEM = "cashflowitem";
    private static final String ASSTACT_TYPE = "asstacttype";
    private static final String ASSTMEMBER = "asstmember";
    private static final String SELECTORS = ForumulaCfAndAssgrpPlugin.genUniqueKey("id", "assistentry", "assistentry.asstypeid", "assistentry.asstypeid.number", "assistentry.asstypeid.name", "assistentry.asstypeid.flexfield", "assistentry.asstypeid.valuesource", "assistentry.asstypeid.valuetype");
    private static final String ENTITY = "gl_cashflowitem";

    public void initialize() {
        super.initialize();
        this.addItemClickListeners(new String[]{"toolbarap", "account"});
        this.addClickListeners(new String[]{"cancel", "confirm", ASSTMEMBER});
        BasedataEdit cashflowitem = (BasedataEdit)this.getControl(CASHFLOWITEM);
        cashflowitem.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit base = (BasedataEdit)this.getView().getControl(CASHFLOWITEM);
        base.addBeforeF7SelectListener(select -> {
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            if (org != null) {
                ListShowParameter showParam = (ListShowParameter)select.getFormShowParameter();
                ArrayList<QFilter> list = new ArrayList<QFilter>();
                QFilter qbase = BaseDataServiceHelper.getBaseDataFilter((String)ENTITY, (Long)org.getLong("id"));
                list.add(qbase);
                showParam.getListFilterParameter().getQFilters().addAll(list);
            }
        });
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter param = this.getView().getFormShowParameter();
        String accountStr = (String)param.getCustomParam("cashflow");
        String orgid = (String)param.getCustomParam("org");
        if (!StringUtils.isEmpty((CharSequence)orgid)) {
            this.getModel().setValue("org", (Object)Long.parseLong(orgid));
        } else {
            long oid = RequestContext.get().getOrgId();
            this.getPageCache().put("orgid", orgid);
            this.getModel().setValue("org", (Object)oid);
        }
        if (!StringUtils.isEmpty((CharSequence)accountStr)) {
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            this.resetEntityAndAssgrp(org == null ? 0L : org.getLong("id"), 0L, accountStr, ENTITY);
        }
    }

    protected void resetEntityAndAssgrp(long orgId, long accounttableId, String accountStr, String entityKey) {
        QFilter qnum;
        QFilter qbase;
        List ids;
        IDataModel model = this.getModel();
        if (orgId == 0L || accounttableId == 0L && "bd_accountview".equals(entityKey) || StringUtils.isEmpty((CharSequence)accountStr)) {
            return;
        }
        String[] memberStrs = accountStr.split("\\|");
        if (memberStrs.length > 0 && !(ids = QueryServiceHelper.queryPrimaryKeys((String)entityKey, (QFilter[])new QFilter[]{qbase = BaseDataServiceHelper.getBaseDataFilter((String)entityKey, (Long)orgId), qnum = new QFilter("number", "=", (Object)memberStrs[0])}, null, (int)-1)).isEmpty()) {
            model.setValue(CASHFLOWITEM, ids.get(0));
        }
        ArrayList<String> asstNums = new ArrayList<String>(memberStrs.length - 1);
        HashMap<String, AssgrpEntryRowInfo> asstNumAndInfoMap = new HashMap<String, AssgrpEntryRowInfo>(memberStrs.length - 1);
        for (int i = 1; i < memberStrs.length; i += 2) {
            String[] values;
            String member = memberStrs[i];
            asstNums.add(member);
            String asstmember = null;
            if (i + 1 < memberStrs.length && (values = memberStrs[i + 1].split("#")).length == 1) {
                int newAssgrpValueLen;
                String assgrpValueStr = memberStrs[i + 1];
                int oldAssgrpValueLen = assgrpValueStr.length();
                if (oldAssgrpValueLen == (newAssgrpValueLen = (assgrpValueStr = assgrpValueStr.replace("[", "").replace("]", "")).length())) {
                    asstmember = assgrpValueStr;
                }
            }
            AssgrpEntryRowInfo info = new AssgrpEntryRowInfo(asstmember);
            asstNumAndInfoMap.put(member, info);
        }
        DynamicObject dyo = (DynamicObject)model.getValue(CASHFLOWITEM);
        if (dyo != null) {
            this.initAsstEntry(dyo.getLong("id"), entityKey, SELECTORS, "assistentry", "asstypeid", asstNums, asstNumAndInfoMap);
        }
    }

    public void initAsstEntry(Long newOneId, String entity, String selector, String entryid, String asstacttype, List<String> asstNums, Map<String, AssgrpEntryRowInfo> asstNumAndInfoMap) {
        this.getModel().deleteEntryData(ENTRY);
        DynamicObject dy = BusinessDataServiceHelper.loadSingle((Object)newOneId, (String)entity, (String)selector);
        DynamicObjectCollection entry = dy.getDynamicObjectCollection(entryid);
        if (entry != null && entry.size() > 0) {
            this.getModel().batchCreateNewEntryRow(ENTRY, entry.size());
            int i = 0;
            for (DynamicObject item : entry) {
                DynamicObject asst = item.getDynamicObject(asstacttype);
                DynamicObject valueSource = asst.getDynamicObject("valuesource");
                if (null == valueSource) continue;
                String asstNumber = asst.getString("number");
                DynamicObject rowObj = this.getModel().getEntryRowEntity(ENTRY, i);
                int index = asstNums.indexOf(asstNumber);
                if (index >= 0) {
                    rowObj.set("isfilter", (Object)Boolean.TRUE);
                    AssgrpEntryRowInfo info = asstNumAndInfoMap.get(asstNumber);
                    if (info != null) {
                        rowObj.set(ASSTMEMBER, (Object)info.asstmember);
                    }
                }
                rowObj.set(ASSTACT_TYPE, (Object)asst);
                ++i;
            }
        }
        this.getView().updateView();
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        DynamicObject org;
        BasedataEdit t;
        if (arg0.getSource() instanceof BasedataEdit && CASHFLOWITEM.equals((t = (BasedataEdit)arg0.getSource()).getKey()) && Objects.isNull(org = (DynamicObject)this.getModel().getValue("org"))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"", (String)"", (Object[])new Object[0]));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        switch (propName) {
            case "org": {
                this.getModel().setValue(CASHFLOWITEM, null);
                this.getModel().deleteEntryData("assgrpentity");
                DynamicObject neworg = (DynamicObject)e.getChangeSet()[0].getNewValue();
                this.getPageCache().put("orgid", neworg == null ? null : neworg.getString("id"));
                break;
            }
            case "cashflowitem": {
                DynamicObject newOne = (DynamicObject)changeSet[0].getNewValue();
                DynamicObject oldOne = (DynamicObject)changeSet[0].getOldValue();
                if (newOne == null) {
                    this.getModel().deleteEntryData("assgrpentity");
                    break;
                }
                if (oldOne != null && newOne.getLong("id") == oldOne.getLong("id")) break;
                String selector = ForumulaCfAndAssgrpPlugin.genUniqueKey("id", "assistentry", "assistentry.asstypeid", "assistentry.asstypeid.number", "assistentry.asstypeid.name", "assistentry.asstypeid.flexfield", "assistentry.asstypeid.valuesource", "assistentry.asstypeid.valuetype");
                this.initAsstEntry(newOne.getLong("id"), ENTITY, selector, "assistentry", "asstypeid", new ArrayList<String>(5), new HashMap<String, AssgrpEntryRowInfo>());
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctr = (Control)evt.getSource();
        String key = ctr.getKey();
        HashMap<String, Consumer<IFormView>> clickMap = new HashMap<String, Consumer<IFormView>>(3);
        clickMap.put("confirm", this::confirmClick);
        clickMap.put(ASSTMEMBER, this::asstMemeber);
        Optional.ofNullable(clickMap.get(key)).ifPresent(v -> v.accept(this.getView()));
    }

    private void asstMemeber(IFormView formView) {
        QFilter orgFilter;
        Tuple<String, DynamicObject> typeMapSource = this.getValueTypeAndSource();
        String entityName = ((DynamicObject)typeMapSource.item2).getString("id");
        if ("3".equals(typeMapSource.item1)) {
            return;
        }
        if ("2".equals(typeMapSource.item1)) {
            EntryGrid entryGrid = (EntryGrid)this.getControl("assgrpentity");
            int[] selectRows = entryGrid.getSelectRows();
            DynamicObject asstacttype = ((DynamicObject)this.getModel().getEntryEntity("assgrpentity").get(selectRows[0])).getDynamicObject(ASSTACT_TYPE);
            ListShowParameter lsp = ShowFormHelper.createShowListForm((String)"bos_assistantdata_detail", (boolean)false);
            long groupId = BusinessDataServiceHelper.loadSingle((Object)asstacttype.get("id"), (String)"bd_asstacttype").getDynamicObject("assistanttype").getLong("id");
            lsp.getListFilterParameter().setFilter(new QFilter("group", "=", (Object)groupId));
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, ASSTMEMBER);
            lsp.setCloseCallBack(closeCallBack);
            lsp.setMultiSelect(true);
            Object orgId = this.getModel().getValue("org_id");
            if (Objects.nonNull(orgId) && Long.parseLong(orgId.toString()) != 0L) {
                this.getView().getFormShowParameter().setCustomParam("orgId", orgId);
            } else {
                this.getView().getFormShowParameter().getCustomParams().remove("orgId");
            }
            this.getView().cacheFormShowParameter();
            this.getView().showForm((FormShowParameter)lsp);
            return;
        }
        ListShowParameter lsp = ShowFormHelper.createShowListForm((String)entityName, (boolean)true);
        ListFilterParameter filterParam = lsp.getListFilterParameter();
        List qFilters = filterParam.getQFilters();
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityName);
        DynamicProperty statusProp = entityType.getProperty("status");
        if (statusProp != null) {
            qFilters.add(new QFilter("status", "=", (Object)"C"));
        }
        if ((orgFilter = BaseDataServiceHelper.getBaseDataFilter((String)entityName, (Long)Long.valueOf(String.valueOf(this.getModel().getValue("org_id"))))) != null) {
            qFilters.add(orgFilter);
        }
        lsp.setUseOrgId(((Long)this.getModel().getValue("org_id")).longValue());
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, ASSTMEMBER);
        lsp.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)lsp);
    }

    private void confirmClick(IFormView formView) {
        DynamicObject cashflowitem = (DynamicObject)formView.getModel().getValue(CASHFLOWITEM);
        if (cashflowitem == null) {
            formView.showTipNotification(ResManager.loadKDString((String)"\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CashFlowItemAndAssgrpPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        StringBuilder returnData = new StringBuilder();
        returnData.append(cashflowitem.getString("number"));
        this.appendAssgrps(this.getModel().getEntryEntity(ENTRY), returnData);
        HashMap<String, String> map = new HashMap<String, String>(1);
        if (returnData.length() > 2000) {
            formView.showTipNotification(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u957f\u5ea6\u8d85\u8fc72000,\u8bf7\u9009\u62e9\u9002\u91cf\u7684\u6838\u7b97\u7ef4\u5ea6\u503c", (String)"CashFlowItemAndAssgrpPlugin_2", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return;
        }
        map.put("returnData", returnData.toString());
        formView.returnDataToParent(map);
        formView.close();
    }

    private Tuple<String, DynamicObject> getValueTypeAndSource() {
        EntryGrid entryGrid = (EntryGrid)this.getControl("assgrpentity");
        int[] selectRows = entryGrid.getSelectRows();
        DynamicObject asstacttype = ((DynamicObject)this.getModel().getEntryEntity("assgrpentity").get(selectRows[0])).getDynamicObject(ASSTACT_TYPE);
        String valuetype = asstacttype.getString("valuetype");
        DynamicObject valuesource = asstacttype.getDynamicObject("valuesource");
        return Tuple.create((Object)valuetype, (Object)valuesource);
    }

    protected void appendAssgrps(DynamicObjectCollection assgrpentity, StringBuilder returnData) {
        for (DynamicObject row : assgrpentity) {
            boolean isfilter = row.getBoolean("isfilter");
            if (!isfilter) continue;
            DynamicObject asstacttype = row.getDynamicObject(ASSTACT_TYPE);
            String asstmember = row.getString(ASSTMEMBER);
            returnData.append('|');
            String asstacttypeNum = asstacttype.getString("number");
            returnData.append(asstacttypeNum).append('|');
            if (!StringUtils.isNotEmpty((CharSequence)asstmember)) continue;
            returnData.append(asstmember);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if ("cancel".equals(key)) {
            this.getView().close();
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        ListSelectedRowCollection coll;
        super.closedCallBack(closedCallBackEvent);
        Object returnData = closedCallBackEvent.getReturnData();
        String actionId = closedCallBackEvent.getActionId();
        if (returnData != null && actionId.endsWith(ASSTMEMBER) && (coll = (ListSelectedRowCollection)returnData).size() > 0) {
            EntryGrid entryGrid = (EntryGrid)this.getControl("assgrpentity");
            int[] selectRows = entryGrid.getSelectRows();
            StringBuilder sb = new StringBuilder();
            for (ListSelectedRow row : coll) {
                if (sb.length() != 0) {
                    sb.append(',');
                }
                sb.append(row.getNumber());
            }
            this.getModel().setValue(actionId, (Object)sb.toString(), selectRows[0]);
        }
    }

    public static String genUniqueKey(String ... strings) {
        StringBuilder key = new StringBuilder();
        key.append(strings[0]);
        for (int i = 1; i < strings.length; ++i) {
            key.append(',');
            key.append(strings[i]);
        }
        return key.toString();
    }

    static class AssgrpEntryRowInfo {
        private String asstmember;

        AssgrpEntryRowInfo(String asstmember) {
            this.asstmember = asstmember;
        }
    }
}

