/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.formplugin.formula;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.ict.util.DateUtils;
import kd.fi.ict.util.DynamicObjectCollectionUtil;
import kd.fi.ict.util.QFBuilder;

public class FoumulaAcctAndAssgrpPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener,
RowClickEventListener {
    private static final String ACCOUNT = "account";
    private static final String ENDACCOUNT = "endaccount";
    private static final String ISMULTIACCOUNT = "ismultiaccount";
    private static final String ASSTMEMBER = "asstmember";
    private static final String SASSTMEMBER = "sasstmember";
    private static final String EASSTMEMBER = "easstmember";
    private static String ENTRY = "assgrpentity";
    private static String MULTIACCOUNT = "multiaccount";
    private static final String TYPE_CONSIST = "1";
    private static final String TYPE_MULT = "2";
    private static final String IS_FILTER = "isfilter";
    private static final String TYPE = "type";

    public void initialize() {
        super.initialize();
        this.addItemClickListeners(new String[]{"toolbarap", ACCOUNT, "org", "accounttable"});
        this.addClickListeners(new String[]{"cancel", "confirm"});
        BasedataEdit account = (BasedataEdit)this.getControl(ACCOUNT);
        BasedataEdit endaccount = (BasedataEdit)this.getControl(ENDACCOUNT);
        BasedataEdit multiaccountEdit = (BasedataEdit)this.getControl("multiaccount");
        account.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        endaccount.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        multiaccountEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.getView().setVisible(Boolean.FALSE, new String[]{"dispropertynumber"});
    }

    private void setAccountF7Filter(BeforeF7SelectEvent e) {
        ListShowParameter param = (ListShowParameter)e.getFormShowParameter();
        param.getListFilterParameter().getQFilters().clear();
        if (this.getModel().getValue("org") != null) {
            QFilter qc = BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountview", (Long)((DynamicObject)this.getModel().getValue("org")).getLong("id"));
            param.getListFilterParameter().setFilter(qc);
        }
        param.getListFilterParameter().setFilter(new QFilter("accounttable.id", "=", (Object)((DynamicObject)this.getModel().getValue("accounttable")).getLong("id")));
        param.getListFilterParameter().setFilter(new QFilter("enddate", "=", (Object)DateUtils.getEndDate()));
    }

    private void setAccountTableF7Filter(BeforeF7SelectEvent e) {
        ListShowParameter param = (ListShowParameter)e.getFormShowParameter();
        QFBuilder bookBuilder = new QFBuilder();
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        bookBuilder.add("org.id", "=", (Object)org.getLong("id"));
        DynamicObject[] dcs = BusinessDataServiceHelper.load((String)this.getAccountBookMetadataNumber(), (String)"accounttable", (QFilter[])bookBuilder.toArray());
        HashSet<Long> bookids = new HashSet<Long>();
        if (dcs != null) {
            for (DynamicObject dy : dcs) {
                bookids.add(dy.getDynamicObject("accounttable").getLong("id"));
            }
            ArrayList<QFilter> list = new ArrayList<QFilter>();
            list.add(new QFilter("id", "in", bookids));
            param.getListFilterParameter().getQFilters().clear();
            param.getListFilterParameter().setFilter((QFilter)list.get(0));
        } else {
            ArrayList<QFilter> list = new ArrayList<QFilter>();
            list.add(new QFilter(TYPE_CONSIST, "=", (Object)"0"));
            param.getListFilterParameter().getQFilters().clear();
            param.getListFilterParameter().setFilter((QFilter)list.get(0));
        }
    }

    private String getAccountBookMetadataNumber() {
        String str = "select fid from t_meta_formdesign where fnumber = ? ";
        DataSet result = DB.queryDataSet((String)"IntergrationUtil", (DBRoute)DBRoute.meta, (String)str, (Object[])new Object[]{"bd_accountbooks"});
        if (result.hasNext()) {
            return "bd_accountbooks";
        }
        return "gl_accountbook";
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{ASSTMEMBER, SASSTMEMBER, EASSTMEMBER, IS_FILTER});
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY);
        entryGrid.addRowClickListener((RowClickEventListener)this);
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (evt.getSource() instanceof TextEdit) {
            QFilter orgFilter;
            EntryGrid entryGrid = (EntryGrid)this.getControl("assgrpentity");
            int[] selectRows = entryGrid.getSelectRows();
            if (selectRows.length == 0) {
                return;
            }
            if (this.getModel().getEntryEntity("assgrpentity").isEmpty()) {
                return;
            }
            DynamicObject asstacttype = ((DynamicObject)this.getModel().getEntryEntity("assgrpentity").get(selectRows[0])).getDynamicObject("asstacttype");
            if (asstacttype == null) {
                return;
            }
            String valuetype = asstacttype.getString("valuetype");
            if ("3".equals(valuetype)) {
                return;
            }
            if (TYPE_MULT.equals(valuetype)) {
                Object orgId;
                ListShowParameter lsp = ShowFormHelper.createShowListForm((String)"bos_assistantdata_detail", (boolean)false);
                long groupId = BusinessDataServiceHelper.loadSingle((Object)asstacttype.get("id"), (String)"bd_asstacttype").getDynamicObject("assistanttype").getLong("id");
                lsp.getListFilterParameter().setFilter(new QFilter("group", "=", (Object)groupId));
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, key);
                lsp.setCloseCallBack(closeCallBack);
                if (ASSTMEMBER.equals(key)) {
                    lsp.setMultiSelect(true);
                }
                if (Objects.nonNull(orgId = this.getModel().getValue("org_id")) && Long.parseLong(orgId.toString()) != 0L) {
                    this.getView().getFormShowParameter().setCustomParam("orgId", orgId);
                } else {
                    this.getView().getFormShowParameter().getCustomParams().remove("orgId");
                }
                this.getView().cacheFormShowParameter();
                this.getView().showForm((FormShowParameter)lsp);
                return;
            }
            DynamicObject valuesource = asstacttype.getDynamicObject("valuesource");
            String entityName = valuesource.getString("id");
            ListShowParameter lsp = ShowFormHelper.createShowListForm((String)entityName, (boolean)false);
            ListFilterParameter filterParam = lsp.getListFilterParameter();
            List qFilters = filterParam.getQFilters();
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityName);
            DynamicProperty statusProp = entityType.getProperty("status");
            if (statusProp != null) {
                qFilters.add(new QFilter("status", "=", (Object)"C"));
            }
            if ((orgFilter = BaseDataServiceHelper.getBaseDataFilter((String)entityName, (Long)Long.valueOf(String.valueOf(this.getModel().getValue("org_id"))))) != null) {
                qFilters.add(orgFilter);
            }
            lsp.setUseOrgId(((Long)this.getModel().getValue("org_id")).longValue());
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, key);
            lsp.setCloseCallBack(closeCallBack);
            if (ASSTMEMBER.equals(key)) {
                lsp.setMultiSelect(true);
            }
            this.getView().showForm((FormShowParameter)lsp);
        } else {
            HashMap map = Maps.newHashMap();
            if ("cancel".equals(key)) {
                this.getView().close();
            } else {
                DynamicObjectCollection assgrpentity;
                String result;
                StringBuilder returnData = new StringBuilder();
                IDataModel model = this.getModel();
                String ismultiaccount = (String)model.getValue(ISMULTIACCOUNT);
                if (TYPE_MULT.equals(ismultiaccount)) {
                    DynamicObjectCollection accts = (DynamicObjectCollection)model.getValue("multiaccount");
                    if (accts.isEmpty()) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u4f1a\u8ba1\u79d1\u76ee\u4e3a\u7a7a\u3002", (String)"FoumulaAcctAndAssgrpPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    for (DynamicObject acct : accts) {
                        if (returnData.length() != 0) {
                            returnData.append(',');
                        }
                        returnData.append(acct.getDynamicObject("fbasedataid").getString("number"));
                    }
                } else {
                    DynamicObject account = (DynamicObject)model.getValue(ACCOUNT);
                    DynamicObject endaccount = (DynamicObject)model.getValue(ENDACCOUNT);
                    if (account == null || endaccount == null) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8d77\u59cb\u6216\u7ed3\u675f\u79d1\u76ee\u4e3a\u7a7a\u3002", (String)"FoumulaAcctAndAssgrpPlugin_0", (String)"fi-ict-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    if (account.getString("number").equals(endaccount.getString("number"))) {
                        returnData.append(account.getString("number"));
                    } else {
                        returnData.append('[');
                        returnData.append(account.getString("number")).append(',');
                        returnData.append(endaccount.getString("number"));
                        returnData.append(']');
                    }
                    if (account.getLong("level") != endaccount.getLong("level")) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8fde\u7eed\u79d1\u76ee\u53d6\u6570\u65f6,\u8d77\u59cb\u548c\u7ed3\u675f\u79d1\u76ee\u7684\u7ea7\u6b21\u5e94\u4fdd\u6301\u4e00\u81f4\u3002", (String)"FoumulaAcctAndAssgrpPlugin_1", (String)"fi-ict-formplugin", (Object[])new Object[0]));
                        return;
                    }
                }
                if (!StringUtils.isEmpty((CharSequence)(result = this.appendAssgrps(assgrpentity = model.getEntryEntity(ENTRY), returnData)))) {
                    this.getView().showTipNotification(result);
                    return;
                }
                map.put("returnData", returnData.toString());
                DynamicObject endaccount = (DynamicObject)this.getModel().getValue(ENDACCOUNT);
                map.put(ENDACCOUNT, endaccount == null ? "" : endaccount.getString("number"));
                map.put("level", endaccount == null ? "" : endaccount.getString("level"));
                DynamicObject table = (DynamicObject)this.getModel().getValue("accounttable");
                map.put("accounttable", table == null ? "0" : table.getString("id"));
                this.getView().returnDataToParent((Object)map);
                this.getView().close();
            }
        }
    }

    private String appendAssgrps(DynamicObjectCollection assgrpentity, StringBuilder returnData) {
        StringBuilder result = new StringBuilder();
        for (DynamicObject row : assgrpentity) {
            boolean isfilter = row.getBoolean(IS_FILTER);
            if (!isfilter) continue;
            DynamicObject asstacttype = row.getDynamicObject("asstacttype");
            String type = row.getString(TYPE);
            String sasstmember = row.getString(SASSTMEMBER);
            String easstmember = row.getString(EASSTMEMBER);
            String asstmember = row.getString(ASSTMEMBER);
            returnData.append('|');
            String asstacttypeNum = asstacttype.getString("number");
            returnData.append(asstacttypeNum).append('|');
            boolean isExistMember = org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)sasstmember) && org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)easstmember) && org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)asstmember);
            if (isExistMember) continue;
            if (TYPE_CONSIST.equals(type)) {
                returnData.append('[');
                returnData.append(sasstmember).append(',');
                returnData.append(easstmember);
                returnData.append(']');
                if (!StringUtils.isEmpty((CharSequence)sasstmember) && !StringUtils.isEmpty((CharSequence)easstmember)) continue;
                result.append(ResManager.loadKDString((String)"\u5f00\u59cb\u6216\u7ed3\u675f\u6210\u5458\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FoumulaAcctAndAssgrpPlugin_3", (String)"fi-ict-formplugin", (Object[])new Object[0]));
                continue;
            }
            returnData.append(asstmember);
        }
        return result.toString();
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        e.getSource();
        if (e.getSource() instanceof BasedataEdit) {
            BasedataEdit t = (BasedataEdit)e.getSource();
            if (ACCOUNT.equals(t.getKey()) || "multiaccount".equals(t.getKey())) {
                if (this.getModel().getValue("accounttable") != null) {
                    this.setAccountF7Filter(e);
                }
            } else if ("accounttable".equals(t.getKey())) {
                if (this.getModel().getValue("org") == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u4e3b\u4f53\u3002", (String)"FoumulaAcctAndAssgrpPlugin_4", (String)"fi-ict-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                } else {
                    this.setAccountTableF7Filter(e);
                }
            } else if (ENDACCOUNT.equals(t.getKey())) {
                if (this.getModel().getValue(ACCOUNT) == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8d77\u59cb\u79d1\u76ee\u3002", (String)"FoumulaAcctAndAssgrpPlugin_5", (String)"fi-ict-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                } else if (this.getModel().getValue("accounttable") != null) {
                    this.setAccountF7Filter(e);
                    DynamicObject dy = (DynamicObject)this.getModel().getValue(ACCOUNT);
                    ListShowParameter param = (ListShowParameter)e.getFormShowParameter();
                    param.getListFilterParameter().getQFilters().add(new QFilter("level", "=", (Object)dy.getInt("level")));
                }
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter param = this.getView().getFormShowParameter();
        String orgid = (String)param.getCustomParam("org");
        String accountBookType = (String)param.getCustomParam("accountbookstype");
        if (StringUtils.isNotEmpty((CharSequence)orgid)) {
            long orgId = Long.parseLong(orgid);
            if (orgId == 0L) {
                orgId = RequestContext.get().getOrgId();
            }
            this.getModel().setValue("org", (Object)orgId);
            this.modifyByOrgChange(orgId, accountBookType);
        } else {
            long oid = RequestContext.get().getOrgId();
            IFormView view = this.getAutoTransParentView(this.getView());
            if (view != null) {
                oid = (Long)view.getModel().getValue("org_id");
            }
            this.getModel().setValue("org", (Object)oid);
            this.modifyByOrgChange(oid, accountBookType);
        }
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        DynamicObject accounttableDyo = (DynamicObject)this.getModel().getValue("accounttable");
        this.resetAccountAndAssgrp(org == null ? 0L : org.getLong("id"), accounttableDyo == null ? 0L : accounttableDyo.getLong("id"), (String)param.getCustomParam(ACCOUNT));
    }

    private IFormView getAutoTransParentView(IFormView curView) {
        String curPageId = curView.getPageId();
        IFormView originalView = curView;
        while (!StringUtils.isEmpty((CharSequence)curPageId) && !Objects.isNull(curView)) {
            if ("gl_autotrans".equals(curView.getEntityId())) {
                return curView;
            }
            curPageId = curView.getFormShowParameter().getParentPageId();
            curView = originalView.getViewNoPlugin(curPageId);
        }
        return null;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        if (ACCOUNT.equals(propName) || "org".equals(propName) || "accounttable".equals(propName) || ENDACCOUNT.equals(propName)) {
            ChangeData[] changeSet = e.getChangeSet();
            DynamicObject newOne = (DynamicObject)changeSet[0].getNewValue();
            DynamicObject oldOne = (DynamicObject)changeSet[0].getOldValue();
            switch (propName) {
                case "account": {
                    if (newOne == null) {
                        this.getModel().deleteEntryData(ENTRY);
                        break;
                    }
                    this.getModel().beginInit();
                    this.getModel().setValue(ENDACCOUNT, (Object)newOne);
                    this.getModel().endInit();
                    this.getView().updateView(ENDACCOUNT);
                    if (oldOne != null && newOne.getLong("id") == oldOne.getLong("id")) break;
                    this.initAsstEntry(newOne, newOne, new ArrayList<String>(5), new HashMap<String, AssgrpEntryRowInfo>(5));
                    break;
                }
                case "endaccount": {
                    if (newOne == null) {
                        this.getModel().deleteEntryData(ENTRY);
                        break;
                    }
                    DynamicObject startaccount = (DynamicObject)this.getModel().getValue(ACCOUNT);
                    if (startaccount == null) break;
                    this.initAsstEntry(startaccount, newOne, new ArrayList<String>(5), new HashMap<String, AssgrpEntryRowInfo>(5));
                    break;
                }
                case "org": {
                    Long orgid = newOne == null ? null : Long.valueOf(newOne.getLong("id"));
                    this.modifyByOrgChange(orgid, null);
                    break;
                }
                case "accounttable": {
                    this.getModel().setValue(ENDACCOUNT, null);
                    this.getModel().setValue("multiaccount", null);
                    this.getModel().setValue(ACCOUNT, null);
                }
            }
        } else if ("multiaccount".equals(propName)) {
            ChangeData[] changeSet = e.getChangeSet();
            DynamicObjectCollection newOne = (DynamicObjectCollection)changeSet[0].getNewValue();
            if (newOne == null || newOne.isEmpty()) {
                this.getModel().deleteEntryData(ENTRY);
            }
            if (newOne != null && !newOne.isEmpty()) {
                List acts = DynamicObjectCollectionUtil.getMultiDynamicObjects((DynamicObjectCollection)newOne);
                this.initMultiAsstEntry(acts, new ArrayList<String>(5), new HashMap<String, AssgrpEntryRowInfo>(5));
            }
        } else if (ISMULTIACCOUNT.equals(propName)) {
            String ismultiaccount = (String)this.getModel().getValue(ISMULTIACCOUNT);
            if (TYPE_MULT.equals(ismultiaccount)) {
                this.getModel().setValue(ENDACCOUNT, null);
                this.getModel().setValue(ACCOUNT, null);
            } else {
                this.getModel().setValue("multiaccount", null);
            }
        } else if (TYPE.equals(propName)) {
            IDataModel model = this.getModel();
            int index = model.getEntryCurrentRowIndex("assgrpentity");
            String type = (String)model.getValue(propName);
            boolean isConsist = TYPE_CONSIST.equals(type);
            if (isConsist) {
                model.setValue(ASSTMEMBER, null, index);
            } else {
                model.setValue(SASSTMEMBER, null, index);
                model.setValue(EASSTMEMBER, null, index);
            }
            this.getView().setEnable(Boolean.valueOf(!isConsist), index, new String[]{ASSTMEMBER});
            this.getView().setEnable(Boolean.valueOf(isConsist), index, new String[]{SASSTMEMBER, EASSTMEMBER});
        }
    }

    private void resetAccountAndAssgrp(long orgId, long accounttableId, String accountStr) {
        IDataModel model = this.getModel();
        if (orgId == 0L || accounttableId == 0L || StringUtils.isEmpty((CharSequence)accountStr)) {
            return;
        }
        String[] memberStrs = accountStr.split("\\|");
        accountStr = memberStrs[0];
        int oldLen = accountStr.length();
        accountStr = accountStr.replace("[", "").replace("]", "");
        int newLen = accountStr.length();
        String[] accts = accountStr.split(",");
        QFilter qbase = BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountview", (Long)orgId);
        QFilter qtable = new QFilter("accounttable", "=", (Object)accounttableId);
        QFilter qnum = new QFilter("number", "in", (Object)accts);
        HashMap<String, Long> numIdsMap = new HashMap<String, Long>();
        try (DataSet dt = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_accountview", (String)"id,number", (QFilter[])new QFilter[]{qbase, qtable, qnum}, null);){
            while (dt.hasNext()) {
                Row row = dt.next();
                String number = row.getString("number");
                long id = row.getLong("id");
                numIdsMap.put(number, id);
            }
        }
        ArrayList<String> asstNums = new ArrayList<String>(memberStrs.length - 1);
        HashMap<String, AssgrpEntryRowInfo> asstNumAndInfoMap = new HashMap<String, AssgrpEntryRowInfo>(memberStrs.length - 1);
        for (int i = 1; i < memberStrs.length; i += 2) {
            int newAssgrpValueLen;
            String member = memberStrs[i];
            asstNums.add(member);
            if (i + 1 >= memberStrs.length) continue;
            AssgrpEntryRowInfo info = null;
            String assgrpValueStr = memberStrs[i + 1];
            int oldAssgrpValueLen = assgrpValueStr.length();
            if (oldAssgrpValueLen != (newAssgrpValueLen = (assgrpValueStr = assgrpValueStr.replace("[", "").replace("]", "")).length())) {
                String[] assgrpValues = assgrpValueStr.split(",");
                if (assgrpValues.length > 0) {
                    info = new AssgrpEntryRowInfo(TYPE_CONSIST, null, assgrpValues[0], assgrpValues[assgrpValues.length - 1]);
                }
            } else {
                info = new AssgrpEntryRowInfo(TYPE_MULT, assgrpValueStr, null, null);
            }
            if (info == null) continue;
            asstNumAndInfoMap.put(member, info);
        }
        if (oldLen != newLen) {
            model.setValue(ISMULTIACCOUNT, (Object)TYPE_CONSIST);
            model.setValue(ACCOUNT, numIdsMap.get(accts[0]));
            model.setValue(ENDACCOUNT, numIdsMap.get(accts[accts.length - 1]));
            if (numIdsMap.get(accts[0]) == null || numIdsMap.get(accts[accts.length - 1]) == null) {
                return;
            }
            this.initAsstEntry((DynamicObject)model.getValue(ACCOUNT), (DynamicObject)model.getValue(ENDACCOUNT), asstNums, asstNumAndInfoMap);
        } else {
            model.setValue(ISMULTIACCOUNT, (Object)TYPE_MULT);
            Object[] ids = numIdsMap.values().toArray();
            if (numIdsMap.values().isEmpty()) {
                return;
            }
            model.setValue(MULTIACCOUNT, (Object)ids);
            this.initMultiAsstEntry(DynamicObjectCollectionUtil.getMultiDynamicObjects((DynamicObjectCollection)((DynamicObjectCollection)model.getValue(MULTIACCOUNT))), asstNums, asstNumAndInfoMap);
        }
    }

    private void modifyByOrgChange(Long orgId, String booktypeId) {
        this.getModel().beginInit();
        this.getModel().setValue("accounttable", null);
        this.getModel().setValue(ENDACCOUNT, null);
        this.getModel().setValue("multiaccount", null);
        this.getModel().setValue(ACCOUNT, null);
        this.getModel().deleteEntryData(ENTRY);
        this.getModel().endInit();
        if (orgId == null || orgId == 0L) {
            return;
        }
        QFBuilder bookBuilder = new QFBuilder();
        bookBuilder.add("org.id", "=", (Object)orgId);
        if (StringUtils.isNotEmpty((CharSequence)booktypeId) && !"0".equals(booktypeId)) {
            bookBuilder.add("bookstype.id", "=", (Object)Long.parseLong(booktypeId));
        } else {
            bookBuilder.add("bookstype.accounttype", "=", (Object)TYPE_CONSIST);
        }
        DynamicObject[] dcs = BusinessDataServiceHelper.load((String)this.getAccountBookMetadataNumber(), (String)"accounttable,accounttable.name,accounttable.number", (QFilter[])bookBuilder.toArray());
        if (dcs != null && dcs.length > 0) {
            this.getModel().setValue("accounttable", (Object)dcs[0].getDynamicObject("accounttable"));
        }
        this.getView().updateView();
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        ListSelectedRowCollection coll;
        super.closedCallBack(closedCallBackEvent);
        Object returnData = closedCallBackEvent.getReturnData();
        String actionId = closedCallBackEvent.getActionId();
        if (returnData != null && actionId.endsWith(ASSTMEMBER) && (coll = (ListSelectedRowCollection)returnData).size() > 0) {
            EntryGrid entryGrid = (EntryGrid)this.getControl("assgrpentity");
            int[] selectRows = entryGrid.getSelectRows();
            StringBuilder sb = new StringBuilder();
            for (ListSelectedRow row : coll) {
                if (!StringUtils.isNotEmpty((CharSequence)row.getNumber())) continue;
                if (sb.length() != 0) {
                    sb.append(',');
                }
                sb.append(row.getNumber());
            }
            this.getModel().setValue(actionId, (Object)sb.toString(), selectRows[0]);
        }
    }

    private void initAsstEntry(DynamicObject startAcct, DynamicObject endAcct, List<String> asstNums, Map<String, AssgrpEntryRowInfo> asstNumAndInfoMap) {
        DynamicObject table;
        this.getModel().beginInit();
        String selector = FoumulaAcctAndAssgrpPlugin.genUniqueKey("id", "checkitementry", "checkitementry.asstactitem", "checkitementry.asstactitem.number", "checkitementry.asstactitem.name", "checkitementry.asstactitem.flexfield", "checkitementry.asstactitem.valuesource, checkitementry.asstactitem.valuetype");
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        ArrayList<QFilter> qfs = new ArrayList<QFilter>(3);
        if (org != null) {
            QFilter qids = BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountview", (Long)org.getLong("id"));
            qfs.add(qids);
        }
        if ((table = (DynamicObject)this.getModel().getValue("accounttable")) != null) {
            qfs.add(new QFilter("accounttable", "=", (Object)table.getLong("id")));
        }
        QFilter idFilter = new QFilter("number", ">=", (Object)startAcct.getString("number")).and(new QFilter("number", "<=", (Object)endAcct.getString("number")));
        qfs.add(idFilter);
        DynamicObject[] accounts = BusinessDataServiceHelper.load((String)"bd_accountview", (String)selector, (QFilter[])qfs.toArray(new QFilter[0]));
        DynamicObjectCollection checkitemEntry = this.getRetainCollection(accounts);
        if (checkitemEntry.size() > 0) {
            this.getModel().deleteEntryData(ENTRY);
            this.getModel().batchCreateNewEntryRow(ENTRY, checkitemEntry.size());
            int i = 0;
            for (DynamicObject checkitem : checkitemEntry) {
                DynamicObject asst = checkitem.getDynamicObject("asstactitem");
                if (asst == null) continue;
                String asstNumber = asst.getString("number");
                DynamicObject rowObj = this.getModel().getEntryRowEntity(ENTRY, i);
                int index = asstNums.indexOf(asstNumber);
                if (index >= 0) {
                    rowObj.set(IS_FILTER, (Object)Boolean.TRUE);
                    AssgrpEntryRowInfo info = asstNumAndInfoMap.get(asstNumber);
                    if (info != null) {
                        rowObj.set(TYPE, (Object)info.type);
                        if (TYPE_CONSIST.equals(info.type)) {
                            rowObj.set(SASSTMEMBER, (Object)info.sasstmember);
                            rowObj.set(EASSTMEMBER, (Object)info.easstmember);
                        } else {
                            rowObj.set(ASSTMEMBER, (Object)info.asstmember);
                        }
                    }
                }
                rowObj.set("asstacttype", (Object)asst);
                rowObj.set("asstnum", (Object)asstNumber);
                ++i;
            }
        } else {
            this.getModel().deleteEntryData(ENTRY);
        }
        this.getModel().endInit();
        this.getView().updateView();
        this.setEntryEnable(this.getModel().getEntryEntity(ENTRY));
    }

    private void initMultiAsstEntry(List<DynamicObject> newDys, List<String> asstNums, Map<String, AssgrpEntryRowInfo> asstNumAndInfoMap) {
        this.getModel().beginInit();
        String selector = FoumulaAcctAndAssgrpPlugin.genUniqueKey("id", "checkitementry", "checkitementry.asstactitem", "checkitementry.asstactitem.number", "checkitementry.asstactitem.name", "checkitementry.asstactitem.flexfield", "checkitementry.asstactitem.valuesource, checkitementry.asstactitem.valuetype");
        ArrayList<Long> ids = new ArrayList<Long>(10);
        for (DynamicObject newDy : newDys) {
            ids.add(newDy.getLong("id"));
        }
        QFilter idFilter = new QFilter("id", "in", ids);
        QFilter[] filters = new QFilter[]{idFilter};
        DynamicObject[] accounts = BusinessDataServiceHelper.load((String)"bd_accountview", (String)selector, (QFilter[])filters);
        DynamicObjectCollection checkitemEntry = this.getRetainCollection(accounts);
        if (checkitemEntry.size() > 0) {
            this.getModel().deleteEntryData(ENTRY);
            this.getModel().batchCreateNewEntryRow(ENTRY, checkitemEntry.size());
            int i = 0;
            for (DynamicObject checkitem : checkitemEntry) {
                DynamicObject asst = checkitem.getDynamicObject("asstactitem");
                if (asst == null) continue;
                String asstNumber = asst.getString("number");
                DynamicObject rowObj = this.getModel().getEntryRowEntity(ENTRY, i);
                int index = asstNums.indexOf(asstNumber);
                if (index >= 0) {
                    rowObj.set(IS_FILTER, (Object)Boolean.TRUE);
                    AssgrpEntryRowInfo info = asstNumAndInfoMap.get(asstNumber);
                    if (info != null) {
                        rowObj.set(TYPE, (Object)info.type);
                        if (TYPE_CONSIST.equals(info.type)) {
                            rowObj.set(SASSTMEMBER, (Object)info.sasstmember);
                            rowObj.set(EASSTMEMBER, (Object)info.easstmember);
                        } else {
                            rowObj.set(ASSTMEMBER, (Object)info.asstmember);
                        }
                    }
                }
                rowObj.set("asstacttype", (Object)asst);
                rowObj.set("asstnum", (Object)asstNumber);
                ++i;
            }
        } else {
            this.getModel().deleteEntryData(ENTRY);
        }
        this.getModel().endInit();
        this.getView().updateView();
        this.setEntryEnable(this.getModel().getEntryEntity(ENTRY));
    }

    private void setEntryEnable(DynamicObjectCollection entry) {
        IFormView view = this.getView();
        for (int i = 0; i < entry.size(); ++i) {
            String typeVal = ((DynamicObject)entry.get(i)).getString(TYPE);
            view.setEnable(Boolean.TRUE, i, new String[]{TYPE});
            if (TYPE_MULT.equalsIgnoreCase(typeVal)) {
                view.setEnable(Boolean.TRUE, i, new String[]{ASSTMEMBER});
                view.setEnable(Boolean.FALSE, i, new String[]{SASSTMEMBER, EASSTMEMBER});
                continue;
            }
            view.setEnable(Boolean.FALSE, i, new String[]{ASSTMEMBER});
            view.setEnable(Boolean.TRUE, i, new String[]{SASSTMEMBER, EASSTMEMBER});
        }
    }

    private DynamicObjectCollection getRetainCollection(DynamicObject[] accounts) {
        HashSet idSets = Sets.newHashSet();
        HashMap idMaps = Maps.newHashMap();
        if (accounts != null) {
            for (int i = 0; i < accounts.length; ++i) {
                HashSet curSets = Sets.newHashSet();
                DynamicObject account = accounts[i];
                for (DynamicObject dynamicObject : account.getDynamicObjectCollection("checkitementry")) {
                    idMaps.put(dynamicObject.getLong("asstactitem_id"), dynamicObject);
                    curSets.add(dynamicObject.getLong("asstactitem_id"));
                }
                if (i == 0) {
                    idSets = curSets;
                    continue;
                }
                idSets.retainAll(curSets);
            }
        }
        DynamicObjectCollection checkitemEntry = new DynamicObjectCollection();
        for (Long id : idSets) {
            DynamicObject dyo = (DynamicObject)idMaps.get(id);
            if (dyo == null) continue;
            checkitemEntry.add((Object)dyo);
        }
        return checkitemEntry;
    }

    public static String genUniqueKey(String ... strings) {
        StringBuilder key = new StringBuilder();
        key.append(strings[0]);
        for (int i = 1; i < strings.length; ++i) {
            key.append(',');
            key.append(strings[i]);
        }
        return key.toString();
    }

    static class AssgrpEntryRowInfo {
        private String type;
        private String asstmember;
        private String sasstmember;
        private String easstmember;

        AssgrpEntryRowInfo(String type, String asstmember, String sasstmember, String easstmember) {
            this.type = type;
            this.asstmember = asstmember;
            this.sasstmember = sasstmember;
            this.easstmember = easstmember;
        }
    }
}

