/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.formplugin.formula;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.IntegerProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.OrgEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ict.enums.PuchType;
import kd.fi.ict.formplugin.formula.IctBcmFormulaParser;
import org.apache.commons.lang3.StringUtils;

public class IctFormulaEditPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String ACCOUNT_AND_ASSGRP_VALUE = "account_and_assgrp_value";
    private static final String CASHFLOW_AND_ASSGRP_VALUE = "cashflow_and_assgrp_value";
    private static final String PUCHTYPE = "verifyytpe";
    private static final String FETCHTYPE = "fetchtype";
    private static final String ICTACCT = "ictacct";
    private static final String[] mustInputFields = new String[]{"oporg", "account", "cashflow", "verifyytpe", "fetchtype"};

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"account", "btn_confirm", "cashflow"});
        ((OrgEdit)this.getControl("org")).addBeforeF7SelectListener((BeforeF7SelectListener)this);
        ((OrgEdit)this.getControl("oporg")).addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.showFormula();
        String formulaType = this.getFormulaNumber();
        this.hideControlByType(formulaType);
        if (ICTACCT.equalsIgnoreCase(formulaType)) {
            this.setFeatchTypeValuesByAcct();
        } else {
            this.setFeatchTypeValuesByCf();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        if (PUCHTYPE.equalsIgnoreCase(propertyName)) {
            this.getModel().setValue(FETCHTYPE, null);
            if (ICTACCT.equalsIgnoreCase(this.getFormulaNumber())) {
                this.setFeatchTypeValuesByAcct();
            } else {
                this.setFeatchTypeValuesByCf();
            }
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "btn_confirm": {
                this.callBackFormual();
                break;
            }
            case "account": {
                this.showAcctAndAssgrpF7();
                break;
            }
            case "cashflow": {
                this.showCashFlowAndAssgrpF7();
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        Object source = e.getSource();
        if (source instanceof OrgEdit && Objects.nonNull(e.getCustomQFilters())) {
            OrgEdit orgEdit = (OrgEdit)source;
            if ("org".equals(orgEdit.getKey())) {
                e.getCustomQFilters().add(new QFilter("id", "!=", this.getModel().getValue("oporg_id")));
                return;
            }
            if ("oporg".equals(orgEdit.getKey())) {
                e.getCustomQFilters().add(new QFilter("id", "!=", this.getModel().getValue("org_id")));
            }
        }
    }

    private void setFeatchTypeValuesByAcct() {
        String puchtype = (String)this.getModel().getValue(PUCHTYPE);
        ComboEdit fetchtype = (ComboEdit)this.getControl(FETCHTYPE);
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(36);
        if (PuchType.PULL.name().equalsIgnoreCase(puchtype) || PuchType.CHECK.name().equalsIgnoreCase(puchtype)) {
            items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"CY \u5e74\u521d\u4f59\u989d", (String)"IctFormulaEditPlugin_0", (String)"fi-ict-formplugin", (Object[])new Object[0])), "CY"));
            items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"C \u671f\u521d\u4f59\u989d", (String)"IctFormulaEditPlugin_1", (String)"fi-ict-formplugin", (Object[])new Object[0])), "C"));
            items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"JFCY \u5e74\u521d\u501f\u65b9", (String)"IctFormulaEditPlugin_2", (String)"fi-ict-formplugin", (Object[])new Object[0])), "JFCY"));
            items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"DFCY \u5e74\u521d\u8d37\u65b9", (String)"IctFormulaEditPlugin_3", (String)"fi-ict-formplugin", (Object[])new Object[0])), "DFCY"));
            items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"JC \u671f\u521d\u501f\u65b9", (String)"IctFormulaEditPlugin_4", (String)"fi-ict-formplugin", (Object[])new Object[0])), "JC"));
            items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"DC \u671f\u521d\u8d37\u65b9", (String)"IctFormulaEditPlugin_5", (String)"fi-ict-formplugin", (Object[])new Object[0])), "DC"));
            items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"FS \u672c\u671f\u53d1\u751f", (String)"IctFormulaEditPlugin_6", (String)"fi-ict-formplugin", (Object[])new Object[0])), "FS"));
            items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"JF \u672c\u671f\u501f\u65b9", (String)"IctFormulaEditPlugin_7", (String)"fi-ict-formplugin", (Object[])new Object[0])), "JF"));
            items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"DF \u672c\u671f\u8d37\u65b9", (String)"IctFormulaEditPlugin_8", (String)"fi-ict-formplugin", (Object[])new Object[0])), "DF"));
            items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"LJ \u672c\u5e74\u7d2f\u8ba1", (String)"IctFormulaEditPlugin_9", (String)"fi-ict-formplugin", (Object[])new Object[0])), "LJ"));
            items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"JL \u672c\u5e74\u7d2f\u8ba1\u501f\u65b9", (String)"IctFormulaEditPlugin_10", (String)"fi-ict-formplugin", (Object[])new Object[0])), "JL"));
            items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"DL \u672c\u5e74\u7d2f\u8ba1\u8d37\u65b9", (String)"IctFormulaEditPlugin_11", (String)"fi-ict-formplugin", (Object[])new Object[0])), "DL"));
            items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"LCY \u672c\u4f4d\u5e01\u5e74\u521d\u4f59\u989d", (String)"IctFormulaEditPlugin_12", (String)"fi-ict-formplugin", (Object[])new Object[0])), "LCY"));
            items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"LC \u672c\u4f4d\u5e01\u671f\u521d\u4f59\u989d", (String)"IctFormulaEditPlugin_13", (String)"fi-ict-formplugin", (Object[])new Object[0])), "LC"));
            items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"LJFCY \u672c\u4f4d\u5e01\u5e74\u521d\u501f\u65b9", (String)"IctFormulaEditPlugin_14", (String)"fi-ict-formplugin", (Object[])new Object[0])), "LJFCY"));
            items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"LDFCY \u672c\u4f4d\u5e01\u5e74\u521d\u8d37\u65b9", (String)"IctFormulaEditPlugin_15", (String)"fi-ict-formplugin", (Object[])new Object[0])), "LDFCY"));
            items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"LJC \u672c\u4f4d\u5e01\u671f\u521d\u501f\u65b9", (String)"IctFormulaEditPlugin_16", (String)"fi-ict-formplugin", (Object[])new Object[0])), "LJC"));
            items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"LDC \u672c\u4f4d\u5e01\u671f\u521d\u8d37\u65b9", (String)"IctFormulaEditPlugin_17", (String)"fi-ict-formplugin", (Object[])new Object[0])), "LDC"));
            items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"LFS \u672c\u4f4d\u5e01\u672c\u671f\u53d1\u751f", (String)"IctFormulaEditPlugin_18", (String)"fi-ict-formplugin", (Object[])new Object[0])), "LFS"));
            items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"LJF \u672c\u4f4d\u5e01\u672c\u671f\u501f\u65b9", (String)"IctFormulaEditPlugin_19", (String)"fi-ict-formplugin", (Object[])new Object[0])), "LJF"));
            items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"LDF \u672c\u4f4d\u5e01\u672c\u671f\u8d37\u65b9", (String)"IctFormulaEditPlugin_20", (String)"fi-ict-formplugin", (Object[])new Object[0])), "LDF"));
            items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"LLJ \u672c\u4f4d\u5e01\u672c\u5e74\u7d2f\u8ba1", (String)"IctFormulaEditPlugin_21", (String)"fi-ict-formplugin", (Object[])new Object[0])), "LLJ"));
            items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"LJL \u672c\u4f4d\u5e01\u672c\u5e74\u7d2f\u8ba1\u501f\u65b9", (String)"IctFormulaEditPlugin_22", (String)"fi-ict-formplugin", (Object[])new Object[0])), "LJL"));
            items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"LDL \u672c\u4f4d\u5e01\u672c\u5e74\u7d2f\u8ba1\u8d37\u65b9", (String)"IctFormulaEditPlugin_23", (String)"fi-ict-formplugin", (Object[])new Object[0])), "LDL"));
        }
        items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"Y \u671f\u672b\u4f59\u989d", (String)"IctFormulaEditPlugin_24", (String)"fi-ict-formplugin", (Object[])new Object[0])), "Y"));
        items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"JY \u671f\u672b\u501f\u65b9", (String)"IctFormulaEditPlugin_25", (String)"fi-ict-formplugin", (Object[])new Object[0])), "JY"));
        items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"DY \u671f\u672b\u8d37\u65b9", (String)"IctFormulaEditPlugin_26", (String)"fi-ict-formplugin", (Object[])new Object[0])), "DY"));
        items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"LY \u672c\u4f4d\u5e01\u671f\u672b\u4f59\u989d", (String)"IctFormulaEditPlugin_27", (String)"fi-ict-formplugin", (Object[])new Object[0])), "LY"));
        items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"LJY \u672c\u4f4d\u5e01\u671f\u672b\u501f\u65b9", (String)"IctFormulaEditPlugin_28", (String)"fi-ict-formplugin", (Object[])new Object[0])), "LJY"));
        items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"LDY \u672c\u4f4d\u5e01\u671f\u672b\u8d37\u65b9", (String)"IctFormulaEditPlugin_29", (String)"fi-ict-formplugin", (Object[])new Object[0])), "LDY"));
        if (PuchType.CHECK.name().equalsIgnoreCase(puchtype)) {
            items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"QFS \u4ec5\u5728\u5f53\u671f\u53d1\u751f\u91d1\u989d", (String)"IctFormulaEditPlugin_30", (String)"fi-ict-formplugin", (Object[])new Object[0])), "QFS"));
            items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"QJF \u4ec5\u5728\u5f53\u671f\u501f\u65b9\u53d1\u751f\u91d1\u989d", (String)"IctFormulaEditPlugin_31", (String)"fi-ict-formplugin", (Object[])new Object[0])), "QJF"));
            items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"QDF \u4ec5\u5728\u5f53\u671f\u8d37\u65b9\u53d1\u751f\u91d1\u989d", (String)"IctFormulaEditPlugin_32", (String)"fi-ict-formplugin", (Object[])new Object[0])), "QDF"));
            items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"LQFS \u672c\u4f4d\u5e01\u4ec5\u5728\u5f53\u671f\u53d1\u751f\u91d1\u989d", (String)"IctFormulaEditPlugin_33", (String)"fi-ict-formplugin", (Object[])new Object[0])), "LQFS"));
            items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"LQJF \u672c\u4f4d\u5e01\u4ec5\u5728\u5f53\u671f\u501f\u65b9\u53d1\u751f\u91d1\u989d", (String)"IctFormulaEditPlugin_34", (String)"fi-ict-formplugin", (Object[])new Object[0])), "LQJF"));
            items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"LQDF \u672c\u4f4d\u5e01\u4ec5\u5728\u5f53\u671f\u8d37\u65b9\u53d1\u751f\u91d1\u989d", (String)"IctFormulaEditPlugin_35", (String)"fi-ict-formplugin", (Object[])new Object[0])), "LQDF"));
        }
        fetchtype.setComboItems(items);
    }

    private void setFeatchTypeValuesByCf() {
        String puchtype = (String)this.getModel().getValue(PUCHTYPE);
        ComboEdit fetchtype = (ComboEdit)this.getControl(FETCHTYPE);
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(36);
        items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"FS \u53d1\u751f\u91d1\u989d", (String)"IctFormulaEditPlugin_38", (String)"fi-ict-formplugin", (Object[])new Object[0])), "FS"));
        if (PuchType.PULL.name().equalsIgnoreCase(puchtype) || PuchType.CHECK.name().equalsIgnoreCase(puchtype)) {
            items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"LJ \u672c\u5e74\u7d2f\u8ba1", (String)"IctFormulaEditPlugin_36", (String)"fi-ict-formplugin", (Object[])new Object[0])), "LJ"));
        }
        if (PuchType.CHECK.name().equalsIgnoreCase(puchtype) || PuchType.NOCHECK.name().equalsIgnoreCase(puchtype)) {
            items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"QFS \u4ec5\u5728\u5f53\u671f\u53d1\u751f\u91d1\u989d", (String)"IctFormulaEditPlugin_37", (String)"fi-ict-formplugin", (Object[])new Object[0])), "QFS"));
        }
        fetchtype.setComboItems(items);
    }

    private void showAcctAndAssgrpF7() {
        Object account;
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("ict_accountassgrpf7");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        Long org = (Long)this.getModel().getValue("org_id");
        Long accountBookType = (Long)this.getModel().getValue("accountbookstype_id");
        if (Objects.nonNull(org)) {
            parameter.setCustomParam("org", (Object)String.valueOf(org));
        }
        if (Objects.nonNull(accountBookType)) {
            parameter.setCustomParam("accountbookstype", (Object)String.valueOf(accountBookType));
        }
        if (Objects.nonNull(account = this.getModel().getValue("account"))) {
            parameter.setCustomParam("account", account);
        }
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ACCOUNT_AND_ASSGRP_VALUE));
        this.getView().showForm(parameter);
    }

    private void showCashFlowAndAssgrpF7() {
        Object cashFlow;
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("ict_cashitemassgrpf7");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        Long org = (Long)this.getModel().getValue("org_id");
        if (Objects.nonNull(org)) {
            parameter.setCustomParam("org", (Object)String.valueOf(org));
        }
        if (Objects.nonNull(cashFlow = this.getModel().getValue("cashflow"))) {
            parameter.setCustomParam("cashflow", cashFlow);
        }
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CASHFLOW_AND_ASSGRP_VALUE));
        this.getView().showForm(parameter);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        if (ACCOUNT_AND_ASSGRP_VALUE.equals(e.getActionId()) && Objects.nonNull(e.getReturnData())) {
            this.getModel().setValue("account", ((Map)e.getReturnData()).get("returnData"));
        } else if (CASHFLOW_AND_ASSGRP_VALUE.equals(e.getActionId()) && Objects.nonNull(e.getReturnData())) {
            this.getModel().setValue("cashflow", ((Map)e.getReturnData()).get("returnData"));
        }
    }

    private void callBackFormual() {
        if (!this.checkMustInput()) {
            return;
        }
        String formulaNumber = this.getFormulaNumber();
        IctBcmFormulaParser parser = new IctBcmFormulaParser(formulaNumber);
        List<String> numbers = parser.getParamNumbers();
        DataEntityPropertyCollection properties = this.getModel().getDataEntityType().getProperties();
        ArrayList<String> valueList = new ArrayList<String>(16);
        for (String field : numbers) {
            IDataEntityProperty property = (IDataEntityProperty)properties.get((Object)field);
            String value = this.getFieldValueByType(property);
            valueList.add(value);
        }
        String format = "=%s(%s)";
        String result = String.format(format, formulaNumber, String.join((CharSequence)",", valueList));
        this.getView().returnDataToParent((Object)result);
        this.getView().close();
    }

    private boolean checkMustInput() {
        String formulaNumber = this.getFormulaNumber();
        ArrayList<String> checkFieldList = new ArrayList<String>(Arrays.asList(mustInputFields));
        if (ICTACCT.equals(formulaNumber)) {
            checkFieldList.remove("cashflow");
        } else {
            checkFieldList.remove("account");
        }
        IDataModel model = this.getModel();
        for (String mustInputField : checkFieldList) {
            Object value = model.getValue(mustInputField);
            if (FETCHTYPE.equals(mustInputField)) {
                IClientViewProxy viewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
                Map fetchtypeMap = viewProxy.getControlMetaState(FETCHTYPE);
                List st = (List)fetchtypeMap.get("st");
                boolean fetchtypeValid = Boolean.FALSE;
                for (List fetchtypeLst : st) {
                    Object fetchtype = fetchtypeLst.get(0);
                    if (!Objects.nonNull(value) || !value.equals(fetchtype)) continue;
                    fetchtypeValid = Boolean.TRUE;
                    break;
                }
                if (!fetchtypeValid) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%1$s\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"IctFormulaEditPlugin_100", (String)"fi-ict-formplugin", (Object[])new Object[0]), model.getDataEntityType().findProperty(mustInputField).getDisplayName().getLocaleValue()));
                    return false;
                }
            }
            if (!Objects.isNull(value) && (!(value instanceof String) || !StringUtils.isBlank((CharSequence)((CharSequence)value)))) continue;
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%1$s\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"IctFormulaEditPlugin_100", (String)"fi-ict-formplugin", (Object[])new Object[0]), model.getDataEntityType().findProperty(mustInputField).getDisplayName().getLocaleValue()));
            return false;
        }
        return true;
    }

    private String getFieldValueByType(IDataEntityProperty property) {
        Object fieldValue = this.getModel().getValue(property.getName());
        if (Objects.isNull(fieldValue)) {
            return this.escapeValue("");
        }
        if (property instanceof BasedataProp) {
            DynamicObject dyObj = (DynamicObject)fieldValue;
            return this.escapeValue(dyObj.getString("number"));
        }
        if (property instanceof ComboProp) {
            return this.escapeValue(String.valueOf(fieldValue));
        }
        if (property instanceof IntegerProp) {
            return String.valueOf(fieldValue);
        }
        return this.escapeValue(String.valueOf(fieldValue));
    }

    private String escapeValue(String value) {
        return "\"" + value + "\"";
    }

    private void showFormula() {
        String formulaNumber = this.getFormulaNumber();
        if (Objects.isNull(formulaNumber)) {
            return;
        }
        String formulaStr = (String)this.getView().getFormShowParameter().getCustomParam("formula");
        IctBcmFormulaParser parse = new IctBcmFormulaParser(formulaNumber);
        Map<String, String> fieldValues = parse.explainFormulaValue(formulaStr);
        DataEntityPropertyCollection properties = this.getModel().getDataEntityType().getProperties();
        fieldValues.forEach((fieldKey, value) -> {
            IDataEntityProperty property = (IDataEntityProperty)properties.get(fieldKey);
            if (StringUtils.isNotEmpty((CharSequence)value)) {
                if (property instanceof BasedataProp) {
                    String baseEntityId = ((BasedataProp)property).getBaseEntityId();
                    List<Object> baseDataIds = this.getBaseDataIds((String)value, baseEntityId);
                    if (baseDataIds.size() > 0) {
                        this.getModel().setValue(property.getName(), baseDataIds.get(0));
                    }
                } else {
                    this.getModel().setValue(property.getName(), value);
                }
            }
        });
    }

    private List<Object> getBaseDataIds(String paramValue, String baseEntityId) {
        return QueryServiceHelper.queryPrimaryKeys((String)baseEntityId, (QFilter[])new QFilter[]{new QFilter("number", "in", (Object)paramValue.split(","))}, (String)null, (int)-1);
    }

    private void hideControlByType(String formulaType) {
        if (ICTACCT.equalsIgnoreCase(formulaType)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"cashflow"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"account", "reclassparam", "currency"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"cashflow"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"account", "reclassparam", "currency"});
        }
    }

    private String getFormulaNumber() {
        return (String)this.getView().getFormShowParameter().getCustomParam("accttype");
    }
}

