/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.formplugin.imports;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.ict.business.bean.VerifySchemeEntry;
import kd.fi.ict.formplugin.imports.IctAccountImportInfo;
import kd.fi.ict.formplugin.imports.IctImportUtil;
import kd.fi.ict.util.AccountServiceHelper;

public class IctImportAcctHandler
extends AbstractBillPlugIn {
    private static final Log LOG = LogFactory.getLog(IctImportAcctHandler.class);
    public static final String FI_ICT_FORMPLUGIN = "fi-ict-formplugin";
    protected static final String selectFields = "accounttable.number acctableNumber,entryentity.account.id acctid,entryentity.interiorassgrp.id interId,entryentity.interiorassgrp.name interName,entryentity.commonassgrp.fbasedataid commonbasedata";

    public void beforeImportData(BeforeImportDataEventArgs e) {
        super.beforeImportData(e);
        Map sourceData = e.getSourceData();
        IctAccountImportInfo accInfo = new IctAccountImportInfo(sourceData);
        LOG.info("IctImportAcctHandler before is sourceData:{}", (Object)sourceData);
        IctImportUtil.setVoucherType(sourceData, accInfo);
        IctImportUtil.setPeriodByBookeddate(sourceData, accInfo);
        this.checkInsideException(accInfo, sourceData);
        this.reconciliationSchema(accInfo, sourceData);
        IctImportUtil.setCurrencyAccAmt(sourceData, accInfo);
        IctImportUtil.setOporgByAssgrp(sourceData, accInfo);
        sourceData.put("sourcesys", "import");
        IctImportUtil.setVchIdAndVchEntryId(sourceData, "t_ict_relacctrecord");
        LOG.info("IctImportAcctHandler after is sourceData:{}", (Object)sourceData);
    }

    private void reconciliationSchema(IctAccountImportInfo accInfo, Map<String, Object> sourceData) {
        DynamicObjectCollection schemaDs = QueryServiceHelper.query((String)"ict_verifyscheme", (String)selectFields, (QFilter[])new QFilter("number", "=", (Object)accInfo.getSchemeNumber()).toArray());
        HashSet<Long> commonassgrpSet = new HashSet<Long>(schemaDs.size());
        for (DynamicObject dyn : schemaDs) {
            commonassgrpSet.add(dyn.getLong("commonbasedata"));
        }
        IctImportUtil.setCommonAssgrp(commonassgrpSet, accInfo, sourceData);
        String acctableNumber = (String)((DynamicObject)schemaDs.get(0)).get("acctableNumber");
        if (accInfo.getAccountTableNumber().equals(acctableNumber)) {
            Map<String, Map<String, String>> assgrpMap = accInfo.getAssgrpInfoMap();
            for (DynamicObject row : schemaDs) {
                VerifySchemeEntry verifySchemeEntry = new VerifySchemeEntry();
                verifySchemeEntry.setAccountId(Long.valueOf(row.getLong("acctid")));
                String interName = row.getString("interName");
                Set childrenIds = AccountServiceHelper.getChildrenIdsByAcctNumber((long)accInfo.getOrgId(), (long)verifySchemeEntry.getAccountId(), (boolean)true, (boolean)false);
                LOG.info("reconciliationSchema childrenIds :" + childrenIds.toString());
                if (!childrenIds.contains(accInfo.getMasterId())) continue;
                for (Map.Entry<String, Map<String, String>> entry : assgrpMap.entrySet()) {
                    if (!entry.getKey().equals(interName)) continue;
                    accInfo.setInteriorassgrp(row.getLong("interId"));
                    accInfo.setAssgrpNumber(entry.getValue().get("number"));
                    return;
                }
                throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u5165\u7684\u6240\u6709\u6838\u7b97\u7ef4\u5ea6\u4e0e\u5bf9\u8d26\u65b9\u6848\u7684\u6838\u7b97\u7ef4\u5ea6\u4e0d\u5339\u914d\u3002", (String)"IctImportHandler_0", (String)FI_ICT_FORMPLUGIN, (Object[])new Object[0]));
            }
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u7684\u79d1\u76ee\u7f16\u7801\u3010%1$s\u3011,\u79d1\u76eeID\u3010%2$s\u3011\u548c\u79d1\u76eemasterId\u3010%3$s\u3011\u4e0d\u662f\u5bf9\u8d26\u65b9\u6848\u79d1\u76ee\u7684\u660e\u7ec6\u79d1\u76ee\uff0c\u7ec4\u7ec7ID\u3010%4$s\u3011\u3002", (String)"IctImportHandler_1", (String)FI_ICT_FORMPLUGIN, (Object[])new Object[0]), accInfo.getAccountNumber(), accInfo.getAccountId(), accInfo.getMasterId(), accInfo.getOrgId()));
        }
        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u7684\u79d1\u76ee\u8868\u3010%s\u3011\u4e0e\u5bf9\u8d26\u65b9\u6848\u7684\u79d1\u76ee\u8868\u4e0d\u5339\u914d\u3002", (String)"IctImportHandler_2", (String)FI_ICT_FORMPLUGIN, (Object[])new Object[0]), accInfo.getAccountTableNumber()));
    }

    private Long queryAccIdByNumber(Long orgId, Long accountTable, String number, Date enddate) {
        Long accId = null;
        ArrayList<QFilter> filters = new ArrayList<QFilter>(3);
        filters.add(new QFilter("accounttable", "=", (Object)accountTable));
        QFilter qids = BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountview", (Long)orgId);
        filters.add(qids);
        filters.add(new QFilter("number", "=", (Object)number));
        filters.add(new QFilter("enddate", ">=", (Object)enddate));
        filters.add(new QFilter("startdate", "<=", (Object)enddate));
        DynamicObject dyn = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_accountview", (String)"id", (QFilter[])filters.toArray(new QFilter[0]));
        if (dyn != null) {
            accId = dyn.getLong("id");
        }
        return accId;
    }

    private void checkInsideException(IctAccountImportInfo accInfo, Map<String, Object> sourceData) {
        IctImportUtil.checkReconScheme(accInfo);
        Long accounttableId = (Long)ThreadCache.get((Object)("IctImportAcctHandler-" + accInfo.getOrgId() + accInfo.getBookTypeId()), () -> {
            DynamicObject accountBookDyn = QueryServiceHelper.queryOne((String)"gl_accountbook", (String)"accounttable,curperiod,isbizunit", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)accInfo.getOrgId()), new QFilter("bookstype", "=", (Object)accInfo.getBookTypeId())});
            if (!accountBookDyn.getBoolean("isbizunit")) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u7f16\u7801\u4e3a\uff1a\u3010%s\u3011\u7684\u6838\u7b97\u7ec4\u7ec7\u4e0d\u662f\u5b9e\u4f53\u7ec4\u7ec7\u3002", (String)"IctImportHandler_4", (String)FI_ICT_FORMPLUGIN, (Object[])new Object[]{accInfo.getOrgNumber()}));
            }
            return accountBookDyn.getLong("accounttable");
        });
        Long accId = this.queryAccIdByNumber(accInfo.getOrgId(), accounttableId, accInfo.getAccountNumber(), accInfo.getEnddate());
        if (null == accId) {
            throw new KDBizException(ResManager.loadKDString((String)"\u79d1\u76ee\u7f16\u7801\u4e3a\uff1a\u3010%s\u3011\u586b\u5199\u4e0d\u6b63\u786e\u3002", (String)"IctImportHandler_5", (String)FI_ICT_FORMPLUGIN, (Object[])new Object[]{accInfo.getAccountNumber()}));
        }
        accInfo.setAccountId(accId);
        Long masterId = (Long)ThreadCache.get((Object)("IctImportAcctHandler-" + accInfo.getAccountId()), () -> {
            DynamicObject dyn = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_accountview", (String)"masterid", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)accInfo.getAccountId())});
            return dyn.getLong("masterid");
        });
        accInfo.setMasterId(masterId);
        Map accountInfoMap = (Map)sourceData.get("account");
        accountInfoMap.put("id", accId);
        sourceData.put("account", accountInfoMap);
    }
}

