/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.formplugin.imports;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.ict.accsys.AccSysUtil;
import kd.fi.ict.accsys.AccountBookInfo;
import kd.fi.ict.business.bean.VerifySchemeEntry;
import kd.fi.ict.formplugin.imports.IctAccountImportInfo;
import kd.fi.ict.formplugin.imports.IctImportUtil;
import kd.fi.ict.util.AccountServiceHelper;
import kd.fi.ict.util.QFBuilder;

public class IctImportCfHandler
extends AbstractBillPlugIn {
    private static final Log LOG = LogFactory.getLog(IctImportCfHandler.class);
    public static final String FI_ICT_FORMPLUGIN = "fi-ict-formplugin";
    protected static final String selectFields = "entryentity.cashflowitem.masterid ctmasterid,entryentity.interiorassgrp.id interId,entryentity.interiorassgrp.name interName,entryentity.commonassgrp.fbasedataid commonbasedata";

    public void beforeImportData(BeforeImportDataEventArgs ext) {
        Map sourceData = ext.getSourceData();
        LOG.info("IctImportCfHandler before is sourceData:{}", (Object)sourceData);
        IctAccountImportInfo cfInfo = new IctAccountImportInfo(sourceData);
        IctImportUtil.setVoucherType(sourceData, cfInfo);
        this.checkInsideException(cfInfo, sourceData);
        IctImportUtil.setPeriodByBookeddate(sourceData, cfInfo);
        IctImportUtil.setCurrencyCfAmt(sourceData, cfInfo);
        this.reconciliationSchema(cfInfo, sourceData);
        this.baseCurrency(cfInfo);
        IctImportUtil.setOporgByAssgrp(sourceData, cfInfo);
        sourceData.put("sourcesys", "import");
        sourceData.put("isconvert", "0");
        sourceData.put("convertamtbal", cfInfo.getAmt());
        sourceData.put("convertamt", cfInfo.getAmt());
        sourceData.put("concurrency", sourceData.get("currency"));
        IctImportUtil.setVchIdAndVchEntryId(sourceData, "t_ict_relcfrecord");
        LOG.info("IctImportCfHandler after is sourceData:{}", (Object)sourceData);
    }

    private void baseCurrency(IctAccountImportInfo cfInfo) {
        AccountBookInfo book = AccSysUtil.getBookFromAccSys((long)cfInfo.getOrgId(), (long)cfInfo.getBookTypeId());
        String baseCurrencyId = String.valueOf(book.getBaseCurrencyId());
        QFBuilder currencyIdBuilder = new QFBuilder("id", "=", (Object)Long.valueOf(baseCurrencyId));
        DynamicObject curDynObj = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_currency", (String)"number", (QFilter[])currencyIdBuilder.toArray());
        String curNumber = curDynObj.getString("number");
        if (!curNumber.equals(cfInfo.getCurrencyNumber())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u7684\u672c\u4f4d\u5e01\u4e0e\u586b\u5165\u7684\u4e0d\u5339\u914d\uff0c\u8bf7\u67e5\u770b\u8be5\u7ec4\u7ec7\u7684\u672c\u4f4d\u5e01\u518d\u91cd\u65b0\u586b\u5165\u3002", (String)"IctAccountImportInfo_8", (String)FI_ICT_FORMPLUGIN, (Object[])new Object[0]));
        }
    }

    private void reconciliationSchema(IctAccountImportInfo cfInfo, Map<String, Object> sourceData) {
        DynamicObjectCollection schemaDs = QueryServiceHelper.query((String)"ict_verifyscheme", (String)selectFields, (QFilter[])new QFilter("number", "=", (Object)cfInfo.getSchemeNumber()).toArray());
        Map<String, Map<String, String>> assgrpMap = cfInfo.getAssgrpInfoMap();
        HashSet<Long> commonassgrpSet = new HashSet<Long>(schemaDs.size());
        for (DynamicObject dyn : schemaDs) {
            commonassgrpSet.add(dyn.getLong("commonbasedata"));
        }
        IctImportUtil.setCommonAssgrp(commonassgrpSet, cfInfo, sourceData);
        for (DynamicObject row : schemaDs) {
            VerifySchemeEntry verifySchemeEntry = new VerifySchemeEntry();
            verifySchemeEntry.setCashflowitemId(Long.valueOf(row.getLong("ctmasterid")));
            Set childrenIdsByCfId = AccountServiceHelper.getChildrenIdsByCfId((long)cfInfo.getOrgId(), (long)verifySchemeEntry.getCashflowitemId(), (boolean)true, (boolean)false);
            String interName = row.getString("interName");
            if (!childrenIdsByCfId.contains(cfInfo.getCashflowitemId())) continue;
            for (Map.Entry<String, Map<String, String>> entry : assgrpMap.entrySet()) {
                if (!entry.getKey().equals(interName)) continue;
                cfInfo.setInteriorassgrp(row.getLong("interId"));
                cfInfo.setAssgrpNumber(entry.getValue().get("number"));
                return;
            }
            throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u5165\u7684\u6240\u6709\u6838\u7b97\u7ef4\u5ea6\u4e0e\u5bf9\u8d26\u65b9\u6848\u7684\u6838\u7b97\u7ef4\u5ea6\u4e0d\u5339\u914d\u3002", (String)"IctImportHandler_0", (String)FI_ICT_FORMPLUGIN, (Object[])new Object[0]));
        }
        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u7684\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u3010%s\u3011\u4e0e\u5bf9\u8d26\u65b9\u6848\u7684\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u4e0d\u5339\u914d\u3002", (String)"IctImportCfHandler_0", (String)FI_ICT_FORMPLUGIN, (Object[])new Object[0]), cfInfo.getCashflowitemNumber()));
    }

    private void checkInsideException(IctAccountImportInfo cfInfo, Map<String, Object> sourceData) {
        IctImportUtil.checkReconScheme(cfInfo);
        QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"gl_cashflowitem", (Long)cfInfo.getOrgId());
        DynamicObjectCollection cashflowitems = QueryServiceHelper.query((String)"gl_cashflowitem", (String)"masterid,isassist", (QFilter[])new QFilter[]{baseDataFilter});
        ArrayList cfMasterIds = new ArrayList(cashflowitems.size());
        cashflowitems.forEach(value -> cfMasterIds.add(value.getLong("masterid")));
        QFilter cfIdsFilter = new QFilter("masterid", "in", cfMasterIds);
        cfIdsFilter.and(new QFilter("number", "=", (Object)cfInfo.getCashflowitemNumber()));
        DynamicObject dynCf = BusinessDataServiceHelper.loadSingleFromCache((String)"gl_cashflowitem", (String)"masterid", (QFilter[])cfIdsFilter.toArray());
        if (Objects.isNull(dynCf)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u73b0\u91d1\u6d41\u91cf\u7f16\u7801\u3010%s\u3011\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u66ff\u6362\u7f16\u7801\u3002", (String)"IctImportCfHandler_1", (String)FI_ICT_FORMPLUGIN, (Object[])new Object[0]), cfInfo.getCashflowitemNumber()));
        }
        Map cashflowitemMap = (Map)sourceData.get("cashflowitem");
        cashflowitemMap.put("id", dynCf.getLong("masterid"));
        sourceData.put("cashflowitem", cashflowitemMap);
        cfInfo.setCashflowitemId(dynCf.getLong("masterid"));
    }
}

