/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.formplugin.imports;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.ict.constant.GLField;
import kd.fi.ict.formplugin.imports.IctAccountImportInfo;
import kd.fi.ict.util.ICTUtils;
import kd.fi.ict.util.QFBuilder;

public class IctImportUtil {
    private static final String FI_ICT_FORMPLUGIN = "fi-ict-formplugin";
    private static final String ICTIMPORTUTIL = "IctImportUtil-Scheme";
    private static final String ICTIMPORTUTIL_ACCOUNTBOOK = "ictimportutil-accountbook";

    protected static void checkReconScheme(IctAccountImportInfo accInfo) {
        if (StringUtils.isBlank((CharSequence)accInfo.getOrgNumber())) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u7f16\u7801\u4e3a\uff1a\u3010%s\u3011\u7684\u7ec4\u7ec7\uff0c\u6216\u8005\u8be5\u7ec4\u7ec7\u6ca1\u6709\u51ed\u8bc1\u7684\u67e5\u770b\u6743\u9650\u3002", (String)"IctImportUtil_0", (String)FI_ICT_FORMPLUGIN, (Object[])new Object[0]), accInfo.getOrgNumber()));
        }
        String orgName = (String)ThreadCache.get((Object)("IctImportUtil-" + accInfo.getOrgNumber()), () -> {
            QFBuilder orgNumberFilter = new QFBuilder("number", "=", (Object)accInfo.getOrgNumber());
            DynamicObject orgDynObj = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (String)"name", (QFilter[])orgNumberFilter.toArray());
            return orgDynObj.getString("name");
        });
        if (accInfo.getOrgName().equals("")) {
            accInfo.setOrgName(orgName);
        }
        if (!orgName.equals(accInfo.getOrgName())) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u540d\u79f0\u3010%1$s\u3011\u4e0e\u6838\u7b97\u7ec4\u7ec7\u7f16\u7801\u3010%2$s\u3011\u4e0d\u5339\u914d\u3002", (String)"IctImportUtil_1", (String)FI_ICT_FORMPLUGIN, (Object[])new Object[0]), accInfo.getOrgName(), accInfo.getOrgNumber()));
        }
        if (StringUtils.isBlank((CharSequence)accInfo.getSchemeNumber())) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u5bf9\u8d26\u7f16\u7801\u4e3a\uff1a\u3010%s\u3011\u7684\u5bf9\u8d26\u7f16\u7801\u3002", (String)"IctImportUtil_2", (String)FI_ICT_FORMPLUGIN, (Object[])new Object[0]), accInfo.getSchemeNumber()));
        }
        String schemeName = (String)ThreadCache.get((Object)("IctImportUtil-" + accInfo.getSchemeNumber()), () -> {
            QFBuilder schemeNumberFilter = new QFBuilder("number", "=", (Object)accInfo.getSchemeNumber());
            DynamicObject schemeDynObj = BusinessDataServiceHelper.loadSingleFromCache((String)"ict_verifyscheme", (String)"name", (QFilter[])schemeNumberFilter.toArray());
            if (null == schemeDynObj) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u7684\u5bf9\u8d26\u65b9\u6848\u7f16\u7801\u3010%1$s\u3011\uff0c\u5728\u5185\u90e8\u5bf9\u8d26\u65b9\u6848\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u4e0b\u5bf9\u8d26\u65b9\u6848\u7f16\u7801\u7684\u6b63\u786e\u6027\u3002", (String)"IctImportUtil_13", (String)FI_ICT_FORMPLUGIN, (Object[])new Object[0]), accInfo.getSchemeNumber()));
            }
            return schemeDynObj.getString("name");
        });
        HashMap<String, Object> schemeMap = (HashMap<String, Object>)ThreadCache.get((Object)ICTIMPORTUTIL);
        if (Objects.isNull(schemeMap)) {
            schemeMap = new HashMap<String, Object>(20);
            QFBuilder schemeNumberFilter = new QFBuilder("number", "=", (Object)accInfo.getSchemeNumber());
            DynamicObject schemeDynObj = BusinessDataServiceHelper.loadSingleFromCache((String)"ict_verifyscheme", (String)"number,org,accounttable", (QFilter[])schemeNumberFilter.toArray());
            schemeMap.put("number", schemeDynObj.getString("number"));
            schemeMap.put("org", schemeDynObj.get("org"));
            schemeMap.put("accounttable", schemeDynObj.get("accounttable"));
            ThreadCache.put((Object)ICTIMPORTUTIL, schemeMap);
        }
        if (null != schemeMap.get("accounttable") && !((DynamicObject)schemeMap.get("accounttable")).get("number").equals(accInfo.getAccountTableNumber())) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u7684\u79d1\u76ee\u8868\u7f16\u7801\u3010%1$s\u3011\uff0c\u5728\u5185\u90e8\u5bf9\u8d26\u65b9\u6848\u4e2d\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u4e0b\u79d1\u76ee\u8868\u7f16\u7801\u7684\u6b63\u786e\u6027\u3002", (String)"IctImportUtil_15", (String)FI_ICT_FORMPLUGIN, (Object[])new Object[0]), accInfo.getAccountTableNumber()));
        }
        if (accInfo.getSchemeName().equals("")) {
            accInfo.setSchemeName(schemeName);
        }
    }

    protected static void setCommonAssgrp(Set<Long> commonassgrpSet, IctAccountImportInfo accInfo, Map<String, Object> sourceData) {
        Tuple<String, String> flexFieldAndValue = null;
        String assName = null;
        String commonass = null;
        ArrayList<String> commonassList = new ArrayList<String>(2);
        Map<String, Map<String, String>> assgrpMap = accInfo.getAssgrpInfoMap();
        for (Long commonAssgrp : commonassgrpSet) {
            assName = IctImportUtil.selectSchemaLog(commonAssgrp);
            for (Map.Entry<String, Map<String, String>> entry : assgrpMap.entrySet()) {
                if (!assName.equals(entry.getKey())) continue;
                flexFieldAndValue = IctImportUtil.getFlexFieldAndValue(commonAssgrp);
                commonass = (String)flexFieldAndValue.item2 + "=" + commonAssgrp;
                commonassList.add(commonass);
            }
        }
        if (commonassgrpSet.size() > 1) {
            commonass = String.join((CharSequence)";", commonassList.stream().map(String::valueOf).collect(Collectors.toList()));
        }
        sourceData.put("commonassgrp", commonass);
    }

    private static String selectSchemaLog(Long commonAssgrp) {
        return (String)DB.query((DBRoute)DBRoute.of((String)"sys"), (String)"select fname as c from  t_bas_flex_property_l where fentryid =?  and flocaleid = 'zh_CN';", (Object[])new Object[]{commonAssgrp}, e -> {
            if (e.next()) {
                return e.getString("c");
            }
            return "";
        });
    }

    protected static void setPeriodByBookeddate(Map<String, Object> sourceData, IctAccountImportInfo accInfo) {
        DynamicObject bookTypeDyn = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_accountbookstype", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)accInfo.getBookTypeNumber())});
        if (bookTypeDyn == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8d26\u7c3f\u7f16\u7801\u4e3a\uff1a\u3010%s\u3011\u7684\u8d26\u7c3f\u7c7b\u578b\u4e0d\u5b58\u5728\u3002", (String)"IctImportHandler_3", (String)FI_ICT_FORMPLUGIN, (Object[])new Object[]{accInfo.getBookTypeNumber()}));
        }
        accInfo.setBookTypeId(bookTypeDyn.getLong("id"));
        Map periodTypeMap = (Map)ThreadCache.get((Object)("IctImportutil-" + accInfo.getOrgId() + accInfo.getBookTypeId()), () -> {
            QFilter orgFilter = new QFilter("org", "=", (Object)accInfo.getOrgId());
            QFilter bookTypeFilter = new QFilter("bookstype", "=", (Object)accInfo.getBookTypeId());
            DynamicObject periodTypeDyn = BusinessDataServiceHelper.loadSingleFromCache((String)"gl_accountbook", (String)"periodtype_id, startperiod_id", (QFilter[])new QFilter[]{orgFilter, bookTypeFilter});
            long periodtypeId = periodTypeDyn.getLong("periodtype_id");
            long startperiodId = periodTypeDyn.getLong("startperiod_id");
            HashMap<String, Long> periodsMap = new HashMap<String, Long>(2);
            periodsMap.put("periodtype", periodtypeId);
            periodsMap.put("startperiod", startperiodId);
            return periodsMap;
        });
        QFilter periodtypeFilter = new QFilter("periodtype", "=", periodTypeMap.get("periodtype"));
        QFilter begindateFilter = new QFilter("begindate", "<=", (Object)accInfo.getBookeddate());
        QFilter enddateFilter = new QFilter("enddate", ">=", (Object)accInfo.getBookeddate());
        DynamicObject periodDyn = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_period", (String)"id, enddate", (QFilter[])new QFilter[]{periodtypeFilter, begindateFilter, enddateFilter});
        if (periodDyn == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8bb0\u8d26\u65e5\u671f\u3010%s\u3011\u6ca1\u6709\u5339\u914d\u5230\u5bf9\u5e94\u7684\u671f\u95f4\u3002", (String)"IctImportHandler_7", (String)FI_ICT_FORMPLUGIN, (Object[])new Object[0]), sourceData.get("bookeddate")));
        }
        long periodid = periodDyn.getLong("id");
        if (periodid < (Long)periodTypeMap.get("startperiod")) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bb0\u8d26\u65e5\u671f\u6240\u5728\u7684\u671f\u95f4\u4e0d\u80fd\u5c0f\u4e8e\u5f53\u524d\u7ec4\u7ec7\u7684\u542f\u7528\u671f\u95f4\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\u8bb0\u8d26\u65e5\u671f\u3002", (String)"IctImportHandler_6", (String)FI_ICT_FORMPLUGIN, (Object[])new Object[0]));
        }
        accInfo.setEnddate(periodDyn.getDate("enddate"));
        HashMap<String, Long> periodMap = new HashMap<String, Long>(3);
        periodMap.put("id", periodid);
        sourceData.put("period", periodMap);
        sourceData.put("ori_period", periodMap);
    }

    protected static void setCurrencyAccAmt(Map<String, Object> sourceData, IctAccountImportInfo accInfo) {
        BigDecimal amtloc;
        if (sourceData.get("amt").toString().equals("0")) {
            throw new KDBizException(ResManager.loadKDString((String)"\u539f\u5e01\u91d1\u989d\u4e0d\u80fd\u4e3a0\u3002", (String)"IctImportUtil_4", (String)FI_ICT_FORMPLUGIN, (Object[])new Object[0]));
        }
        BigDecimal amtbal = accInfo.getAmt();
        sourceData.put("amtbal", amtbal);
        HashMap<String, Long> accountBookMap = (HashMap<String, Long>)ThreadCache.get((Object)ICTIMPORTUTIL_ACCOUNTBOOK);
        if (Objects.isNull(accountBookMap)) {
            accountBookMap = new HashMap<String, Long>(20);
            Map bookTypeInfoMap = (Map)sourceData.get("booktype");
            DynamicObject bookTypeDyn = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_accountbookstype", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", bookTypeInfoMap.get("number"))});
            Long bookTypeId = bookTypeDyn.getLong("id");
            QFilter org = new QFilter("org", "=", (Object)accInfo.getOrgId());
            QFilter bookType = new QFilter("bookstype", "=", (Object)bookTypeId);
            DynamicObject book = QueryServiceHelper.queryOne((String)"gl_accountbook", (String)"id, exratetable, basecurrency", (QFilter[])new QFilter[]{org, bookType});
            accountBookMap.put("exratetable", book.getLong("exratetable"));
            accountBookMap.put("basecurrency", book.getLong("basecurrency"));
            ThreadCache.put((Object)ICTIMPORTUTIL, accountBookMap);
        }
        if (null == sourceData.get("localrate") && null == sourceData.get("amtloc")) {
            Map currencyInfoMap = (Map)sourceData.get("currency");
            Long currencyId = (Long)ThreadCache.get((Object)("IctImportUtil-" + currencyInfoMap.get("number")), () -> {
                DynamicObject currencyDyn = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_currency", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", currencyInfoMap.get("number"))});
                return currencyDyn.getLong("id");
            });
            HashMap currencyLocInfoMap = new HashMap(3);
            currencyLocInfoMap.put("id", accountBookMap.get("basecurrency"));
            sourceData.put("currencyloc", currencyLocInfoMap);
            BigDecimal exchangeRate = ICTUtils.getExchangeRate((Long)((Long)accountBookMap.get("exratetable")), (Long)currencyId, (Long)((Long)accountBookMap.get("basecurrency")), (Date)accInfo.getBookeddate());
            if (currencyId.equals(accountBookMap.get("basecurrency"))) {
                sourceData.put("localrate", BigDecimal.valueOf(1L));
            } else {
                sourceData.put("localrate", exchangeRate);
            }
            BigDecimal localrate = (BigDecimal)sourceData.get("localrate");
            sourceData.put("amtloc", accInfo.getAmt().multiply(localrate));
            sourceData.put("amtballoc", amtbal.multiply(localrate));
        } else if (null != sourceData.get("amtloc") && null == sourceData.get("localrate")) {
            if (sourceData.get("amtloc").toString().equals("0")) {
                throw new KDBizException(ResManager.loadKDString((String)"\u672c\u4f4d\u5e01\u91d1\u989d\u4e0d\u80fd\u4e3a0\u3002", (String)"IctImportUtil_5", (String)FI_ICT_FORMPLUGIN, (Object[])new Object[0]));
            }
            try {
                amtloc = new BigDecimal((String)sourceData.get("amtloc"));
                sourceData.put("localrate", amtloc.divide(accInfo.getAmt()));
                sourceData.put("amtballoc", amtloc);
            }
            catch (NumberFormatException ex) {
                throw new KDBizException(ex.getCause(), new ErrorCode("", ResManager.loadKDString((String)"\u672c\u4f4d\u5e01\u91d1\u989d\u4e0d\u80fd\u4e3a\u975e\u6570\u5b57\u7c7b\u578b\u7684\u503c\u3002", (String)"IctImportUtil_6", (String)FI_ICT_FORMPLUGIN, (Object[])new Object[0])), new Object[0]);
            }
        } else if (null == sourceData.get("amtloc") && null != sourceData.get("localrate")) {
            if (sourceData.get("localrate").toString().equals("0")) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6c47\u7387\u4e0d\u80fd\u4e3a0\u3002", (String)"IctImportUtil_7", (String)FI_ICT_FORMPLUGIN, (Object[])new Object[0]), new Object[0]));
            }
            try {
                BigDecimal localrate = new BigDecimal((String)sourceData.get("localrate"));
                HashMap currencyLocInfoMap = new HashMap(3);
                currencyLocInfoMap.put("id", accountBookMap.get("basecurrency"));
                sourceData.put("currencyloc", currencyLocInfoMap);
                sourceData.put("amtloc", localrate.multiply(accInfo.getAmt()));
                sourceData.put("amtballoc", localrate.multiply(accInfo.getAmt()));
            }
            catch (NumberFormatException ex) {
                throw new KDBizException(ex.getCause(), new ErrorCode("", ResManager.loadKDString((String)"\u6c47\u7387\u4e0d\u80fd\u4e3a\u975e\u6570\u5b57\u7c7b\u578b\u7684\u503c\u3002", (String)"IctImportUtil_8", (String)FI_ICT_FORMPLUGIN, (Object[])new Object[0])), new Object[0]);
            }
        } else {
            amtloc = new BigDecimal((String)sourceData.get("amtloc"));
            sourceData.put("amtballoc", amtloc);
        }
        sourceData.put("status", "0");
    }

    public static void setCurrencyCfAmt(Map<String, Object> sourceData, IctAccountImportInfo cfInfo) {
        BigDecimal amt = cfInfo.getAmt();
        sourceData.put("amtbal", amt);
        sourceData.put("status", "0");
    }

    public static void setVchIdAndVchEntryId(Map<String, Object> sourceData, String tableName) {
        long pkId = DB.genLongId((String)tableName);
        sourceData.put("id", pkId);
        sourceData.put("voucherid", pkId);
        sourceData.put("voucherentry", pkId);
    }

    protected static void setOporgByAssgrp(Map<String, Object> sourceData, IctAccountImportInfo accInfo) {
        Long assgrpId = accInfo.getInteriorassgrp();
        if (assgrpId > 0L) {
            DynamicObject fromMerchantsDO;
            QFBuilder qfBuilder;
            Tuple<String, String> flexFieldAndValueSource = IctImportUtil.getFlexFieldAndValue(assgrpId);
            if ("bd_customer".equals(flexFieldAndValueSource.item1)) {
                qfBuilder = new QFBuilder();
                qfBuilder.add("number", "=", (Object)accInfo.getAssgrpNumber());
                fromMerchantsDO = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_customer", (String)"internal_company,number,name", (QFilter[])qfBuilder.toArray());
                IctImportUtil.assgrpToOporg(fromMerchantsDO, sourceData, accInfo);
            }
            if ("bd_supplier".equals(flexFieldAndValueSource.item1)) {
                qfBuilder = new QFBuilder();
                qfBuilder.add("number", "=", (Object)accInfo.getAssgrpNumber());
                fromMerchantsDO = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_supplier", (String)"internal_company,number,name", (QFilter[])qfBuilder.toArray());
                IctImportUtil.assgrpToOporg(fromMerchantsDO, sourceData, accInfo);
            }
            if ("bd_bizpartner".equals(flexFieldAndValueSource.item1)) {
                qfBuilder = new QFBuilder();
                qfBuilder.add("number", "=", (Object)accInfo.getAssgrpNumber());
                fromMerchantsDO = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_bizpartner", (String)"internal_company,number,name", (QFilter[])qfBuilder.toArray());
                IctImportUtil.assgrpToOporg(fromMerchantsDO, sourceData, accInfo);
            }
            if ("bos_org".equals(flexFieldAndValueSource.item1)) {
                qfBuilder = new QFBuilder();
                qfBuilder.add("number", "=", (Object)accInfo.getAssgrpNumber());
                fromMerchantsDO = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (String)"id", (QFilter[])qfBuilder.toArray());
                IctImportUtil.assgrpToOporg(fromMerchantsDO, sourceData, accInfo);
            }
        }
    }

    private static void assgrpToOporg(DynamicObject fromMerchantsDO, Map<String, Object> sourceData, IctAccountImportInfo accInfo) {
        if (Objects.isNull(fromMerchantsDO)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u6838\u7b97\u7ef4\u5ea6\u503c\u7f16\u7801\u3010%s\u3011\u6ca1\u6709\u5185\u90e8\u4e1a\u52a1\u5355\u5143\uff0c\u8bf7\u91cd\u65b0\u66ff\u6362\u6838\u7b97\u7ef4\u5ea6\u3002", (String)"IctImportUtil_9", (String)FI_ICT_FORMPLUGIN, (Object[])new Object[0]), accInfo.getAssgrpNumber()));
        }
        Long oporgid = "bos_org".equals(fromMerchantsDO.getDataEntityType().getName()) ? Long.valueOf(fromMerchantsDO.getLong("id")) : Long.valueOf(fromMerchantsDO.getLong(GLField.id_((String)"internal_company")));
        if (0L == oporgid) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u6838\u7b97\u7ef4\u5ea6\u503c\u7f16\u7801\u3010%s\u3011\u6ca1\u6709\u5bf9\u5e94\u7684\u5185\u90e8\u4e1a\u52a1\u5355\u5143\uff0c\u8bf7\u91cd\u65b0\u66ff\u6362\u6838\u7b97\u7ef4\u5ea6\u3002", (String)"IctImportUtil_16", (String)FI_ICT_FORMPLUGIN, (Object[])new Object[0]), accInfo.getAssgrpNumber()));
        }
        IctImportUtil.checkAssgrp(fromMerchantsDO, accInfo);
        if (oporgid.equals(accInfo.getOrgId())) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u6838\u7b97\u7ef4\u5ea6\u503c\u7f16\u7801\u3010%s\u3011\u5bf9\u5e94\u7684\u5185\u90e8\u4e1a\u52a1\u5355\u5143\u4e0e\u672c\u65b9\u7ec4\u7ec7\u76f8\u540c\uff0c\u8bf7\u91cd\u65b0\u66ff\u6362\u6838\u7b97\u7ef4\u5ea6\u3002", (String)"IctImportUtil_10", (String)FI_ICT_FORMPLUGIN, (Object[])new Object[0]), accInfo.getAssgrpNumber()));
        }
        String selectField = "number,name,id";
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"bos_org", (String)selectField, (QFilter[])new QFilter("id", "=", (Object)oporgid).toArray());
        HashMap<String, Object> oporgMap = new HashMap<String, Object>(4);
        oporgMap.put("importprop", "number");
        oporgMap.put("id", oporgid);
        oporgMap.put("number", dynamicObject.get("number"));
        oporgMap.put("name", dynamicObject.get("name"));
        sourceData.put("oporg", oporgMap);
    }

    private static void checkAssgrp(DynamicObject fromMerchantsDO, IctAccountImportInfo accInfo) {
        String assgrpNumber = fromMerchantsDO.getString("number");
        String assgrpName = fromMerchantsDO.getString("name");
        if (accInfo.getAssgrpInfoMap().values().isEmpty()) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6ca1\u6709\u6dfb\u52a0\u6838\u7b97\u7ef4\u5ea6\u503c\u7f16\u7801\u548c\u540d\u79f0\uff0c\u8bf7\u6dfb\u52a0\u7f16\u7801\u548c\u540d\u79f0\u3002", (String)"IctImportUtil_11", (String)FI_ICT_FORMPLUGIN, (Object[])new Object[0]), new Object[0]));
        }
        for (Map<String, String> assMap : accInfo.getAssgrpInfoMap().values()) {
            if (!Objects.nonNull(assgrpNumber) || !assgrpNumber.equals(assMap.get("number")) || !Objects.nonNull(assgrpName) || !assgrpName.equals(assMap.get("name"))) continue;
            return;
        }
        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u7684\u6838\u7b97\u7ef4\u5ea6\u503c\u7f16\u7801\u548c\u540d\u79f0\u4e0e\u5bf9\u5e94\u7684\u6838\u7b97\u7ef4\u5ea6\u503c\u7f16\u7801\u3010%1$s\u3011\u548c\u540d\u79f0\u3010%2$s\u3011\u4e0d\u5339\u914d\u3002", (String)"IctImportUtil_12", (String)FI_ICT_FORMPLUGIN, (Object[])new Object[0]), assgrpNumber, assgrpName));
    }

    private static Tuple<String, String> getFlexFieldAndValue(Long assgrpId) {
        QFilter fassType = new QFilter("id", "=", (Object)assgrpId);
        DynamicObjectCollection assTypeCol = QueryServiceHelper.query((String)"bd_asstacttype", (String)"flexfield,valuesource", (QFilter[])fassType.toArray());
        String valuesource = ((DynamicObject)assTypeCol.get(0)).getString("valuesource");
        String flexField = ((DynamicObject)assTypeCol.get(0)).getString("flexfield");
        return new Tuple((Object)valuesource, (Object)flexField);
    }

    public static void setVoucherType(Map<String, Object> sourceData, IctAccountImportInfo accInfo) {
        Map voucherType;
        QFilter filter = BaseDataServiceHelper.getBaseDataFilter((String)"gl_vouchertype", (Long)accInfo.getOrgId());
        filter.and(new QFilter("number", "=", (Object)accInfo.getVoucherTypeNumber()));
        DynamicObject dynObj = BusinessDataServiceHelper.loadSingleFromCache((String)"gl_vouchertype", (String)"id", (QFilter[])filter.toArray());
        if (Objects.nonNull(dynObj) && Objects.nonNull(voucherType = (Map)sourceData.get("vouchertype"))) {
            voucherType.put("id", dynObj.getPkValue());
        }
    }
}

