/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.formplugin.manualrelverigy;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.SelectRowsEvent;
import kd.bos.form.control.events.SelectRowsEventListener;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ict.business.opservice.manualrelverigy.autoclick.ManualRelQueryParam;
import kd.fi.ict.entity.ManualReconciliationVo;
import kd.fi.ict.entity.RecordManualVo;
import kd.fi.ict.formplugin.manualrelverigy.ReEntryGridControl;

public class EntryOperatorPlugin
extends AbstractFormPlugin
implements SelectRowsEventListener,
HyperLinkClickListener {
    private static final Log LOG = LogFactory.getLog(EntryOperatorPlugin.class);

    public void initialize() {
        super.initialize();
        this.addListerner("b_");
        this.addListerner("d_");
    }

    public void addListerner(String prefix) {
        this.getView().addCustomControls(new String[]{this.getEntryentityName(prefix)});
    }

    public void selectRowsChange(SelectRowsEvent evt) {
        String field_prefix = ((EntryGrid)evt.getSource()).getEntryKey().startsWith("b_") ? "b_" : "d_";
        this.flushTotalLocal(field_prefix, evt.getNewRows(), evt.getOldRows());
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String field_prefix = evt.getFieldName().startsWith("b_") ? "b_" : "d_";
        Long vchId = (Long)this.getModel().getValue(field_prefix + "voucherid", evt.getRowIndex());
        if (null != vchId && vchId > 0L) {
            boolean exists = QueryServiceHelper.exists((String)"gl_voucher", (Object)vchId);
            if (exists) {
                this.showVchEdit(vchId);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u8981\u8bfb\u53d6\u7684\u51ed\u8bc1\u6570\u636e\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664\u3002", (String)"EntryOperatorPlugin_0", (String)"fi-ict-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void onGetControl(OnGetControlArgs e) {
        if (StringUtils.equals((CharSequence)e.getKey(), (CharSequence)"b_entryentity")) {
            this.initControl("b_", e);
        }
        if (StringUtils.equals((CharSequence)e.getKey(), (CharSequence)"d_entryentity")) {
            this.initControl("d_", e);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().updateView("b_entryentity");
        this.getView().updateView("d_entryentity");
    }

    private void showVchEdit(Long vchId) {
        BillShowParameter parameter = new BillShowParameter();
        parameter.setFormId("gl_voucher");
        parameter.setPkId((Object)vchId);
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setStatus(OperationStatus.VIEW);
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void flushTotalLocal(String prefix, List<Integer> rows, List<Integer> oldRows) {
        IDataModel model = this.getModel();
        BigDecimal debitTotal = BigDecimal.ZERO;
        BigDecimal creditTotal = BigDecimal.ZERO;
        String entryentityName = this.getEntryentityName(prefix);
        EntryGrid grid = this.getGridControl(entryentityName);
        int startIndex = grid.getEntryData().getStartIndex();
        ManualReconciliationVo manualReconciliationRows = new ManualReconciliationVo();
        ArrayList<RecordManualVo> recordList = new ArrayList<RecordManualVo>(10);
        ManualReconciliationVo manualReconciliationOldRows = new ManualReconciliationVo();
        ArrayList<RecordManualVo> recordOldList = new ArrayList<RecordManualVo>(10);
        BigDecimal oldDebitTotal = BigDecimal.ZERO;
        BigDecimal oldCreditTotal = BigDecimal.ZERO;
        ManualRelQueryParam manualField = this.setManualRelParam(entryentityName);
        String cacheKey = "IctManualReconciliation_" + manualField.getOwnorgId() + "_" + manualField.getOppoorgId() + "_" + manualField.getPeriodId() + "_" + manualField.getSchemeId();
        String cacheManual = this.getView().getPageCache().get(cacheKey);
        LOG.info("Page cache cacheManual:{}", (Object)cacheManual);
        DynamicObjectCollection entryEntity = model.getEntryEntity(entryentityName);
        for (int index = startIndex; index < startIndex + entryEntity.size(); ++index) {
            Long relRecordid = (Long)model.getValue(prefix + "relacctrecordid", index);
            if (this.checkContainsIndex(index, rows)) {
                BigDecimal taoriamount = (BigDecimal)model.getValue(prefix + "taoriamount", index);
                RecordManualVo vo = new RecordManualVo();
                if (BigDecimal.ZERO.compareTo(taoriamount) == 0) {
                    model.setValue(prefix + "taoriamount", model.getValue(prefix + "noriamount", index), index);
                    model.setValue(prefix + "tlocalcur", model.getValue(prefix + "nlocalcur", index), index);
                }
                vo.setTaoriamount((BigDecimal)model.getValue(prefix + "taoriamount", index));
                vo.setTlocalcur((BigDecimal)model.getValue(prefix + "tlocalcur", index));
                vo.setRecordId(relRecordid);
                vo.setIndex(Integer.valueOf(index));
                recordList.add(vo);
                manualReconciliationRows.setRecordManualList(recordList);
                if ("type_acc".equals(model.getValue("showtype"))) {
                    String entryDc = (String)model.getValue(prefix + "entrydc", index);
                    if ("1".equals(entryDc)) {
                        debitTotal = debitTotal.add((BigDecimal)model.getValue(prefix + "taoriamount", index));
                    } else if ("-1".equals(entryDc)) {
                        creditTotal = creditTotal.add((BigDecimal)model.getValue(prefix + "taoriamount", index));
                    }
                } else {
                    String entryCashDc = (String)model.getValue(prefix + "entry_cash_dc", index);
                    if ("i".equals(entryCashDc)) {
                        debitTotal = debitTotal.add((BigDecimal)model.getValue(prefix + "taoriamount", index));
                    } else if ("o".equals(entryCashDc)) {
                        creditTotal = creditTotal.add((BigDecimal)model.getValue(prefix + "taoriamount", index));
                    }
                }
                manualReconciliationRows.setDebitTotal(debitTotal);
                manualReconciliationRows.setCreditTotal(creditTotal);
            } else {
                model.setValue(prefix + "taoriamount", (Object)BigDecimal.ZERO, index);
                model.setValue(prefix + "tlocalcur", (Object)BigDecimal.ZERO, index);
            }
            if (!this.checkContainsIndex(index, oldRows)) continue;
            ManualReconciliationVo reconVo = (ManualReconciliationVo)JSON.parseObject((String)cacheManual, ManualReconciliationVo.class);
            List recordManualList = reconVo.getRecordManualList();
            for (RecordManualVo recordManualVo : recordManualList) {
                if (!Objects.equals(recordManualVo.getRecordId(), relRecordid)) continue;
                if ("type_acc".equals(model.getValue("showtype"))) {
                    String entryDc = (String)model.getValue(prefix + "entrydc", index);
                    if ("1".equals(entryDc)) {
                        oldDebitTotal = oldDebitTotal.add(recordManualVo.getTaoriamount());
                        continue;
                    }
                    if (!"-1".equals(entryDc)) continue;
                    oldCreditTotal = oldCreditTotal.add(recordManualVo.getTaoriamount());
                    continue;
                }
                String entryCashDc = (String)model.getValue(prefix + "entry_cash_dc", index);
                if ("i".equals(entryCashDc)) {
                    oldDebitTotal = oldDebitTotal.add(recordManualVo.getTaoriamount());
                    continue;
                }
                if (!"o".equals(entryCashDc)) continue;
                oldCreditTotal = oldCreditTotal.add(recordManualVo.getTaoriamount());
            }
            RecordManualVo vo = new RecordManualVo();
            vo.setIndex(Integer.valueOf(index));
            vo.setRecordId(relRecordid);
            recordOldList.add(vo);
            manualReconciliationOldRows.setRecordManualList(recordOldList);
            manualReconciliationOldRows.setDebitTotal(oldDebitTotal);
            manualReconciliationOldRows.setCreditTotal(oldCreditTotal);
        }
        ManualReconciliationVo manualVo = new ManualReconciliationVo();
        if (cacheManual == null) {
            manualVo = manualReconciliationRows;
        }
        if (cacheManual != null) {
            manualVo = (ManualReconciliationVo)JSON.parseObject((String)cacheManual, ManualReconciliationVo.class);
            List recordManualVoList = manualVo.getRecordManualList();
            manualVo = this.totalRecenciliation(manualReconciliationRows, manualVo, recordManualVoList, manualReconciliationOldRows);
        }
        model.setValue(prefix + "totaldebitlocal", (Object)manualVo.getDebitTotal());
        model.setValue(prefix + "totalcreditlocal", (Object)manualVo.getCreditTotal());
        this.getView().getPageCache().put(cacheKey, SerializationUtils.toJsonString((Object)manualVo));
        LOG.info("New page cache cacheManual:{}", (Object)SerializationUtils.toJsonString((Object)manualVo));
    }

    private ManualRelQueryParam setManualRelParam(String entryentityName) {
        String customParamStr = (String)this.getView().getFormShowParameter().getCustomParam("autoParam");
        ManualRelQueryParam manualField = (ManualRelQueryParam)SerializationUtils.fromJsonString((String)customParamStr, ManualRelQueryParam.class);
        if (entryentityName.startsWith("d_")) {
            long ownorgId = manualField.getOwnorgId();
            long oppoorgId = manualField.getOppoorgId();
            manualField.setOwnorgId(oppoorgId);
            manualField.setOppoorgId(ownorgId);
        }
        return manualField;
    }

    private String getFromKey() {
        String customParamStr = (String)this.getView().getFormShowParameter().getCustomParam("autoParam");
        ManualRelQueryParam autoParam = (ManualRelQueryParam)SerializationUtils.fromJsonString((String)customParamStr, ManualRelQueryParam.class);
        return "type_acc".equals(autoParam.getShowType()) ? "ict_relacctrecord" : "ict_relcfrecord";
    }

    private ManualReconciliationVo totalRecenciliation(ManualReconciliationVo manualReconciliationRows, ManualReconciliationVo manualVo, List<RecordManualVo> recordManualVoList, ManualReconciliationVo manualReconciliationOldRows) {
        List recordManualRowsList = manualReconciliationRows.getRecordManualList();
        List recordManualOldRowsList = manualReconciliationOldRows.getRecordManualList();
        BigDecimal debitDecimal = manualReconciliationRows.getDebitTotal().subtract(manualReconciliationOldRows.getDebitTotal());
        BigDecimal creditDecimal = manualReconciliationRows.getCreditTotal().subtract(manualReconciliationOldRows.getCreditTotal());
        if (recordManualRowsList == null) {
            List<Long> recordIdsOldRows = recordManualOldRowsList.stream().map(RecordManualVo::getRecordId).collect(Collectors.toList());
            return this.setSelectedRecord(recordManualVoList, recordIdsOldRows, manualVo, debitDecimal, creditDecimal);
        }
        List recordIdsRows = recordManualRowsList.stream().map(RecordManualVo::getRecordId).collect(Collectors.toList());
        List recordIds = recordManualVoList.stream().map(RecordManualVo::getRecordId).collect(Collectors.toList());
        if (recordManualOldRowsList != null) {
            List<Long> recordIdsOldRows = recordManualOldRowsList.stream().map(RecordManualVo::getRecordId).collect(Collectors.toList());
            ManualReconciliationVo manualReconciliationVo = this.setSelectedRecord(recordManualVoList, recordIdsOldRows, manualVo, debitDecimal, creditDecimal);
            manualReconciliationVo.getRecordManualList().addAll(recordManualRowsList);
            return manualReconciliationVo;
        }
        recordManualVoList.addAll(recordManualRowsList);
        List result = recordManualVoList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<RecordManualVo>(Comparator.comparing(RecordManualVo::getRecordId))), ArrayList::new));
        manualVo.setRecordManualList(result);
        manualVo.setDebitTotal(manualVo.getDebitTotal().add(debitDecimal));
        manualVo.setCreditTotal(manualVo.getCreditTotal().add(creditDecimal));
        return manualVo;
    }

    private ManualReconciliationVo setSelectedRecord(List<RecordManualVo> recordManualVoList, List<Long> recordIdsOldRows, ManualReconciliationVo manualVo, BigDecimal debitDecimal, BigDecimal creditDecimal) {
        ArrayList<RecordManualVo> recordMiddleRowsList = new ArrayList<RecordManualVo>(10);
        for (RecordManualVo recordManualVo : recordManualVoList) {
            for (Long recordId : recordIdsOldRows) {
                if (!recordManualVo.getRecordId().equals(recordId)) continue;
                recordMiddleRowsList.add(recordManualVo);
            }
        }
        recordManualVoList.removeAll(recordMiddleRowsList);
        manualVo.setRecordManualList(recordManualVoList);
        manualVo.setDebitTotal(manualVo.getDebitTotal().add(debitDecimal));
        manualVo.setCreditTotal(manualVo.getCreditTotal().add(creditDecimal));
        return manualVo;
    }

    private boolean checkContainsIndex(int rowIndex, List<Integer> rows) {
        for (Integer row : rows) {
            if (rowIndex != row) continue;
            return true;
        }
        return false;
    }

    private void initControl(final String prefix, OnGetControlArgs e) {
        String prefix_entryentity = prefix + "entryentity";
        ReEntryGridControl entryGrid = new ReEntryGridControl();
        entryGrid.addSelectRowsListener(this);
        entryGrid.addHyperClickListener(this);
        entryGrid.addPackageDataListener(new Consumer<PackageDataEvent>(){
            Map<Integer, Boolean> row = new HashMap<Integer, Boolean>(10);

            @Override
            public void accept(PackageDataEvent packageDataEvent) {
                Integer rowIndex = (Integer)packageDataEvent.getRowData().get(1);
                Boolean noLink = this.row.get(rowIndex);
                if (noLink == null) {
                    this.row.put(rowIndex, false);
                }
                if (packageDataEvent.getRowData() != null && !this.row.get(rowIndex).booleanValue() && !packageDataEvent.getRowData().get(prefix + "sourcesys").equals("83bfebc8000017ac")) {
                    this.row.put(rowIndex, true);
                    packageDataEvent.getNoLinkKey().add(prefix + "billno");
                }
            }
        });
        entryGrid.setView(this.getView());
        entryGrid.setKey(prefix_entryentity);
        entryGrid.setEntryKey(prefix_entryentity);
        entryGrid.setSplitPage(true);
        Control oldGrid = e.getControl();
        if (oldGrid instanceof EntryGrid) {
            entryGrid.getItems().addAll(((EntryGrid)oldGrid).getItems());
            entryGrid.setPageRow(((EntryGrid)oldGrid).getPageRow());
        }
        e.setControl((Control)entryGrid);
    }

    private String getEntryentityName(String prefix) {
        return prefix + "entryentity";
    }

    private EntryGrid getGridControl(String entryName) {
        return (EntryGrid)this.getView().getControl(entryName);
    }
}

