/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.formplugin.manualrelverigy;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityState;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.AmountEdit;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.ict.business.opservice.manualrelverigy.autoclick.ManualRelQueryParam;
import kd.fi.ict.business.opservice.manualrelverigy.factory.GetVchDataHandleFactory;
import kd.fi.ict.entity.ManualReconciliationVo;
import kd.fi.ict.entity.RecordManualVo;
import kd.fi.ict.formplugin.AlertFromUtils;
import kd.fi.ict.formplugin.manualrelverigy.EntryOperatorPlugin;
import kd.fi.ict.util.AppLogHelper;

public class ManualReconciliationPlugin
extends AbstractFormPlugin {
    private static final String[] fieldName = new String[]{"relacctrecordid", "voucherid", "voucherentry", "billno", "vchperiod", "vchtype", "vchdesc", "assgrp", "account", "cfitem", "entrydc", "entry_cash_dc", "baldc", "currency", "currencyloc", "bizdate", "vchdate", "oriamount", "localcur", "aoriamount", "alocalcur", "noriamount", "nlocalcur", "taoriamount", "tlocalcur", "localrate", "isnextperiod", "vchcreator", "billstatus", "sourcesys", "assgrp_cf", "remark"};

    public void initialize() {
        super.initialize();
        this.getView().addPlugin((IFormPlugin)new EntryOperatorPlugin());
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.addClickListeners(new String[]{"refresh"});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        String prefix = "b_";
        IDataModel model = this.getModel();
        ChangeData changeData = e.getChangeSet()[0];
        if (changeData.getDataEntity().getDataEntityType().getName().startsWith("d_")) {
            prefix = "d_";
        }
        if ((prefix + "taoriamount").equals(name)) {
            BigDecimal rateBig;
            BigDecimal noriamountNewAbs;
            int rowIndex = changeData.getRowIndex();
            if (rowIndex < 0) {
                return;
            }
            BigDecimal noriamountOld = (BigDecimal)changeData.getOldValue();
            BigDecimal noriamountNew = (BigDecimal)changeData.getNewValue();
            String noriamount_key = prefix + "noriamount";
            BigDecimal noriamount = (BigDecimal)model.getValue(noriamount_key, rowIndex);
            BigDecimal noriamountAbs = noriamount.abs();
            if (noriamountOld.compareTo(BigDecimal.ZERO) != 0 && noriamountNew.compareTo(BigDecimal.ZERO) != 0 && ((noriamountNewAbs = noriamountNew.abs()).compareTo(noriamountAbs) > 0 || noriamountNew.signum() != noriamount.signum())) {
                model.setValue(prefix + "taoriamount", (Object)noriamountOld, rowIndex);
                this.getView().updateView(prefix + "taoriamount", rowIndex);
                noriamountOld = BigDecimal.ZERO;
            }
            BigDecimal taoriamount = (BigDecimal)model.getValue(prefix + "taoriamount", rowIndex);
            BigDecimal oriamount = (BigDecimal)model.getValue(prefix + "oriamount", rowIndex);
            BigDecimal localcur = (BigDecimal)model.getValue(prefix + "localcur", rowIndex);
            BigDecimal bigDecimal = rateBig = oriamount.compareTo(BigDecimal.ZERO) != 0 ? localcur.divide(oriamount, 10, RoundingMode.HALF_UP) : BigDecimal.ONE;
            if (BigDecimal.ZERO.compareTo(rateBig) < 0) {
                taoriamount = taoriamount.multiply(rateBig);
            }
            model.setValue(prefix + "tlocalcur", (Object)taoriamount, rowIndex);
            String totaldebitlocal = prefix + "totaldebitlocal";
            String totalcreditlocal = prefix + "totalcreditlocal";
            if (noriamountNew.signum() == noriamount.signum() && noriamountOld.signum() == noriamount.signum()) {
                ManualRelQueryParam manualField = this.getCacheManualVo(changeData);
                String cacheKey = "IctManualReconciliation_" + manualField.getOwnorgId() + "_" + manualField.getOppoorgId() + "_" + manualField.getPeriodId() + "_" + manualField.getSchemeId();
                this.getView().getPageCache().remove(cacheKey);
                ManualReconciliationVo reconciliationVo = this.setCacheRecord(model, prefix, rowIndex, changeData, noriamountOld);
                this.getView().getPageCache().put(cacheKey, SerializationUtils.toJsonString((Object)reconciliationVo));
                if ("ict_relacctrecord".equals(this.getFromKey())) {
                    if ("1".equals(model.getValue(prefix + "entrydc", rowIndex))) {
                        model.setValue(totaldebitlocal, (Object)reconciliationVo.getDebitTotal());
                        model.setValue(totalcreditlocal, (Object)BigDecimal.ZERO);
                    } else {
                        model.setValue(totalcreditlocal, (Object)reconciliationVo.getCreditTotal());
                        model.setValue(totaldebitlocal, (Object)BigDecimal.ZERO);
                    }
                }
                if ("ict_relcfrecord".equals(this.getFromKey())) {
                    if ("i".equals(model.getValue(prefix + "entry_cash_dc", rowIndex))) {
                        model.setValue(totaldebitlocal, (Object)reconciliationVo.getDebitTotal());
                        model.setValue(totalcreditlocal, (Object)BigDecimal.ZERO);
                    } else {
                        model.setValue(totalcreditlocal, (Object)reconciliationVo.getCreditTotal());
                        model.setValue(totaldebitlocal, (Object)BigDecimal.ZERO);
                    }
                }
            }
        }
    }

    private ManualRelQueryParam getCacheManualVo(ChangeData changeData) {
        String customParamStr = (String)this.getView().getFormShowParameter().getCustomParam("autoParam");
        ManualRelQueryParam autoParam = (ManualRelQueryParam)SerializationUtils.fromJsonString((String)customParamStr, ManualRelQueryParam.class);
        if (changeData.getDataEntity().getDataEntityType().getName().startsWith("d_")) {
            long oppoorgId = autoParam.getOppoorgId();
            long ownorgId = autoParam.getOwnorgId();
            autoParam.setOwnorgId(oppoorgId);
            autoParam.setOppoorgId(ownorgId);
        }
        return autoParam;
    }

    private ManualReconciliationVo setCacheRecord(IDataModel model, String prefix, int rowIndex, ChangeData changeData, BigDecimal noriamountOld) {
        BigDecimal tlocalcurSel = (BigDecimal)model.getValue(prefix + "tlocalcur", rowIndex);
        BigDecimal taoriamountSel = (BigDecimal)model.getValue(prefix + "taoriamount", rowIndex);
        ManualReconciliationVo reconciliationVo = new ManualReconciliationVo();
        ArrayList<RecordManualVo> recordManualVoList = new ArrayList<RecordManualVo>(1);
        if ("ict_relacctrecord".equals(this.getFromKey())) {
            if ("1".equals(model.getValue(prefix + "entrydc", rowIndex))) {
                reconciliationVo.setDebitTotal(taoriamountSel);
            } else {
                reconciliationVo.setCreditTotal(taoriamountSel);
            }
        }
        if ("ict_relcfrecord".equals(this.getFromKey())) {
            BigDecimal localcurSel;
            BigDecimal oriamountSel = (BigDecimal)model.getValue(prefix + "oriamount", rowIndex);
            tlocalcurSel = oriamountSel.compareTo(localcurSel = (BigDecimal)model.getValue(prefix + "localcur", rowIndex)) == 0 ? (BigDecimal)model.getValue(prefix + "tlocalcur", rowIndex) : taoriamountSel.multiply(localcurSel).divide(new BigDecimal(String.valueOf(oriamountSel)), 4, 5);
            model.setValue(prefix + "tlocalcur", (Object)tlocalcurSel, rowIndex);
            if ("i".equals(model.getValue(prefix + "entry_cash_dc", rowIndex))) {
                reconciliationVo.setDebitTotal(taoriamountSel);
            } else {
                reconciliationVo.setCreditTotal(taoriamountSel);
            }
        }
        RecordManualVo reconVo = new RecordManualVo();
        reconVo.setIndex(Integer.valueOf(rowIndex));
        reconVo.setTaoriamount(taoriamountSel);
        reconVo.setTlocalcur(tlocalcurSel);
        reconVo.setRecordId(Long.valueOf(changeData.getDataEntity().getLong(prefix + "relacctrecordid")));
        recordManualVoList.add(reconVo);
        reconciliationVo.setRecordManualList(recordManualVoList);
        return reconciliationVo;
    }

    public void afterCreateNewData(EventObject e) {
        ManualReconciliationVo breconciliationVo = this.getbcacheManual();
        ManualReconciliationVo dreconciliationVo = this.getdcacheManual();
        IDataModel model = this.getModel();
        String customParamStr = (String)this.getView().getFormShowParameter().getCustomParam("autoParam");
        ManualRelQueryParam autoParam = (ManualRelQueryParam)SerializationUtils.fromJsonString((String)customParamStr, ManualRelQueryParam.class);
        model.setValue("period", (Object)autoParam.getPeriodId());
        model.setValue("org", (Object)autoParam.getOwnorgId());
        model.setValue("oppoorg", (Object)autoParam.getOppoorgId());
        model.setValue("booktype", (Object)autoParam.getBooktypeId());
        model.setValue("verifyscheme", (Object)autoParam.getSchemeId());
        model.setValue("currency", (Object)autoParam.getCurrencyId());
        String showType = autoParam.getShowType();
        model.setValue("showtype", (Object)autoParam.getShowType());
        if ("type_acc".equals(showType)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"b_cfitem", "d_cfitem"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"b_account", "b_fullaccount", "d_account", "d_fullaccount"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"b_entry_cash_dc", "d_entry_cash_dc"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"b_entrydc", "d_entrydc"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"b_assgrp", "d_assgrp"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"b_assgrp_cf", "d_assgrp_cf"});
        } else {
            this.modifyFiledApName("b_totaldebitlocal", new LocaleString(ResManager.loadKDString((String)"\u5df2\u52fe\u9009\u6d41\u5165\u65b9\u91d1\u989d\u5408\u8ba1", (String)"ManualReconciliationPlugin_20", (String)"fi-ict-formplugin", (Object[])new Object[0])));
            this.modifyFiledApName("b_totalcreditlocal", new LocaleString(ResManager.loadKDString((String)"\u5df2\u52fe\u9009\u6d41\u51fa\u65b9\u91d1\u989d\u5408\u8ba1", (String)"ManualReconciliationPlugin_21", (String)"fi-ict-formplugin", (Object[])new Object[0])));
            this.modifyFiledApName("d_totaldebitlocal", new LocaleString(ResManager.loadKDString((String)"\u5df2\u52fe\u9009\u6d41\u5165\u65b9\u91d1\u989d\u5408\u8ba1", (String)"ManualReconciliationPlugin_22", (String)"fi-ict-formplugin", (Object[])new Object[0])));
            this.modifyFiledApName("d_totalcreditlocal", new LocaleString(ResManager.loadKDString((String)"\u5df2\u52fe\u9009\u6d41\u51fa\u65b9\u91d1\u989d\u5408\u8ba1", (String)"ManualReconciliationPlugin_23", (String)"fi-ict-formplugin", (Object[])new Object[0])));
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"b_cfitem", "d_cfitem"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"b_account", "b_fullaccount", "d_account", "d_fullaccount"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"b_entry_cash_dc", "d_entry_cash_dc"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"b_entrydc", "d_entrydc"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"b_assgrp", "d_assgrp"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"b_assgrp_cf", "d_assgrp_cf"});
        }
        this.queryVoucher();
    }

    private void modifyFiledApName(String fildName, LocaleString localeString) {
        FieldAp fieldAp = new FieldAp();
        fieldAp.setKey(fildName);
        fieldAp.setName(localeString);
        fieldAp.setLock("new,edit");
        fieldAp.setWidth(new LocaleString("300px"));
        fieldAp.setLabelWidth(new LocaleString("140px"));
        fieldAp.setFieldStyle(2);
        fieldAp.setTextAlign("center");
        this.getView().updateControlMetadata(fieldAp.getKey(), fieldAp.createControl());
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        ManualReconciliationVo breconciliationVo = this.getbcacheManual();
        ManualReconciliationVo dreconciliationVo = this.getdcacheManual();
        List<RecordManualVo> bselectRowIndexs = this.getSelectRowIndexs(breconciliationVo);
        List<RecordManualVo> dselectRowIndexs = this.getSelectRowIndexs(dreconciliationVo);
        List bindexs = bselectRowIndexs.stream().map(RecordManualVo::getIndex).collect(Collectors.toList());
        List dindexs = dselectRowIndexs.stream().map(RecordManualVo::getIndex).collect(Collectors.toList());
        switch (operateKey) {
            case "nextperiod": 
            case "rejectnextperiod": 
            case "cfrnextperiod": 
            case "cancelnextperiod": 
            case "relieve": 
            case "revoke": {
                if (dindexs.size() > 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u672c\u65b9\u5173\u8054\u4ea4\u6613\u51ed\u8bc1\u3002", (String)"ManualReconciliationPlugin_19", (String)"fi-ict-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                if (bindexs.size() == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u6570\u636e\u3002", (String)"ManualReconciliationPlugin_28", (String)"fi-ict-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                if (breconciliationVo != null && breconciliationVo.getRecordManualList() != null) {
                    Set recordIds = breconciliationVo.getRecordManualList().stream().map(RecordManualVo::getRecordId).collect(Collectors.toSet());
                    QFilter filter = new QFilter("id", "in", recordIds);
                    IDataModel model = this.getModel();
                    DynamicObject dyn = null;
                    dyn = "type_acc".equals(model.getValue("showtype")) ? BusinessDataServiceHelper.loadSingleFromCache((String)"ict_relacctrecord", (String)"id", (QFilter[])new QFilter[]{filter}) : BusinessDataServiceHelper.loadSingleFromCache((String)"ict_relcfrecord", (String)"id", (QFilter[])new QFilter[]{filter});
                    if (dyn == null) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u5df2\u7ecf\u88ab\u5220\u9664\uff0c\u8bf7\u70b9\u51fb\u5237\u65b0\u518d\u91cd\u65b0\u52fe\u9009\u3002", (String)"ManualReconciliationPlugin_26", (String)"fi-ict-formplugin", (Object[])new Object[0]));
                    }
                }
                if (!operateKey.equals("nextperiod")) break;
                ManualReconciliationPlugin.showOpenedView(this.getView(), new CloseCallBack((IFormPlugin)this, "call_back_nextperiod"));
                args.setCancel(true);
                break;
            }
            case "manualreconciliation": {
                IDataModel model = this.getModel();
                BigDecimal b_totaldebitlocal = (BigDecimal)model.getValue("b_totaldebitlocal");
                BigDecimal b_totalcreditlocal = (BigDecimal)model.getValue("b_totalcreditlocal");
                BigDecimal d_totaldebitlocal = (BigDecimal)model.getValue("d_totaldebitlocal");
                BigDecimal d_totalcreditlocal = (BigDecimal)model.getValue("d_totalcreditlocal");
                if (bindexs.size() > 0 && dindexs.size() > 0) {
                    BigDecimal totalcreditlocal;
                    if (this.checkSingAmt(bselectRowIndexs, dselectRowIndexs)) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u52fe\u7a3d\u5fc5\u987b\u6ee1\u8db3\u4e00\u65b9\u5b8c\u5168\u52fe\u7a3d\u3002", (String)"ManualReconciliationPlugin_11", (String)"fi-ict-formplugin", (Object[])new Object[0]));
                        args.setCancel(true);
                        return;
                    }
                    BigDecimal totaldebitlocal = b_totaldebitlocal.add(d_totaldebitlocal);
                    if (totaldebitlocal.compareTo(totalcreditlocal = b_totalcreditlocal.add(d_totalcreditlocal)) != 0) {
                        ManualReconciliationPlugin.showOpenedView(this.getView(), new CloseCallBack((IFormPlugin)this, "call_back_manual"));
                        args.setCancel(true);
                        return;
                    }
                } else if ((bindexs.size() <= 0 || dindexs.size() != 0) && bindexs.size() == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u52fe\u9009\u672c\u65b9\u51ed\u8bc1\u3002", (String)"ManualReconciliationPlugin_15", (String)"fi-ict-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                }
                this.beforeDoOperationParam(operate, breconciliationVo, dreconciliationVo);
            }
        }
    }

    private boolean checkSingAmt(List<RecordManualVo> bselectRowIndexs, List<RecordManualVo> dselectRowIndexs) {
        List<Integer> b_entry = this.getSelectRowIndexs("b_");
        List<Integer> d_select = this.getSelectRowIndexs("d_");
        DynamicObjectCollection bColl = this.getModel().getEntryEntity("b_entryentity");
        DynamicObjectCollection dColl = this.getModel().getEntryEntity("d_entryentity");
        boolean bSingAmt = true;
        for (int i = 0; i < bColl.size() && bSingAmt; ++i) {
            DynamicObject dyn = (DynamicObject)bColl.get(i);
            if (!bSingAmt || !b_entry.contains(i) || dyn.getBigDecimal("b_noriamount").compareTo(dyn.getBigDecimal("b_taoriamount")) == 0) continue;
            bSingAmt = false;
        }
        boolean dSingAmt = true;
        for (int i = 0; i < dColl.size() && dSingAmt; ++i) {
            DynamicObject dyn = (DynamicObject)dColl.get(i);
            if (!dSingAmt || !d_select.contains(i) || dyn.getBigDecimal("d_noriamount").compareTo(dyn.getBigDecimal("d_taoriamount")) == 0) continue;
            dSingAmt = false;
        }
        return !bSingAmt && !dSingAmt;
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        this.getView().returnDataToParent((Object)customParams);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        OperationResult result;
        OperateOption option;
        String remark;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Map returnMap = (Map)closedCallBackEvent.getReturnData();
        if (returnMap == null) {
            return;
        }
        ManualReconciliationVo breconciliationVo = this.getbcacheManual();
        ManualReconciliationVo dreconciliationVo = this.getdcacheManual();
        if ("call_back_manual".equals(actionId)) {
            remark = (String)returnMap.get("remark");
            option = OperateOption.create();
            option.setVariableValue("remark", remark);
            this.setOperationParam(option, breconciliationVo, dreconciliationVo);
            result = OperationServiceHelper.executeOperate((String)"manualreconciliation", (String)"ict_manual_reconciliation", (DynamicObject[])new DynamicObject[]{this.getModel().getDataEntity(Boolean.TRUE.booleanValue())}, (OperateOption)option);
            if (result.isSuccess()) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u52fe\u7a3d\u5b8c\u6210\u3002", (String)"ManualReconciliationPlugin_1", (String)"fi-ict-formplugin", (Object[])new Object[0]));
                this.queryVoucher();
                this.clearCheckAmt();
                this.clearCacheKey();
            } else {
                this.getView().showTipNotification(result.getMessage());
            }
        }
        if ("call_back_nextperiod".equals(actionId)) {
            remark = (String)returnMap.get("remark");
            option = OperateOption.create();
            option.setVariableValue("remark", remark);
            option.setVariableValue("isStrict", "false");
            result = OperationServiceHelper.executeOperate((String)"nextperiod", (String)this.getFromKey(), (Object[])this.getSelectRowKey("b_", breconciliationVo.getRecordManualList()).toArray(), (OperateOption)option);
            if (result.isSuccess()) {
                this.execOpResult(result, ResManager.loadKDString((String)"\u63d0\u4ea4\u8f6c\u4e0b\u671f\u6210\u529f\u3002", (String)"ManualReconciliationPlugin_12", (String)"fi-ict-formplugin", (Object[])new Object[0]));
            } else {
                try {
                    this.getView().showTipNotification(((OperateErrorInfo)((ValidateResult)result.getValidateResult().getValidateErrors().get(0)).getAllErrorInfo().get(0)).getMessage());
                }
                catch (Exception ex) {
                    this.getView().showTipNotification(result.getMessage());
                }
            }
        }
    }

    private ManualReconciliationVo getbcacheManual() {
        String customParamStr = (String)this.getView().getFormShowParameter().getCustomParam("autoParam");
        ManualRelQueryParam autoParam = (ManualRelQueryParam)SerializationUtils.fromJsonString((String)customParamStr, ManualRelQueryParam.class);
        String bcacheKey = "IctManualReconciliation_" + autoParam.getOwnorgId() + "_" + autoParam.getOppoorgId() + "_" + autoParam.getPeriodId() + "_" + autoParam.getSchemeId();
        String bcacheManual = this.getView().getPageCache().get(bcacheKey);
        return (ManualReconciliationVo)JSON.parseObject((String)bcacheManual, ManualReconciliationVo.class);
    }

    private ManualReconciliationVo getdcacheManual() {
        String customParamStr = (String)this.getView().getFormShowParameter().getCustomParam("autoParam");
        ManualRelQueryParam autoParam = (ManualRelQueryParam)SerializationUtils.fromJsonString((String)customParamStr, ManualRelQueryParam.class);
        String dcacheKey = "IctManualReconciliation_" + autoParam.getOppoorgId() + "_" + autoParam.getOwnorgId() + "_" + autoParam.getPeriodId() + "_" + autoParam.getSchemeId();
        String dcacheManual = this.getView().getPageCache().get(dcacheKey);
        return (ManualReconciliationVo)JSON.parseObject((String)dcacheManual, ManualReconciliationVo.class);
    }

    private void setOperationParam(OperateOption option, ManualReconciliationVo breconciliationVo, ManualReconciliationVo dreconciliationVo) {
        option.setVariableValue("current_time", this.getPageCache().get("expritime"));
        option.setVariableValue("source", "manualreconciliation");
        option.setVariableValue("showtype", (String)this.getModel().getValue("showtype"));
        option.setVariableValue("select_b_entryentity", SerializationUtils.toJsonString(this.getSelectRowIndexs(breconciliationVo)));
        option.setVariableValue("select_d_entryentity", SerializationUtils.toJsonString(this.getSelectRowIndexs(dreconciliationVo)));
    }

    private void beforeDoOperationParam(FormOperate operate, ManualReconciliationVo breconciliationVo, ManualReconciliationVo dreconciliationVo) {
        if (breconciliationVo == null) {
            return;
        }
        operate.getOption().setVariableValue("remark", "");
        operate.getOption().setVariableValue("source", "manualreconciliation");
        operate.getOption().setVariableValue("showtype", (String)this.getModel().getValue("showtype"));
        operate.getOption().setVariableValue("select_b_entryentity", SerializationUtils.toJsonString(this.getSelectRowIndexs(breconciliationVo)));
        operate.getOption().setVariableValue("select_d_entryentity", SerializationUtils.toJsonString(this.getSelectRowIndexs(dreconciliationVo)));
        operate.getOption().setVariableValue("current_time", this.getPageCache().get("expritime"));
        operate.getOption().setVariableValue("select_b_ids", SerializationUtils.toJsonString(this.getSelectRowKey("b_", breconciliationVo.getRecordManualList())));
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        OperationResult opResult = args.getOperationResult();
        EntryGrid d_entry = (EntryGrid)this.getControl("d_entryentity");
        int[] d_select = d_entry.getSelectRows();
        ManualReconciliationVo breconciliationVo = this.getbcacheManual();
        ManualReconciliationVo dreconciliationVo = this.getdcacheManual();
        if (Arrays.asList("nextperiod", "rejectnextperiod", "cfrnextperiod", "cancelnextperiod").contains(operateKey) && d_select.length > 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u52fe\u9009\u5bf9\u65b9\u51ed\u8bc1\u3002", (String)"ManualReconciliationPlugin_27", (String)"fi-ict-formplugin", (Object[])new Object[0]));
            return;
        }
        OperateOption option = OperateOption.create();
        option.setVariableValue("isStrict", "false");
        if (opResult.isSuccess()) {
            switch (operateKey) {
                case "nextperiod": {
                    OperationResult result = OperationServiceHelper.executeOperate((String)"nextperiod", (String)this.getFromKey(), (Object[])this.getSelectRowKey("b_", breconciliationVo.getRecordManualList()).toArray(), (OperateOption)option);
                    this.execOpResult(result, ResManager.loadKDString((String)"\u63d0\u4ea4\u8f6c\u4e0b\u671f\u6210\u529f\u3002", (String)"ManualReconciliationPlugin_12", (String)"fi-ict-formplugin", (Object[])new Object[0]));
                    break;
                }
                case "rejectnextperiod": {
                    OperationResult result = OperationServiceHelper.executeOperate((String)"rejectnextperiod", (String)this.getFromKey(), (Object[])this.getSelectRowKey("b_", breconciliationVo.getRecordManualList()).toArray(), (OperateOption)option);
                    this.execOpResult(result, ResManager.loadKDString((String)"\u9a73\u56de\u8f6c\u4e0b\u671f\u6210\u529f\u3002", (String)"ManualReconciliationPlugin_31", (String)"fi-ict-formplugin", (Object[])new Object[0]));
                    break;
                }
                case "cfrnextperiod": {
                    OperationResult result = OperationServiceHelper.executeOperate((String)"cfrnextperiod", (String)this.getFromKey(), (Object[])this.getSelectRowKey("b_", breconciliationVo.getRecordManualList()).toArray(), (OperateOption)option);
                    this.execOpResult(result, ResManager.loadKDString((String)"\u5ba1\u6838\u8f6c\u5165\u4e0b\u671f\u6210\u529f\u3002", (String)"ManualReconciliationPlugin_14", (String)"fi-ict-formplugin", (Object[])new Object[0]));
                    break;
                }
                case "cancelnextperiod": {
                    if (d_select.length > 0) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u52fe\u9009\u5bf9\u65b9\u51ed\u8bc1\u3002", (String)"ManualReconciliationPlugin_27", (String)"fi-ict-formplugin", (Object[])new Object[0]));
                        break;
                    }
                    Set recordIds = breconciliationVo.getRecordManualList().stream().map(RecordManualVo::getRecordId).collect(Collectors.toSet());
                    QFilter filter = new QFilter("id", "in", recordIds);
                    IDataModel model = this.getModel();
                    DynamicObjectCollection dyn = null;
                    dyn = "type_acc".equals(model.getValue("showtype")) ? QueryServiceHelper.query((String)"ict_relacctrecord", (String)"isnextperiod", (QFilter[])new QFilter[]{filter}) : QueryServiceHelper.query((String)"ict_relcfrecord", (String)"isnextperiod", (QFilter[])new QFilter[]{filter});
                    for (DynamicObject dynamicObject : dyn) {
                        boolean isnext = dynamicObject.getBoolean("isnextperiod");
                        if (isnext) continue;
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u64a4\u9500\u8f6c\u5165\u4e0b\u671f\uff0c\u8bf7\u91cd\u65b0\u52fe\u9009\u3002", (String)"ManualReconciliationPlugin_29", (String)"fi-ict-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    OperationResult result = OperationServiceHelper.executeOperate((String)"cannextperiod", (String)this.getFromKey(), (Object[])this.getSelectRowKey("b_", breconciliationVo.getRecordManualList()).toArray(), (OperateOption)option);
                    this.execOpResult(result, ResManager.loadKDString((String)"\u64a4\u9500\u8f6c\u5165\u4e0b\u671f\u6210\u529f\u3002", (String)"ManualReconciliationPlugin_13", (String)"fi-ict-formplugin", (Object[])new Object[0]));
                    break;
                }
                case "relieve": {
                    OperationResult result = OperationServiceHelper.executeOperate((String)"relieve", (String)this.getFromKey(), (Object[])this.getSelectRowKey("b_", breconciliationVo.getRecordManualList()).toArray(), (OperateOption)option);
                    if (!result.isSuccess()) {
                        args.getOperationResult().setSuccess(result.isSuccess());
                        args.getOperationResult().setShowMessage(false);
                    }
                    this.execOpResult(result, result.getMessage());
                    break;
                }
                case "revoke": {
                    OperationResult result = OperationServiceHelper.executeOperate((String)"revoke", (String)this.getFromKey(), (Object[])this.getSelectRowKey("b_", breconciliationVo.getRecordManualList()).toArray(), (OperateOption)option);
                    if (!result.isSuccess()) {
                        args.getOperationResult().setSuccess(result.isSuccess());
                        args.getOperationResult().setShowMessage(false);
                    }
                    this.execOpResult(result, result.getMessage());
                    break;
                }
                case "manualreconciliation": {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u52fe\u7a3d\u5b8c\u6210\u3002", (String)"ManualReconciliationPlugin_1", (String)"fi-ict-formplugin", (Object[])new Object[0]));
                    String opName = ResManager.loadKDString((String)"\u624b\u5de5\u52fe\u7a3d", (String)"ManualReconciliationPlugin_32", (String)"", (Object[])new Object[0]);
                    long orgId = (Long)this.getModel().getValue("org_id");
                    String entityId = "ict_manual_reconciliation";
                    String opDesc = opResult.isSuccess() ? ResManager.loadKDString((String)"\u624b\u5de5\u52fe\u7a3d\u6210\u529f\u3002", (String)"ManualReconciliationPlugin_33", (String)"", (Object[])new Object[0]) : opResult.getMessage();
                    AppLogHelper.addBatchLog((String)opDesc, (String)opName, (long)orgId, (String)entityId);
                    this.queryVoucher();
                    this.clearCheckAmt();
                    this.clearCacheKey();
                }
            }
        }
    }

    private void execOpResult(OperationResult result, String s) {
        this.queryVoucher();
        this.clearCheckAmt();
        this.clearCacheKey();
        if (result.isSuccess()) {
            if (Objects.nonNull(s)) {
                this.getView().showSuccessNotification(s);
            }
        } else {
            OperateErrorInfo operateErrorInfo = (OperateErrorInfo)((ValidateResult)result.getValidateResult().getValidateErrors().get(0)).getAllErrorInfo().get(0);
            this.getView().showTipNotification(operateErrorInfo.getMessage());
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "refresh": {
                this.clearCheckAmt();
                this.clearCacheKey();
                this.queryVoucher();
                break;
            }
            case "baritemap6": {
                this.clearCacheKey();
            }
        }
    }

    private void clearCacheKey() {
        String customParamStr = (String)this.getView().getFormShowParameter().getCustomParam("autoParam");
        ManualRelQueryParam manualField = (ManualRelQueryParam)SerializationUtils.fromJsonString((String)customParamStr, ManualRelQueryParam.class);
        String cacheOwnKey = "IctManualReconciliation_" + manualField.getOwnorgId() + "_" + manualField.getOppoorgId() + "_" + manualField.getPeriodId() + "_" + manualField.getSchemeId();
        String cacheOppKey = "IctManualReconciliation_" + manualField.getOppoorgId() + "_" + manualField.getOwnorgId() + "_" + manualField.getPeriodId() + "_" + manualField.getSchemeId();
        this.getView().getPageCache().remove(cacheOwnKey);
        this.getView().getPageCache().remove(cacheOppKey);
    }

    private boolean checkFieldIsOk() {
        boolean checkResult = true;
        StringBuilder errorMsg = new StringBuilder();
        IDataModel model = this.getModel();
        this.checkIsNull((DynamicObject)model.getValue("org"), ResManager.loadKDString((String)"\u672c\u65b9\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ManualReconciliationPlugin_4", (String)"fi-ict-formplugin", (Object[])new Object[0]), errorMsg);
        this.checkIsNull((DynamicObject)model.getValue("oppoorg"), ResManager.loadKDString((String)"\u5bf9\u65b9\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ManualReconciliationPlugin_5", (String)"fi-ict-formplugin", (Object[])new Object[0]), errorMsg);
        this.checkIsNull((DynamicObject)model.getValue("booktype"), ResManager.loadKDString((String)"\u8d26\u7c3f\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ManualReconciliationPlugin_6", (String)"fi-ict-formplugin", (Object[])new Object[0]), errorMsg);
        this.checkIsNull((DynamicObject)model.getValue("period"), ResManager.loadKDString((String)"\u671f\u95f4\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ManualReconciliationPlugin_7", (String)"fi-ict-formplugin", (Object[])new Object[0]), errorMsg);
        this.checkIsNull((DynamicObject)model.getValue("verifyscheme"), ResManager.loadKDString((String)"\u5bf9\u8d26\u65b9\u6848\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ManualReconciliationPlugin_8", (String)"fi-ict-formplugin", (Object[])new Object[0]), errorMsg);
        if (null != errorMsg && errorMsg.length() > 0) {
            checkResult = false;
            this.getView().showTipNotification(errorMsg.substring(0, errorMsg.length() - 1));
        }
        return checkResult;
    }

    private boolean checkIsNull(DynamicObject dynamicObject, String errorMsg, StringBuilder msg) {
        if (null == dynamicObject) {
            msg.append(errorMsg).append(",");
        }
        return false;
    }

    private boolean checkIsNull(String str, String errorMsg, StringBuilder msg) {
        if (null == str) {
            msg.append(errorMsg).append(",");
        }
        return false;
    }

    private void queryVoucher() {
        ManualRelQueryParam autoParamClone;
        if (!this.checkFieldIsOk()) {
            return;
        }
        String customParamStr = (String)this.getView().getFormShowParameter().getCustomParam("autoParam");
        ManualRelQueryParam autoParam = (ManualRelQueryParam)SerializationUtils.fromJsonString((String)customParamStr, ManualRelQueryParam.class);
        this.updateEntryData("b_entryentity", autoParam, fieldName);
        try {
            autoParamClone = (ManualRelQueryParam)autoParam.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new KDBizException(e.getMessage());
        }
        autoParamClone.setOwnorgId(autoParam.getOppoorgId());
        autoParamClone.setOppoorgId(autoParam.getOwnorgId());
        this.updateEntryData("d_entryentity", autoParamClone, fieldName);
    }

    private void updateEntryData(String entryName, ManualRelQueryParam param, String[] fieldName) {
        List ids = GetVchDataHandleFactory.getHandle((String)param.getShowType()).init(param).getRelRecordIds();
        int rowCount = ids.size();
        EntryGrid grid = this.getGridControl(entryName);
        int pageRow = grid.getPageRow();
        AbstractGrid.GridState entryState = grid.getEntryState();
        Integer currentPageIndex = entryState.getCurrentPageIndex();
        int fromIndex = grid.getEntryData().getStartIndex();
        int toIndex = rowCount - fromIndex > pageRow ? currentPageIndex * pageRow : rowCount;
        List pageIds = ids.subList(fromIndex, toIndex);
        List tablePageOneValueList = GetVchDataHandleFactory.getHandle((String)param.getShowType()).init(param).compile(pageIds);
        TableValueSetter vs = new TableValueSetter(new String[0]);
        String prefix = entryName.startsWith("b_") ? "b_" : "d_";
        Arrays.stream(fieldName).forEach(fld -> vs.addField(prefix + fld, new Object[0]));
        tablePageOneValueList.stream().map(objectMap -> Arrays.stream(fieldName).map(objectMap::get).toArray()).forEach(arg_0 -> ((TableValueSetter)vs).addRow(arg_0));
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        DataEntityState setDateEntiryState = model.getDataEntity(true).getDataEntityState();
        model.getEntryEntity(entryName).clear();
        model.beginInit();
        model.batchCreateNewEntryRow(entryName, vs);
        model.endInit();
        setDateEntiryState.setEntryRowCount(entryName, rowCount);
        setDateEntiryState.setEntryPageSize(entryName, pageRow);
        setDateEntiryState.setEntryStartRowIndex(entryName, fromIndex);
        this.getView().updateView(entryName);
    }

    private void clearCheckAmt() {
        this.getModel().setValue("b_totaldebitlocal", (Object)BigDecimal.ZERO);
        this.getModel().setValue("b_totalcreditlocal", (Object)BigDecimal.ZERO);
        this.getModel().setValue("d_totaldebitlocal", (Object)BigDecimal.ZERO);
        this.getModel().setValue("d_totalcreditlocal", (Object)BigDecimal.ZERO);
    }

    private boolean isEqLocalCur(String prefix, int rowIndex) {
        DynamicObject curLoc = (DynamicObject)this.getModel().getValue(prefix + "currency", rowIndex);
        DynamicObject curreny = (DynamicObject)this.getModel().getValue(prefix + "currencyloc", rowIndex);
        if (curreny == null) {
            return true;
        }
        return curLoc != null && curreny != null && curLoc.getLong("id") == curreny.getLong("id");
    }

    private List<Integer> getSelectRowIndexs(String prefix) {
        EntryGrid grid = this.getGridControlByPrefix(prefix);
        int startIndex = grid.getEntryData().getStartIndex();
        int[] rows = grid.getSelectRows();
        ArrayList<Integer> bselectedn = new ArrayList<Integer>(rows.length);
        for (int i : rows) {
            bselectedn.add(i - startIndex);
        }
        return bselectedn;
    }

    private List<RecordManualVo> getSelectRowIndexs(ManualReconciliationVo reconciliationVo) {
        if (reconciliationVo == null) {
            return new ArrayList<RecordManualVo>();
        }
        return reconciliationVo.getRecordManualList();
    }

    private List<Long> getSelectRowKey(String prefix, List<RecordManualVo> recordManualList) {
        List<Long> bselectedn = recordManualList.stream().map(RecordManualVo::getRecordId).collect(Collectors.toList());
        return bselectedn;
    }

    protected static void showOpenedView(IFormView view, CloseCallBack closeCallBack) {
        if (null == view) {
            return;
        }
        AlertFromUtils.openAlertFrom(view, closeCallBack);
    }

    private String getFromKey() {
        String customParamStr = (String)this.getView().getFormShowParameter().getCustomParam("autoParam");
        ManualRelQueryParam autoParam = (ManualRelQueryParam)SerializationUtils.fromJsonString((String)customParamStr, ManualRelQueryParam.class);
        return "type_acc".equals(autoParam.getShowType()) ? "ict_relacctrecord" : "ict_relcfrecord";
    }

    private EntryGrid getGridControlByPrefix(String prefix) {
        return (EntryGrid)this.getView().getControl(prefix + "entryentity");
    }

    private EntryGrid getGridControl(String entryName) {
        return (EntryGrid)this.getView().getControl(entryName);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        if ("type_cf".equals(this.getModel().getValue("showtype"))) {
            LocaleString currencyString = new LocaleString(ResManager.loadKDString((String)"\u5e01\u79cd", (String)"IctPullVchEntryCfData_2", (String)"fi-ict-formplugin", (Object[])new Object[0]));
            LocaleString convertAmt = new LocaleString(ResManager.loadKDString((String)"\u6298\u7b97\u91d1\u989d", (String)"IctPullVchEntryCfData_1", (String)"fi-ict-formplugin", (Object[])new Object[0]));
            LocaleString localAmt = new LocaleString(ResManager.loadKDString((String)"\u672c\u5e01\u91d1\u989d", (String)"IctPullVchEntryCfData_0", (String)"fi-ict-formplugin", (Object[])new Object[0]));
            BasedataEdit b_currency = (BasedataEdit)this.getView().getControl("b_currency");
            b_currency.setCaption(currencyString);
            BasedataEdit d_currency = (BasedataEdit)this.getView().getControl("d_currency");
            d_currency.setCaption(currencyString);
            AmountEdit b_taoriamount = (AmountEdit)this.getView().getControl("b_taoriamount");
            b_taoriamount.setCaption(convertAmt);
            AmountEdit b_tlocalcur = (AmountEdit)this.getView().getControl("b_tlocalcur");
            b_tlocalcur.setCaption(localAmt);
            AmountEdit b_oriamount = (AmountEdit)this.getView().getControl("b_oriamount");
            b_oriamount.setCaption(convertAmt);
            AmountEdit b_localcur = (AmountEdit)this.getView().getControl("b_localcur");
            b_localcur.setCaption(localAmt);
            AmountEdit b_aoriamount = (AmountEdit)this.getView().getControl("b_aoriamount");
            b_aoriamount.setCaption(convertAmt);
            AmountEdit b_alocalcur = (AmountEdit)this.getView().getControl("b_alocalcur");
            b_alocalcur.setCaption(localAmt);
            AmountEdit b_noriamount = (AmountEdit)this.getView().getControl("b_noriamount");
            b_noriamount.setCaption(convertAmt);
            AmountEdit b_nlocalcur = (AmountEdit)this.getView().getControl("b_nlocalcur");
            b_nlocalcur.setCaption(localAmt);
            AmountEdit d_taoriamount = (AmountEdit)this.getView().getControl("d_taoriamount");
            d_taoriamount.setCaption(convertAmt);
            AmountEdit d_tlocalcur = (AmountEdit)this.getView().getControl("d_tlocalcur");
            d_tlocalcur.setCaption(localAmt);
            AmountEdit d_oriamount = (AmountEdit)this.getView().getControl("d_oriamount");
            d_oriamount.setCaption(convertAmt);
            AmountEdit d_localcur = (AmountEdit)this.getView().getControl("d_localcur");
            d_localcur.setCaption(localAmt);
            AmountEdit d_aoriamount = (AmountEdit)this.getView().getControl("d_aoriamount");
            d_aoriamount.setCaption(convertAmt);
            AmountEdit d_alocalcur = (AmountEdit)this.getView().getControl("d_alocalcur");
            d_alocalcur.setCaption(localAmt);
            AmountEdit d_noriamount = (AmountEdit)this.getView().getControl("d_noriamount");
            d_noriamount.setCaption(convertAmt);
            AmountEdit d_nlocalcur = (AmountEdit)this.getView().getControl("d_nlocalcur");
            d_nlocalcur.setCaption(localAmt);
        }
    }
}

