/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.formplugin.puch;

import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.form.control.Control;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ict.enums.OperationType;
import kd.fi.ict.lock.LockKey;
import kd.fi.ict.pullcheck.acct.AcctCalculatorCheckAmt;
import kd.fi.ict.pullcheck.acct.AcctCalculatorPullAmt;
import kd.fi.ict.pullcheck.cf.CfCalculatorCheckAmt;
import kd.fi.ict.pullcheck.cf.CfCalculatorPullAmt;

public class PuchAmtRecalculateFormPlugin
extends AbstractFormPlugin {
    protected static final String orgAndBookTypeKey = "%s_%s";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"recal", "recalall", "recalcf", "recalallcf"});
        BasedataEdit startperiod = (BasedataEdit)this.getControl("period");
        startperiod.addBeforeF7SelectListener(evt -> {
            ListShowParameter show = (ListShowParameter)evt.getFormShowParameter();
            long periodType = (Long)this.getModel().getValue("periodtype_id");
            long startPeriod = (Long)this.getModel().getValue("startperiod_id");
            QFilter ftypeId = new QFilter("periodtype", "=", (Object)periodType);
            QFilter fid2 = new QFilter("id", ">=", (Object)startPeriod);
            show.getListFilterParameter().getQFilters().add(fid2.and(ftypeId));
        });
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        String key = c.getKey();
        if (!this.checkInput()) {
            return;
        }
        if (key.equals("recal")) {
            this.relCalPuchAmt("ict_acctpuchamt_log");
        } else if (key.equals("recalall")) {
            this.reCalAllPuchAmt("ict_acctpuchamt_log");
        } else if (key.equals("recalcf")) {
            this.relCalPuchAmt("ict_cfpuchamt_log");
        } else if (key.equals("recalallcf")) {
            this.reCalAllPuchAmt("ict_cfpuchamt_log");
        }
    }

    private boolean checkInput() {
        long bookTypeId = (Long)this.getModel().getValue("booktype_id");
        long periodId = (Long)this.getModel().getValue("period_id");
        long periodType = (Long)this.getModel().getValue("periodtype_id");
        DynamicObjectCollection orgs = (DynamicObjectCollection)this.getModel().getValue("org");
        boolean isPass = true;
        if (orgs == null || orgs.size() <= 0) {
            isPass = false;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ec4\u7ec7\u3002", (String)"PuchAmtRecalculateFormPlugin_1", (String)"fi-ict-formplugin", (Object[])new Object[0]));
        }
        if (bookTypeId == 0L) {
            isPass = false;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8d26\u7c3f\u7c7b\u578b\u3002", (String)"PuchAmtRecalculateFormPlugin_2", (String)"fi-ict-formplugin", (Object[])new Object[0]));
        }
        if (periodType == 0L) {
            isPass = false;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u671f\u95f4\u7c7b\u578b\u3002", (String)"PuchAmtRecalculateFormPlugin_3", (String)"fi-ict-formplugin", (Object[])new Object[0]));
        }
        if (periodId == 0L) {
            isPass = false;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u671f\u95f4\u3002", (String)"PuchAmtRecalculateFormPlugin_4", (String)"fi-ict-formplugin", (Object[])new Object[0]));
        }
        return isPass;
    }

    private void reCalAllPuchAmt(String entityName) {
        boolean exec = false;
        long bookTypeId = (Long)this.getModel().getValue("booktype_id");
        long periodId = (Long)this.getModel().getValue("period_id");
        long periodType = (Long)this.getModel().getValue("periodtype_id");
        DynamicObjectCollection orgs = (DynamicObjectCollection)this.getModel().getValue("org");
        if (orgs != null && orgs.size() > 0) {
            for (DynamicObject org : orgs) {
                QFilter fid2;
                long orgId = org.getLong("fbasedataid.id");
                long endperiodid = PuchAmtRecalculateFormPlugin.getMaxVchPeriodId(orgId, bookTypeId, (Long)this.getModel().getValue("curperiod_id"), entityName);
                QFilter ftypeId = new QFilter("periodtype", "=", (Object)periodType);
                QFilter fid1 = new QFilter("id", ">=", (Object)periodId);
                DynamicObjectCollection col = QueryServiceHelper.query((String)"bd_period", (String)"id", (QFilter[])new QFilter[]{fid1, fid2 = new QFilter("id", "<=", (Object)endperiodid), ftypeId}, (String)"id");
                if (!col.isEmpty()) {
                    for (DynamicObject obj : col) {
                        exec = this.calculate(orgId, bookTypeId, obj.getLong("id"), null, entityName);
                    }
                    continue;
                }
                exec = true;
            }
        }
        this.showProcessMsg(exec);
    }

    private void relCalPuchAmt(String entityName) {
        DynamicObjectCollection orgs = (DynamicObjectCollection)this.getModel().getValue("org");
        long bookTypeId = (Long)this.getModel().getValue("booktype_id");
        long periodId = (Long)this.getModel().getValue("period_id");
        boolean exec = false;
        if (orgs != null && orgs.size() > 0) {
            for (DynamicObject org : orgs) {
                long orgId = org.getLong("fbasedataid.id");
                exec = this.calculate(orgId, bookTypeId, periodId, null, entityName);
            }
        }
        this.showProcessMsg(exec);
    }

    private void showProcessMsg(boolean success) {
        if (success) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u91cd\u7b97\u6210\u529f\u3002", (String)"PuchAmtRecalculateFormPlugin_0", (String)"fi-ict-formplugin", (Object[])new Object[0]));
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u83b7\u53d6\u9501\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"PuchAmtRecalculateFormPlugin_5", (String)"fi-ict-formplugin", (Object[])new Object[0]));
        }
    }

    private boolean calculate(long orgId, long bookTypeId, long periodId, OperationType operationType, String tableName) {
        LockKey lockKey = "ict_acctpuchamt_log".equals(tableName) ? LockKey.AccountRec : LockKey.CfItemRec;
        String key = String.format(orgAndBookTypeKey, orgId, lockKey);
        try (DLock dLock = DLock.create((String)key).fastMode();){
            if (dLock.tryLock()) {
                AcctCalculatorPullAmt calculator = "ict_acctpuchamt_log".equals(tableName) ? new AcctCalculatorPullAmt(operationType) : new CfCalculatorPullAmt(operationType);
                try (TXHandle txh = TX.requiresNew();){
                    try {
                        calculator.reCalculate(orgId, bookTypeId, periodId);
                    }
                    catch (Exception ex) {
                        txh.markRollback();
                        throw ex;
                    }
                }
                calculator = "ict_acctpuchamt_log".equals(tableName) ? new AcctCalculatorCheckAmt(operationType) : new CfCalculatorCheckAmt(operationType);
                txh = TX.requiresNew();
                var15_16 = null;
                try {
                    try {
                        calculator.reCalculate(orgId, bookTypeId, periodId);
                    }
                    catch (Exception ex) {
                        txh.markRollback();
                        throw ex;
                    }
                }
                catch (Throwable throwable) {
                    var15_16 = throwable;
                    throw throwable;
                }
                finally {
                    if (txh != null) {
                        if (var15_16 != null) {
                            try {
                                txh.close();
                            }
                            catch (Throwable throwable) {
                                var15_16.addSuppressed(throwable);
                            }
                        } else {
                            txh.close();
                        }
                    }
                }
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    public static Long getMaxVchPeriodId(long orgId, long btId, long curPid, String entityName) {
        String tableName = "ict_acctpuchamt_log".equals(entityName) ? "t_ict_relacctrecord" : "t_ict_relcfrecord";
        return (Long)DB.query((DBRoute)DBRoute.of((String)"gl"), (String)("select max(fperiodid) endperiod from " + tableName + " where forgid=? and fbooktypeid=?"), (Object[])new Object[]{orgId, btId}, resultSet -> {
            if (resultSet.next()) {
                return resultSet.getLong("endperiod");
            }
            return curPid;
        });
    }
}

