/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.formplugin.pulldata;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.ict.accsys.AccSysUtil;
import kd.fi.ict.business.handle.impl.DataPullHandelIProgress;
import kd.fi.ict.business.intertrans.syndata.FilterParam;
import kd.fi.ict.cache.CacheHelper;
import kd.fi.ict.cache.CacheKey;
import kd.fi.ict.cache.CacheModule;
import kd.fi.ict.cache.DistributeCache;
import kd.fi.ict.formplugin.AlertFromUtils;
import kd.fi.ict.util.ICTUtils;
import kd.fi.ict.util.PermissonType;
import kd.fi.ict.util.VoucherUtils;

public abstract class IctPullDataListPlugin
extends AbstractListPlugin {
    protected static final Log LOGGER = LogFactory.getLog(IctPullDataListPlugin.class);
    private DistributeCache cache = CacheHelper.getDistributeCache((CacheModule)CacheModule.PUCHDATA);
    protected static final String ORG_ID = "org.id";
    protected static final Set<String> nextPeriodOp = new LinkedHashSet<String>(Arrays.asList("nextperiod", "rejectnextperiod", "cfrnextperiod", "cannextperiod", "relieve", "revoke"));
    protected static final String ICT_CONVERT = "convert";
    protected static final Set<String> OP_KEY = new LinkedHashSet<String>(Arrays.asList("initacct", "pullacct", "initcf", "pullcf"));
    protected static final String CHCHE_QUERY_VALUE = "chche_query_value";

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        Set<Object> selectOrg;
        super.filterContainerSearchClick(args);
        List qFilters = args.getFilterParameter().getQFilters();
        if (Objects.isNull(args.getSelectMainOrgIds()) || args.getSelectMainOrgIds().size() == 0) {
            ArrayList<QFilter> orgFilter = new ArrayList<QFilter>(1);
            for (QFilter qFilter : qFilters) {
                QFilter[] reFilter;
                if (!Objects.nonNull(qFilter)) continue;
                for (QFilter filter2 : reFilter = qFilter.recombine()) {
                    if (!Objects.nonNull(filter2.getProperty()) || !filter2.getProperty().startsWith("org.")) continue;
                    orgFilter.add(filter2);
                }
            }
            selectOrg = IctPullDataListPlugin.getSelectOrg(orgFilter);
            HasPermOrgResult permOrgResult = AccSysUtil.getAllPermOrgs((String)this.getFormKey(), (String)PermissonType.JTNBJYPULL.getPermId());
            if (!permOrgResult.hasAllOrgPerm()) {
                selectOrg.retainAll(permOrgResult.getHasPermOrgs());
            }
        } else {
            selectOrg = new HashSet(args.getSelectMainOrgIds());
        }
        FilterParam filterParam = new FilterParam();
        filterParam.setOrgIdLst(new ArrayList(selectOrg));
        qFilters.forEach(filter -> {
            String property = filter.getProperty();
            if ("bookeddate".equals(property)) {
                this.setBookDate(filterParam, (QFilter)filter);
                if (filter.getNests(false).size() > 0) {
                    this.setBookDate(filterParam, ((QFilter.QFilterNest)filter.getNests(false).get(0)).getFilter());
                }
            }
        });
        this.getView().getPageCache().put(CHCHE_QUERY_VALUE, SerializationUtils.toJsonString((Object)filterParam));
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        if (args.getFieldName().startsWith("org.")) {
            String entityId = ((ListView)this.getView()).getListModel().getEntityId();
            args.addCustomQFilter(AccSysUtil.getAccountingOrgFilter((String)entityId, (boolean)false, (PermissonType)PermissonType.VIEW));
        }
    }

    public void filterColumnSetFilter(SetFilterEvent args) {
        super.filterColumnSetFilter(args);
        if (args.getFieldName().startsWith("org.")) {
            String entityId = ((ListView)this.getView()).getListModel().getEntityId();
            args.addCustomQFilter(AccSysUtil.getAccountingOrgFilter((String)entityId, (boolean)false, (PermissonType)PermissonType.VIEW));
        }
    }

    private void setBookDate(FilterParam filterParam, QFilter filter) {
        if (filter.getCP().contains(">")) {
            Date monthFirstCurDate = ICTUtils.getMonthFirstCurDate((Date)((Date)filter.getValue()));
            if (Objects.isNull(filterParam.getBeginBookDate()) || monthFirstCurDate.compareTo(filterParam.getBeginBookDate()) > 0) {
                filterParam.setBeginBookDate(monthFirstCurDate);
            }
        }
        if (filter.getCP().contains("<")) {
            Date monthLastCurDate = ICTUtils.getMonthLastCurDate((Date)((Date)filter.getValue()));
            if (Objects.isNull(filterParam.getEndBookDate()) || monthLastCurDate.compareTo(filterParam.getEndBookDate()) < 0) {
                filterParam.setEndBookDate(monthLastCurDate);
            }
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        String key = args.getFieldName();
        HyperLinkClickEvent evt = args.getHyperLinkClickEvent();
        BillList billList = (BillList)evt.getSource();
        if ("billno".equals(key)) {
            ListSelectedRow curRow = billList.getCurrentSelectedRowInfo();
            DynamicObject dyn = BusinessDataServiceHelper.loadSingle((Object)curRow.getPrimaryKeyValue(), (String)billList.getBillFormId());
            IctPullDataListPlugin.openVoucher(dyn.getLong(ORG_ID), this.getView(), dyn.getLong("voucherid"));
        }
        args.setCancel(true);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (OP_KEY.contains(operateKey)) {
            String strMsg;
            if (("initacct".equals(operateKey) || "initcf".equals(operateKey)) && (strMsg = this.initCheckData(this.getFormKey())).length() > 0) {
                this.getView().showTipNotification(strMsg);
                args.setCancel(true);
                return;
            }
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, operateKey);
            DataPullHandelIProgress.showOpBatchForm((IFormView)this.getView(), (FilterParam)this.getFilterValue(), (String)operateKey, (CloseCallBack)closeCallBack);
            return;
        }
        Object[] recordObj = operate.getListSelectedData().getPrimaryKeyValues();
        if ("nextperiod".equals(operateKey)) {
            HashSet<String> recordSet = new HashSet<String>(3);
            for (Object obj : recordObj) {
                recordSet.add(obj.toString());
            }
            QFilter filter = new QFilter("objectid", "in", recordSet);
            DynamicObjectCollection dataLocks = QueryServiceHelper.query((String)"bos_datalock", (String)"id", (QFilter[])new QFilter[]{filter});
            HashMap<String, String> acctMap = new HashMap<String, String>();
            for (DynamicObject data : dataLocks) {
                acctMap.put("id", data.getString("id"));
            }
            if (acctMap.size() != 0) {
                return;
            }
            AlertFromUtils.openAlertFrom(this.getView(), new CloseCallBack((IFormPlugin)this, "call_back_nextperiod"));
            args.setCancel(true);
            return;
        }
        if (ICT_CONVERT.equals(operateKey)) {
            if (recordObj == null || recordObj.length == 0) {
                ResManager.loadKDString((String)"\u8bf7\u52fe\u9009\u9700\u8981\u6298\u7b97\u7684\u73b0\u91d1\u6d41\u91cf\u6570\u636e\u3002", (String)"IctPullDataListPlugin_4", (String)"fi-ict-formplugin", (Object[])new Object[0]);
                return;
            }
            AlertFromUtils.openConvert(this.getView(), new CloseCallBack((IFormPlugin)this, ICT_CONVERT));
            args.setCancel(true);
        }
    }

    public void packageData(PackageDataEvent e) {
        super.packageData(e);
        if (!e.getRowData().get("sourcesys").equals("83bfebc8000017ac")) {
            e.getNoLinkKey().add("billno");
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        if (nextPeriodOp.contains(op.getOperateKey())) {
            this.getView().invokeOperation("refresh");
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Map returnMap = (Map)closedCallBackEvent.getReturnData();
        if ("call_back_nextperiod".equals(actionId)) {
            if (returnMap == null) {
                return;
            }
            ListSelectedRowCollection selectedRows = ((BillList)this.getControl("billlistap")).getSelectedRows();
            Object bselectedn = new ArrayList(selectedRows.size());
            for (ListSelectedRow selectedRow : selectedRows) {
                long primaryKey = (Long)selectedRow.getPrimaryKeyValue();
                bselectedn.add(primaryKey);
            }
            AlertFromUtils.closedCallBack(this.getView(), this.getFormKey(), (List<Long>)bselectedn, returnMap);
        }
        if (OP_KEY.contains(actionId)) {
            String msg = null;
            switch (actionId) {
                case "initacct": {
                    msg = ResManager.loadKDString((String)"\u521d\u59cb\u5316\u79d1\u76ee\u6570\u636e\u5df2\u6267\u884c\u3002", (String)"IctPullDataListPlugin_0", (String)"fi-ict-formplugin", (Object[])new Object[0]);
                    break;
                }
                case "pullacct": {
                    msg = ResManager.loadKDString((String)"\u62bd\u53d6\u53d1\u751f\u6570\u636e\u5df2\u6267\u884c\u3002", (String)"IctPullDataListPlugin_1", (String)"fi-ict-formplugin", (Object[])new Object[0]);
                    break;
                }
                case "initcf": {
                    msg = ResManager.loadKDString((String)"\u521d\u59cb\u5316\u73b0\u91d1\u6d41\u91cf\u6570\u636e\u5df2\u6267\u884c\u3002", (String)"IctPullDataListPlugin_2", (String)"fi-ict-formplugin", (Object[])new Object[0]);
                    break;
                }
                case "pullcf": {
                    msg = ResManager.loadKDString((String)"\u62bd\u53d6\u53d1\u751f\u6570\u636e\u5df2\u6267\u884c\u3002", (String)"IctPullDataListPlugin_3", (String)"fi-ict-formplugin", (Object[])new Object[0]);
                }
            }
            OperationResult result = new OperationResult();
            FilterParam filterValue = this.getFilterValue();
            int orgCount = filterValue.getOrgIdLst().size();
            ArrayList<Long> succOrgIds = new ArrayList<Long>(orgCount);
            for (Long orgId : filterValue.getOrgIdLst()) {
                for (Long boolTypeId : filterValue.getBooktypeIdLst()) {
                    String value = CacheKey.getUserKey((long)orgId, (long)boolTypeId);
                    if (Objects.nonNull(this.cache.get(value))) {
                        OperateErrorInfo errorInfo = new OperateErrorInfo("", ErrorLevel.FatalError, (Object)orgId);
                        errorInfo.setMessage(this.cache.get(value + "_error"));
                        errorInfo.setLevel(ErrorLevel.Error);
                        errorInfo.setTitle(msg);
                        result.setSuccess(Boolean.FALSE.booleanValue());
                        result.addErrorInfo(errorInfo);
                        this.cache.remove(value);
                        continue;
                    }
                    succOrgIds.add(orgId);
                }
            }
            if (result.isSuccess()) {
                this.getView().showSuccessNotification(msg);
            } else {
                result.setBillCount(orgCount);
                result.setSuccessPkIds(succOrgIds);
                this.getView().showOperationResult(result);
            }
            this.getView().invokeOperation("refresh");
        }
        if (ICT_CONVERT.equals(actionId)) {
            this.convertCheck(returnMap);
        }
    }

    private void convertCheck(Map<String, String> returnMap) {
        if (returnMap == null) {
            return;
        }
        ListSelectedRowCollection selectedRows = ((BillList)this.getControl("billlistap")).getSelectedRows();
        ArrayList<Long> billIds = new ArrayList<Long>(selectedRows.size());
        for (ListSelectedRow selectedRow : selectedRows) {
            long primaryKey = (Long)selectedRow.getPrimaryKeyValue();
            billIds.add(primaryKey);
        }
        AlertFromUtils.closedConvertBack(this.getView(), this.getFormKey(), billIds, returnMap);
    }

    public static void openVoucher(long orgId, IFormView view, long voucherid) {
        VoucherUtils.hyperLinkSingleVoucher((long)orgId, (long)voucherid, (IFormView)view);
    }

    protected FilterParam getFilterValue() {
        String querValue = this.getView().getPageCache().get(CHCHE_QUERY_VALUE);
        FilterParam param = new FilterParam();
        if (Objects.isNull(querValue)) {
            Date now = TimeServiceHelper.now();
            String defaultOrg = this.getView().getPageCache().get("defaultOrg");
            long orgId = StringUtils.isEmpty((String)defaultOrg) ? RequestContext.get().getOrgId() : Long.parseLong(defaultOrg);
            param.setOrgIdLst(Collections.singletonList(orgId));
            param.setBeginBookDate(ICTUtils.getMonthFirstCurDate((Date)now));
            param.setEndBookDate(ICTUtils.getMonthLastCurDate((Date)now));
        } else {
            param = (FilterParam)SerializationUtils.fromJsonString((String)querValue, FilterParam.class);
        }
        ArrayList<Long> boottypeIds = new ArrayList<Long>(1);
        boottypeIds.add(AccSysUtil.getMainBookType().getLong("id"));
        param.setBooktypeIdLst(boottypeIds);
        LOGGER.info("- IctPullDataListPlugin param:{}", (Object)SerializationUtils.toJsonString((Object)param));
        return param;
    }

    private static Set<Long> getSelectOrg(List<QFilter> filter) {
        filter.add(new QFilter("view.treetype", "=", (Object)"10"));
        filter.add(new QFilter("view.number", "=", (Object)"10"));
        DynamicObjectCollection idColl = QueryServiceHelper.query((String)"GLUtil.getParentOrgId", (String)"bos_org_structure", (String)ORG_ID, (QFilter[])filter.toArray(new QFilter[0]), null);
        List selOrgIds = idColl.stream().map(v -> v.getLong(ORG_ID)).collect(Collectors.toList());
        return new HashSet<Long>(selOrgIds);
    }

    protected String initCheckData(String formKey) {
        FilterParam filterValue = this.getFilterValue();
        if (Objects.isNull(filterValue.getBeginBookDate())) {
            return ResManager.loadKDString((String)"\u62bd\u53d6\u521d\u59cb\u5316\u6570\u636e\u5f00\u59cb\u8bb0\u8d26\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"IctPullVchEntryAcctData_0", (String)"fi-ict-formplugin", (Object[])new Object[0]);
        }
        List orgIds = filterValue.getOrgIdLst();
        List booktypeIdLst = filterValue.getBooktypeIdLst();
        QFilter filter = new QFilter("org", "in", (Object)orgIds);
        filter.and(new QFilter("booktype", "in", (Object)booktypeIdLst));
        QFilter fisinit = new QFilter("isinitrecord", "=", (Object)"1");
        boolean exists = QueryServiceHelper.exists((String)formKey, (QFilter[])new QFilter[]{filter, fisinit});
        if (exists) {
            return ResManager.loadKDString((String)"\u6240\u9009\u7ec4\u7ec7\u6216\u4e0b\u7ea7\u7ec4\u7ec7\u5df2\u8fdb\u884c\u8fc7\u521d\u59cb\u5316\uff0c\u5982\u9700\u91cd\u65b0\u521d\u59cb\u5316\uff0c\u8bf7\u5220\u9664\u4e4b\u524d\u521d\u59cb\u5316\u6570\u636e\u540e\uff0c\u518d\u91cd\u65b0\u62bd\u53d6\u3002", (String)"IctPullVchEntryAcctData_2", (String)"fi-ict-formplugin", (Object[])new Object[0]);
        }
        filter.and(new QFilter("bookeddate", "<", (Object)filterValue.getBeginBookDate()));
        exists = QueryServiceHelper.exists((String)formKey, (QFilter[])filter.toArray());
        if (exists) {
            return ResManager.loadKDString((String)"\u5df2\u62bd\u53d6\u8fc7\u603b\u8d26\u4e1a\u52a1\u6570\u636e\uff0c\u521d\u59cb\u5316\u8bb0\u8d26\u65e5\u671f\u4e0d\u80fd\u5927\u4e8e\u603b\u8d26\u4e1a\u52a1\u65e5\u671f\u3002", (String)"IctPullVchEntryAcctData_1", (String)"fi-ict-formplugin", (Object[])new Object[0]);
        }
        return "";
    }

    protected abstract String getFormKey();
}

