/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.formplugin.recontolerance;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ict.accsys.AccSysUtil;
import kd.fi.ict.accsys.AccountBookInfo;
import kd.fi.ict.util.AccountServiceHelper;
import kd.fi.ict.util.QFBuilder;

public class IctCfReconToleranceEditPlugin
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.cashFlowItemListerer();
    }

    private void cashFlowItemListerer() {
        BasedataEdit cashflowitem = (BasedataEdit)this.getView().getControl("cashflowitem");
        cashflowitem.addBeforeF7SelectListener(ext -> {
            Long orgId = (Long)this.getModel().getValue("createorg_id");
            QFBuilder cfFilter = AccountServiceHelper.getInterCashItemFilter((long)orgId, (boolean)false);
            ListShowParameter showParameter = (ListShowParameter)ext.getFormShowParameter();
            List filter = showParameter.getListFilterParameter().getQFilters();
            filter.addAll(cfFilter.toList());
            DynamicObjectCollection idColl = QueryServiceHelper.query((String)"gl_cashflowitem", (String)"id", (QFilter[])filter.toArray(new QFilter[0]));
            HashSet ids = new HashSet(idColl.size());
            idColl.forEach(v -> ids.add(v.getLong("id")));
            ArrayList<QFilter> newFilter = new ArrayList<QFilter>(2);
            newFilter.add(new QFilter("id", "in", ids));
            showParameter.getListFilterParameter().setQFilters(newFilter);
        });
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        super.beforeImportData(e);
        this.setUniqueCashFlowItem(e);
    }

    private void setUniqueCashFlowItem(BeforeImportDataEventArgs e) {
        Map sourceData = e.getSourceData();
        if (sourceData == null) {
            return;
        }
        Map orgMap = (Map)sourceData.get("org");
        if (Objects.isNull(orgMap)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u540d\u79f0\u6216\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"IctCfReconToleranceEditPlugin_0", (String)"fi-ict-formplugin", (Object[])new Object[0]), new Object[0]));
        }
        Long orgId = this.getOrgIdByNumber(orgMap);
        if (orgId == null) {
            return;
        }
        AccountBookInfo bookInfo = AccSysUtil.getBookFromAccSys((long)orgId, (long)237528347981256704L);
        if (bookInfo == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u62e9\u7684\u6838\u7b97\u7ec4\u7ec7\u6ca1\u6709\u5efa\u7acb\u4e3b\u8d26\u7c3f\uff0c\u8bf7\u524d\u5f80\u57fa\u7840\u8d44\u6599\u8bbe\u7f6e\u3002", (String)"ICTHomePlugin_3", (String)"fi-ict-formplugin", (Object[])new Object[0]));
            return;
        }
    }

    private Long getOrgIdByNumber(Map<String, Object> orgMap) {
        Object orgNumber = orgMap.get("number");
        QFilter[] orgNumberFilter = new QFilter[]{new QFilter("number", "=", orgNumber)};
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (String)"id", (QFilter[])orgNumberFilter);
        if (dynamicObject == null) {
            return null;
        }
        return dynamicObject.getLong("id");
    }
}

