/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.report;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportList;
import kd.bos.report.plugin.AbstractReportFormPlugin;

public class AccReconciliationFormRpt
extends AbstractReportFormPlugin
implements BeforeF7SelectListener,
HyperLinkClickListener {
    public void registerListener(EventObject e) {
        BasedataEdit reconschemefield = (BasedataEdit)this.getControl("reconschemefield");
        reconschemefield.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        ReportList reportList = (ReportList)this.getControl("reportlistap");
        reportList.addHyperClickListener((HyperLinkClickListener)this);
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        super.verifyQuery(queryParam);
        FilterInfo filterInfo = queryParam.getFilter();
        String amountType = filterInfo.getString("amounttype");
        if (null == amountType) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u91d1\u989d\u7c7b\u578b\u3002", (String)"AccReconciliationFormRpt_0", (String)"fi-ict-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void setMergeColums(List<String> columns) {
        columns.add("period");
        columns.add("reconscheme");
        columns.add("currency");
        columns.add("ownorg");
        columns.add("opporg");
        columns.add("reconschemename");
        columns.add("currencyname");
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        BasedataEdit baseData = (BasedataEdit)e.getSource();
        if ("reconschemefield".equals(baseData.getKey())) {
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>(2);
            qFilters.add(new QFilter("enable", "=", (Object)"1"));
            qFilters.add(new QFilter("transactiontype", "!=", (Object)"4"));
            ListShowParameter f7List = (ListShowParameter)e.getFormShowParameter();
            f7List.getListFilterParameter().setQFilters(qFilters);
        }
    }

    public void processRowData(String gridId, DynamicObjectCollection rowData, ReportQueryParam queryParam) {
        DynamicObject period = this.getQueryParam().getFilter().getDynamicObject("periodfield");
        String totalMsg = ResManager.loadKDString((String)"\u5408\u8ba1", (String)"AccReconciliationFormRpt_1", (String)"fi-ict-formplugin", (Object[])new Object[0]);
        for (DynamicObject row : rowData) {
            row.set("period", (Object)period);
            if (row.getLong("rowtype") == 1L) {
                row.set("period", null);
                row.set("reconscheme", null);
                row.set("ownorg", null);
                row.set("opporg", null);
                row.set("ownaccountnumber", null);
                row.set("ownaccount", null);
                row.set("ownorg", null);
                row.set("reconschemename", (Object)totalMsg);
                continue;
            }
            row.set("perioddiff", null);
            row.set("yeardiff", null);
            row.set("reconschemename", row.get("reconscheme.name"));
            row.set("currencyname", row.get("currency.name"));
        }
    }

    public void packageData(PackageDataEvent e) {
        super.packageData(e);
        if (e.getRowData().getLong("rowtype") == 1L) {
            e.getNoLinkKey().addAll(this.getLinkFields());
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent event) {
        String fieldName = event.getFieldName();
        if (this.getLinkFields().contains(fieldName)) {
            this.showRelaccRrecord(fieldName);
        }
    }

    private void showRelaccRrecord(String fieldName) {
        ReportList control = (ReportList)this.getControl("reportlistap");
        int rowIndex = this.getModel().getEntryCurrentRowIndex("reportlistap");
        DynamicObject rowData = control.getReportModel().getRowData(rowIndex);
        QFilter filter = new QFilter("reconscheme", "=", (Object)rowData.getLong("reconscheme.id"));
        filter.and(new QFilter("currency", "=", (Object)rowData.getLong("currency.id")));
        Date endDate = rowData.getDate("period.enddate");
        String dc = "";
        long org = 0L;
        String amountType = this.getQueryParam().getFilter().getString("amounttype");
        boolean isBalance = "balance".equals(amountType);
        switch (fieldName) {
            case "pdebitfor": {
                filter.and(new QFilter("org", "=", (Object)rowData.getLong("ownorg.id")));
                filter.and(new QFilter("oporg", "=", (Object)rowData.getLong("opporg.id")));
                if (isBalance) {
                    filter.and(new QFilter("bookeddate", "<=", (Object)endDate));
                } else {
                    filter.and(new QFilter("ori_period", "=", (Object)rowData.getLong("period.id")));
                }
                filter.and(new QFilter("account.masterid", "=", (Object)rowData.getLong("ownaccount.id")));
                dc = "1";
                org = rowData.getLong("ownorg.id");
                break;
            }
            case "pcreditfor": {
                filter.and(new QFilter("org", "=", (Object)rowData.getLong("ownorg.id")));
                filter.and(new QFilter("oporg", "=", (Object)rowData.getLong("opporg.id")));
                if (isBalance) {
                    filter.and(new QFilter("bookeddate", "<=", (Object)endDate));
                } else {
                    filter.and(new QFilter("ori_period", "=", (Object)rowData.getLong("period.id")));
                }
                filter.and(new QFilter("account.masterid", "=", (Object)rowData.getLong("ownaccount.id")));
                dc = "-1";
                org = rowData.getLong("ownorg.id");
                break;
            }
            case "pyeardebitfor": {
                filter.and(new QFilter("org", "=", (Object)rowData.getLong("ownorg.id")));
                filter.and(new QFilter("oporg", "=", (Object)rowData.getLong("opporg.id")));
                filter.and(new QFilter("bookeddate", ">=", (Object)AccReconciliationFormRpt.getFirstDayOfYear(endDate)));
                filter.and(new QFilter("bookeddate", "<=", (Object)endDate));
                filter.and(new QFilter("account.masterid", "=", (Object)rowData.getLong("ownaccount.id")));
                dc = "1";
                org = rowData.getLong("ownorg.id");
                break;
            }
            case "pyearcreditfor": {
                filter.and(new QFilter("org", "=", (Object)rowData.getLong("ownorg.id")));
                filter.and(new QFilter("oporg", "=", (Object)rowData.getLong("opporg.id")));
                filter.and(new QFilter("bookeddate", ">=", (Object)AccReconciliationFormRpt.getFirstDayOfYear(endDate)));
                filter.and(new QFilter("bookeddate", "<=", (Object)endDate));
                filter.and(new QFilter("account.masterid", "=", (Object)rowData.getLong("ownaccount.id")));
                dc = "-1";
                org = rowData.getLong("ownorg.id");
                break;
            }
            case "oppdebitfor": {
                filter.and(new QFilter("org", "=", (Object)rowData.getLong("opporg.id")));
                filter.and(new QFilter("oporg", "=", (Object)rowData.getLong("ownorg.id")));
                if (isBalance) {
                    filter.and(new QFilter("bookeddate", "<=", (Object)endDate));
                } else {
                    filter.and(new QFilter("ori_period", "=", (Object)rowData.getLong("period.id")));
                }
                filter.and(new QFilter("account.masterid", "=", (Object)rowData.getLong("oppaccount.id")));
                dc = "1";
                org = rowData.getLong("opporg.id");
                break;
            }
            case "oppcreditfor": {
                filter.and(new QFilter("org", "=", (Object)rowData.getLong("opporg.id")));
                filter.and(new QFilter("oporg", "=", (Object)rowData.getLong("ownorg.id")));
                if (isBalance) {
                    filter.and(new QFilter("bookeddate", "<=", (Object)endDate));
                } else {
                    filter.and(new QFilter("ori_period", "=", (Object)rowData.getLong("period.id")));
                }
                filter.and(new QFilter("account.masterid", "=", (Object)rowData.getLong("oppaccount.id")));
                dc = "-1";
                org = rowData.getLong("opporg.id");
                break;
            }
            case "oppyeardebitfor": {
                filter.and(new QFilter("org", "=", (Object)rowData.getLong("opporg.id")));
                filter.and(new QFilter("oporg", "=", (Object)rowData.getLong("ownorg.id")));
                filter.and(new QFilter("bookeddate", ">=", (Object)AccReconciliationFormRpt.getFirstDayOfYear(endDate)));
                filter.and(new QFilter("bookeddate", "<=", (Object)endDate));
                filter.and(new QFilter("account.masterid", "=", (Object)rowData.getLong("oppaccount.id")));
                dc = "1";
                org = rowData.getLong("opporg.id");
                break;
            }
            case "oppyearcreditfor": {
                filter.and(new QFilter("org", "=", (Object)rowData.getLong("opporg.id")));
                filter.and(new QFilter("oporg", "=", (Object)rowData.getLong("ownorg.id")));
                filter.and(new QFilter("bookeddate", ">=", (Object)AccReconciliationFormRpt.getFirstDayOfYear(endDate)));
                filter.and(new QFilter("bookeddate", "<=", (Object)endDate));
                filter.and(new QFilter("account.masterid", "=", (Object)rowData.getLong("oppaccount.id")));
                dc = "-1";
                org = rowData.getLong("opporg.id");
                break;
            }
        }
        if (!isBalance && !StringUtils.isEmpty((CharSequence)dc)) {
            filter.and(new QFilter("dc", "=", (Object)dc));
        }
        ListShowParameter parameter = new ListShowParameter();
        parameter.setBillFormId("ict_relacctrecord");
        parameter.setFormId("bos_list");
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setCustomParam("filter", (Object)filter.toSerializedString());
        parameter.setCustomParam("org", (Object)org);
        parameter.setShowFilter(false);
        parameter.setShowQuickFilter(false);
        this.getView().showForm((FormShowParameter)parameter);
    }

    private static Date getFirstDayOfYear(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int year = calendar.get(1);
        calendar.clear();
        calendar.set(1, year);
        return calendar.getTime();
    }

    private List<String> getLinkFields() {
        return Arrays.asList("pdebitfor", "pcreditfor", "pyeardebitfor", "pyearcreditfor", "oppdebitfor", "oppcreditfor", "oppyeardebitfor", "oppyearcreditfor");
    }
}

