/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.report;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.ext.fi.lock.IShareLock;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.report.IReportView;
import kd.bos.report.ReportList;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.bd.util.BatchProcessUtil;
import kd.fi.ict.accsys.AccSysUtil;
import kd.fi.ict.business.cancelcheck.bean.OperatorLockKey;
import kd.fi.ict.business.handle.ProgressResult;
import kd.fi.ict.business.handle.impl.AutoReconHandleIProgress;
import kd.fi.ict.business.handle.impl.NoDiffAuditHandleIProgress;
import kd.fi.ict.enums.CheckStatus;
import kd.fi.ict.enums.TransactionType;
import kd.fi.ict.lock.LockKey;
import kd.fi.ict.report.AutoReconciliationFormRptCheckCross;
import kd.fi.ict.util.ICTUtils;
import kd.fi.ict.util.ListFilterUtils;
import kd.fi.ict.util.PermissonType;

public class AutoReconFormRpt
extends AbstractReportFormPlugin {
    private static final String RECONSCHEME = "reconscheme";
    private static final String PERIOD = "period";
    private static final String OPERKEY_AUTORECON = "autoreconciliation";
    private static final String OWNORG_ID = "ownorg_id";
    private static final String OPPORG_ID = "opporg_id";
    private static final String CURRENCY_ID = "currency_id";
    private static final String SCHEME = "scheme";
    private static final String TRANSACTIONTYPE = "transactiontype";
    private static final String OPERKEY_NODIFFAUDIT = "nodiffaudit";
    private static final Log logger = LogFactory.getLog(AutoReconFormRpt.class);

    public void initialize() {
        super.initialize();
        this.getView().addPlugin((IFormPlugin)new AutoReconciliationFormRptCheckCross());
        this.setShortCuts();
    }

    private void setShortCuts() {
        JSONArray arrayItem = new JSONArray();
        JSONObject item = new JSONObject();
        item.put("type", (Object)"keyUp");
        item.put("shortCuts", (Object)"shift+m");
        arrayItem.add((Object)item);
        IReportView formView = this.getView();
        IClientViewProxy clientViewProxy = (IClientViewProxy)formView.getService(IClientViewProxy.class);
        JSONArray action = new JSONArray();
        action.add((Object)arrayItem);
        clientViewProxy.addAction("setShortCuts", (Object)action);
    }

    public void customEvent(CustomEventArgs e) {
        super.customEvent(e);
        String key = e.getEventArgs();
        if ("[16,77]".equals(key)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"releaselock"});
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("releaselock".equals(itemKey)) {
            this.releaseShareLock();
        }
    }

    private void releaseShareLock() {
        DynamicObjectCollection selectRowData = this.getSelectRowData();
        if (selectRowData.size() != 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"AutoReconFormRpt_6", (String)"fi-ict-formplugin", (Object[])new Object[0]));
            return;
        }
        List<String> lists = this.selectRowFieldJoin(selectRowData);
        for (String list : lists) {
            String[] reconStr = list.split(",");
            String orgId = reconStr[0];
            String oppOrgId = reconStr[1];
            String schemeId = reconStr[2];
            String currencyId = reconStr[3];
            String transactionType = reconStr[4];
            OperatorLockKey opLockKey = new OperatorLockKey(LockKey.getLockKeyByTransactionType((String)transactionType), Long.valueOf(orgId), Long.valueOf(oppOrgId), Long.valueOf(currencyId), Long.valueOf(schemeId));
            IShareLock shareLock = IShareLock.create();
            shareLock.forceRelease(opLockKey.getLockKey());
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u5b8c\u6210\u3002", (String)"AutoReconFormRpt_5", (String)"fi-ict-formplugin", (Object[])new Object[0]));
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.orgAddBeforeF7SelectListener("org", Boolean.TRUE);
        this.periodTypeAddBeforeF7SelectListener();
        this.periodAddBeforeF7SelectListener();
        this.f7ReconschemeListener();
        BasedataEdit thisOrgEdit = (BasedataEdit)this.getView().getControl("org");
        thisOrgEdit.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            ArrayList<QFilter> filters = param.getListFilterParameter().getQFilters();
            if (null == filters) {
                filters = new ArrayList<QFilter>(1);
                param.getListFilterParameter().setQFilters(filters);
            }
            DynamicObjectCollection orgCol = (DynamicObjectCollection)this.getModel().getValue("oporg");
            List org = orgCol.parallelStream().map(o -> o.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
            Set childOrgId = ICTUtils.getChildOrgId(new HashSet(org), (boolean)true);
            filters.add(new QFilter("id", "not in", (Object)childOrgId));
        });
        BasedataEdit opOrgEdit = (BasedataEdit)this.getView().getControl("oporg");
        opOrgEdit.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            ArrayList<QFilter> filters = param.getListFilterParameter().getQFilters();
            if (null == filters) {
                filters = new ArrayList<QFilter>(1);
                param.getListFilterParameter().setQFilters(filters);
            }
            DynamicObjectCollection orgCol = (DynamicObjectCollection)this.getModel().getValue("org");
            List org = orgCol.parallelStream().map(o -> o.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
            Set childOrgId = ICTUtils.getChildOrgId(new HashSet(org), (boolean)true);
            QFilter filterOrg = new QFilter("org", "in", (Object)childOrgId).or("oporg", "in", (Object)childOrgId);
            QFilter filterStatus = new QFilter("status", "in", (Object)new String[]{CheckStatus.NONE.getValue(), CheckStatus.PART_CHECK.getValue()});
            DataSet oppOrgAccSet = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + ".queryORecordSet"), (String)"ict_relacctrecord", (String)"org,oporg", (QFilter[])new QFilter[]{filterStatus, filterOrg}, null).distinct();
            DataSet oppOrgCFSet = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + ".queryORecordSet"), (String)"ict_relcfrecord", (String)"org,oporg", (QFilter[])new QFilter[]{filterStatus, filterOrg}, null).distinct();
            DataSet oppOrgList = oppOrgAccSet.union(oppOrgCFSet).distinct().groupBy(new String[]{"org", "oporg"}).finish().distinct();
            HashSet<Long> orglist = new HashSet<Long>(5);
            for (Row row : oppOrgList) {
                orglist.add(row.getLong("org"));
                orglist.add(row.getLong("oporg"));
            }
            filters.add(new QFilter("id", "in", orglist));
        });
    }

    private void orgAddBeforeF7SelectListener(String org, Boolean isIncludeUnit) {
        BasedataEdit orgEdit = (BasedataEdit)this.getControl(org);
        orgEdit.addBeforeF7SelectListener(evt -> {
            List orgList = AccSysUtil.getAcctOrgPkList((String)this.getView().getEntityId(), (boolean)isIncludeUnit, (PermissonType)PermissonType.VIEW);
            ListShowParameter listShow = (ListShowParameter)evt.getFormShowParameter();
            listShow.getListFilterParameter().getQFilters().add(new QFilter("id", "in", (Object)orgList));
        });
    }

    private void periodTypeAddBeforeF7SelectListener() {
        BasedataEdit orgEdit = (BasedataEdit)this.getControl("periodtype");
        orgEdit.addBeforeF7SelectListener(evt -> {
            DynamicObjectCollection orgCol = (DynamicObjectCollection)this.getModel().getValue("org");
            List org = orgCol.parallelStream().map(o -> o.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
            Set childOrgId = ICTUtils.getChildOrgId(new HashSet(org), (boolean)true);
            Set periodTypeByOrgs = AccSysUtil.getPeriodTypeByAccountBookOrgs((Set)childOrgId);
            ListShowParameter listShow = (ListShowParameter)evt.getFormShowParameter();
            List qFilters = listShow.getListFilterParameter().getQFilters();
            qFilters.add(new QFilter("id", "in", (Object)periodTypeByOrgs));
        });
    }

    private void periodAddBeforeF7SelectListener() {
        BasedataEdit period = (BasedataEdit)this.getControl(PERIOD);
        period.addBeforeF7SelectListener(evt -> {
            DynamicObject periodType = (DynamicObject)this.getModel().getValue("periodtype");
            Long pkValue = Optional.ofNullable(periodType).map(v -> v.getLong("id")).orElse(0L);
            ListShowParameter listShow = (ListShowParameter)evt.getFormShowParameter();
            List qFilters = listShow.getListFilterParameter().getQFilters();
            qFilters.add(new QFilter("periodtype", "=", (Object)pkValue));
            DynamicObject periodObj = (DynamicObject)this.getModel().getValue(PERIOD);
            if (periodObj != null) {
                listShow.setSelectedRow(periodObj.getPkValue());
            }
        });
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "org": {
                ListFilterUtils.setPeriodTypeDefaultValue((IFormView)this.getView(), (String)"org");
                break;
            }
            case "periodtype": {
                this.getModel().setValue(PERIOD, null);
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        List orgList = AccSysUtil.getAcctOrgPkList((String)this.getView().getEntityId(), (boolean)false, (PermissonType)PermissonType.VIEW);
        if (orgList.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u6709\u6743\u9650\u7684\u7ec4\u7ec7\uff0c\u8bf7\u5148\u5206\u914d\u6743\u9650\u3002", (String)"AutoReconciliationFormRpt_0", (String)"fi-ict-formplugin", (Object[])new Object[0]));
        } else {
            long defId = RequestContext.get().getOrgId();
            if (!orgList.contains(defId)) {
                defId = (Long)orgList.get(0);
            }
            this.getModel().setValue("org", (Object)new Long[]{defId});
            this.setPeriodTypeDefValue(defId);
        }
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"releaselock"});
    }

    private void setPeriodTypeDefValue(long defId) {
        Set childOrgId = ICTUtils.getChildOrgId(new HashSet<Long>(Collections.singletonList(defId)), (boolean)true);
        Set periodTypeByOrgs = AccSysUtil.getPeriodTypeByOrgs((Set)childOrgId);
        if (Objects.nonNull(periodTypeByOrgs) && periodTypeByOrgs.size() > 0) {
            this.getModel().setValue("periodtype", periodTypeByOrgs.iterator().next());
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        DynamicObjectCollection reconscheme;
        FilterInfo filterInfo = queryParam.getFilter();
        DynamicObjectCollection org = filterInfo.getDynamicObjectCollection("org");
        if (null == org || org.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"AutoReconciliationFormRpt_1", (String)"fi-ict-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (filterInfo.getLong("periodtype") == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u671f\u95f4\u7c7b\u578b\u3002", (String)"AutoReconciliationFormRpt_4", (String)"fi-ict-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (filterInfo.getLong(PERIOD) == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5bf9\u8d26\u671f\u95f4\u3002", (String)"AutoReconciliationFormRpt_3", (String)"fi-ict-formplugin", (Object[])new Object[0]));
            return false;
        }
        DynamicObjectCollection oporg = filterInfo.getDynamicObjectCollection("oporg");
        if (null == oporg || oporg.isEmpty()) {
            oporg = new DynamicObjectCollection();
        }
        if ((reconscheme = filterInfo.getDynamicObjectCollection(RECONSCHEME)) == null || reconscheme.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5bf9\u8d26\u65b9\u6848\u3002", (String)"AutoReconciliationFormRpt_5", (String)"fi-ict-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (this.checkScheme(reconscheme)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bf9\u8d26\u65b9\u6848\u5305\u542b\u79d1\u76ee\u548c\u73b0\u91d1\u6d41\u91cf\u4e24\u79cd\u4e0d\u540c\u7c7b\u578b\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"AutoReconciliationFormRpt_7", (String)"fi-ict-formplugin", (Object[])new Object[0]));
            return false;
        }
        long bookTypeId = AccSysUtil.getMainBookType().getLong("id");
        ArrayList<Long> orgIds = new ArrayList<Long>(org.size() + oporg.size());
        for (DynamicObject obj : org) {
            orgIds.add(obj.getLong("id"));
        }
        for (DynamicObject obj : oporg) {
            orgIds.add(obj.getLong("id"));
        }
        QFilter fbt = new QFilter("bookstype", "=", (Object)bookTypeId);
        DynamicObjectCollection books = BatchProcessUtil.batchQueryDynColl(orgIds, batchData -> {
            QFilter forgIds = new QFilter("org", "in", batchData);
            return QueryServiceHelper.query((String)"gl_accountbook", (String)"id,periodtype,basecurrency", (QFilter[])new QFilter[]{fbt, forgIds});
        });
        HashSet<Long> periodTypeIds = new HashSet<Long>(5);
        for (DynamicObject book : books) {
            periodTypeIds.add(book.getLong("periodtype"));
        }
        if (periodTypeIds.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bf9\u65b9\u7ec4\u7ec7\u548c\u672c\u65b9\u7ec4\u7ec7\u7684\u671f\u95f4\u7c7b\u578b\u4e0d\u4e00\u81f4\uff0c\u4e0d\u5141\u8bb8\u5bf9\u8d26\u3002", (String)"AutoReconciliationFormRpt_6", (String)"fi-ict-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean checkScheme(DynamicObjectCollection reconscheme) {
        HashSet<String> schemeMap = new HashSet<String>();
        for (DynamicObject scheme : reconscheme) {
            String type = scheme.getString(TRANSACTIONTYPE);
            if (TransactionType.CASH_FLOW.getTransactionType().equals(type)) {
                schemeMap.add("2");
                continue;
            }
            schemeMap.add("1");
        }
        return schemeMap.size() > 1;
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        ReportList control = (ReportList)this.getView().getControl("reportlistap");
        control.setSelectedAll(Boolean.TRUE.booleanValue());
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        ReportList control = (ReportList)this.getView().getControl("reportlistap");
        switch (operateKey) {
            case "autoreconciliation": {
                int[] selectRows;
                if (!control.getEntryState().isSelectAllRows() && (selectRows = control.getEntryState().getSelectedRows()).length <= 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u81f3\u5c11\u4e00\u884c\u6570\u636e\u8fdb\u884c\u81ea\u52a8\u5bf9\u8d26\u3002", (String)"AutoReconFormRpt_3", (String)"fi-ict-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    break;
                }
                this.beforeDoOperationParam(operate);
                args.setCancel(true);
                break;
            }
            case "nodiffaudit": {
                int[] selectRows;
                if (!control.getEntryState().isSelectAllRows() && (selectRows = control.getEntryState().getSelectedRows()).length <= 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u81f3\u5c11\u4e00\u884c\u6570\u636e\u8fdb\u884c\u65e0\u5dee\u5f02\u52fe\u7a3d\u3002", (String)"AutoReconFormRpt_4", (String)"fi-ict-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    break;
                }
                this.beforeDoOperationParam(operate);
                args.setCancel(true);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        OperationResult opResult = args.getOperationResult();
        if (OPERKEY_AUTORECON.equals(operateKey)) {
            if (opResult.isSuccess()) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u81ea\u52a8\u5bf9\u8d26\u5b8c\u6210\u3002", (String)"AutoReconFormRpt_1", (String)"fi-ict-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showErrorNotification(opResult.getMessage());
            }
            this.getView().invokeOperation("refresh");
        }
    }

    private void beforeDoOperationParam(FormOperate operate) {
        DynamicObjectCollection dynColl = this.getSelectRowData();
        if (dynColl.size() == 0) {
            if (OPERKEY_AUTORECON.equals(operate.getOperateKey())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u81f3\u5c11\u4e00\u884c\u6570\u636e\u8fdb\u884c\u81ea\u52a8\u5bf9\u8d26\u3002", (String)"AutoReconFormRpt_3", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                return;
            }
            if (OPERKEY_NODIFFAUDIT.equals(operate.getOperateKey())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u81f3\u5c11\u4e00\u884c\u6570\u636e\u8fdb\u884c\u65e0\u5dee\u5f02\u52fe\u7a3d\u3002", (String)"AutoReconFormRpt_4", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                return;
            }
            return;
        }
        this.batchAutoRecon(operate, dynColl);
    }

    private DynamicObjectCollection getSelectRowData() {
        ReportList control = (ReportList)this.getView().getControl("reportlistap");
        int rowCount = control.getReportModel().getRowCount();
        DynamicObjectCollection dynColl = new DynamicObjectCollection();
        if (control.getEntryState().isSelectAllRows()) {
            dynColl = control.getReportModel().getRowData(0, rowCount, true);
        } else {
            int[] selectedRows;
            for (int selectedRow : selectedRows = control.getEntryState().getSelectedRows()) {
                dynColl.add((Object)control.getReportModel().getRowData(selectedRow));
            }
        }
        return dynColl;
    }

    private void batchAutoRecon(FormOperate operate, DynamicObjectCollection dynColl) {
        List<String> list = this.selectRowFieldJoin(dynColl);
        if (OPERKEY_AUTORECON.equals(operate.getOperateKey())) {
            operate.getOption().setVariableValue("autoScheme", SerializationUtils.toJsonString(list));
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, OPERKEY_AUTORECON);
            AutoReconHandleIProgress.showOpBatchForm((IFormView)this.getView(), (FormOperate)operate, (CloseCallBack)closeCallBack);
        } else if (OPERKEY_NODIFFAUDIT.equals(operate.getOperateKey())) {
            operate.getOption().setVariableValue("nodiffparam", SerializationUtils.toJsonString(list));
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, OPERKEY_NODIFFAUDIT);
            NoDiffAuditHandleIProgress.showOpBatchForm((IFormView)this.getView(), (FormOperate)operate, (CloseCallBack)closeCallBack);
        }
    }

    private List<String> selectRowFieldJoin(DynamicObjectCollection dynColl) {
        ArrayList<String> list = new ArrayList<String>(dynColl.size());
        HashSet<String> orgAndOporgMap = new HashSet<String>(dynColl.size());
        for (DynamicObject rowData : dynColl) {
            long ownorgId = rowData.getLong(OWNORG_ID);
            long opporgId = rowData.getLong(OPPORG_ID);
            long currencyId = rowData.getLong(CURRENCY_ID);
            DynamicObject schemeaDy = rowData.getDynamicObject(SCHEME);
            long schemeId = schemeaDy.getLong("id");
            String transactionType = schemeaDy.getString(TRANSACTIONTYPE);
            long period = this.getQueryParam().getFilter().getLong(PERIOD);
            String orgAndOporgStr = ownorgId + "," + opporgId;
            if (opporgId > ownorgId) {
                orgAndOporgStr = opporgId + "," + ownorgId;
            }
            if (orgAndOporgMap.contains(orgAndOporgStr)) continue;
            orgAndOporgMap.add(orgAndOporgStr);
            orgAndOporgStr = String.join((CharSequence)",", (CharSequence[])Arrays.asList(ownorgId, opporgId, schemeId, currencyId, transactionType, period).stream().map(String::valueOf).toArray(String[]::new));
            list.add(orgAndOporgStr);
        }
        return list;
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        if (OPERKEY_AUTORECON.equals(actionId) || OPERKEY_NODIFFAUDIT.equals(actionId)) {
            List results = (List)e.getReturnData();
            if (results != null && !results.isEmpty()) {
                OperationResult delResult = new OperationResult();
                ArrayList<Integer> succObjs = new ArrayList<Integer>(10);
                for (ProgressResult result : results) {
                    if (Objects.isNull(result) || result.getResult().booleanValue()) {
                        succObjs.add(1);
                        continue;
                    }
                    OperateErrorInfo operateErrorInfo = new OperateErrorInfo("ICT_CANCEL_CHECK", ErrorLevel.Warning, null);
                    operateErrorInfo.setMessage(result.getMsg());
                    operateErrorInfo.setTitle(ResManager.loadKDString((String)"\u65e0\u5dee\u5f02\u52fe\u7a3d", (String)"AutoReconFormRpt_2", (String)"fi-ict-formplugin", (Object[])new Object[0]));
                    delResult.addErrorInfo(operateErrorInfo);
                }
                if (delResult.getAllErrorInfo().isEmpty()) {
                    delResult.setMessage(ResManager.loadKDString((String)"\u64cd\u4f5c\u5b8c\u6210\u3002", (String)"AutoReconFormRpt_5", (String)"fi-ict-formplugin", (Object[])new Object[0]));
                }
                delResult.setBillCount(results.size());
                delResult.setSuccessPkIds(succObjs);
                this.getView().showOperationResult(delResult);
            }
            this.getView().invokeOperation("refresh");
        }
    }

    private void f7ReconschemeListener() {
        MulBasedataEdit reconscheme = (MulBasedataEdit)this.getView().getControl(RECONSCHEME);
        reconscheme.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            List qFilters = param.getListFilterParameter().getQFilters();
            DynamicObjectCollection orgDyns = (DynamicObjectCollection)this.getModel().getValue("org");
            if (orgDyns.size() == 0) {
                qFilters.add(new QFilter("1", "=", (Object)"0", true));
            } else {
                orgDyns.forEach(v -> {
                    QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"ict_verifyscheme", (Long)v.getLong("fbasedataid.id"));
                    qFilters.add(baseDataFilter);
                });
            }
        });
    }
}

