/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.report;

import java.util.EventObject;
import java.util.Objects;
import java.util.Optional;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dlock.DLock;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.report.IReportView;
import kd.bos.report.ReportList;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.fi.ict.business.opservice.manualrelverigy.autoclick.ManualRelQueryParam;
import kd.fi.ict.cache.CacheHelper;
import kd.fi.ict.cache.CacheModule;
import kd.fi.ict.cache.DistributeCache;
import kd.fi.ict.enums.TransactionType;

public class AutoReconciliationFormRptCheckCross
extends AbstractReportFormPlugin {
    private static final String REPORT_LIST_AP = "reportlistap";
    private static final String RECON_RESULT = "reconresult";
    private static final String BAR_HANDRECON = "handrecon";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        ReportList rptList = (ReportList)this.getView().getControl(REPORT_LIST_AP);
        rptList.addHyperClickListener(evt -> {
            String clickFieldName = evt.getFieldName();
            if (RECON_RESULT.equals(clickFieldName)) {
                this.setHandReconClienkType(false);
                this.itemBtnShowManualReconciliationForm();
            }
        });
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        switch (evt.getItemKey()) {
            case "handrecon": {
                this.setHandReconClienkType(true);
                this.itemBtnShowManualReconciliationForm();
                break;
            }
        }
    }

    public void itemBtnShowManualReconciliationForm() {
        DynamicObject rowData;
        ReportList control = (ReportList)this.getView().getControl(REPORT_LIST_AP);
        if (this.getHandReconClienkType()) {
            if (control.getEntryState().isSelectAllRows()) {
                DynamicObjectCollection dynColl = control.getReportModel().getRowData(0, control.getReportModel().getRowCount(), true);
                if (dynColl.size() != 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u8fdb\u884c\u624b\u5de5\u5bf9\u8d26\u3002", (String)"AutoReconciliationFormRptCheckCross_0", (String)"fi-ict-formplugin", (Object[])new Object[0]));
                    return;
                }
                rowData = (DynamicObject)dynColl.get(0);
            } else {
                int[] selectRows = control.getEntryState().getSelectedRows();
                if (selectRows.length == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5bf9\u8d26\u6570\u636e\u3002", (String)"AutoReconciliationFormRptCheckCross_7", (String)"fi-ict-formplugin", (Object[])new Object[0]));
                    return;
                }
                rowData = control.getReportModel().getRowData(selectRows[0]);
            }
        } else {
            int[] selectRows = new int[]{control.getEntryState().getFocusRow()};
            if (selectRows.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5bf9\u8d26\u6570\u636e\u3002", (String)"AutoReconciliationFormRptCheckCross_7", (String)"fi-ict-formplugin", (Object[])new Object[0]));
                return;
            }
            rowData = control.getReportModel().getRowData(selectRows[0]);
        }
        if (Objects.isNull(rowData)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u8fdb\u884c\u624b\u5de5\u5bf9\u8d26\u3002", (String)"AutoReconciliationFormRptCheckCross_0", (String)"fi-ict-formplugin", (Object[])new Object[0]));
            return;
        }
        this.showManualReconciliationForm(rowData);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String actionId = messageBoxClosedEvent.getCallBackId();
        if ("checklockaction".equals(actionId) && "Yes".equals(messageBoxClosedEvent.getResultValue())) {
            String key = this.getView().getPageCache().get("checklockkey");
            DLock.forceUnlock((String[])new String[]{key});
            DistributeCache cache = CacheHelper.getDistributeCache((CacheModule)CacheModule.book);
            cache.remove(key);
            this.itemBtnShowManualReconciliationForm();
        }
    }

    private void showManualReconciliationForm(DynamicObject rowData) {
        int permission = PermissionServiceHelper.checkPermission((Long)Long.parseLong(RequestContext.get().getUserId()), (Long)rowData.getLong("ownorg.id"), (String)"ict", (String)"ict_auto_reconc_report", (String)"1QGF9Y82VI+6");
        if (permission == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u5185\u90e8\u4ea4\u6613\u5bf9\u8d26\u201d\u7684\u201c\u624b\u5de5\u5bf9\u8d26\u201d\u64cd\u4f5c\u7684\u529f\u80fd\u6743\u9650\u3002", (String)"AutoReconFormRpt_0", (String)"fi-ict-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("ict_manual_reconciliation");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setCustomParam("autoParam", (Object)SerializationUtils.toJsonString((Object)this.paramConvert(rowData)));
        this.getView().showForm(showParameter);
    }

    private ManualRelQueryParam paramConvert(DynamicObject rowData) {
        ManualRelQueryParam toManualRelParam = new ManualRelQueryParam();
        DynamicObject accountBookType = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_accountbookstype", (String)"id", (QFilter[])new QFilter("accounttype", "=", (Object)"1").toArray());
        toManualRelParam.setBooktypeId(accountBookType.getLong("id"));
        ReportQueryParam queryParam = this.getQueryParam();
        long periodId = Optional.ofNullable(queryParam.getFilter().getDynamicObject("period")).map(x -> x.getLong("id")).orElse(0L);
        if (periodId == 0L) {
            return toManualRelParam;
        }
        toManualRelParam.setPeriodId(periodId);
        toManualRelParam.setOwnorgId(((Long)rowData.getDynamicObject("ownorg").getPkValue()).longValue());
        toManualRelParam.setOppoorgId(((Long)rowData.getDynamicObject("opporg").getPkValue()).longValue());
        DynamicObject scheme = rowData.getDynamicObject("scheme");
        toManualRelParam.setSchemeId(scheme.getLong("id"));
        String showType = scheme.getString("transactiontype");
        if (TransactionType.CASH_FLOW.getTransactionType().equals(showType)) {
            toManualRelParam.setShowType("type_cf");
        } else {
            toManualRelParam.setShowType("type_acc");
        }
        toManualRelParam.setCurrencyId(((Long)rowData.getDynamicObject("currency").getPkValue()).longValue());
        return toManualRelParam;
    }

    public boolean validate(DynamicObject rowData) {
        IReportView view = this.getView();
        if ("1".equals(rowData.getString(RECON_RESULT))) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8be5\u6570\u636e\u5df2\u7ecf\u5bf9\u5e73\uff0c\u65e0\u987b\u624b\u5de5\u5bf9\u8d26\u3002", (String)"AutoReconciliationFormRptCheckCross_1", (String)"fi-ict-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (null == rowData.getDynamicObject("ownorg")) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8be5\u6570\u636e\u672c\u65b9\u7ec4\u7ec7\u4e3a\u7a7a\u3002", (String)"AutoReconciliationFormRptCheckCross_2", (String)"fi-ict-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (null == rowData.getDynamicObject("opporg")) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8be5\u6570\u636e\u5bf9\u65b9\u7ec4\u7ec7\u4e3a\u7a7a\u3002", (String)"AutoReconciliationFormRptCheckCross_3", (String)"fi-ict-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (null == rowData.getDynamicObject("scheme")) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8be5\u6570\u636e\u5bf9\u8d26\u65b9\u6848\u4e3a\u7a7a\u3002", (String)"AutoReconciliationFormRptCheckCross_6", (String)"fi-ict-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void setHandReconClienkType(boolean state) {
        this.getView().getPageCache().put(BAR_HANDRECON, String.valueOf(state));
    }

    private boolean getHandReconClienkType() {
        return String.valueOf(true).equals(this.getView().getPageCache().get(BAR_HANDRECON));
    }
}

