/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.report;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportList;
import kd.bos.report.events.CreateColumnEvent;
import kd.bos.report.plugin.AbstractReportFormPlugin;

public class CfitemFormRpt
extends AbstractReportFormPlugin
implements BeforeF7SelectListener,
HyperLinkClickListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        ReportList reportList = (ReportList)this.getControl("reportlistap");
        reportList.addHyperClickListener((HyperLinkClickListener)this);
        Toolbar bar = (Toolbar)this.getControl("toolbarap");
        bar.addItemClickListener((ItemClickListener)this);
        BasedataEdit scheme = (BasedataEdit)this.getControl("reconschemefield");
        scheme.addBeforeF7SelectListener(evt -> {
            ListShowParameter sp = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter listFilterParameter = sp.getListFilterParameter();
            List qFilters = listFilterParameter.getQFilters();
            qFilters.add(new QFilter("enable", "=", (Object)"1"));
            qFilters.add(new QFilter("transactiontype", "=", (Object)"4"));
        });
        ReportList control = (ReportList)this.getControl("reportlistap");
        control.addHyperClickListener(evt -> {
            int rowIndex = this.getModel().getEntryCurrentRowIndex("reportlistap");
            DynamicObject rowData = control.getReportModel().getRowData(rowIndex);
            String name = evt.getFieldName();
            if (this.linkFields().contains(name)) {
                String billType = "ict_relcfrecord";
                this.showBillEditForm(rowData, billType, name);
            }
        });
    }

    public void packageData(PackageDataEvent e) {
        super.packageData(e);
        if (e.getRowData().get("rowtype").equals("1")) {
            e.getNoLinkKey().addAll(this.linkFields());
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent event) {
        String fieldName = event.getFieldName();
    }

    private void showBillEditForm(DynamicObject rowData, String sourceBillTypeId, String name) {
        QFilter yearQfilter;
        if (rowData.getString("rowtype").equals("1")) {
            return;
        }
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setBillFormId(sourceBillTypeId);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setShowFilter(false);
        showParameter.setShowQuickFilter(false);
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(16);
        QFilter reconschemeQfilter = new QFilter("reconscheme", "=", (Object)rowData.getLong("reconscheme.id"));
        qFilters.add(reconschemeQfilter);
        QFilter currencyQfilter = new QFilter("currency", "=", (Object)rowData.getLong("currency.id"));
        qFilters.add(currencyQfilter);
        QFilter ownQfilter = null;
        QFilter oppQfilter = null;
        QFilter cfitemQfilter = null;
        QFilter periodQfilter = null;
        DynamicObject periodDyn = rowData.getDynamicObject("period");
        Date enddate = periodDyn.getDate("enddate");
        String year = periodDyn.getString("name").substring(0, 4);
        long periodId = periodDyn.getLong("id");
        if (this.ownFields().contains(name)) {
            showParameter.getCustomParams().put("ownOrg", rowData.getLong("ownorg.id"));
            ownQfilter = new QFilter("org", "=", (Object)rowData.getLong("ownorg.id"));
            oppQfilter = new QFilter("oporg", "=", (Object)rowData.getLong("opporg.id"));
            cfitemQfilter = new QFilter("cashflowitem.masterid", "=", (Object)rowData.getLong("owncfitem.id"));
            if ("ownperiodin".equals(name) || "ownperiodout".equals(name)) {
                periodQfilter = new QFilter("ori_period", "=", (Object)periodId);
            }
            if ("ownyearin".equals(name) || "ownyearout".equals(name)) {
                periodQfilter = new QFilter("bookeddate", ">=", (Object)this.getYearFirst(year));
                yearQfilter = new QFilter("bookeddate", "<=", (Object)enddate);
                qFilters.add(yearQfilter);
            }
        }
        if (this.oppFields().contains(name)) {
            showParameter.getCustomParams().put("ownOrg", rowData.getLong("opporg.id"));
            ownQfilter = new QFilter("org", "=", (Object)rowData.getLong("opporg.id"));
            oppQfilter = new QFilter("oporg", "=", (Object)rowData.getLong("ownorg.id"));
            cfitemQfilter = new QFilter("cashflowitem.masterid", "=", (Object)rowData.getLong("oppcfitem.id"));
            if ("oppperiodin".equals(name) || "oppperiodout".equals(name)) {
                periodQfilter = new QFilter("ori_period", "=", (Object)periodId);
            }
            if ("oppyearin".equals(name) || "oppyearout".equals(name)) {
                periodQfilter = new QFilter("bookeddate", ">=", (Object)this.getYearFirst(year));
                yearQfilter = new QFilter("bookeddate", "<=", (Object)enddate);
                qFilters.add(yearQfilter);
            }
        }
        qFilters.add(ownQfilter);
        qFilters.add(oppQfilter);
        qFilters.add(cfitemQfilter);
        qFilters.add(periodQfilter);
        showParameter.getCustomParams().put("qFilters", SerializationUtils.serializeToBase64(qFilters));
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
    }

    private List<String> linkFields() {
        return Arrays.asList("ownperiodin", "ownperiodout", "ownyearin", "ownyearout", "oppperiodin", "oppperiodout", "oppyearin", "oppyearout");
    }

    private List<String> ownFields() {
        return Arrays.asList("ownperiodin", "ownperiodout", "ownyearin", "ownyearout");
    }

    private List<String> oppFields() {
        return Arrays.asList("oppperiodin", "oppperiodout", "oppyearin", "oppyearout");
    }

    private Date getYearFirst(String year) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(1, Integer.parseInt(year));
        Date currYearFirst = calendar.getTime();
        return currYearFirst;
    }

    public void setMergeColums(List<String> columns) {
        columns.add("period");
        columns.add("currencyname");
        columns.add("tips");
        columns.add("ownorg");
        columns.add("opporg");
    }

    public void afterCreateColumn(CreateColumnEvent event) {
        super.afterCreateColumn(event);
        List columns = event.getColumns();
        for (AbstractReportColumn column : columns) {
            ReportColumn col;
            String key;
            if (!(column instanceof ReportColumn) || !(key = (col = (ReportColumn)column).getFieldKey()).equals("assgrp")) continue;
            col.setHide(true);
            if (!this.getQueryParam().getFilter().getBoolean("showassist")) continue;
            col.setHide(false);
        }
    }

    public void processRowData(String gridId, DynamicObjectCollection rowData, ReportQueryParam queryParam) {
        DynamicObject period = this.getQueryParam().getFilter().getDynamicObject("periodfield");
        String tips = ResManager.loadKDString((String)"\u5408\u8ba1", (String)"AccReconciliationFormRpt_1", (String)"fi-ict-formplugin", (Object[])new Object[0]);
        for (DynamicObject row : rowData) {
            row.set("period", (Object)period);
            if (row.getLong("rowtype") == 1L) {
                row.set("period", null);
                row.set("reconscheme", null);
                row.set("ownorg", null);
                row.set("opporg", null);
                row.set("owncfitemnumber", null);
                row.set("owncfitem", null);
                row.set("currencyname", null);
                row.set("tips", (Object)tips);
                continue;
            }
            row.set("tips", row.get("reconscheme.name"));
            row.set("currencyname", row.get("currency.name"));
            row.set("perioddiff", null);
            row.set("yeardiff", null);
        }
    }
}

