/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.report;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.IFormView;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ict.accsys.AccSysUtil;
import kd.fi.ict.util.ICTUtils;
import kd.fi.ict.util.ListFilterUtils;
import kd.fi.ict.util.PermissonType;

public class IctRptTemplatePlugin
extends AbstractReportFormPlugin
implements BeforeF7SelectListener {
    protected static String CURRENCYFIELD = "currencyfield";
    private static final String OWNORGFIELD = "ownorgfield";
    private static final String OPPORGFIELD = "opporgfield";
    private static final String PERIODFIELD = "periodfield";
    private static final String PERIODTYPE = "periodtype";

    protected static LocaleString getAllCurrency() {
        return new LocaleString(ResManager.loadKDString((String)"\u6240\u6709\u5e01\u79cd", (String)"IctRptTemplatePlugin_0", (String)"fi-ict-formplugin", (Object[])new Object[0]));
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        List orgIds = AccSysUtil.getAcctOrgPkList((String)this.getView().getEntityId(), (boolean)true, (PermissonType)PermissonType.VIEW);
        if (!orgIds.isEmpty()) {
            Long orgid = RequestContext.get().getOrgId();
            if (!orgIds.contains(orgid)) {
                orgid = (Long)orgIds.get(0);
            }
            this.getModel().setValue(OWNORGFIELD, (Object)new Object[]{orgid});
            this.setPeriodTypeDefValue(orgid);
        }
        this.initCurrency();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        BasedataEdit ownorgBase = (BasedataEdit)this.getView().getControl(OWNORGFIELD);
        ownorgBase.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit opporgBase = (BasedataEdit)this.getView().getControl(OPPORGFIELD);
        opporgBase.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit periodBase = (BasedataEdit)this.getView().getControl(PERIODFIELD);
        periodBase.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit periodtypeBase = (BasedataEdit)this.getView().getControl(PERIODTYPE);
        periodtypeBase.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        switch (key = e.getProperty().getName()) {
            case "ownorgfield": {
                ListFilterUtils.setPeriodTypeDefaultValue((IFormView)this.getView(), (String)OWNORGFIELD);
                break;
            }
            case "periodtype": {
                List<QFilter> filters = Collections.singletonList(new QFilter(PERIODTYPE, "=", this.getModel().getValue("periodtype_id")));
                List pkIds = QueryServiceHelper.queryPrimaryKeys((String)"bd_period", (QFilter[])filters.toArray(new QFilter[0]), null, (int)-1);
                DynamicObject period = (DynamicObject)this.getModel().getValue(PERIODFIELD);
                if (period != null && pkIds.contains(period.getPkValue())) {
                    this.getModel().setValue(PERIODFIELD, period.getPkValue());
                    break;
                }
                this.getModel().setValue(PERIODFIELD, null);
            }
        }
    }

    private void setPeriodTypeDefValue(long defId) {
        Set childOrgId = ICTUtils.getChildOrgId(new HashSet<Long>(Collections.singletonList(defId)), (boolean)true);
        Set periodTypeByOrgs = AccSysUtil.getPeriodTypeByOrgs((Set)childOrgId);
        if (Objects.nonNull(periodTypeByOrgs) && periodTypeByOrgs.size() > 0) {
            this.getModel().setValue(PERIODTYPE, periodTypeByOrgs.iterator().next());
        }
    }

    private void initCurrency() {
        ComboEdit currency = (ComboEdit)this.getControl(CURRENCYFIELD);
        currency.setComboItems(this.getCurrencyItems());
    }

    protected List<ComboItem> getCurrencyItems() {
        ArrayList<ComboItem> currColl = new ArrayList<ComboItem>();
        ComboItem allCur = new ComboItem();
        allCur.setValue("allcurrency");
        allCur.setCaption(IctRptTemplatePlugin.getAllCurrency());
        currColl.add(allCur);
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"bd_currency", (String)"id,name,number", null);
        for (DynamicObject obj : coll) {
            ComboItem item = new ComboItem();
            item.setValue(obj.getString("id"));
            item.setCaption(new LocaleString(obj.getString("name")));
            if ("CNY".equalsIgnoreCase(obj.getString("number"))) {
                this.getModel().setValue(CURRENCYFIELD, (Object)obj.getString("id"));
            }
            currColl.add(item);
        }
        return currColl;
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        BasedataEdit baseData = (BasedataEdit)arg0.getSource();
        ListShowParameter f7List = (ListShowParameter)arg0.getFormShowParameter();
        if (PERIODTYPE.equals(baseData.getKey())) {
            if (this.getModel().getValue(OWNORGFIELD) == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u672c\u65b9\u7ec4\u7ec7\u3002", (String)"IctRptTemplatePlugin_1", (String)"fi-ict-report", (Object[])new Object[0]));
                arg0.setCancel(true);
                return;
            }
            DynamicObjectCollection ownorgDyns = (DynamicObjectCollection)this.getModel().getValue(OWNORGFIELD);
            Set ownorg = ownorgDyns.stream().map(o -> o.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toSet());
            QFilter orgF = new QFilter("org", "in", ownorg);
            QFilter typeB = new QFilter("bookstype.accounttype", "=", (Object)"1");
            DynamicObjectCollection bookDyns = QueryServiceHelper.query((String)"gl_accountbook", (String)"id,periodtype", (QFilter[])new QFilter[]{orgF, typeB});
            Set periodTypes = bookDyns.stream().map(o -> o.getLong(PERIODTYPE)).collect(Collectors.toSet());
            ArrayList<QFilter> filters = new ArrayList<QFilter>();
            QFilter qFilter = new QFilter("id", "in", periodTypes);
            filters.add(qFilter);
            f7List.getListFilterParameter().setQFilters(filters);
        }
        if (PERIODFIELD.equals(baseData.getKey())) {
            if (this.getModel().getValue(PERIODTYPE) == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u671f\u95f4\u7c7b\u578b\u3002", (String)"IctRptTemplatePlugin_6", (String)"fi-ict-report", (Object[])new Object[0]));
                arg0.setCancel(true);
                return;
            }
            ArrayList<QFilter> filters = new ArrayList<QFilter>();
            QFilter qFilter = new QFilter(PERIODTYPE, "=", this.getModel().getValue("periodtype_id"));
            filters.add(qFilter);
            f7List.getListFilterParameter().setQFilters(filters);
            DynamicObject period = (DynamicObject)this.getModel().getValue(PERIODFIELD);
            if (period != null) {
                f7List.setSelectedRow(period.getPkValue());
            }
        }
        if (OWNORGFIELD.equals(baseData.getKey())) {
            List orgList = AccSysUtil.getAcctOrgPkList((String)this.getView().getEntityId(), (boolean)true, (PermissonType)PermissonType.VIEW);
            f7List.getListFilterParameter().getQFilters().add(new QFilter("id", "in", (Object)orgList));
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        super.verifyQuery(queryParam);
        FilterInfo filterInfo = queryParam.getFilter();
        DynamicObjectCollection org = filterInfo.getDynamicObjectCollection(OWNORGFIELD);
        if (null == org) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u672c\u65b9\u7ec4\u7ec7\u3002", (String)"IctRptTemplatePlugin_1", (String)"fi-ict-report", (Object[])new Object[0]));
            return false;
        }
        DynamicObject periodtype = filterInfo.getDynamicObject(PERIODTYPE);
        if (null == periodtype) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u671f\u95f4\u7c7b\u578b\u3002", (String)"IctRptTemplatePlugin_6", (String)"fi-ict-report", (Object[])new Object[0]));
            return false;
        }
        DynamicObject period = filterInfo.getDynamicObject(PERIODFIELD);
        if (null == period) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u671f\u95f4\u3002", (String)"IctRptTemplatePlugin_3", (String)"fi-ict-report", (Object[])new Object[0]));
            return false;
        }
        DynamicObjectCollection reconscheme = filterInfo.getDynamicObjectCollection("reconschemefield");
        if (null == reconscheme) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5bf9\u8d26\u65b9\u6848\u3002", (String)"IctRptTemplatePlugin_4", (String)"fi-ict-report", (Object[])new Object[0]));
            return false;
        }
        String currency = filterInfo.getString("currencyfield");
        if (null == currency) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5e01\u79cd\u3002", (String)"IctRptTemplatePlugin_5", (String)"fi-ict-report", (Object[])new Object[0]));
            return false;
        }
        return true;
    }
}

