/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.upgradeservice;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class CfCheckRecordUpgradeService
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(CfCheckRecordUpgradeService.class);

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try {
            logger.info("CfCheckRecordUpgradeService upgrade begin");
            this.cfCheckRecordUpdate();
            result.setSuccess(true);
        }
        catch (Exception e) {
            logger.error("CfCheckRecordUpgradeService error: " + e.getMessage(), (Throwable)e);
            result.setSuccess(false);
        }
        logger.info("CfCheckRecordUpgradeService upgrade end");
        return result;
    }

    public void cfCheckRecordUpdate() {
        DB.query((DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)this.getBatchExecSql(), rs -> {
            HashMap<Long, Integer> amtprecisionMap = new HashMap<Long, Integer>();
            ArrayList<Object[]> cRecordInfoList = new ArrayList<Object[]>(1000);
            while (rs.next()) {
                Long entryId = rs.getLong("fentryid");
                BigDecimal amt = rs.getBigDecimal("famt");
                BigDecimal amtverify = rs.getBigDecimal("famtverify");
                BigDecimal convertamt = rs.getBigDecimal("fconvertamt");
                BigDecimal convertamtverify = BigDecimal.ZERO;
                if (BigDecimal.ZERO.compareTo(amtverify) == 0 || BigDecimal.ZERO.compareTo(amt) == 0) continue;
                Long concurrencyid = rs.getLong("fconcurrencyid");
                Integer amtprecision = (Integer)amtprecisionMap.get(concurrencyid);
                if (amtprecision == null) {
                    DynamicObject concurrency = BusinessDataServiceHelper.loadSingleFromCache((Object)concurrencyid, (String)"bd_currency", (String)"amtprecision");
                    amtprecision = concurrency == null ? 10 : concurrency.getInt("amtprecision");
                    amtprecisionMap.put(concurrencyid, amtprecision);
                }
                convertamtverify = amt.compareTo(amtverify) == 0 ? convertamt : convertamt.multiply(amtverify.divide(amt, 10, RoundingMode.HALF_UP)).setScale((int)amtprecision, RoundingMode.HALF_UP);
                Object[] upCRecord = new Object[]{convertamtverify, entryId};
                cRecordInfoList.add(upCRecord);
                if (cRecordInfoList.size() < 1000) continue;
                String sql = "update t_ict_cf_cross_entry set fconvertamtverify = ? where FEntryID = ? ";
                DB.executeBatch((DBRoute)DBRoute.of((String)"fi"), (String)sql, cRecordInfoList);
                cRecordInfoList.clear();
            }
            if (cRecordInfoList.size() > 0) {
                String sql = "update t_ict_cf_cross_entry set fconvertamtverify = ? where FEntryID = ? ";
                DB.executeBatch((DBRoute)DBRoute.of((String)"fi"), (String)sql, cRecordInfoList);
            }
            return true;
        });
    }

    private SqlBuilder getBatchExecSql() {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select fentryid,famt,famtverify,fconvertamt,fconvertamtverify,fconcurrencyid from t_ict_cf_cross_entry", new Object[0]);
        sqlBuilder.append(" where fconvertamtverify = 0 ", new Object[0]);
        return sqlBuilder;
    }
}

