/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.upgradeservice;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ict.enums.OperationType;
import kd.fi.ict.pullcheck.IPuchAmtLog;
import kd.fi.ict.pullcheck.PuchLogFactory;
import org.apache.commons.lang3.time.StopWatch;

public class PuchAmtUpgradeService
implements IUpgradeService {
    private static final Log LOGGER = LogFactory.getLog(PuchAmtUpgradeService.class);
    private static final String acctSelectField = "id,voucherentry,voucherid,account,assgrp,amtbal,amtballoc,amt,amtloc,currency,currencyloc,period,org,booktype,accounttable,oporg,status,createtime,lastupdatetime,dc,commonassgrp,relevancetype,baldc,isnextperiod,bookeddate,isinitrecord,ori_period,bizdate,edescription,sourcetype,sourcesys,localrate,vouchertype,vchcreator,billstatus";
    private static final String cfSelectField = "id,voucherentry,voucherid,cashflowitem,assgrp,amtbal,amt,currency,period,org,booktype,accounttable,oporg,status,createtime,lastupdatetime,dc,commonassgrp,relevancetype,baldc,isnextperiod,bookeddate,isinitrecord,ori_period,bizdate,edescription,sourcesys,sourcetype,vouchertype,vchcreator,billstatus";

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try {
            StopWatch sw = new StopWatch();
            sw.start();
            this.batchPuchAmtUpgrade("ict_relacctrecord");
            LOGGER.info("ICT-PuchAmtUpgradeService time:{}", (Object)sw.getTime());
            sw.reset();
            this.batchPuchAmtUpgrade("ict_relcfrecord");
            LOGGER.info("ICT-PuchAmtUpgradeService time:{}", (Object)sw.getTime());
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
        }
        return result;
    }

    private void batchPuchAmtUpgrade(String formKey) {
        DataSet ds = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)formKey, (String)"id", null, (String)"period asc");
        ArrayList<Long> idList = new ArrayList<Long>(16);
        while (ds.hasNext()) {
            idList.add(ds.next().getLong("id"));
            if (idList.size() % 1000 != 0 && ds.hasNext()) continue;
            this.batchExecute(formKey, idList);
        }
    }

    private void batchExecute(String formKey, List<Long> idList) {
        try (TXHandle handle = TX.requiresNew((String)formKey);){
            try {
                HashSet<Long> idsSet = new HashSet<Long>(idList);
                this.removeUpgradedId(formKey, idsSet, OperationType.PULLDATA);
                QFilter filter = new QFilter("id", "in", idsSet);
                String selectStr = "ict_relacctrecord".equals(formKey) ? acctSelectField : cfSelectField;
                DataSet batchDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)formKey, (String)selectStr, (QFilter[])filter.toArray(), (String)"period asc");
                DynamicObject[] dynArrays = (DynamicObject[])ORM.create().toPlainDynamicObjectCollection(batchDs).toArray((Object[])new DynamicObject[0]);
                this.puchAmtUpgrade(formKey, dynArrays);
                idList.clear();
            }
            catch (Exception e) {
                handle.markRollback();
                throw e;
            }
        }
    }

    private void puchAmtUpgrade(String formKey, DynamicObject[] dynArrays) {
        IPuchAmtLog acctRecord = PuchLogFactory.getPuchLog((String)formKey);
        acctRecord.setAddLog(dynArrays, OperationType.PULLDATA);
        Set<Long> idSet = Arrays.stream(dynArrays).map(v -> v.getLong("id")).collect(Collectors.toSet());
        this.removeUpgradedId(formKey, idSet, OperationType.MANUALCHECK);
        QFilter filter = new QFilter("entryentity.relrecordid", "in", idSet);
        String checkFormKey = formKey.equals("ict_relacctrecord") ? "ict_check_record" : "ict_check_cash_record";
        DataSet batchDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)checkFormKey, (String)"id", (QFilter[])filter.toArray(), (String)"period asc");
        DynamicObject[] checkArrays = (DynamicObject[])ORM.create().toPlainDynamicObjectCollection(batchDs).toArray((Object[])new DynamicObject[0]);
        acctRecord.setAddCheckLog(checkArrays, OperationType.MANUALCHECK);
    }

    private String getLogFormKey(String formKey) {
        return formKey.equals("ict_relacctrecord") ? "ict_acctpuchamt_log" : "ict_cfpuchamt_log";
    }

    private void removeUpgradedId(String formKey, Set<Long> idsSet, OperationType operationType) {
        QFilter filterLog = new QFilter("record", "in", idsSet).and(new QFilter("operation", "=", (Object)operationType));
        DataSet logDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)this.getLogFormKey(formKey), (String)"record", (QFilter[])filterLog.toArray(), null);
        HashSet<Long> removeIds = new HashSet<Long>(16);
        while (logDs.hasNext()) {
            removeIds.add(logDs.next().getLong("record"));
        }
        idsSet.removeAll(removeIds);
    }
}

