/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.upgradeservice;

import java.util.ArrayList;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;

public class VerifySchemeUpgradeService
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(VerifySchemeUpgradeService.class);
    private String SELECT_SQL = "select fid,faccounttableid from t_ict_verifyscheme;";
    private String UPDATE_SQL = "update t_ict_verifydimentry set faccounttableid = ? where fid = ? and faccounttableid = 0;";

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try {
            logger.info("VerifySchemeUpgradeService upgrade begin");
            this.updateEntry();
            result.setSuccess(true);
        }
        catch (Exception e) {
            logger.error("VerifySchemeUpgradeService error: " + e.getMessage(), (Throwable)e);
            result.setSuccess(false);
        }
        logger.info("VerifySchemeUpgradeService upgrade end");
        return result;
    }

    private void updateEntry() {
        ArrayList verifySchemes = new ArrayList(10);
        DB.query((DBRoute)DBRoute.of((String)"gl"), (String)this.SELECT_SQL, rs -> {
            while (rs.next()) {
                verifySchemes.add(new Object[]{rs.getLong("faccounttableid"), rs.getLong("fid")});
            }
            return true;
        });
        if (verifySchemes.size() > 0) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"gl"), (String)this.UPDATE_SQL, verifySchemes);
        }
    }
}

