/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.report;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.FilterFunction;
import kd.bos.algo.MapFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ict.util.ICTUtils;

public class AccReconciliationQryRpt
extends AbstractReportListDataPlugin {
    private static final String PERIOD = "period";
    private static final String OPPPERIOD = "oppperiod";
    private static final String RECONSCHEME = "reconscheme";
    private static final String OPPRECONSCHEME = "oppreconscheme";
    private static final String CURRENCY = "currency";
    private static final String OPPCURRENCY = "oppcurrency";
    private static final String OWNORG = "ownorg";
    private static final String OPPORG = "opporg";
    private static final String OWNACCOUNT = "ownaccount";
    private static final String OPPACCOUNT = "oppaccount";
    private static final String PENDFOR = "pendfor";
    private static final String PDEBITFOR = "pdebitfor";
    private static final String PCREDITFOR = "pcreditfor";
    private static final String PYEARDEBITFOR = "pyeardebitfor";
    private static final String PYEARCREDITFOR = "pyearcreditfor";
    private static final String OWNPERIODDIFF = "ownperioddiff";
    private static final String OWNYEARDIFF = "ownyeardiff";
    private static final String OPPDEBITFOR = "oppdebitfor";
    private static final String OPPCREDITFOR = "oppcreditfor";
    private static final String OPPYEARDEBITFOR = "oppyeardebitfor";
    private static final String OPPYEARCREDITFOR = "oppyearcreditfor";
    private static final String OPPPERIODDIFF = "oppperioddiff";
    private static final String OPPYEARDIFF = "oppyeardiff";
    private static final String PERIODDIFF = "perioddiff";
    private static final String YEARDIFF = "yeardiff";
    private static final String ROWTYPE = "rowtype";

    public DataSet query(ReportQueryParam queryParam, Object o) {
        DataSet oppData;
        DataSet ownData;
        ArrayList<QFilter> commonFilters = new ArrayList<QFilter>(5);
        this.initCommonFilter(commonFilters);
        ArrayList<QFilter> ownOrgFilters = new ArrayList<QFilter>(2);
        ownOrgFilters.addAll(commonFilters);
        this.addOrgFilter(ownOrgFilters, true);
        ArrayList<QFilter> oppOrgFilters = new ArrayList<QFilter>(2);
        oppOrgFilters.addAll(commonFilters);
        this.addOrgFilter(oppOrgFilters, false);
        FilterInfo filterInfo = this.getQueryParam().getFilter();
        String amountType = filterInfo.getString("amounttype");
        if ("balance".equals(amountType)) {
            ownData = this.getRowsForBalance(ownOrgFilters);
            oppData = this.getRowsForBalance(oppOrgFilters);
        } else {
            ownData = this.getRows(ownOrgFilters);
            oppData = this.getRows(oppOrgFilters);
        }
        DataSet dataSet = this.getCompleteRows(ownData, oppData);
        DataSet setTotal = this.getTotalRows(dataSet);
        dataSet = dataSet.union(setTotal).orderBy(new String[]{RECONSCHEME, CURRENCY, OWNORG, OPPORG, "rowtype desc"});
        boolean noShowZero = filterInfo.getBoolean("noshowzero");
        if (noShowZero) {
            dataSet = this.filterNoDiffRows(dataSet);
        }
        return dataSet.addField(OWNACCOUNT, "ownaccountnumber").addField(OPPACCOUNT, "oppaccountnumber").orderBy(new String[]{RECONSCHEME, CURRENCY, OWNORG, OPPORG, ROWTYPE});
    }

    private DataSet filterNoDiffRows(DataSet dataSet) {
        final HashSet zeroData = new HashSet();
        dataSet = dataSet.filter(new FilterFunction(){

            public boolean test(Row row) {
                String groupKey = row.getLong(AccReconciliationQryRpt.RECONSCHEME) + "_" + row.getLong(AccReconciliationQryRpt.CURRENCY) + "_" + row.getLong(AccReconciliationQryRpt.OWNORG) + "_" + row.getLong(AccReconciliationQryRpt.OPPORG);
                Long rowType = row.getLong(AccReconciliationQryRpt.ROWTYPE);
                if (rowType == 1L) {
                    BigDecimal periodDiff = row.getBigDecimal(AccReconciliationQryRpt.PERIODDIFF);
                    if (null == periodDiff || periodDiff.compareTo(BigDecimal.ZERO) == 0) {
                        zeroData.add(groupKey);
                        return false;
                    }
                } else {
                    return !zeroData.contains(groupKey);
                }
                return true;
            }
        });
        return dataSet;
    }

    private DataSet getTotalRows(DataSet dataSet) {
        return dataSet.copy().groupBy(new String[]{RECONSCHEME, CURRENCY, OWNORG, OPPORG}).sum(PDEBITFOR).sum(PCREDITFOR).sum(PYEARDEBITFOR).sum(PYEARCREDITFOR).sum(OWNPERIODDIFF).sum(OWNYEARDIFF).sum(OPPDEBITFOR).sum(OPPCREDITFOR).sum(OPPYEARDEBITFOR).sum(OPPYEARCREDITFOR).sum(OPPPERIODDIFF).sum(OPPYEARDIFF).sum(PERIODDIFF).sum(YEARDIFF).finish().addField("0", OWNACCOUNT).addField("0", OPPACCOUNT).addField("1", ROWTYPE).select("reconscheme,currency,pdebitfor,pcreditfor,pyeardebitfor,pyearcreditfor,ownperioddiff,ownyeardiff,ownorg,opporg,ownaccount,oppaccount,oppdebitfor,oppcreditfor,oppyeardebitfor,oppyearcreditfor,oppperioddiff,oppyeardiff,perioddiff,yeardiff,rowtype");
    }

    private DataSet getCompleteRows(DataSet ownData, DataSet oppData) {
        DataSet dataSet = ownData.fullJoin(oppData).on(RECONSCHEME, RECONSCHEME).on(CURRENCY, CURRENCY).on("org", "oporg").on("oporg", "org").on("seq", "seq").select(new String[]{RECONSCHEME, CURRENCY, PDEBITFOR, PCREDITFOR, PYEARDEBITFOR, PYEARCREDITFOR, "org ownorg", "oporg opporg", "account ownaccount", "perioddiff ownperioddiff", "yeardiff ownyeardiff"}, new String[]{"account oppaccount", "pdebitfor oppdebitfor", "pcreditfor oppcreditfor", "pyeardebitfor oppyeardebitfor", "pyearcreditfor oppyearcreditfor", "perioddiff oppperioddiff", "yeardiff oppyeardiff", "reconscheme oppreconscheme", "currency oppcurrency", "org rightownorg", "oporg rightopporg"}).finish().addField("ownperioddiff+oppperioddiff", PERIODDIFF).addField("ownyeardiff+oppyeardiff", YEARDIFF).addField("0", ROWTYPE);
        dataSet = dataSet.map(new MapFunction(){

            public Object[] map(Row row) {
                Long ownorg = row.getLong(AccReconciliationQryRpt.OWNORG) == null ? row.getLong("rightopporg") : row.getLong(AccReconciliationQryRpt.OWNORG);
                Long opporg = row.getLong(AccReconciliationQryRpt.OPPORG) == null ? row.getLong("rightownorg") : row.getLong(AccReconciliationQryRpt.OPPORG);
                Long reconscheme = row.getLong(AccReconciliationQryRpt.RECONSCHEME) == null ? row.getLong(AccReconciliationQryRpt.OPPRECONSCHEME) : row.getLong(AccReconciliationQryRpt.RECONSCHEME);
                Long currency = row.getLong(AccReconciliationQryRpt.CURRENCY) == null ? row.getLong(AccReconciliationQryRpt.OPPCURRENCY) : row.getLong(AccReconciliationQryRpt.CURRENCY);
                return new Object[]{reconscheme, currency, row.getBigDecimal(AccReconciliationQryRpt.PDEBITFOR), row.getBigDecimal(AccReconciliationQryRpt.PCREDITFOR), row.getBigDecimal(AccReconciliationQryRpt.PYEARDEBITFOR), row.getBigDecimal(AccReconciliationQryRpt.PYEARCREDITFOR), row.getBigDecimal(AccReconciliationQryRpt.OWNPERIODDIFF), row.getBigDecimal(AccReconciliationQryRpt.OWNYEARDIFF), ownorg, opporg, row.getLong(AccReconciliationQryRpt.OWNACCOUNT), row.getLong(AccReconciliationQryRpt.OPPACCOUNT), row.getBigDecimal(AccReconciliationQryRpt.OPPDEBITFOR), row.getBigDecimal(AccReconciliationQryRpt.OPPCREDITFOR), row.getBigDecimal(AccReconciliationQryRpt.OPPYEARDEBITFOR), row.getBigDecimal(AccReconciliationQryRpt.OPPYEARCREDITFOR), row.getBigDecimal(AccReconciliationQryRpt.OPPPERIODDIFF), row.getBigDecimal(AccReconciliationQryRpt.OPPYEARDIFF), row.getBigDecimal(AccReconciliationQryRpt.PERIODDIFF), row.getBigDecimal(AccReconciliationQryRpt.YEARDIFF), row.getLong(AccReconciliationQryRpt.ROWTYPE)};
            }

            public RowMeta getResultRowMeta() {
                return new RowMeta(new Field[]{new Field(AccReconciliationQryRpt.RECONSCHEME, (DataType)DataType.LongType), new Field(AccReconciliationQryRpt.CURRENCY, (DataType)DataType.LongType), new Field(AccReconciliationQryRpt.PDEBITFOR, (DataType)DataType.BigDecimalType), new Field(AccReconciliationQryRpt.PCREDITFOR, (DataType)DataType.BigDecimalType), new Field(AccReconciliationQryRpt.PYEARDEBITFOR, (DataType)DataType.BigDecimalType), new Field(AccReconciliationQryRpt.PYEARCREDITFOR, (DataType)DataType.BigDecimalType), new Field(AccReconciliationQryRpt.OWNPERIODDIFF, (DataType)DataType.BigDecimalType), new Field(AccReconciliationQryRpt.OWNYEARDIFF, (DataType)DataType.BigDecimalType), new Field(AccReconciliationQryRpt.OWNORG, (DataType)DataType.LongType), new Field(AccReconciliationQryRpt.OPPORG, (DataType)DataType.LongType), new Field(AccReconciliationQryRpt.OWNACCOUNT, (DataType)DataType.LongType), new Field(AccReconciliationQryRpt.OPPACCOUNT, (DataType)DataType.LongType), new Field(AccReconciliationQryRpt.OPPDEBITFOR, (DataType)DataType.BigDecimalType), new Field(AccReconciliationQryRpt.OPPCREDITFOR, (DataType)DataType.BigDecimalType), new Field(AccReconciliationQryRpt.OPPYEARDEBITFOR, (DataType)DataType.BigDecimalType), new Field(AccReconciliationQryRpt.OPPYEARCREDITFOR, (DataType)DataType.BigDecimalType), new Field(AccReconciliationQryRpt.OPPPERIODDIFF, (DataType)DataType.BigDecimalType), new Field(AccReconciliationQryRpt.OPPYEARDIFF, (DataType)DataType.BigDecimalType), new Field(AccReconciliationQryRpt.PERIODDIFF, (DataType)DataType.BigDecimalType), new Field(AccReconciliationQryRpt.YEARDIFF, (DataType)DataType.BigDecimalType), new Field(AccReconciliationQryRpt.ROWTYPE, (DataType)DataType.LongType)});
            }
        });
        return dataSet;
    }

    private DataSet getRows(List<QFilter> filters) {
        String selectFields = "reconscheme,currency,org,oporg,account,pdebitfor,pcreditfor,pyeardebitfor,pyearcreditfor,assgrp";
        DataSet rows = QueryServiceHelper.queryDataSet((String)AccReconciliationQryRpt.class.getName(), (String)"ict_acctpuchamt", (String)selectFields, (QFilter[])filters.toArray(new QFilter[0]), null).groupBy(new String[]{RECONSCHEME, CURRENCY, "org", "oporg", "account"}).sum(PDEBITFOR).sum(PCREDITFOR).sum(PYEARDEBITFOR).sum(PYEARCREDITFOR).finish().addField("pdebitfor-pcreditfor", PERIODDIFF).addField("pyeardebitfor-pyearcreditfor", YEARDIFF);
        final HashMap seqMap = new HashMap(10);
        rows = rows.map(new MapFunction(){

            public Object[] map(Row row) {
                String groupKey = row.getLong(AccReconciliationQryRpt.RECONSCHEME) + "_" + row.getLong(AccReconciliationQryRpt.CURRENCY) + "_" + row.getLong("org") + "_" + row.getLong("oporg");
                Long seq = (Long)seqMap.get(groupKey);
                seq = null == seq ? Long.valueOf(1L) : Long.valueOf(seq + 1L);
                seqMap.put(groupKey, seq);
                return new Object[]{row.getLong(AccReconciliationQryRpt.RECONSCHEME), row.getLong(AccReconciliationQryRpt.CURRENCY), row.getBigDecimal(AccReconciliationQryRpt.PDEBITFOR), row.getBigDecimal(AccReconciliationQryRpt.PCREDITFOR), row.getBigDecimal(AccReconciliationQryRpt.PYEARDEBITFOR), row.getBigDecimal(AccReconciliationQryRpt.PYEARCREDITFOR), row.getBigDecimal(AccReconciliationQryRpt.PERIODDIFF), row.getBigDecimal(AccReconciliationQryRpt.YEARDIFF), row.getLong("org"), row.getLong("oporg"), row.getLong("account"), seq};
            }

            public RowMeta getResultRowMeta() {
                return new RowMeta(new Field[]{new Field(AccReconciliationQryRpt.RECONSCHEME, (DataType)DataType.LongType), new Field(AccReconciliationQryRpt.CURRENCY, (DataType)DataType.LongType), new Field(AccReconciliationQryRpt.PDEBITFOR, (DataType)DataType.BigDecimalType), new Field(AccReconciliationQryRpt.PCREDITFOR, (DataType)DataType.BigDecimalType), new Field(AccReconciliationQryRpt.PYEARDEBITFOR, (DataType)DataType.BigDecimalType), new Field(AccReconciliationQryRpt.PYEARCREDITFOR, (DataType)DataType.BigDecimalType), new Field(AccReconciliationQryRpt.PERIODDIFF, (DataType)DataType.BigDecimalType), new Field(AccReconciliationQryRpt.YEARDIFF, (DataType)DataType.BigDecimalType), new Field("org", (DataType)DataType.LongType), new Field("oporg", (DataType)DataType.LongType), new Field("account", (DataType)DataType.LongType), new Field("seq", (DataType)DataType.LongType)});
            }
        });
        return rows;
    }

    private DataSet getRowsForBalance(List<QFilter> filters) {
        String selectFields = "reconscheme,currency,org,oporg,account,pendfor,assgrp";
        DataSet rows = QueryServiceHelper.queryDataSet((String)AccReconciliationQryRpt.class.getName(), (String)"ict_acctpuchamt", (String)selectFields, (QFilter[])filters.toArray(new QFilter[0]), null).groupBy(new String[]{RECONSCHEME, CURRENCY, "org", "oporg", "account"}).sum(PENDFOR).finish().addField("0", PDEBITFOR).addField("0", PCREDITFOR).addField("0", PYEARDEBITFOR).addField("0", PYEARCREDITFOR).addField("0", PERIODDIFF).addField("0", YEARDIFF);
        final HashMap seqMap = new HashMap(10);
        rows = rows.map(new MapFunction(){

            public Object[] map(Row row) {
                BigDecimal pdebitfor = BigDecimal.ZERO;
                BigDecimal pcreditfor = BigDecimal.ZERO;
                BigDecimal pendFor = row.getBigDecimal(AccReconciliationQryRpt.PENDFOR);
                if (pendFor.compareTo(BigDecimal.ZERO) > 0) {
                    pdebitfor = pendFor;
                } else {
                    pcreditfor = pendFor.abs();
                }
                String groupKey = row.getLong(AccReconciliationQryRpt.RECONSCHEME) + "_" + row.getLong(AccReconciliationQryRpt.CURRENCY) + "_" + row.getLong("org") + "_" + row.getLong("oporg");
                Long seq = (Long)seqMap.get(groupKey);
                seq = null == seq ? Long.valueOf(1L) : Long.valueOf(seq + 1L);
                seqMap.put(groupKey, seq);
                return new Object[]{row.getLong(AccReconciliationQryRpt.RECONSCHEME), row.getLong(AccReconciliationQryRpt.CURRENCY), pdebitfor, pcreditfor, row.getBigDecimal(AccReconciliationQryRpt.PYEARDEBITFOR), row.getBigDecimal(AccReconciliationQryRpt.PYEARCREDITFOR), pendFor, row.getBigDecimal(AccReconciliationQryRpt.YEARDIFF), row.getLong("org"), row.getLong("oporg"), row.getLong("account"), seq};
            }

            public RowMeta getResultRowMeta() {
                return new RowMeta(new Field[]{new Field(AccReconciliationQryRpt.RECONSCHEME, (DataType)DataType.LongType), new Field(AccReconciliationQryRpt.CURRENCY, (DataType)DataType.LongType), new Field(AccReconciliationQryRpt.PDEBITFOR, (DataType)DataType.BigDecimalType), new Field(AccReconciliationQryRpt.PCREDITFOR, (DataType)DataType.BigDecimalType), new Field(AccReconciliationQryRpt.PYEARDEBITFOR, (DataType)DataType.BigDecimalType), new Field(AccReconciliationQryRpt.PYEARCREDITFOR, (DataType)DataType.BigDecimalType), new Field(AccReconciliationQryRpt.PERIODDIFF, (DataType)DataType.BigDecimalType), new Field(AccReconciliationQryRpt.YEARDIFF, (DataType)DataType.BigDecimalType), new Field("org", (DataType)DataType.LongType), new Field("oporg", (DataType)DataType.LongType), new Field("account", (DataType)DataType.LongType), new Field("seq", (DataType)DataType.LongType)});
            }
        });
        return rows;
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) {
        FilterInfo filterInfo = this.getQueryParam().getFilter();
        String amountType = filterInfo.getString("amounttype");
        if ("balance".equals(amountType)) {
            block10: for (AbstractReportColumn column : columns) {
                String fieldKey;
                if (column instanceof ReportColumn) {
                    fieldKey = ((ReportColumn)column).getFieldKey();
                    if (PERIODDIFF.equals(fieldKey)) {
                        column.setCaption(new LocaleString(ResManager.loadKDString((String)"\u5dee\u5f02", (String)"AccReconciliationQryRpt_1", (String)"fi-ict-report", (Object[])new Object[0])));
                        continue;
                    }
                    if (!YEARDIFF.equals(fieldKey)) continue;
                    ((ReportColumn)column).setHide(true);
                    continue;
                }
                if (!(column instanceof ReportColumnGroup)) continue;
                switch (fieldKey = ((ReportColumnGroup)column).getFieldKey()) {
                    case "ownperiodamount": 
                    case "oppperiodamount": {
                        column.setCaption(new LocaleString(ResManager.loadKDString((String)"\u62bd\u53d6\u91d1\u989d", (String)"AccReconciliationQryRpt_0", (String)"fi-ict-report", (Object[])new Object[0])));
                        break;
                    }
                    case "ownyearamount": 
                    case "oppyearamount": {
                        List childList = ((ReportColumnGroup)column).getChildren();
                        for (AbstractReportColumn child : childList) {
                            if (!(child instanceof ReportColumn)) continue;
                            ((ReportColumn)child).setHide(true);
                        }
                        continue block10;
                    }
                }
            }
        }
        return columns;
    }

    private void addOrgFilter(List<QFilter> filters, boolean isOwnOrg) {
        FilterInfo filterInfo = this.getQueryParam().getFilter();
        DynamicObjectCollection ownOrgField = filterInfo.getDynamicObjectCollection("ownorgfield");
        DynamicObjectCollection oppOrgField = filterInfo.getDynamicObjectCollection("opporgfield");
        if (isOwnOrg) {
            if (null != ownOrgField) {
                filters.add(new QFilter("org", "in", this.getChildOrgByOrg(ownOrgField)));
            }
            if (null != oppOrgField) {
                filters.add(new QFilter("oporg", "in", this.getChildOrgByOrg(oppOrgField)));
            }
        } else {
            if (null != ownOrgField) {
                filters.add(new QFilter("oporg", "in", this.getChildOrgByOrg(ownOrgField)));
            }
            if (null != oppOrgField) {
                filters.add(new QFilter("org", "in", this.getChildOrgByOrg(oppOrgField)));
            }
        }
    }

    private void initCommonFilter(List<QFilter> filters) {
        String currency;
        DynamicObjectCollection reconScheme;
        FilterInfo filterInfo = this.getQueryParam().getFilter();
        DynamicObject period = filterInfo.getDynamicObject("periodfield");
        String amountType = filterInfo.getString("amounttype");
        if (null != period) {
            if ("amount".equals(amountType)) {
                filters.add(new QFilter(PERIOD, "=", (Object)period.getLong("id")));
            } else {
                filters.add(new QFilter(PERIOD, "<=", (Object)period.getLong("id")));
                filters.add(new QFilter("endperiod", ">", (Object)period.getLong("id")));
            }
        }
        if (null != (reconScheme = filterInfo.getDynamicObjectCollection("reconschemefield"))) {
            filters.add(new QFilter(RECONSCHEME, "in", this.getIdsOfObjects(reconScheme)));
        }
        if (!"allcurrency".equals(currency = filterInfo.getString("currencyfield"))) {
            filters.add(new QFilter(CURRENCY, "=", (Object)Long.parseLong(currency)));
        }
    }

    private List<Long> getIdsOfObjects(DynamicObjectCollection objList) {
        return objList.stream().map(t -> t.getLong("id")).collect(Collectors.toList());
    }

    private Set<Long> getChildOrgByOrg(DynamicObjectCollection objList) {
        Set orgIds = objList.stream().map(t -> t.getLong("id")).collect(Collectors.toSet());
        return ICTUtils.getChildOrgId(orgIds, (boolean)true);
    }
}

