/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.report;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bd.util.BatchProcessUtil;
import kd.fi.bd.util.DebugTrace;
import kd.fi.ict.accsys.AccSysUtil;
import kd.fi.ict.enums.CheckStatus;
import kd.fi.ict.enums.TransactionType;
import kd.fi.ict.util.ICTUtils;
import kd.fi.ict.util.PeriodUtil;

public class AutoReconciliationQryRptPlugin
extends AbstractReportListDataPlugin {
    private Log LOGGER = LogFactory.getLog((String)AutoReconciliationQryRptPlugin.class.getName());
    private FilterInfo filterInfo;
    private String transactiontype;
    Set<Long> orgIds;
    Map<Long, List<Long>> orgMap;
    Set<Long> opOrgIds;
    Set<Long> allOrgIds = new HashSet<Long>(16);
    QFilter schemaFilter;
    private static final String recordFields = "org,oporg,currency,reconscheme,amtbal,dc";
    private static final String recordCfFields = "org,oporg,concurrency as currency,reconscheme,convertamtbal as amtbal,dc";
    private static final String[] reportFiles = new String[]{"org", "oporg", "currency", "scheme"};
    private static final String[] groupByFields = new String[]{"org", "oporg", "currency", "reconscheme"};
    private static final String[] groupOpByFields = new String[]{"oporg", "org", "currency", "reconscheme"};
    private static final String[] hisCurFields = new String[]{"org", "oporg", "currency", "reconscheme scheme", "amtbal his_c_amtbal", "his_op_amtbal"};
    private static final String[] hisCurOppFields = new String[]{"oporg", "org", "currency", "reconscheme scheme", "his_c_amtbal", "amtbal his_op_amtbal"};
    private static final String[] thisCurFields = new String[]{"org", "oporg", "currency", "reconscheme scheme", "amtbal cur_c_amtbal", "cur_op_amtbal"};
    private static final String[] thisOppFields = new String[]{"oporg", "org", "currency", "reconscheme scheme", "cur_c_amtbal", "amtbal cur_op_amtbal"};
    private static final String[] sumFields = new String[]{"org", "oporg", "currency", "scheme", "his_c_amtbal", "his_op_amtbal", "cur_c_amtbal", "cur_op_amtbal"};
    private static final String[] sumGroupFields = new String[]{"org ownorg", "oporg opporg", "currency", "scheme", "his_op_amtbal preoppamt", "his_c_amtbal preownamt", "cur_c_amtbal ownamt", "cur_op_amtbal oppamt"};
    private static final String[] sumReportFields = new String[]{"his_c_amtbal", "his_op_amtbal", "cur_c_amtbal", "cur_op_amtbal"};
    private static final String[] hisSumFields = new String[]{"his_c_amtbal", "his_op_amtbal"};
    private static final String[] curSumFields = new String[]{"cur_c_amtbal", "cur_op_amtbal"};

    public DataSet query(ReportQueryParam queryParam, Object o) {
        FilterInfo filterInfo = queryParam.getFilter();
        DynamicObjectCollection collect = filterInfo.getDynamicObjectCollection("reconscheme");
        this.transactiontype = ((DynamicObject)collect.get(0)).getString("transactiontype");
        List<QFilter> commonFilters = this.initCommonFilters(queryParam);
        StringBuilder orgid = new StringBuilder("0,");
        for (Long orgId : this.orgIds) {
            orgid.append(orgId.toString()).append(",");
        }
        String orgId = orgid.substring(0, orgid.length() - 1);
        StringBuilder oporgid = new StringBuilder("0,");
        for (Long opOrgid : this.opOrgIds) {
            oporgid.append(opOrgid.toString()).append(",");
        }
        String oporgId = oporgid.substring(0, oporgid.length() - 1);
        DynamicObject period = PeriodUtil.getCurrentPeriod((Object)filterInfo.getLong("period"));
        Set mainBookOrgs = AccSysUtil.getOrgsByPeriodType(new HashSet<Long>(this.allOrgIds), (Long)period.getLong("periodtype.id"));
        DataSet hisResultSet = BatchProcessUtil.batchQueryDataSet((Collection)mainBookOrgs, batchData -> {
            ArrayList<QFilter> filterList = new ArrayList<QFilter>(commonFilters);
            filterList.add(new QFilter("org", "in", batchData));
            return this.queryPreRecordSet(filterList);
        });
        DataSet thisHisResultSet = ICTUtils.gainSumSet((DataSet)hisResultSet, (String[])groupByFields, (String[])new String[]{"amtbal"}).filter("org in (" + orgId + ")");
        thisHisResultSet = thisHisResultSet.addField("0", "his_op_amtbal").select(hisCurFields);
        DataSet oppHisResultSet = ICTUtils.gainSumSet((DataSet)hisResultSet, (String[])groupOpByFields, (String[])new String[]{"amtbal"}).filter("org in (" + oporgId + ")");
        oppHisResultSet = oppHisResultSet.addField("0", "his_c_amtbal").select(hisCurOppFields);
        DataSet hisResult = ICTUtils.gainSumSet((DataSet)thisHisResultSet.union(oppHisResultSet), (String[])reportFiles, (String[])hisSumFields);
        DataSet currResultSet = BatchProcessUtil.batchQueryDataSet((Collection)mainBookOrgs, batchData -> {
            ArrayList<QFilter> filterList = new ArrayList<QFilter>(commonFilters);
            filterList.add(new QFilter("org", "in", batchData));
            return this.queryCurrRecordSet(filterList);
        });
        DataSet thisResultSet = ICTUtils.gainSumSet((DataSet)currResultSet, (String[])groupByFields, (String[])new String[]{"amtbal"}).filter("org in (" + orgId + ")");
        thisResultSet = thisResultSet.addField("0", "cur_op_amtbal").select(thisCurFields);
        DataSet oppResultSet = ICTUtils.gainSumSet((DataSet)currResultSet, (String[])groupOpByFields, (String[])new String[]{"amtbal"}).filter("org in (" + oporgId + ")");
        oppResultSet = oppResultSet.addField("0", "cur_c_amtbal").select(thisOppFields);
        DataSet currentResult = ICTUtils.gainSumSet((DataSet)thisResultSet.union(oppResultSet), (String[])reportFiles, (String[])curSumFields);
        hisResult = hisResult.addField("0", "cur_c_amtbal").addField("0", "cur_op_amtbal").select(sumFields);
        currentResult = currentResult.addField("0", "his_c_amtbal").addField("0", "his_op_amtbal").select(sumFields);
        String filterStr = "org in (" + orgId + ")";
        if (this.opOrgIds.size() > 0) {
            filterStr = filterStr + " and oporg in (" + oporgId + ")";
        }
        DataSet resultSet = ICTUtils.gainSumSet((DataSet)hisResult.union(currentResult), (String[])reportFiles, (String[])sumReportFields).filter(filterStr).select(sumGroupFields).addField("preownamt+ownamt", "sumownamt").addField("preoppamt+oppamt", "sumoppamt").addField("case when sumownamt+sumoppamt ==0 then 1 else 2 end", "reconresult").filter("ownorg <> opporg");
        if (filterInfo.getBoolean("nointernalrecon")) {
            StringBuilder sqlSplicing = new StringBuilder();
            String sqlPart = "(ownorg = %s and opporg not in (%s))";
            this.orgMap.forEach((k, v) -> {
                String join = String.join((CharSequence)",", v.stream().map(String::valueOf).collect(Collectors.toList()));
                sqlSplicing.append(String.format(sqlPart, k, join)).append(" or ");
            });
            String sqlFilter = sqlSplicing.substring(0, sqlSplicing.length() - 3);
            return resultSet.filter(sqlFilter);
        }
        return resultSet;
    }

    private List<QFilter> initCommonFilters(ReportQueryParam queryParam) {
        this.filterInfo = queryParam.getFilter();
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        List<Long> schemasList = this.getSchemas(this.filterInfo.getDynamicObjectCollection("reconscheme"));
        this.schemaFilter = new QFilter("reconscheme", "in", schemasList);
        DynamicObject accountBookType = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_accountbookstype", (String)"id", (QFilter[])new QFilter("accounttype", "=", (Object)"1").toArray());
        QFilter bookTypeFilter = new QFilter("booktype", "=", (Object)accountBookType.getLong("id"));
        filters.add(bookTypeFilter);
        QFilter statusFilter = new QFilter("status", "in", (Object)new String[]{CheckStatus.NONE.getValue(), CheckStatus.PART_CHECK.getValue()});
        filters.add(statusFilter);
        this.orgIds = this.getChildOrgByOrg(this.getOrgIds(this.filterInfo.getDynamicObjectCollection("org"), schemasList));
        this.opOrgIds = this.getChildOrgByOrg(this.getOrgIds(this.filterInfo.getDynamicObjectCollection("oporg"), schemasList));
        this.allOrgIds.addAll(this.orgIds);
        this.allOrgIds.addAll(this.opOrgIds);
        this.LOGGER.info("- AutoReconciliationQryRptPlugin - allOrgIds : {}", this.allOrgIds);
        DynamicObjectCollection orgDynColl = this.filterInfo.getDynamicObjectCollection("org");
        orgDynColl.sort(Comparator.comparing(v -> v.getLong("id")));
        this.orgMap = new HashMap<Long, List<Long>>(orgDynColl.size());
        orgDynColl.forEach(v -> {
            long orgId = v.getLong("id");
            Set<Long> childOrgByOrg = this.getChildOrgByOrg(Collections.singleton(orgId));
            childOrgByOrg.retainAll(this.allOrgIds);
            childOrgByOrg.forEach(x -> {
                ArrayList<Long> vaules = new ArrayList<Long>(childOrgByOrg);
                vaules.remove(x);
                if (vaules.size() == 0) {
                    vaules.add(0L);
                }
                if (Objects.isNull(this.orgMap.get(x)) || this.orgMap.get(x).size() > 0 && this.orgMap.get(x).get(0) == 0L) {
                    this.orgMap.put((Long)x, (List<Long>)vaules);
                }
            });
        });
        DebugTrace.action(() -> this.LOGGER.info("- AutoReconciliationQryRptPlugin - orgMap : {}", this.orgMap));
        DynamicObject period = PeriodUtil.getCurrentPeriod((Object)this.filterInfo.getLong("period"));
        Set mainBookOrgs = AccSysUtil.getOrgsByPeriodType(new HashSet<Long>(this.allOrgIds), (Long)period.getLong("periodtype.id"));
        filters.add(new QFilter("oporg", "in", (Object)mainBookOrgs));
        filters.add(new QFilter("billstatus", "in", (Object)new String[]{"A", "B"}));
        filters.add(this.schemaFilter);
        this.LOGGER.info("- AutoReconciliationQryRptPlugin - filters : {}", filters);
        return filters;
    }

    private Set<Long> getChildOrgByOrg(Set<Long> orgIds) {
        return new HashSet<Long>(ICTUtils.getChildOrgId(new HashSet<Long>(orgIds), (boolean)true));
    }

    private Set<Long> getOrgIds(DynamicObjectCollection orgs, List<Long> schemasList) {
        HashSet<Long> orglist = new HashSet<Long>(16);
        if (orgs == null || orgs.size() == 0) {
            if (this.orgIds.size() > 0 && schemasList.size() > 0) {
                String tableName = TransactionType.CASH_FLOW.getTransactionType().equals(this.transactiontype) ? "t_ict_relcfrecord" : "t_ict_relacctrecord";
                String orgIdsStr = this.orgIds.toString().substring(1, this.orgIds.toString().length() - 1);
                String schemasIdsStr = schemasList.toString().substring(1, schemasList.toString().length() - 1);
                String sqlStr = "select distinct forgid,foporgid from " + tableName + " where (forgid in (" + String.join((CharSequence)",", orgIdsStr) + ") or foporgid in (" + String.join((CharSequence)",", orgIdsStr) + ")) and fschemeid in (" + String.join((CharSequence)",", schemasIdsStr) + ") and fstatus in ('0', '1')";
                DB.query((DBRoute)DBRoute.of((String)"fi"), (String)sqlStr, oppOrgSet -> {
                    while (oppOrgSet.next()) {
                        orglist.add(oppOrgSet.getLong("forgid"));
                        orglist.add(oppOrgSet.getLong("foporgid"));
                    }
                    return null;
                });
            }
            if (orglist.size() == 0) {
                orglist.add(0L);
            }
        } else {
            orgs.stream().forEach(o -> orglist.add(o.getLong("id")));
        }
        return orglist;
    }

    private List<Long> getSchemas(DynamicObjectCollection schemas) {
        ArrayList<Long> schemaList = new ArrayList<Long>(5);
        schemas.stream().forEach(o -> schemaList.add(o.getLong("masterid")));
        return schemaList;
    }

    private DataSet queryPreRecordSet(List<QFilter> commonFilters) {
        return this.queryRecordSet(commonFilters, "<");
    }

    private DataSet queryCurrRecordSet(List<QFilter> commonFilters) {
        return this.queryRecordSet(commonFilters, "=");
    }

    private DataSet queryRecordSet(List<QFilter> commonFilters, String qcp) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(commonFilters);
        Long periodId = this.filterInfo.getLong("period");
        QFilter periodFilter = new QFilter("period", qcp, (Object)periodId);
        filters.add(periodFilter);
        String entityName = TransactionType.CASH_FLOW.getTransactionType().equals(this.transactiontype) ? "ict_relcfrecord" : "ict_relacctrecord";
        DataSet record = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)entityName, (String)this.getRecordFields(entityName), (QFilter[])filters.toArray(new QFilter[0]), null);
        record = record.select(new String[]{"org", "oporg", "currency", "reconscheme", "case when amtbal < 0 then amtbal * -1 else amtbal end as amtbal"});
        return record;
    }

    private String getRecordFields(String entityName) {
        if (entityName.equals("ict_relacctrecord")) {
            return recordFields;
        }
        return recordCfFields;
    }

    private Set<Long> getReconOrg() {
        String tableName = TransactionType.CASH_FLOW.getTransactionType().equals(this.transactiontype) ? "t_ict_relcfrecord" : "t_ict_relacctrecord";
        StringBuilder sqlStr = new StringBuilder("select distinct forgid,foporgid from ").append(tableName).append(" where  fstatus in ('0', '1')");
        HashSet<Long> orgAlls = new HashSet<Long>(16);
        DB.query((DBRoute)DBRoute.of((String)"fi"), (String)String.valueOf(sqlStr), oppOrgSet -> {
            while (oppOrgSet.next()) {
                orgAlls.add(oppOrgSet.getLong("forgid"));
                orgAlls.add(oppOrgSet.getLong("foporgid"));
            }
            return null;
        });
        return orgAlls;
    }
}

