/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.report;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.FilterFunction;
import kd.bos.algo.MapFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ict.util.ICTUtils;

public class CfitemQryRpt
extends AbstractReportListDataPlugin {
    private static final String OWNORGFIELD = "ownorgfield";
    private static final String OPPORGFIELD = "opporgfield";
    private static final String PERIODFIELD = "periodfield";
    private static final String RECONSCHEMEFIELD = "reconschemefield";
    private static final String CURRENCYFIELD = "currencyfield";
    private static final String ICT_CFPUCHAMT = "ict_cfpuchamt";
    private static final String OWNORG = "ownorg";
    private static final String OPPORG = "opporg";
    private static final String PERIOD = "period";
    private static final String CURRENCY = "currency";
    private static final String RECONSCHEME = "reconscheme";
    private static final String PERIODDIFF = "perioddiff";
    private static final String YEARDIFF = "yeardiff";
    private static final String SEQ = "seq";
    private static final String OWNPERIODIN = "ownperiodin";
    private static final String OWNPERIODOUT = "ownperiodout";
    private static final String OWNYEARIN = "ownyearin";
    private static final String OWNYEAROUT = "ownyearout";
    private static final String OPPPERIODIN = "oppperiodin";
    private static final String OPPPERIODOUT = "oppperiodout";
    private static final String OPPYEARIN = "oppyearin";
    private static final String OPPYEAROUT = "oppyearout";
    private static final String ROWTYPE = "rowtype";

    public DataSet query(ReportQueryParam param, Object obj) throws Throwable {
        DataSet voucherDataset = this.queryData(param);
        return voucherDataset;
    }

    public DataSet queryData(ReportQueryParam param) {
        FilterInfo filterInfo = param.getFilter();
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(6);
        DynamicObjectCollection ownorgDyns = filterInfo.getDynamicObjectCollection(OWNORGFIELD);
        DynamicObjectCollection opporgDyns = filterInfo.getDynamicObjectCollection(OPPORGFIELD);
        DynamicObjectCollection reconschemeDyns = filterInfo.getDynamicObjectCollection(RECONSCHEMEFIELD);
        Set ownorg = ownorgDyns.stream().map(o -> o.getLong("id")).collect(Collectors.toSet());
        Set ownorgfield = ICTUtils.getChildOrgId(ownorg, (boolean)true);
        List reconschemefield = reconschemeDyns.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
        long periodfield = filterInfo.getLong(PERIODFIELD);
        boolean noshowzero = filterInfo.getBoolean("noshowzero");
        QFilter periodFilter = new QFilter(PERIOD, "<=", (Object)periodfield);
        QFilter periodendFilter = new QFilter("endperiod", ">", (Object)periodfield);
        QFilter ownorgFilter = new QFilter("org", "in", (Object)ownorgfield);
        QFilter schemeFilter = new QFilter(RECONSCHEME, "in", reconschemefield);
        qFilters.add(periodFilter);
        qFilters.add(periodendFilter);
        qFilters.add(schemeFilter);
        qFilters.add(ownorgFilter);
        QFilter oporgFilter = null;
        Set opporgfield = null;
        if (opporgDyns != null) {
            Set opporg = opporgDyns.stream().map(o -> o.getLong("id")).collect(Collectors.toSet());
            opporgfield = ICTUtils.getChildOrgId(opporg, (boolean)true);
            oporgFilter = new QFilter("oporg", "in", (Object)opporgfield);
            qFilters.add(oporgFilter);
        }
        if (!"allcurrency".equals(filterInfo.getString(CURRENCYFIELD))) {
            long currencyfield = filterInfo.getLong(CURRENCYFIELD);
            QFilter curFilter = new QFilter(CURRENCY, "=", (Object)currencyfield);
            qFilters.add(curFilter);
        }
        DataSet owndataset = this.bulidDataSet(qFilters);
        qFilters.remove(ownorgFilter);
        if (opporgDyns != null) {
            qFilters.remove(oporgFilter);
            QFilter ownorgFilter1 = new QFilter("org", "in", (Object)opporgfield);
            qFilters.add(ownorgFilter1);
        }
        QFilter oporgFilter1 = new QFilter("oporg", "in", (Object)ownorgfield);
        qFilters.add(oporgFilter1);
        DataSet oppdataset = this.bulidDataSet(qFilters);
        DataSet dataSet = this.getJoinRows(owndataset, oppdataset);
        final String filteryear = filterInfo.getDynamicObject(PERIODFIELD).getString("periodyear");
        dataSet = this.filterPeriodData(dataSet, periodfield).filter(new FilterFunction(){

            public boolean test(Row row) {
                String year = row.getString(CfitemQryRpt.PERIOD);
                return year.contains(filteryear);
            }
        });
        dataSet = dataSet.groupBy(new String[]{RECONSCHEME, CURRENCY, OWNORG, OPPORG, "owncfitemnumber", "owncfitem", "oppcfitemnumber", "oppcfitem"}).sum(OWNPERIODIN).sum(OWNPERIODOUT).sum(OWNYEARIN).sum(OWNYEAROUT).sum(OPPPERIODIN).sum(OPPPERIODOUT).sum(OPPYEARIN).sum(OPPYEAROUT).finish().addField("0", "assgrp").addField("0", PERIODDIFF).addField("0", YEARDIFF).addField("0", ROWTYPE).select("currency,assgrp,reconscheme,ownorg,opporg,owncfitemnumber,owncfitem,ownperiodin,ownperiodout,ownyearin,ownyearout,oppcfitemnumber,oppcfitem,oppperiodin,oppperiodout,oppyearin,oppyearout,rowtype,perioddiff,yeardiff");
        DataSet totalRows = this.getTotalRows(dataSet);
        dataSet = dataSet.union(totalRows).orderBy(new String[]{RECONSCHEME, CURRENCY, OWNORG, OPPORG, "rowtype desc"});
        if (noshowzero) {
            dataSet = this.filterNoDiffRows(dataSet);
        }
        return dataSet.orderBy(new String[]{RECONSCHEME, CURRENCY, OWNORG, OPPORG, ROWTYPE});
    }

    private DataSet filterPeriodData(DataSet dataSet, final long periodfield) {
        dataSet = dataSet.map(new MapFunction(){

            public Object[] map(Row row) {
                Boolean isSelectPeriod = row.getLong(CfitemQryRpt.PERIOD) == periodfield;
                BigDecimal ownperiodin = isSelectPeriod != false ? row.getBigDecimal(CfitemQryRpt.OWNPERIODIN) : BigDecimal.ZERO;
                BigDecimal ownperiodout = isSelectPeriod != false ? row.getBigDecimal(CfitemQryRpt.OWNPERIODOUT) : BigDecimal.ZERO;
                BigDecimal oppperiodin = isSelectPeriod != false ? row.getBigDecimal(CfitemQryRpt.OPPPERIODIN) : BigDecimal.ZERO;
                BigDecimal oppperiodout = isSelectPeriod != false ? row.getBigDecimal(CfitemQryRpt.OPPPERIODOUT) : BigDecimal.ZERO;
                return new Object[]{row.getLong(CfitemQryRpt.PERIOD), row.getLong(CfitemQryRpt.CURRENCY), row.getLong("assgrp"), row.getLong(CfitemQryRpt.RECONSCHEME), row.getLong(CfitemQryRpt.OWNORG), row.getLong(CfitemQryRpt.OPPORG), row.getLong("owncfitemnumber"), row.getLong("owncfitem"), ownperiodin, ownperiodout, row.getBigDecimal(CfitemQryRpt.OWNYEARIN), row.getBigDecimal(CfitemQryRpt.OWNYEAROUT), row.getLong("oppcfitemnumber"), row.getLong("oppcfitem"), oppperiodin, oppperiodout, row.getBigDecimal(CfitemQryRpt.OPPYEARIN), row.getBigDecimal(CfitemQryRpt.OPPYEAROUT), row.getLong(CfitemQryRpt.ROWTYPE), row.getBigDecimal(CfitemQryRpt.PERIODDIFF), row.getBigDecimal(CfitemQryRpt.YEARDIFF)};
            }

            public RowMeta getResultRowMeta() {
                return new RowMeta(new Field[]{new Field(CfitemQryRpt.PERIOD, (DataType)DataType.LongType), new Field(CfitemQryRpt.CURRENCY, (DataType)DataType.LongType), new Field("assgrp", (DataType)DataType.LongType), new Field(CfitemQryRpt.RECONSCHEME, (DataType)DataType.LongType), new Field(CfitemQryRpt.OWNORG, (DataType)DataType.LongType), new Field(CfitemQryRpt.OPPORG, (DataType)DataType.LongType), new Field("owncfitemnumber", (DataType)DataType.LongType), new Field("owncfitem", (DataType)DataType.LongType), new Field(CfitemQryRpt.OWNPERIODIN, (DataType)DataType.BigDecimalType), new Field(CfitemQryRpt.OWNPERIODOUT, (DataType)DataType.BigDecimalType), new Field(CfitemQryRpt.OWNYEARIN, (DataType)DataType.BigDecimalType), new Field(CfitemQryRpt.OWNYEAROUT, (DataType)DataType.BigDecimalType), new Field("oppcfitemnumber", (DataType)DataType.LongType), new Field("oppcfitem", (DataType)DataType.LongType), new Field(CfitemQryRpt.OPPPERIODIN, (DataType)DataType.BigDecimalType), new Field(CfitemQryRpt.OPPPERIODOUT, (DataType)DataType.BigDecimalType), new Field(CfitemQryRpt.OPPYEARIN, (DataType)DataType.BigDecimalType), new Field(CfitemQryRpt.OPPYEAROUT, (DataType)DataType.BigDecimalType), new Field(CfitemQryRpt.ROWTYPE, (DataType)DataType.LongType), new Field(CfitemQryRpt.PERIODDIFF, (DataType)DataType.BigDecimalType), new Field(CfitemQryRpt.YEARDIFF, (DataType)DataType.BigDecimalType)});
            }
        });
        return dataSet;
    }

    private DataSet bulidDataSet(List<QFilter> qFilters) {
        String selectfield = "period, reconscheme, currency, assgrp,org ownorg, oporg opporg, cfitem, cfitem.direction direction,pamount, pyearamount";
        DataSet dataset = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)ICT_CFPUCHAMT, (String)selectfield, (QFilter[])qFilters.toArray(new QFilter[0]), null).groupBy(new String[]{OWNORG, OPPORG, PERIOD, RECONSCHEME, CURRENCY, "cfitem", "direction"}).sum("assgrp").sum("pamount").sum("pyearamount").finish();
        final HashMap seqMap = new HashMap(16);
        dataset = dataset.map(new MapFunction(){

            public Object[] map(Row row) {
                String key = row.getLong(CfitemQryRpt.OWNORG) + "_" + row.getLong(CfitemQryRpt.OPPORG) + "_" + row.getLong(CfitemQryRpt.PERIOD) + "_" + row.getLong(CfitemQryRpt.RECONSCHEME) + "_" + row.getLong(CfitemQryRpt.CURRENCY);
                Long seq = (Long)seqMap.get(key);
                seq = null == seq ? Long.valueOf(1L) : Long.valueOf(seq + 1L);
                seqMap.put(key, seq);
                return new Object[]{row.getLong(CfitemQryRpt.PERIOD), row.getLong(CfitemQryRpt.RECONSCHEME), row.getLong(CfitemQryRpt.CURRENCY), row.getLong("assgrp"), row.getLong(CfitemQryRpt.OWNORG), row.getLong(CfitemQryRpt.OPPORG), row.getLong("cfitem"), row.getString("direction"), row.getBigDecimal("pamount"), row.getBigDecimal("pyearamount"), seq};
            }

            public RowMeta getResultRowMeta() {
                return new RowMeta(new Field[]{new Field(CfitemQryRpt.PERIOD, (DataType)DataType.LongType), new Field(CfitemQryRpt.RECONSCHEME, (DataType)DataType.LongType), new Field(CfitemQryRpt.CURRENCY, (DataType)DataType.LongType), new Field("assgrp", (DataType)DataType.LongType), new Field(CfitemQryRpt.OWNORG, (DataType)DataType.LongType), new Field(CfitemQryRpt.OPPORG, (DataType)DataType.LongType), new Field("cfitem", (DataType)DataType.LongType), new Field("direction", (DataType)DataType.StringType), new Field("pamount", (DataType)DataType.BigDecimalType), new Field("pyearamount", (DataType)DataType.BigDecimalType), new Field(CfitemQryRpt.SEQ, (DataType)DataType.LongType)});
            }
        });
        return dataset;
    }

    private DataSet getTotalRows(DataSet dataSet) {
        DataSet dataSetCopy = dataSet.copy().groupBy(new String[]{RECONSCHEME, CURRENCY, OWNORG, OPPORG}).sum(OWNPERIODIN).sum(OWNPERIODOUT).sum(OWNYEARIN).sum(OWNYEAROUT).sum(OPPPERIODIN).sum(OPPPERIODOUT).sum(OPPYEARIN).sum(OPPYEAROUT).finish().addField("0", "assgrp").addField("0", "owncfitemnumber").addField("0", "owncfitem").addField("0", "oppcfitemnumber").addField("0", "oppcfitem").addField("1", ROWTYPE).select("currency,assgrp,reconscheme,ownorg,opporg,owncfitemnumber,owncfitem,ownperiodin,ownperiodout,ownyearin,ownyearout,oppcfitemnumber,oppcfitem,oppperiodin,oppperiodout,oppyearin,oppyearout,rowtype");
        dataSetCopy = dataSetCopy.map(new MapFunction(){

            public Object[] map(Row row) {
                BigDecimal ownperiodin = row.getBigDecimal(CfitemQryRpt.OWNPERIODIN) == null ? BigDecimal.ZERO : row.getBigDecimal(CfitemQryRpt.OWNPERIODIN);
                BigDecimal ownperiodout = row.getBigDecimal(CfitemQryRpt.OWNPERIODOUT) == null ? BigDecimal.ZERO : row.getBigDecimal(CfitemQryRpt.OWNPERIODOUT);
                BigDecimal oppperiodin = row.getBigDecimal(CfitemQryRpt.OPPPERIODIN) == null ? BigDecimal.ZERO : row.getBigDecimal(CfitemQryRpt.OPPPERIODIN);
                BigDecimal oppperiodout = row.getBigDecimal(CfitemQryRpt.OPPPERIODOUT) == null ? BigDecimal.ZERO : row.getBigDecimal(CfitemQryRpt.OPPPERIODOUT);
                BigDecimal ownyearin = row.getBigDecimal(CfitemQryRpt.OWNYEARIN) == null ? BigDecimal.ZERO : row.getBigDecimal(CfitemQryRpt.OWNYEARIN);
                BigDecimal ownyearout = row.getBigDecimal(CfitemQryRpt.OWNYEAROUT) == null ? BigDecimal.ZERO : row.getBigDecimal(CfitemQryRpt.OWNYEAROUT);
                BigDecimal oppyearin = row.getBigDecimal(CfitemQryRpt.OPPYEARIN) == null ? BigDecimal.ZERO : row.getBigDecimal(CfitemQryRpt.OPPYEARIN);
                BigDecimal oppyearout = row.getBigDecimal(CfitemQryRpt.OPPYEAROUT) == null ? BigDecimal.ZERO : row.getBigDecimal(CfitemQryRpt.OPPYEAROUT);
                BigDecimal perioddiff = ownperiodin.subtract(ownperiodout).add(oppperiodin.subtract(oppperiodout));
                BigDecimal yeardiff = ownyearin.subtract(ownyearout).add(oppyearin.subtract(oppyearout));
                return new Object[]{row.getLong(CfitemQryRpt.CURRENCY), row.getLong("assgrp"), row.getLong(CfitemQryRpt.RECONSCHEME), row.getLong(CfitemQryRpt.OWNORG), row.getLong(CfitemQryRpt.OPPORG), row.getLong("owncfitemnumber"), row.getLong("owncfitem"), row.getBigDecimal(CfitemQryRpt.OWNPERIODIN), row.getBigDecimal(CfitemQryRpt.OWNPERIODOUT), row.getBigDecimal(CfitemQryRpt.OWNYEARIN), row.getBigDecimal(CfitemQryRpt.OWNYEAROUT), row.getLong("oppcfitemnumber"), row.getLong("oppcfitem"), row.getBigDecimal(CfitemQryRpt.OPPPERIODIN), row.getBigDecimal(CfitemQryRpt.OPPPERIODOUT), row.getBigDecimal(CfitemQryRpt.OPPYEARIN), row.getBigDecimal(CfitemQryRpt.OPPYEAROUT), row.getLong(CfitemQryRpt.ROWTYPE), perioddiff, yeardiff};
            }

            public RowMeta getResultRowMeta() {
                return new RowMeta(new Field[]{new Field(CfitemQryRpt.CURRENCY, (DataType)DataType.LongType), new Field("assgrp", (DataType)DataType.LongType), new Field(CfitemQryRpt.RECONSCHEME, (DataType)DataType.LongType), new Field(CfitemQryRpt.OWNORG, (DataType)DataType.LongType), new Field(CfitemQryRpt.OPPORG, (DataType)DataType.LongType), new Field("owncfitemnumber", (DataType)DataType.LongType), new Field("owncfitem", (DataType)DataType.LongType), new Field(CfitemQryRpt.OWNPERIODIN, (DataType)DataType.BigDecimalType), new Field(CfitemQryRpt.OWNPERIODOUT, (DataType)DataType.BigDecimalType), new Field(CfitemQryRpt.OWNYEARIN, (DataType)DataType.BigDecimalType), new Field(CfitemQryRpt.OWNYEAROUT, (DataType)DataType.BigDecimalType), new Field("oppcfitemnumber", (DataType)DataType.LongType), new Field("oppcfitem", (DataType)DataType.LongType), new Field(CfitemQryRpt.OPPPERIODIN, (DataType)DataType.BigDecimalType), new Field(CfitemQryRpt.OPPPERIODOUT, (DataType)DataType.BigDecimalType), new Field(CfitemQryRpt.OPPYEARIN, (DataType)DataType.BigDecimalType), new Field(CfitemQryRpt.OPPYEAROUT, (DataType)DataType.BigDecimalType), new Field(CfitemQryRpt.ROWTYPE, (DataType)DataType.LongType), new Field(CfitemQryRpt.PERIODDIFF, (DataType)DataType.BigDecimalType), new Field(CfitemQryRpt.YEARDIFF, (DataType)DataType.BigDecimalType)});
            }
        });
        return dataSetCopy;
    }

    private DataSet filterNoDiffRows(DataSet dataSet) {
        final HashSet zeroData = new HashSet();
        dataSet = dataSet.filter(new FilterFunction(){

            public boolean test(Row row) {
                String groupKey = row.getLong(CfitemQryRpt.RECONSCHEME) + "_" + row.getLong(CfitemQryRpt.CURRENCY) + "_" + row.getLong(CfitemQryRpt.OWNORG) + "_" + row.getLong(CfitemQryRpt.OPPORG);
                Long rowType = row.getLong(CfitemQryRpt.ROWTYPE);
                if (rowType == 1L) {
                    BigDecimal periodDiff = row.getBigDecimal(CfitemQryRpt.PERIODDIFF);
                    if (null == periodDiff || periodDiff.compareTo(BigDecimal.ZERO) == 0) {
                        zeroData.add(groupKey);
                        return false;
                    }
                } else {
                    return !zeroData.contains(groupKey);
                }
                return true;
            }
        });
        return dataSet;
    }

    private DataSet getJoinRows(DataSet ownData, DataSet oppData) {
        DataSet dataSet = ownData.fullJoin(oppData).on(OWNORG, OPPORG).on(OPPORG, OWNORG).on(RECONSCHEME, RECONSCHEME).on(PERIOD, PERIOD).on(CURRENCY, CURRENCY).on(SEQ, SEQ).select(new String[]{PERIOD, CURRENCY, "assgrp", RECONSCHEME, OWNORG, OPPORG, "cfitem owncfitemnumber", "cfitem owncfitem", "case when direction = 'i' then pamount else 0 end ownperiodin", "case when direction = 'o' then pamount else 0 end ownperiodout", "case when direction = 'i' then pyearamount else 0 end ownyearin", "case when direction = 'o' then pyearamount else 0 end ownyearout"}, new String[]{"cfitem oppcfitemnumber", "cfitem oppcfitem", "reconscheme rightreconscheme", "period rightperiod", "case when direction = 'i' then pamount else 0 end oppperiodin", "case when direction = 'o' then pamount else 0 end oppperiodout", "case when direction = 'i' then pyearamount else 0 end oppyearin", "case when direction = 'o' then pyearamount else 0 end oppyearout", "currency rightcurrency", "ownorg rightownorg", "opporg rightopporg"}).finish().addField("0", ROWTYPE).addField("0", PERIODDIFF).addField("0", YEARDIFF);
        dataSet = dataSet.map(new MapFunction(){

            public Object[] map(Row row) {
                Long ownorg = row.getLong(CfitemQryRpt.OWNORG) == null ? row.getLong("rightopporg") : row.getLong(CfitemQryRpt.OWNORG);
                Long opporg = row.getLong(CfitemQryRpt.OPPORG) == null ? row.getLong("rightownorg") : row.getLong(CfitemQryRpt.OPPORG);
                Long period = row.getLong(CfitemQryRpt.PERIOD) == null ? row.getLong("rightperiod") : row.getLong(CfitemQryRpt.PERIOD);
                Long reconscheme = row.getLong(CfitemQryRpt.RECONSCHEME) == null ? row.getLong("rightreconscheme") : row.getLong(CfitemQryRpt.RECONSCHEME);
                Long currency = row.getLong(CfitemQryRpt.CURRENCY) == null ? row.getLong("rightcurrency") : row.getLong(CfitemQryRpt.CURRENCY);
                return new Object[]{period, currency, row.getBigDecimal("assgrp"), reconscheme, ownorg, opporg, row.getLong("owncfitemnumber"), row.getLong("owncfitem"), row.getBigDecimal(CfitemQryRpt.OWNPERIODIN), row.getBigDecimal(CfitemQryRpt.OWNPERIODOUT), row.getBigDecimal(CfitemQryRpt.OWNYEARIN), row.getBigDecimal(CfitemQryRpt.OWNYEAROUT), row.getLong("oppcfitemnumber"), row.getLong("oppcfitem"), row.getBigDecimal(CfitemQryRpt.OPPPERIODIN), row.getBigDecimal(CfitemQryRpt.OPPPERIODOUT), row.getBigDecimal(CfitemQryRpt.OPPYEARIN), row.getBigDecimal(CfitemQryRpt.OPPYEAROUT), row.getBigDecimal(CfitemQryRpt.PERIODDIFF), row.getBigDecimal(CfitemQryRpt.YEARDIFF), row.getLong(CfitemQryRpt.ROWTYPE)};
            }

            public RowMeta getResultRowMeta() {
                return new RowMeta(new Field[]{new Field(CfitemQryRpt.PERIOD, (DataType)DataType.LongType), new Field(CfitemQryRpt.CURRENCY, (DataType)DataType.LongType), new Field("assgrp", (DataType)DataType.LongType), new Field(CfitemQryRpt.RECONSCHEME, (DataType)DataType.LongType), new Field(CfitemQryRpt.OWNORG, (DataType)DataType.LongType), new Field(CfitemQryRpt.OPPORG, (DataType)DataType.LongType), new Field("owncfitemnumber", (DataType)DataType.LongType), new Field("owncfitem", (DataType)DataType.LongType), new Field(CfitemQryRpt.OWNPERIODIN, (DataType)DataType.BigDecimalType), new Field(CfitemQryRpt.OWNPERIODOUT, (DataType)DataType.BigDecimalType), new Field(CfitemQryRpt.OWNYEARIN, (DataType)DataType.BigDecimalType), new Field(CfitemQryRpt.OWNYEAROUT, (DataType)DataType.BigDecimalType), new Field("oppcfitemnumber", (DataType)DataType.LongType), new Field("oppcfitem", (DataType)DataType.LongType), new Field(CfitemQryRpt.OPPPERIODIN, (DataType)DataType.BigDecimalType), new Field(CfitemQryRpt.OPPPERIODOUT, (DataType)DataType.BigDecimalType), new Field(CfitemQryRpt.OPPYEARIN, (DataType)DataType.BigDecimalType), new Field(CfitemQryRpt.OPPYEAROUT, (DataType)DataType.BigDecimalType), new Field(CfitemQryRpt.ROWTYPE, (DataType)DataType.LongType), new Field(CfitemQryRpt.PERIODDIFF, (DataType)DataType.BigDecimalType), new Field(CfitemQryRpt.YEARDIFF, (DataType)DataType.BigDecimalType)});
            }
        });
        return dataSet;
    }
}

