/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.iep.upgradeservice;

import java.util.Arrays;
import kd.bos.context.RequestContextCreator;
import kd.bos.ext.permission.mservice.PermissionUpgradeServiceImpl;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;

public class IntellPermission2UpgradeService
implements IUpgradeService {
    private static final ThreadPool threadPool = ThreadPools.newFixedThreadPool((String)IntellPermission2UpgradeService.class.getName(), (int)3);
    private static final String IEP = "3815fd11000209ac";
    private static final String PERM_VIEW = "47150e89000000ac";
    private static final String PERM_DELETE = "4715e1f1000000ac";
    private static final String PERM_REEXECUTE = "19VRZ=MPVBD5";

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try {
            threadPool.submit(() -> {
                PermissionUpgradeServiceImpl permissionUpgradeService = new PermissionUpgradeServiceImpl();
                this.addPermission(permissionUpgradeService, PERM_VIEW, "gl_intellexecdetaillog", "iep_intellexecdetaillog", PERM_VIEW);
                this.addPermission(permissionUpgradeService, PERM_DELETE, "gl_intellexecdetaillog", "iep_intellexecdetaillog", PERM_DELETE);
                this.addPermission(permissionUpgradeService, PERM_REEXECUTE, "gl_intellexecdetaillog", "iep_intellexecdetaillog", PERM_REEXECUTE);
                return Boolean.TRUE;
            }, RequestContextCreator.createForThreadPool());
        }
        catch (Exception e) {
            result.setErrorInfo(e.getMessage());
            result.setLog(e.getMessage());
        }
        return result;
    }

    private void addPermission(PermissionUpgradeServiceImpl permissionUpgradeService, String existPermItemID, String existEntityTypeID, String newEntityTypeID, String ... newPermItemIds) {
        if (newPermItemIds == null || newPermItemIds.length == 0) {
            return;
        }
        permissionUpgradeService.addPermItemsByExistPermItem(existPermItemID, existEntityTypeID, IEP, newEntityTypeID, IEP, Arrays.asList(newPermItemIds));
    }
}

