/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.iep.upgradeservice;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class SchJobRunConcurrentUpgradeService
implements IUpgradeService {
    private static final String SCHEMA_ENTITY = "gl_intellexecschema";
    private static final String SCHEDULE_ENTITY = "sch_schedule";
    private static final String JOB_ENTITY = "sch_job";

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setSuccess(true);
        try {
            this.doUpgrade();
        }
        catch (Exception e) {
            result.setSuccess(false);
            String traceMessage = this.getStackTraceMessage(e);
            result.setErrorInfo(traceMessage);
            result.setLog(traceMessage);
        }
        return result;
    }

    public void doUpgrade() {
        DynamicObject[] upgradeData = this.getUpgradeData();
        if (upgradeData != null && upgradeData.length > 0) {
            this.upgrade(upgradeData);
        }
    }

    private DynamicObject[] getUpgradeData() {
        List<Object> scheduleIds = this.getAllScheduleId();
        return this.getAllSchJobDyn(scheduleIds);
    }

    private List<Object> getAllScheduleId() {
        String selectField = "sheduleplanid";
        DynamicObjectCollection schdules = QueryServiceHelper.query((String)SCHEMA_ENTITY, (String)selectField, null);
        if (schdules != null) {
            ArrayList<Object> scheduleIds = new ArrayList<Object>(schdules.size());
            for (DynamicObject dyo : schdules) {
                if (dyo.get("sheduleplanid") == null) continue;
                scheduleIds.add(dyo.get("sheduleplanid"));
            }
            return scheduleIds;
        }
        return new ArrayList<Object>(0);
    }

    private List<Object> getAllSchJobId(List<Object> scheduleIds) {
        String selectField = "job";
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "in", scheduleIds)};
        DynamicObjectCollection jobs = QueryServiceHelper.query((String)SCHEDULE_ENTITY, (String)selectField, (QFilter[])qFilters);
        if (jobs != null) {
            ArrayList<Object> jobIds = new ArrayList<Object>(jobs.size());
            for (DynamicObject dyo : jobs) {
                if (dyo.get("job") == null) continue;
                jobIds.add(dyo.get("job"));
            }
            return jobIds;
        }
        return new ArrayList<Object>(0);
    }

    private DynamicObject[] getAllSchJobDyn(List<Object> scheduleIds) {
        List<Object> schJobIds;
        if (!scheduleIds.isEmpty() && !(schJobIds = this.getAllSchJobId(scheduleIds)).isEmpty()) {
            String selectField = "runconcurrent,strategy";
            QFilter[] qFilters = new QFilter[]{new QFilter("id", "in", schJobIds)};
            return BusinessDataServiceHelper.load((String)JOB_ENTITY, (String)selectField, (QFilter[])qFilters);
        }
        return null;
    }

    private void upgrade(DynamicObject[] upgradeData) {
        if (upgradeData == null || upgradeData.length == 0) {
            return;
        }
        for (DynamicObject dyo : upgradeData) {
            dyo.set("runconcurrent", (Object)"0");
            dyo.set("strategy", (Object)"1");
        }
        SaveServiceHelper.save((DynamicObject[])upgradeData);
    }

    private String getStackTraceMessage(Exception e) {
        StackTraceElement[] stackArray;
        StringBuilder sb = new StringBuilder();
        sb.append(e.getClass().getName()).append(':');
        sb.append(e.getMessage()).append('\n');
        for (StackTraceElement element : stackArray = e.getStackTrace()) {
            sb.append(element).append('\n');
        }
        return sb.toString();
    }
}

