/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.iep.billmapping;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.fi.iep.billmapping.TreeSelectorHelper;
import kd.fi.iep.strategy.IColsSelectStrategy;
import kd.fi.iep.strategy.SimpleStrategy;

public class PageShowHelper {
    public static void showColsTreePage(IFormView view, String entityNumber, String selectedfields, IColsSelectStrategy strategy, CloseCallBack callBack, String caption) {
        IColsSelectStrategy selectStrategy = strategy;
        if (selectStrategy == null) {
            selectStrategy = new SimpleStrategy();
        }
        TreeSelectorHelper treeSelectorHelper = new TreeSelectorHelper(selectStrategy, entityNumber);
        String jsonTree = treeSelectorHelper.buildTree2JSON();
        view.getPageCache().putBigObject("fieldtreeshow_treenodejson", jsonTree);
        FormShowParameter fp = new FormShowParameter();
        fp.setParentPageId(view.getPageId());
        fp.setFormId("bos_mulfieldtree");
        fp.getCustomParams().put("entitynumber", entityNumber);
        fp.getCustomParams().put("selectedfields", selectedfields);
        fp.setCloseCallBack(callBack);
        fp.getOpenStyle().setShowType(ShowType.Modal);
        if (StringUtils.isNotEmpty((CharSequence)caption)) {
            fp.setCaption(caption);
        }
        view.showForm(fp);
    }

    public static Map<String, String> getSelectFieldsMap(IFormView view, String entityNumber, String[] selectedfields, IColsSelectStrategy strategy) {
        TreeNode rootNode;
        String jsonTree = view.getPageCache().getBigObject("fieldtreeshow_treenodejson");
        if (StringUtils.isNotEmpty((CharSequence)jsonTree)) {
            rootNode = (TreeNode)SerializationUtils.fromJsonString((String)jsonTree, TreeNode.class);
        } else {
            IColsSelectStrategy selectStrategy = strategy;
            if (selectStrategy == null) {
                selectStrategy = new SimpleStrategy();
            }
            TreeSelectorHelper treeSelectorHelper = new TreeSelectorHelper(selectStrategy, entityNumber);
            rootNode = treeSelectorHelper.buildTree();
        }
        return Arrays.stream(selectedfields).filter(selectedfield -> selectedfield.length() > 0).distinct().collect(Collectors.toMap(x -> x, x -> rootNode.getTreeNode(x).getText(), (oldVal, newVal) -> newVal));
    }
}

