/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.iep.cache;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.iep.cache.FinishCache;
import kd.fi.iep.cache.PlanExecCache;
import kd.fi.iep.cache.ProcessingCache;
import kd.fi.iep.cache.ProfileCache;
import kd.fi.iep.cache.ProgressCache;
import kd.fi.iep.cache.SchemaCache;

public class IEPCacheUtil {
    private static final Log logger = LogFactory.getLog(IEPCacheUtil.class);

    public static void clearIndexCache() {
        try (DataSet dataset = QueryServiceHelper.queryDataSet((String)"gl.IntelShareIndexPlugin.Schemas", (String)"gl_intellexecschema", (String)"id", null, null);){
            for (Row row : dataset) {
                long schemaId = row.getLong("id");
                IEPCacheUtil.clearIndexCache(schemaId);
            }
        }
    }

    public static Map<String, Long> getProfileCount(Long[] schemaIds) {
        return ProfileCache.getCount(schemaIds);
    }

    public static LinkedList<HashMap<String, Object>> getProcessOperation(Long[] schemaIds) {
        return ProcessingCache.getProcessOperation(schemaIds);
    }

    public static LinkedList<HashMap<String, Object>> getLimitProcessOperation(Long[] schemaIds, int limit) {
        return ProcessingCache.getProcessOperation(schemaIds, limit);
    }

    public static LinkedList<HashMap<String, Object>> getFinishSchema(Long[] schemaIds) {
        return FinishCache.getFinishSchema(schemaIds);
    }

    public static LinkedList<HashMap<String, Object>> getLimitFinishSchema(Long[] schemaIds, int limit) {
        return IEPCacheUtil.getLimitFinishSchema(FinishCache.getFinishSchema(schemaIds), limit);
    }

    public static LinkedList<HashMap<String, Object>> getLimitFinishSchema(LinkedList<HashMap<String, Object>> allList, int limit) {
        Collections.sort(allList, new Comparator<HashMap<String, Object>>(){

            @Override
            public int compare(HashMap<String, Object> map1, HashMap<String, Object> map2) {
                SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                try {
                    Date date1 = formatter.parse((String)map1.get("enddate"));
                    Date date2 = formatter.parse((String)map2.get("enddate"));
                    return date1.compareTo(date2);
                }
                catch (ParseException e) {
                    logger.error("getLimitFinishSchema-" + e.toString());
                    return 0;
                }
            }
        });
        Collections.reverse(allList);
        LinkedList<HashMap<String, Object>> limitList = new LinkedList();
        if (allList.size() > limit) {
            for (int i = 0; i < limit; ++i) {
                limitList.add(allList.get(i));
            }
        } else {
            limitList = allList;
        }
        return limitList;
    }

    public static Long[] getAccomplishSchema(Long[] userinfo) {
        Long[] schemaIds = new Long[]{};
        Map<String, Long> schemaMap = IEPCacheUtil.getSchemaDataSet(userinfo);
        if (schemaMap.size() == 0) {
            return schemaIds;
        }
        IEPCacheUtil.filterEnableScheduleDataSet(schemaMap);
        return schemaMap.values().toArray(new Long[0]);
    }

    private static Map<String, Long> getSchemaDataSet(Long[] userinfo) {
        QFilter userFilter = new QFilter("modifier", "in", (Object)userinfo);
        QFilter statusFilter = new QFilter("enable", "=", (Object)"1");
        QFilter[] qfiltrs = new QFilter[]{userFilter, statusFilter};
        HashMap<String, Long> schemaMap = new HashMap<String, Long>();
        try (DataSet schemaDataSet = QueryServiceHelper.queryDataSet((String)"fi.iep.IntellIndexPlugin.enableSchema", (String)"gl_intellexecschema", (String)"id, sheduleplanid", (QFilter[])qfiltrs, null);){
            for (Row r : schemaDataSet) {
                Object planId = r.get("sheduleplanid");
                if (planId == null || !StringUtils.isNotBlank((CharSequence)planId.toString())) continue;
                schemaMap.put(planId.toString(), r.getLong("id"));
            }
        }
        return schemaMap;
    }

    private static void filterEnableScheduleDataSet(Map<String, Long> schemaDataSet) {
        Set<String> scheduleSet = schemaDataSet.keySet();
        QFilter idFilter = new QFilter("id", "in", scheduleSet);
        long current = System.currentTimeMillis();
        long zero = current / 86400000L * 86400000L - (long)TimeZone.getDefault().getRawOffset();
        long twelve = zero + 86400000L - 1L;
        QFilter startFilter = new QFilter("starttime", ">", (Object)new Timestamp(twelve));
        QFilter endFilter = new QFilter("endtime", "<", (Object)new Timestamp(zero));
        QFilter[] qfilters = new QFilter[]{idFilter, startFilter, endFilter};
        try (DataSet scheduleDataSet = QueryServiceHelper.queryDataSet((String)"fi.iep.IntellIndexPlugin.disableSchedule", (String)"sch_schedule", (String)"id", (QFilter[])qfilters, null);){
            for (Row r : scheduleDataSet) {
                schemaDataSet.remove(r.getString("id"));
            }
        }
    }

    public static void removeIntellIndexCache(long schemaId) {
        ProfileCache.remove(schemaId);
        PlanExecCache.remove(schemaId);
    }

    public static void clearIndexCache(Long schemaId) {
        PlanExecCache.remove(schemaId);
        ProfileCache.remove(schemaId);
        ProgressCache.remove(schemaId);
        SchemaCache.remove(schemaId);
    }
}

