/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.iep.cache;

import java.util.Calendar;
import java.util.Date;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.util.StringUtils;
import kd.fi.iep.cache.AbstractCache;
import kd.fi.iep.cache.IEPCacheUtil;

public class LastDateCache
extends AbstractCache {
    protected static boolean checkIsTodayCache(Long schemaId) {
        Date lastdate;
        String lastdateleJson = LastDateCache.get(LastDateCache.getKey(schemaId));
        if (lastdateleJson != null && (lastdate = (Date)SerializationUtils.fromJsonString((String)lastdateleJson, Date.class)) != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(lastdate);
            int lastDay = calendar.get(6);
            calendar.setTime(new Date());
            int today = calendar.get(6);
            if (lastDay != today) {
                return false;
            }
        }
        return true;
    }

    public static void setDistributeStartDate(Long intelschemaId, Date execstartdate) {
        Date lastdate = LastDateCache.get(intelschemaId);
        if (lastdate != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(lastdate);
            int lastDay = calendar.get(6);
            calendar.setTime(execstartdate);
            int execstartDay = calendar.get(6);
            if (lastDay != execstartDay) {
                IEPCacheUtil.clearIndexCache(intelschemaId);
            }
        }
        LastDateCache.set(intelschemaId, execstartdate);
    }

    public static Date get(Long schemaId) {
        String dateJSON = LastDateCache.get(LastDateCache.getKey(schemaId));
        if (StringUtils.isNotEmpty((String)dateJSON)) {
            return (Date)SerializationUtils.fromJsonString((String)dateJSON, Date.class);
        }
        return null;
    }

    public static void set(Long schemaId, Object value) {
        LastDateCache.put(LastDateCache.getKey(schemaId), SerializationUtils.toJsonString((Object)value));
    }

    private static String getKey(Long schemaId) {
        return schemaId + "IntellIndexCacheLastDate";
    }
}

