/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.iep.cache;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.fi.iep.cache.AbstractCache;
import kd.fi.iep.cache.LastDateCache;
import kd.fi.iep.info.IntellAcaountExeInfo;
import kd.fi.iep.util.ScheduleCalculateUtil;

public class PlanExecCache
extends AbstractCache {
    private static final Log logger = LogFactory.getLog(PlanExecCache.class);
    private static final int MAX_COUNT = 6;
    private static final String VIEW_KEY = "column";
    private static boolean FIXED = false;

    protected static Map<String, Object> get(Long schemaId) {
        Map<String, Object> map = new HashMap<String, Object>();
        String planJSON = PlanExecCache.get(PlanExecCache.getKey(schemaId));
        if (StringUtils.isNotEmpty((String)planJSON)) {
            Map mapObj = (Map)SerializationUtils.fromJsonString((String)planJSON, Map.class);
            if (!FIXED) {
                int startIndex = schemaId.toString().length();
                for (Map.Entry oldKey : mapObj.entrySet()) {
                    if (!((String)oldKey.getKey()).startsWith(schemaId + "")) continue;
                    map.put(((String)oldKey.getKey()).substring(startIndex + 1, ((String)oldKey.getKey()).length()), mapObj.get(oldKey.getKey()));
                }
                FIXED = true;
                PlanExecCache.set(schemaId, map);
            } else {
                map = mapObj;
            }
        }
        return map;
    }

    public static List<IntellAcaountExeInfo> getCacheFinishSchema(Long[] schemaIds, int i) {
        ArrayList<IntellAcaountExeInfo> dataList = new ArrayList<IntellAcaountExeInfo>();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        for (Long id : schemaIds) {
            LinkedHashMap viewMap;
            Map<String, Object> planMap;
            boolean isTodayCache = LastDateCache.checkIsTodayCache(id);
            if (!isTodayCache || (planMap = PlanExecCache.get(id)) == null || (viewMap = (LinkedHashMap)planMap.get(VIEW_KEY + i)) == null) continue;
            Date execDate = null;
            try {
                execDate = formatter.parse((String)viewMap.get("execDate"));
            }
            catch (Exception e) {
                logger.error("getCacheFinishSchema-" + e.toString());
            }
            IntellAcaountExeInfo intellAcaountExeInfo = new IntellAcaountExeInfo(((Long)viewMap.get("id")).longValue(), execDate, (String)viewMap.get("execstatus"));
            dataList.add(intellAcaountExeInfo);
        }
        return dataList;
    }

    public static void setDistributeTodayPlanCache(Long intelschemaId, String sumStatus, Date date) {
        Map<String, Object> planMap = PlanExecCache.get(intelschemaId);
        String columnKey = PlanExecCache.getColumnKeyByTime(date);
        IntellAcaountExeInfo intellAcaountExeInfo = new IntellAcaountExeInfo(intelschemaId.longValue(), date, sumStatus);
        planMap.put(columnKey, intellAcaountExeInfo);
        PlanExecCache.set(intelschemaId, planMap);
    }

    public static void setPreSchemaFinish(Long schemaId) {
        Map<String, Object> planMap = PlanExecCache.get(schemaId);
        if (planMap != null) {
            for (int i = 0; i < 6; ++i) {
                LinkedHashMap value = (LinkedHashMap)planMap.get(VIEW_KEY + i);
                if (value == null) continue;
                value.put("execstatus", "3");
            }
        }
        PlanExecCache.set(schemaId, planMap);
    }

    private static String getColumnKeyByTime(Date startDate) {
        Calendar startDateCal = Calendar.getInstance();
        startDateCal.setTime(startDate);
        Calendar time0 = PlanExecCache.setCalendarHour(0);
        Calendar time4 = PlanExecCache.setCalendarHour(4);
        Calendar time8 = PlanExecCache.setCalendarHour(8);
        Calendar time12 = PlanExecCache.setCalendarHour(12);
        Calendar time16 = PlanExecCache.setCalendarHour(16);
        Calendar time20 = PlanExecCache.setCalendarHour(20);
        if (PlanExecCache.whereDate(startDateCal, time0, time4)) {
            return "column0";
        }
        if (PlanExecCache.whereDate(startDateCal, time4, time8)) {
            return "column1";
        }
        if (PlanExecCache.whereDate(startDateCal, time8, time12)) {
            return "column2";
        }
        if (PlanExecCache.whereDate(startDateCal, time12, time16)) {
            return "column3";
        }
        if (PlanExecCache.whereDate(startDateCal, time16, time20)) {
            return "column4";
        }
        return "column5";
    }

    public static List<IntellAcaountExeInfo> getCacheProcessingFinishSchema(Long[] schemaIds, int i) {
        ArrayList<IntellAcaountExeInfo> dataList = new ArrayList<IntellAcaountExeInfo>();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        for (Long id : schemaIds) {
            Map<String, Object> planMap = PlanExecCache.get(id);
            if (planMap != null) {
                LinkedHashMap value = (LinkedHashMap)planMap.get(VIEW_KEY + i);
                if (value != null) {
                    Date execDate = null;
                    try {
                        execDate = formatter.parse((String)value.get("execDate"));
                    }
                    catch (Exception e) {
                        logger.error("getCacheProcessingFinishSchema-" + e.toString());
                    }
                    IntellAcaountExeInfo intellAcaountExeInfo = new IntellAcaountExeInfo(((Long)value.get("id")).longValue(), execDate, (String)value.get("execstatus"));
                    if ("1".equals(intellAcaountExeInfo.getExecstatus())) {
                        dataList.add(intellAcaountExeInfo);
                        continue;
                    }
                    PlanExecCache.createPlanExecInfo(dataList, id, i);
                    continue;
                }
                PlanExecCache.createPlanExecInfo(dataList, id, i);
                continue;
            }
            PlanExecCache.createPlanExecInfo(dataList, id, i);
        }
        return dataList;
    }

    private static void createPlanExecInfo(List<IntellAcaountExeInfo> dataList, Long schemaId, int i) {
        IntellAcaountExeInfo intellAcaountExePlanInfo = PlanExecCache.addPlanExeInfo(schemaId);
        if (intellAcaountExePlanInfo != null) {
            Date exeDate = intellAcaountExePlanInfo.getExecDate();
            String[] dates = new String[]{"0:00-03:59", "04:00-07:59", "08:00-11:59", "12:00-15:59", "16:00-19:59", "20:00-23:59"};
            SimpleDateFormat sdf = new SimpleDateFormat("HH:mm");
            String dateStr = dates[i];
            String[] dateArr = dateStr.split("-");
            Calendar calendar1 = Calendar.getInstance();
            Calendar calendar2 = Calendar.getInstance();
            Calendar calendar3 = Calendar.getInstance();
            try {
                Date startDate = sdf.parse(dateArr[0]);
                calendar1.setTime(startDate);
                Date endDate = sdf.parse(dateArr[1]);
                exeDate = sdf.parse(sdf.format(exeDate));
                calendar2.setTime(endDate);
                calendar3.setTime(exeDate);
            }
            catch (ParseException e) {
                logger.error("createPlanExecInfo-" + e.toString());
            }
            if (calendar3.compareTo(calendar1) >= 0 && calendar3.compareTo(calendar2) <= 0) {
                dataList.add(intellAcaountExePlanInfo);
            }
        }
    }

    private static IntellAcaountExeInfo addPlanExeInfo(Long schemaId) {
        List<IntellAcaountExeInfo> singleResult = ScheduleCalculateUtil.execShemaCalculate(schemaId);
        if (singleResult != null && singleResult.size() > 0) {
            return singleResult.get(0);
        }
        return null;
    }

    private static boolean whereDate(Calendar startDateCal, Calendar time0, Calendar time4) {
        return startDateCal.compareTo(time0) >= 0 && startDateCal.compareTo(time4) < 0;
    }

    private static Calendar setCalendarHour(int hour) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.set(11, hour);
        calendar.set(14, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        return calendar;
    }

    public static void set(Long schemaId, Object value) {
        PlanExecCache.put(PlanExecCache.getKey(schemaId), SerializationUtils.toJsonString((Object)value));
    }

    public static void remove(Long schemaId) {
        PlanExecCache.remove(PlanExecCache.getKey(schemaId));
    }

    private static String getKey(Long schemaId) {
        return schemaId + "IntellIndexCachePlan";
    }
}

