/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.iep.cache;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.util.StringUtils;
import kd.fi.iep.cache.AbstractCache;
import kd.fi.iep.cache.LastDateCache;

public class ProcessingCache
extends AbstractCache {
    protected static LinkedList<HashMap<String, Object>> getProcessOperation(Long[] schemaIds) {
        LinkedList<HashMap<String, Object>> operAllList = new LinkedList<HashMap<String, Object>>();
        if (schemaIds == null || schemaIds.length == 0) {
            return operAllList;
        }
        for (Long id : schemaIds) {
            operAllList.addAll(ProcessingCache.getProcessOperation(id));
        }
        return operAllList;
    }

    protected static LinkedList<HashMap<String, Object>> getProcessOperation(Long[] schemaIds, int limit) {
        LinkedList<HashMap<String, Object>> operAllList = new LinkedList<HashMap<String, Object>>();
        if (schemaIds == null || schemaIds.length == 0) {
            return operAllList;
        }
        for (Long id : schemaIds) {
            operAllList.addAll(ProcessingCache.getProcessOperation(id));
            if (operAllList.size() <= limit - 1) continue;
            LinkedList<HashMap<String, Object>> limitList = new LinkedList<HashMap<String, Object>>();
            for (int i = 0; i < limit; ++i) {
                limitList.add(operAllList.get(i));
            }
            return limitList;
        }
        return operAllList;
    }

    protected static LinkedList<HashMap<String, Object>> getProcessOperation(long schemaId) {
        LinkedList<HashMap<String, Object>> operAllList = new LinkedList<HashMap<String, Object>>();
        HashMap operAllMap = new HashMap();
        String prcessingJSON = ProcessingCache.get(ProcessingCache.getKey(schemaId));
        if (StringUtils.isNotEmpty((String)prcessingJSON)) {
            boolean isTodayCache = LastDateCache.checkIsTodayCache(schemaId);
            if (!isTodayCache) {
                return operAllList;
            }
            operAllMap = (HashMap)SerializationUtils.fromJsonString((String)prcessingJSON, Map.class);
            if (operAllMap != null) {
                for (Map.Entry entry : operAllMap.entrySet()) {
                    LinkedHashMap singleMap = (LinkedHashMap)entry.getValue();
                    operAllList.add(singleMap);
                }
            }
        }
        return operAllList;
    }

    private static String getKey(Long schemaId) {
        return schemaId + "IntellIndexCacheProgress";
    }
}

