/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.iep.cache;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.util.StringUtils;
import kd.fi.iep.cache.AbstractCache;

public class ProfileCache
extends AbstractCache {
    public static final String FINISH = "finishCount";
    public static final String PROCESSING = "processingCount";
    private static boolean hasFixed = false;

    protected static Map<String, Long> getCount(Long[] schemaIds) {
        HashMap<String, Long> map = new HashMap<String, Long>(2);
        if (schemaIds == null || schemaIds.length == 0) {
            map.put(PROCESSING, 0L);
            map.put(FINISH, 0L);
            return map;
        }
        long processingCount = 0L;
        long finishCount = 0L;
        for (Long id : schemaIds) {
            Map<String, Integer> each = ProfileCache.get(id);
            processingCount += (long)each.get(PROCESSING).intValue();
            finishCount += (long)each.get(FINISH).intValue();
        }
        map.put(PROCESSING, processingCount);
        map.put(FINISH, finishCount);
        return map;
    }

    public static void setDistributeProfileCache(Long schemaId, boolean isFinish) {
        Integer finishCount = 0;
        Integer processingCount = 0;
        Map<String, Integer> profileMap = ProfileCache.get(schemaId);
        if (profileMap.isEmpty()) {
            profileMap.put(FINISH, finishCount);
            profileMap.put(PROCESSING, processingCount);
        }
        if (isFinish) {
            profileMap.put(PROCESSING, profileMap.get(PROCESSING) - 1);
            profileMap.put(FINISH, profileMap.get(FINISH) + 1);
        } else {
            profileMap.put(PROCESSING, profileMap.get(PROCESSING) + 1);
        }
        ProfileCache.set(schemaId, profileMap);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Map<String, Integer> get(Long schemaId) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        String profileJson = ProfileCache.get(ProfileCache.getKey(schemaId));
        if (StringUtils.isNotEmpty((String)profileJson)) {
            Map oldMapObj;
            Map oldMap = oldMapObj = (Map)SerializationUtils.fromJsonString((String)profileJson, Map.class);
            Map values = (Map)oldMap.get(schemaId);
            if (hasFixed || values == null) return oldMapObj;
            map.putAll(values);
            ProfileCache.set(schemaId, map);
            hasFixed = true;
            return map;
        } else {
            map.put(PROCESSING, 0);
            map.put(FINISH, 0);
        }
        return map;
    }

    public static void setPreSchemaFinish(Long schemaId) {
        Map<String, Integer> profileMap = ProfileCache.get(schemaId);
        if (!profileMap.isEmpty()) {
            Integer finishCount = profileMap.get(FINISH);
            Integer processingCount = profileMap.get(PROCESSING);
            if (processingCount == null) {
                processingCount = 0;
            }
            if (finishCount == null) {
                finishCount = 0;
            }
            if (processingCount != 0) {
                finishCount = finishCount + processingCount;
                processingCount = 0;
            }
            profileMap.put(FINISH, finishCount);
            profileMap.put(PROCESSING, processingCount);
        }
        ProfileCache.set(schemaId, profileMap);
    }

    public static void set(Long schemaId, Object value) {
        ProfileCache.put(ProfileCache.getKey(schemaId), SerializationUtils.toJsonString((Object)value));
    }

    public static void remove(Long schemaId) {
        ProfileCache.remove(ProfileCache.getKey(schemaId));
    }

    private static String getKey(Long schemaId) {
        return schemaId + "IntellIndexCacheProfile";
    }
}

