/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.iep.cache;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.util.StringUtils;
import kd.fi.iep.cache.AbstractCache;
import kd.fi.iep.cache.SchemaCache;
import kd.fi.iep.dao.FormDesignDao;

public class ProgressCache
extends AbstractCache {
    private static final int MAX_COUNT = 5;

    public static void setDistributeOperCache(Long schemeId, int batchSize, HashMap<String, Object> operMap, boolean isFinish) {
        String bussiness = (String)operMap.get("business");
        String oper = (String)operMap.get("oper");
        String key = bussiness + oper;
        int finishCount = batchSize;
        HashMap<String, Object> operCacheMap = new HashMap<String, Object>();
        Map<String, Object> operAllMap = ProgressCache.get(schemeId);
        if (operAllMap.isEmpty()) {
            operAllMap.put(key, operMap);
        } else {
            operCacheMap = (HashMap<String, Object>)operAllMap.get(key);
            if (isFinish && operCacheMap != null) {
                finishCount = (Integer)operCacheMap.get("finishCount") + batchSize;
                operCacheMap.put("finishCount", finishCount);
            } else if (operAllMap.size() < 5) {
                operCacheMap = operMap;
            } else if (operCacheMap == null || operCacheMap.size() == 0) {
                operCacheMap = operMap;
            }
            if (isFinish) {
                operAllMap.remove(key);
                ProgressCache.setDistributeOperFinishCache(schemeId, operMap, key);
            } else {
                operAllMap.put(key, operCacheMap);
            }
        }
        ProgressCache.set(schemeId, operAllMap);
    }

    private static void setDistributeOperFinishCache(Long schemaId, HashMap<String, Object> operMap, String key) {
        Map<String, String> nameMap = ProgressCache.getBussnessAndOperName(operMap);
        HashMap<String, Object> operCacheMap = new HashMap<String, Object>();
        operCacheMap.put("business", nameMap.get("bussiness"));
        operCacheMap.put("oper", nameMap.get("oper"));
        operCacheMap.put("billqty", operMap.get("billqty"));
        operCacheMap.put("enddate", new Date());
        SchemaCache.setDistributeOperFinishCache(schemaId, operCacheMap);
    }

    private static Map<String, String> getBussnessAndOperName(HashMap<String, Object> operMap2) {
        HashMap<String, String> map = new HashMap<String, String>();
        String bussiness = (String)operMap2.get("business");
        map.put("bussiness", FormDesignDao.getFormNameWithPeriodClose(bussiness, null));
        String oper = (String)operMap2.get("oper");
        String operName = FormDesignDao.getOperationNameWithVoucher(bussiness, oper);
        map.put("oper", operName);
        return map;
    }

    protected static Map<String, Object> get(Long schemaId) {
        String progressJSON = ProgressCache.get(ProgressCache.getKey(schemaId));
        if (StringUtils.isNotEmpty((String)progressJSON)) {
            return (Map)SerializationUtils.fromJsonString((String)progressJSON, Map.class);
        }
        return new HashMap<String, Object>();
    }

    public static void set(Long schemaId, Object value) {
        ProgressCache.put(ProgressCache.getKey(schemaId), SerializationUtils.toJsonString((Object)value));
    }

    public static void remove(Long schemaId) {
        ProgressCache.remove(ProgressCache.getKey(schemaId));
    }

    private static String getKey(Long schemaId) {
        return schemaId + "IntellIndexCacheProgress";
    }
}

