/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.iep.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.fi.iep.util.IntelAccountingConstant;

public class FormDesignDao {
    private static final Log logger = LogFactory.getLog(FormDesignDao.class);

    public static Map<String, String> getAllBillFormNameMap() {
        return FormDesignDao.getAllBillFormNameMapWithApps(null, null);
    }

    private static String getDesignFormName(String formId) {
        StringBuilder sql = new StringBuilder(100);
        sql.append("select a.FNAME as name from T_META_FORMDESIGN_L a inner join T_META_FORMDESIGN b on a.FID = b.FID ");
        sql.append("where a.FLOCALEID = '");
        sql.append(Lang.get());
        sql.append("' and b.fnumber = ?");
        String formName = formId;
        try {
            ResultSetHandler<Object> callBackHanlder = new ResultSetHandler<Object>(){

                public String handle(ResultSet rs) throws Exception {
                    String formName = null;
                    try {
                        if (rs.next()) {
                            formName = rs.getString("name");
                        }
                    }
                    catch (SQLException e) {
                        throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format("Error:%s", e.getMessage())});
                    }
                    return formName;
                }
            };
            formName = (String)DB.query((DBRoute)DBRoute.meta, (String)sql.toString(), (Object[])new Object[]{formId}, (ResultSetHandler)callBackHanlder);
        }
        catch (Exception e1) {
            String msg = String.format("error:%s;  sql:%s", e1.getMessage(), sql.toString());
            throw new KDException((Throwable)e1, BosErrorCode.sQL, new Object[]{msg});
        }
        return formName;
    }

    public static Map<String, String> getAllBillFormNameMapWithApps(List<String> appIds, String special) {
        StringBuilder sql = new StringBuilder(100);
        sql.append("select a.FNAME as name,b.FNumber as number from T_META_FORMDESIGN_L a inner join T_META_FORMDESIGN b on a.FID = b.FID ");
        if (special != null) {
            sql.append(" left join t_meta_entity e on e.fid = b.fentityid ");
        }
        sql.append("where a.FLOCALEID = '");
        sql.append(Lang.get());
        sql.append("' and b.fmodeltype in('BillFormModel', 'BaseFormModel') ");
        if (appIds != null && appIds.size() > 0) {
            sql.append(" and b.FBIZAPPID in ");
            sql.append(FormDesignDao.getQuerySQL(appIds));
        }
        if (special != null) {
            sql.append(" and e.FDATA LIKE '%");
            sql.append(special);
            sql.append("%'");
        }
        HashMap<String, String> formMap = new HashMap();
        try {
            ResultSetHandler<Object> callBackHanlder = new ResultSetHandler<Object>(){

                public Map<String, String> handle(ResultSet rs) throws Exception {
                    HashMap<String, String> map = new HashMap<String, String>();
                    try {
                        while (rs.next()) {
                            map.put(rs.getString("number"), rs.getString("name"));
                        }
                    }
                    catch (SQLException e) {
                        throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format("Error:%s", e.getMessage())});
                    }
                    return map;
                }
            };
            formMap = (Map)DB.query((DBRoute)DBRoute.meta, (String)sql.toString(), (Object[])new Object[0], (ResultSetHandler)callBackHanlder);
        }
        catch (Exception e1) {
            String msg = String.format("error:%s;  sql:%s", e1.getMessage(), sql.toString());
            throw new KDException((Throwable)e1, BosErrorCode.sQL, new Object[]{msg});
        }
        return formMap;
    }

    public static Map<String, String> reloadAllForm(Set<String> entitys) {
        StringBuilder sql = new StringBuilder(100);
        sql.append("select a.FNAME as name,b.FNumber as number from T_META_FORMDESIGN_L a inner join T_META_FORMDESIGN b on a.FID = b.FID ");
        sql.append(" inner join t_meta_entity e on e.fid = b.fentityid ");
        sql.append("where a.FLOCALEID = '");
        sql.append(Lang.get());
        sql.append("' and b.fmodeltype in('BillFormModel', 'BaseFormModel') ");
        if (entitys != null && entitys.size() > 0) {
            sql.append(" and e.Fnumber in ");
            sql.append(FormDesignDao.getQuerySQL(entitys));
        }
        sql.append(" group by b.FNumber, a.fname");
        HashMap<String, String> formMap = new HashMap();
        try {
            ResultSetHandler<Object> callBackHanlder = new ResultSetHandler<Object>(){

                public Map<String, String> handle(ResultSet rs) throws Exception {
                    HashMap<String, String> map = new HashMap<String, String>();
                    try {
                        while (rs.next()) {
                            map.put(rs.getString("number"), rs.getString("name"));
                        }
                    }
                    catch (SQLException e) {
                        throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format("Error:%s", e.getMessage())});
                    }
                    return map;
                }
            };
            formMap = (Map)DB.query((DBRoute)DBRoute.meta, (String)sql.toString(), (Object[])new Object[0], (ResultSetHandler)callBackHanlder);
        }
        catch (Exception e1) {
            String msg = String.format("error:%s;  sql:%s", e1.getMessage(), sql.toString());
            throw new KDException((Throwable)e1, BosErrorCode.sQL, new Object[]{msg});
        }
        return formMap;
    }

    private static String getQuerySQL(List<String> appIds) {
        StringBuilder sb = new StringBuilder();
        sb.append(" (");
        for (int i = 0; i < appIds.size(); ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append("'").append(appIds.get(i)).append("'");
        }
        sb.append(") ");
        return sb.toString();
    }

    private static String getQuerySQL(Set<String> appIds) {
        StringBuilder sb = new StringBuilder();
        sb.append(" (");
        boolean isFirst = true;
        for (String appId : appIds) {
            if (!isFirst) {
                sb.append(",");
            }
            if (isFirst) {
                isFirst = false;
            }
            sb.append("'").append(appId).append("'");
        }
        sb.append(") ");
        return sb.toString();
    }

    public static String getFormName(String formId) {
        return FormDesignDao.getDesignFormName(formId);
    }

    public static String getFormNameWithPeriodClose(String formId, String appId) {
        Map<String, String> periodCloseMap = FormDesignDao.getPeriodCloseForm(appId);
        String name = periodCloseMap.get(formId);
        if (name == null) {
            name = FormDesignDao.getFormName(formId);
        }
        return name;
    }

    public static String getOperationName(String formId, String oper) {
        String operName = oper;
        Map<String, String> operMap = FormDesignDao.getFormOperMap(formId);
        if (operMap != null) {
            operName = operMap.get(oper);
        }
        if (operName == null) {
            return oper;
        }
        return operName;
    }

    public static String getOperationNameWithVoucher(String formId, String oper) {
        String operName = oper;
        operName = "buildvoucher".equals(oper) || "generatevoucher".equals(oper) ? IntelAccountingConstant.getGENVOUCHER() : FormDesignDao.getOperationName(formId, oper);
        return operName;
    }

    public static Map<String, String> getFormOperMap(String formNumber) {
        HashMap<String, String> operMap = new HashMap<String, String>();
        try {
            List ops = EntityMetadataCache.getDataEntityOperate((String)formNumber);
            for (Map each : ops) {
                Object oper = each.get("key");
                Object name = each.get("name");
                if (oper == null || name == null) continue;
                operMap.put(oper.toString(), (String)((Map)name).get(Lang.get().toString()));
            }
        }
        catch (Throwable e) {
            logger.error("\u83b7\u53d6\u5355\u636e\u64cd\u4f5c\u5f02\u5e38," + e.getMessage());
        }
        return operMap;
    }

    public static Map<String, String> getPeriodCloseForm(String appID) {
        DynamicObjectCollection cols;
        QFilter[] filters = null;
        if (StringUtils.isNotBlank((CharSequence)appID)) {
            String appNumber = BizAppServiceHelp.getAppNumByAppId((String)appID);
            filters = new QFilter[]{new QFilter("bizapp", "=", (Object)appNumber)};
        }
        if ((cols = QueryServiceHelper.query((String)"fi_closeperiodconf", (String)"bizapp,biztype", filters)) == null) {
            return new HashMap<String, String>();
        }
        HashMap<String, String> map = new HashMap<String, String>(cols.size());
        String name = "";
        int size = cols.size();
        for (int i = 0; i < size; ++i) {
            String formId = ((DynamicObject)cols.get(i)).getString("biztype");
            if ("fa_periodclosebill".equals(formId)) {
                name = IntelAccountingConstant.getMonthCLOSEPRIOD();
            } else if ("fa_periodclose".equals(formId)) {
                name = IntelAccountingConstant.getCLOSEPRIOD();
            }
            map.put(formId, name);
        }
        return map;
    }
}

