/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.iep.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.entity.operate.Save;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.metadata.domainmodel.DomainModelBinder;
import kd.bos.metadata.domainmodel.DomainModelType;
import kd.bos.orm.query.QFilter;
import kd.fi.iep.dao.FormDesignDao;
import kd.fi.iep.info.DynamicParamModel;
import kd.fi.iep.util.IntellExecSchemaUtil;

public class IntellExceOperFilterPlugin
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        BasedataEdit bizapp = (BasedataEdit)this.getControl("bizapp");
        bizapp.addBeforeF7SelectListener(evt -> {
            ListShowParameter sp = (ListShowParameter)evt.getFormShowParameter();
            sp.getCustomParams().put("onlydeployed", false);
            ListFilterParameter listFilterParameter = sp.getListFilterParameter();
            List qFilters = listFilterParameter.getQFilters();
            qFilters.add(new QFilter("number", "not like", (Object)"%ext%"));
        });
    }

    public void initialize() {
        super.initialize();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        if (e.getSource() instanceof Save) {
            String filter = this.getDataFilter();
            if (StringUtils.isEmpty((CharSequence)filter)) {
                e.setCancel(true);
                String errMsg = ResManager.loadKDString((String)"\u5fc5\u987b\u914d\u7f6e\u8fc7\u6ee4\u6761\u4ef6", (String)"IntellExceOperFilterPlugin_0", (String)"fi-iep-formplugin", (Object[])new Object[0]);
                e.setCancelMessage(errMsg);
                this.getView().showErrorNotification(errMsg);
                return;
            }
            this.getModel().setValue("datafilter_tag", (Object)this.getDataFilter());
            this.getModel().setValue("datafilter", (Object)"");
            String appId = null;
            String bussiness = null;
            String oper = null;
            if (this.getModel().getValue("bizapp_id") != null) {
                appId = this.getModel().getValue("bizapp_id").toString();
            }
            if (this.getModel().getValue("bussiness") != null) {
                bussiness = this.getModel().getValue("bussiness").toString();
            }
            if (this.getModel().getValue("oper") != null) {
                oper = this.getModel().getValue("oper").toString();
            }
            this.getModel().setValue("hash", (Object)DynamicParamModel.getUniqueKey((String)appId, (String)bussiness, (String)oper).hashCode());
        }
    }

    private String getDataFilter() {
        FilterGrid filterGrid = (FilterGrid)this.getControl("filterGridap");
        FilterCondition filterCondition = filterGrid.getFilterGridState().getFilterCondition();
        List filteList = filterCondition.getFilterRow();
        if (filteList == null || filteList.isEmpty()) {
            return "";
        }
        String modelType = "DynamicFormModel";
        DomainModelBinder binder = new DomainModelBinder(DomainModelType.getDomainModelType((String)modelType, (boolean)false));
        DcJsonSerializer ser = new DcJsonSerializer((DcBinder)binder);
        binder.setWriteInheritFlag(true);
        Map filterConditionMap = ser.serializeToMap((Object)filterCondition, null);
        String filterJson = SerializationUtils.toJsonString((Object)filterConditionMap);
        return filterJson;
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Object entity = this.getModel().getValue("bussiness");
        if (entity != null) {
            String os = entity.toString();
            this.initFilterCondition(os, os);
            String appId = ((DynamicObject)this.getModel().getValue("bizapp")).getString("id");
            String business = entity.toString();
            ArrayList<ComboItem> list = new ArrayList<ComboItem>(1);
            ComboItem comboItem = new ComboItem();
            LocaleString name = null;
            name = "gl_initaccountbalance".equals(business) ? new LocaleString(ResManager.loadKDString((String)"\u79d1\u76ee\u521d\u59cb\u4f59\u989d", (String)"IntellExceOperFilterPlugin_1", (String)"fi-iep-formplugin", (Object[])new Object[0])) : new LocaleString(FormDesignDao.getFormNameWithPeriodClose(business, appId));
            comboItem.setValue(business);
            comboItem.setCaption(name);
            list.add(comboItem);
            ComboEdit combo = (ComboEdit)this.getView().getControl("bussiness");
            combo.setComboItems(list);
            this.getModel().setValue("bussiness", (Object)business);
            IntellExecSchemaUtil.setOperComboByData(entity.toString(), this.getView());
            this.getModel().setValue("oper", this.getModel().getValue("oper"));
            Object datafilter = this.getModel().getValue("datafilter_tag");
            if (StringUtils.isNotBlank((Object)datafilter)) {
                this.setDataFilter(datafilter.toString());
            }
        }
    }

    private void setDataFilter(String dataFilter) {
        Map filterConditionMap = (Map)SerializationUtils.fromJsonString((String)dataFilter, Map.class);
        ArrayList<IDataEntityType> dts = new ArrayList<IDataEntityType>();
        dts.add(OrmUtils.getDataEntityType(FilterCondition.class));
        dts.add(OrmUtils.getDataEntityType(SimpleFilterRow.class));
        DcJsonSerializer ser = new DcJsonSerializer(dts);
        FilterCondition filterCondition = (FilterCondition)ser.deserializeFromMap(filterConditionMap, null);
        FilterGrid filterGrid = (FilterGrid)this.getControl("filterGridap");
        filterGrid.SetValue(filterCondition);
        filterGrid.getFilterGridState().setState(filterCondition);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if (e.getProperty().getName() == null) {
            return;
        }
        switch (e.getProperty().getName()) {
            case "bizapp": {
                IntellExecSchemaUtil.setBussinessComnoByData(e, this.getView());
                break;
            }
            case "bussiness": {
                ChangeData[] cd = e.getChangeSet();
                String number = (String)cd[0].getNewValue();
                if (number == null) {
                    return;
                }
                String realEntity = IntellExecSchemaUtil.setOperComboListOperByData(e, this.getView());
                this.initFilterCondition(number, realEntity);
            }
        }
    }

    private void initFilterCondition(String formNumber, String entityNumber) {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtergridap");
        FilterGrid.FilterGridState filterGridState = filterGrid.getFilterGridState();
        FilterCondition fc = filterGridState.getFilterCondition();
        fc.getFilterRow().clear();
        ArrayList<Map<String, Object>> filterColumns = new ArrayList();
        if (formNumber != null && !"".equals(formNumber.trim())) {
            Map<String, Object> fields = this.getListFilter(formNumber);
            EntityTypeUtil entityTypeUtil = new EntityTypeUtil();
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            filterColumns = entityTypeUtil.getFilterColumns((IDataEntityType)entityType);
            this.filterColumnList(filterColumns, fields);
        }
        filterGrid.setFilterColumns(filterColumns);
        filterGrid.setEntityNumber(entityNumber);
        filterGrid.SetValue(fc);
        this.getView().updateView("filtergridap");
    }

    private Map<String, Object> getListFilter(String formId) {
        HashMap<String, Object> fields = new HashMap<String, Object>();
        Map filterMeta = FormMetadataCache.getFilterMeta((String)formId);
        Map filterContainer = (Map)SerializationUtils.fromJsonString((String)((String)filterMeta.get("FilterContainer")), Map.class);
        ArrayList itemsParent = (ArrayList)filterContainer.get("Items");
        if (itemsParent == null) {
            return fields;
        }
        for (Map itemMap : itemsParent) {
            ArrayList items = (ArrayList)itemMap.get("Items");
            if (items == null) continue;
            for (Map item : items) {
                fields.put((String)item.get("FieldName"), ((Map)item.get("Caption")).get(Lang.get().toString()));
            }
        }
        return fields;
    }

    private void filterColumnList(List<Map<String, Object>> filterColumns, Map<String, Object> fields) {
        Iterator<Map<String, Object>> iter = filterColumns.iterator();
        Set<String> filterSet = fields.keySet();
        Object fieldName = null;
        while (iter.hasNext()) {
            Map<String, Object> column = iter.next();
            fieldName = column.get("fieldName");
            if (!filterSet.contains(fieldName)) {
                iter.remove();
                continue;
            }
            column.put("fieldCaption", fields.get(fieldName));
        }
    }
}

