/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.iep.formplugin;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.property.MainOrgProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.SingleOrgContextHelper;
import kd.bos.form.StyleCss;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.lang.STConverter;
import kd.bos.license.api.LicenseCheckResult;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.fi.iep.dao.FormDesignDao;
import kd.fi.iep.util.ContextUtil;
import kd.fi.iep.util.GLFabulousOperation;
import kd.fi.iep.util.IntellExecSchemaUtil;
import kd.fi.iep.util.OpenBillUtils;

public class IntellExceSchemaEdit
extends AbstractBillPlugIn
implements ClickListener,
BeforeF7SelectListener {
    private static final String KEY_ORG = "orgid";
    private static final String KEY_EXECUTOR = "executor";
    private static final String STOPTIMERANGE_KEY = "stoptimerange";
    private static final String STOPTIMERANGE_STARTTIME = "stoptimerange_starttime";
    private static final String STOPTIMERANGE_ENDTIME = "stoptimerange_endtime";
    private static final String FAIL_RETRY_STRATEGY_KEY = "failretrystrategy";
    private static final String KEY_MSG_SENDTYPES = "notificationtypes";
    private static final String[][] REQUIRED_FIELDS = new String[][]{{"number", "number"}, {"name", "name"}, {"executor", "executor"}, {"sheduleplanid", "exceplan"}};

    public void preOpenForm(PreOpenFormEventArgs e) {
        LicenseCheckResult result = LicenseServiceHelper.checkPerformGroup((String)"PRO_IEP");
        if (!result.getHasLicense().booleanValue()) {
            String msg = result.getMsg();
            e.setCancel(true);
            e.setCancelMessage(msg);
            e.setCancelFormShowParameter(result.getCancelFormShowParameter());
        } else {
            super.preOpenForm(e);
        }
    }

    public void initialize() {
        long userId;
        BasedataEdit orgF7 = (BasedataEdit)this.getView().getControl(KEY_ORG);
        orgF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit executorF7 = (BasedataEdit)this.getView().getControl(KEY_EXECUTOR);
        executorF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit responsiblepersonF7 = (BasedataEdit)this.getView().getControl("notificationusers");
        responsiblepersonF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        if ("mcenter".equals(this.getView().getFormShowParameter().getCustomParams().get("apptype")) && !PermissionServiceHelper.isSuperUser((long)(userId = ContextUtil.getUserId())) && !PermissionServiceHelper.checkPermission((Long)userId, (String)"iep", (String)"gl_intellexecschema", (String)"47156aff000000ac")) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_save"});
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"execopertoolbarap"});
        this.addItemClickListeners(new String[]{"orgtoolbarap"});
        this.addClickListeners(new String[]{"exceplan"});
        this.addClickListeners(new String[]{"addcard", "addimg", "modifycard", "fabulousimage", "addlabel", "deleteoper", "cardentryflexpanelap6"});
    }

    public void afterLoadData(EventObject e) {
        IDataModel dataModel = this.getModel();
        this.setCardTitleName(dataModel);
        this.initNotificationTypes();
        this.initUserInfo();
        this.setPlanLang(dataModel);
        Object executorId = dataModel.getValue("executor_id");
        this.getPageCache().put("executorId", StringUtils.isBlank((Object)executorId) ? "0" : executorId.toString());
        this.getModel().setDataChanged(false);
    }

    private void setPlanLang(IDataModel dataModel) {
        String str;
        Object valueLang = dataModel.getValue("exceplanlang");
        if (valueLang != null && !StringUtils.isBlank((CharSequence)(str = ((OrmLocaleValue)valueLang).getLocaleValue()))) {
            dataModel.setValue("exceplan", (Object)str);
        }
    }

    private void setCardTitleName(IDataModel dataModel) {
        DynamicObjectCollection entryentity = dataModel.getEntryEntity("operationentry");
        if (entryentity == null || entryentity.isEmpty()) {
            return;
        }
        int size = entryentity.size();
        for (int i = 0; i < size; ++i) {
            String bussiness;
            Object appid = ((DynamicObject)entryentity.get(i)).get("appid");
            if (StringUtils.isBlank((Object)appid) || (bussiness = (String)((DynamicObject)entryentity.get(i)).get("bussiness")) == null) continue;
            dataModel.setValue("bussinessname", (Object)FormDesignDao.getFormNameWithPeriodClose(bussiness, null), i);
            String oper = (String)((DynamicObject)entryentity.get(i)).get("oper");
            if (oper != null) {
                dataModel.setValue("opername", (Object)FormDesignDao.getOperationNameWithVoucher(bussiness, oper), i);
            }
            dataModel.setValue("opertitle", dataModel.getValue("opername", i), i);
            int eachbatchsize = ((DynamicObject)entryentity.get(i)).get("eachbatchsize") != null ? (Integer)((DynamicObject)entryentity.get(i)).get("eachbatchsize") : 50;
            boolean isVchOpe = IntellExecSchemaUtil.isGenerateVoucherOperation(bussiness, oper);
            if (isVchOpe || eachbatchsize != 0 && eachbatchsize != 10000) continue;
            dataModel.setValue("eachbatchsize", (Object)50);
        }
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if ("exceplan".equalsIgnoreCase(key)) {
            IBillModel billmodel = (IBillModel)this.getModel();
            long id = (Long)billmodel.getValue("id");
            if (StringUtils.isBlank((Object)id) || id == 0L) {
                String tableName = billmodel.getDataEntityType().getAlias();
                long[] ids = DBServiceHelper.genLongIds((String)tableName, (int)1);
                id = ids[0];
                billmodel.getDataEntity().set("id", (Object)id);
            }
            BillShowParameter parameter = new BillShowParameter();
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setFormId("sch_schedule");
            parameter.addCustPlugin("kd.fi.iep.formplugin.SchScheduleLayoutPlugin");
            parameter.addCustPlugin("kd.fi.iep.formplugin.SchScheduleRetryPlugin");
            parameter.addCustPlugin("kd.fi.iep.formplugin.SchScheduleSavePlugin");
            String scheduleId = (String)this.getView().getModel().getValue("sheduleplanid");
            if (kd.bos.util.StringUtils.isNotEmpty((String)scheduleId) && this.checkScheduleOrTips(id, scheduleId)) {
                scheduleId = null;
            }
            if (scheduleId == null || scheduleId.trim().length() == 0) {
                parameter.setStatus(OperationStatus.ADDNEW);
                String idJson = "{\"intellSchemaidList\":[{\"Id\":" + id + "}]}";
                parameter.setCustomParam("paramjsonstr", (Object)idJson);
                parameter.setCustomParam("taskclassname", (Object)"kd.fi.iep.task.IntellExceTask");
                parameter.setCustomParam("taskdefineid", (Object)"/=H=I/HPK3MH");
                parameter.setCustomParam("taskname", (Object)ResManager.loadKDString((String)"\u667a\u80fd\u6838\u7b97\u540e\u53f0\u81ea\u52a8\u521b\u5efa\u8ba1\u5212", (String)"IntellExceSchemaEdit_0", (String)"fi-iep-formplugin", (Object[])new Object[0]));
                parameter.setCustomParam("tasknumber", (Object)("iep_autocreate" + System.currentTimeMillis()));
                DynamicObject executor = (DynamicObject)billmodel.getValue(KEY_EXECUTOR);
                if (executor != null) {
                    parameter.setCustomParam(KEY_EXECUTOR, executor.get("id"));
                }
            } else {
                parameter.setPkId((Object)scheduleId);
                parameter.setStatus(OperationStatus.EDIT);
            }
            String appId = this.getAppId(billmodel, parameter);
            parameter.setCustomParam("taskappnumber", (Object)appId);
            parameter.setCustomParam("taskdefineid", (Object)this.getExecClassName(appId));
            parameter.setHasRight(true);
            parameter.setCustomParam("frombiz", (Object)"true");
            IDataModel model = this.getModel();
            parameter.setCustomParam(STOPTIMERANGE_STARTTIME, model.getValue(STOPTIMERANGE_STARTTIME));
            parameter.setCustomParam(STOPTIMERANGE_ENDTIME, model.getValue(STOPTIMERANGE_ENDTIME));
            parameter.setCustomParam(FAIL_RETRY_STRATEGY_KEY, model.getValue(FAIL_RETRY_STRATEGY_KEY));
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "newshedule"));
            StyleCss css1 = new StyleCss();
            css1.setWidth("800");
            css1.setHeight("700");
            parameter.getOpenStyle().setInlineStyleCss(css1);
            this.getView().showForm((FormShowParameter)parameter);
        } else if ("addimg".equals(key) || "addcard".equals(key) || "addlabel".equals(key)) {
            this.addOperation();
        } else if ("cardentryflexpanelap6".equals(key)) {
            int index = this.getModel().getEntryCurrentRowIndex("operationentry");
            this.modifyOperation(index);
        } else if ("fabulousimage".equals(key)) {
            this.doFabulous();
        } else if ("deleteoper".equals(key)) {
            this.deleteSingleOper();
        }
    }

    private String getExecClassName(String appid) {
        String taskdefineid;
        QFilter filter = new QFilter("classname", "=", (Object)"kd.fi.iep.task.IntellExceTask");
        filter.and("appid", "=", (Object)appid);
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"sch_taskdefine", (String)"id", (QFilter[])filter.toArray(), null);
        if (null != load && load.length > 0) {
            taskdefineid = load[0].getString("id");
        } else {
            DynamicObject taskDyn = BusinessDataServiceHelper.newDynamicObject((String)"sch_taskdefine");
            taskDyn.set("name", (Object)("IntellExceTask-" + appid));
            taskDyn.set("number", (Object)("IntellExceTask-" + appid));
            taskDyn.set("classname", (Object)"kd.fi.iep.task.IntellExceTask");
            taskDyn.set("appid", (Object)appid);
            DynamicObject[] save = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{taskDyn});
            taskdefineid = save[0].getString("id");
        }
        return taskdefineid;
    }

    private String getAppId(IBillModel billmodel, BillShowParameter parameter) {
        String number = "iep";
        DynamicObject appDyn = (DynamicObject)billmodel.getValue("appid", 0);
        if (Objects.nonNull(appDyn)) {
            number = appDyn.getString("number");
        }
        return number;
    }

    public void beforeClosed(BeforeClosedEvent e) {
        boolean isExist;
        super.beforeClosed(e);
        Object id = this.getModel().getValue("id");
        Object scheduleId = this.getModel().getValue("sheduleplanid");
        if (StringUtils.isNotBlank((Object)scheduleId) && !(isExist = QueryServiceHelper.exists((String)"gl_intellexecschema", (Object)id))) {
            DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"sch_schedule"), (Object[])new Object[]{scheduleId});
        }
    }

    private void deleteSingleOper() {
        CardEntry operEntry = (CardEntry)this.getControl("operationentry");
        int focusRow = operEntry.getEntryState().getFocusRow();
        this.getModel().deleteEntryRow("operationentry", focusRow);
    }

    public void afterCreateNewData(EventObject e) {
        IBillModel billmodel = (IBillModel)this.getModel();
        String tableName = billmodel.getDataEntityType().getAlias();
        long[] ids = DBServiceHelper.genLongIds((String)tableName, (int)1);
        billmodel.setPKValue((Object)ids[0]);
        this.initNotificationTypes();
        this.initUserInfo();
        Object executorId = billmodel.getValue("executor_id");
        this.getPageCache().put("executorId", StringUtils.isBlank((Object)executorId) ? "0" : executorId.toString());
        LicenseCheckResult result = LicenseServiceHelper.checkPerformGroup((String)"PRO_IEP");
        if (!result.getHasLicense().booleanValue()) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"conentpanel", "titleapanel"});
            this.getView().showMessage(result.getMsg());
        }
        if (this.getModel().getEntryRowEntity("operationentry", 0) == null) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"advconap1"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"orgtoolbarap"});
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"orgtoolbarap"});
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"advconap1"});
        }
        if (SingleOrgContextHelper.isSingleOrgManageMode()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"advconap1"});
        }
    }

    public void itemClick(ItemClickEvent evt) {
        if ("addoperation".equals(evt.getItemKey())) {
            this.addOperation();
        } else if ("addorg".equals(evt.getItemKey())) {
            ListShowParameter para = new ListShowParameter();
            para.setLookUp(true);
            para.setBillFormId("bos_org");
            para.setFormId("bos_orgtreelistf7");
            para.getOpenStyle().setShowType(ShowType.Modal);
            para.setShowTitle(false);
            String orgFunc = this.getBillsMainOrgFunc();
            if (null != orgFunc && orgFunc.trim().length() > 0) {
                para.setCustomParam("orgFuncId", (Object)orgFunc);
            }
            StyleCss css = new StyleCss();
            css.setWidth("960");
            css.setHeight("580");
            para.getOpenStyle().setInlineStyleCss(css);
            para.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "addorg"));
            this.getView().showForm((FormShowParameter)para);
        }
    }

    private String getBillsMainOrgFunc() {
        DynamicObjectCollection operationentryData = this.getModel().getEntryEntity("operationentry");
        for (int i = 0; i < operationentryData.size(); ++i) {
            MainEntityType type;
            String mainOrg;
            DynamicObject dynamicObject = (DynamicObject)operationentryData.get(i);
            String business = dynamicObject.getString("bussiness");
            if (business == null || business.trim().isEmpty() || (mainOrg = (type = EntityMetadataCache.getDataEntityType((String)dynamicObject.getString("bussiness"))).getMainOrg()) == null || mainOrg.trim().length() <= 0) continue;
            MainOrgProp findProperty = (MainOrgProp)type.findProperty(mainOrg);
            String orgFunc = findProperty.getOrgFunc();
            return orgFunc;
        }
        return null;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        AbstractOperate oper;
        super.beforeDoOperation(args);
        if (args.getSource() instanceof AbstractOperate && (oper = (AbstractOperate)args.getSource()).getOperateKey().equals("save")) {
            if (!this.checkDraft()) {
                args.cancel = true;
            }
            IDataModel model = this.getModel();
            DynamicObjectCollection dynColl = model.getEntryEntity("operationentry");
            dynColl.forEach(v -> {
                if (String.valueOf(v.getString("datafilter_tag")).length() == 0) {
                    v.set("datafilter_tag", (Object)v.getString("datafilter"));
                }
                v.set("datafilter", (Object)"");
            });
        }
    }

    private boolean checkDraft() {
        IDataModel datamodel = this.getModel();
        int operRowCount = datamodel.getEntryRowCount("operationentry");
        String errMsg = null;
        Object number = datamodel.getValue("number");
        String errField = null;
        for (int i = 0; i < REQUIRED_FIELDS.length; ++i) {
            String field = REQUIRED_FIELDS[i][0];
            Object val = this.getModel().getValue(field);
            if (val != null && !StringUtils.isBlank((Object)val)) continue;
            FieldEdit control = (FieldEdit)this.getControl(REQUIRED_FIELDS[i][1]);
            errField = control.getProperty().getDisplayName().toString();
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"IntellExceSchemaEdit_1", (String)"fi-iep-formplugin", (Object[])new Object[0]), errField));
            control.setFocus(true);
            return false;
        }
        if (!((DynamicObjectCollection)datamodel.getValue("notificationusers")).isEmpty() && StringUtils.isEmpty((CharSequence)((String)datamodel.getValue(KEY_MSG_SENDTYPES)))) {
            FieldEdit control = (FieldEdit)this.getControl(KEY_MSG_SENDTYPES);
            control.setFocus(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6d88\u606f\u53d1\u9001\u65b9\u5f0f\u3002", (String)"IntellExceSchemaEdit_2", (String)"fi-iep-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (operRowCount < 1) {
            errMsg = ResManager.loadKDString((String)"\u8bf7\u6dfb\u52a0\u64cd\u4f5c\u3002", (String)"IntellExceSchemaEdit_3", (String)"fi-iep-formplugin", (Object[])new Object[0]);
        } else if (operRowCount > 0) {
            HashSet<String> businessSet = new HashSet<String>();
            for (int i = 0; i < operRowCount; ++i) {
                Object bussiness = datamodel.getValue("bussiness", i);
                Object oper = datamodel.getValue("oper", i);
                if (bussiness == null || oper == null) {
                    errMsg = String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u6570\u636e\u4e0d\u5b8c\u6574\u3002", (String)"IntellExceSchemaEdit_5", (String)"fi-iep-formplugin", (Object[])new Object[0]), i + 1);
                    break;
                }
                String key = bussiness.toString() + oper.toString();
                if (businessSet.contains(key)) {
                    errMsg = String.format(ResManager.loadKDString((String)"\u3010\u6267\u884c\u64cd\u4f5c\u3011\u4e2d\u5b58\u5728\u91cd\u590d\u6570\u636e\uff0c\u884c\u53f7\uff1a%s", (String)"IntellExceSchemaEdit_7", (String)"fi-iep-formplugin", (Object[])new Object[0]), i + 1);
                    break;
                }
                businessSet.add(key);
            }
        }
        if (errMsg != null) {
            this.getView().showErrorNotification(errMsg);
            return false;
        }
        long id = (Long)datamodel.getValue("id");
        DynamicObject checkNumber = QueryServiceHelper.queryOne((String)"gl_intellexecschema", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("number", "=", number)});
        if (checkNumber != null && id != checkNumber.getLong("id")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u673a\u5668\u4eba\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u3002", (String)"IntellExceSchemaEdit_8", (String)"fi-iep-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        if (afterDoOperationEventArgs.getOperationResult() == null) {
            return;
        }
        if (afterDoOperationEventArgs.getOperationResult().isSuccess() && afterDoOperationEventArgs.getOperateKey().equals("save")) {
            String newValueStr;
            String sheduleplanid = (String)this.getModel().getValue("sheduleplanid");
            if (StringUtils.isBlank((CharSequence)sheduleplanid)) {
                return;
            }
            DynamicObject sch = BusinessDataServiceHelper.loadSingle((Object)sheduleplanid, (String)"sch_schedule");
            sch.set("name", this.getModel().getValue("name"));
            DynamicObject schJob = sch.getDynamicObject("job");
            if (schJob == null) {
                return;
            }
            DynamicObject job = BusinessDataServiceHelper.loadSingle((Object)schJob.get("id"), (String)"sch_job");
            if (job == null) {
                return;
            }
            Lang lang = RequestContext.get().getLang();
            job.set("runbylang", (Object)lang.toString());
            job.set("runconcurrent", (Object)Boolean.FALSE);
            IBillModel billmodel = (IBillModel)this.getModel();
            String appId = this.getAppId(billmodel, null);
            job.set("classname", (Object)appId);
            job.set("taskclassname", (Object)this.getExecClassName(appId));
            String oldValue = this.getPageCache().get("executorId");
            IDataModel dataModel = this.getModel();
            Object newValue = dataModel.getValue("executor_id");
            String string = newValueStr = StringUtils.isBlank((Object)newValue) ? "0" : newValue.toString();
            if (!newValueStr.equals(oldValue)) {
                MainEntityType userType = EntityMetadataCache.getDataEntityType((String)"bos_user");
                DynamicObject userInfo = new DynamicObject((DynamicObjectType)userType);
                userInfo.set("id", (Object)Long.valueOf(newValueStr));
                job.set("name", this.getModel().getValue("name"));
                job.set("runbyuser", (Object)userInfo);
                this.getPageCache().put("executorId", newValueStr);
            }
            OperationServiceHelper.executeOperate((String)"save", (String)"sch_schedule", (DynamicObject[])new DynamicObject[]{sch}, (OperateOption)OperateOption.create());
            OperationServiceHelper.executeOperate((String)"save", (String)"sch_job", (DynamicObject[])new DynamicObject[]{job}, (OperateOption)OperateOption.create());
        }
    }

    private void addOperation() {
        HashMap<String, Object> defOperData = null;
        IDataModel dataMoel = this.getModel();
        int rowcount = dataMoel.getEntryRowCount("operationentry");
        if (rowcount > 0) {
            defOperData = new HashMap<String, Object>();
            Object appidObj = dataMoel.getValue("appid", 0);
            if (appidObj instanceof DynamicObject) {
                defOperData.put("appid", ((DynamicObject)appidObj).get("id"));
            } else {
                defOperData.put("appid", appidObj);
            }
        }
        this.openOperationUI("newoper", defOperData, "add");
    }

    private void modifyOperation(int index) {
        Map<String, Object> curOperData = this.getCurrentOperation(index);
        QFilter[] qf = new QFilter[]{new QFilter("bizapp", "=", curOperData.get("appid")), new QFilter("bussiness", "=", curOperData.get("bussiness")), new QFilter("oper", "=", curOperData.get("oper"))};
        this.openOperationUI("modifyoper", curOperData, "modify");
    }

    private void openOperationUI(String closeActionID, Map<String, Object> customParam, String oper) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("gl_intellexecshemaoper");
        if (customParam != null && !customParam.isEmpty()) {
            parameter.setCustomParam("oper", (Object)oper);
            parameter.setCustomParam("initdata", customParam);
        }
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, closeActionID));
        this.getView().showForm(parameter);
    }

    private Map<String, Object> getCurrentOperation(int rowIndex) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        IDataModel dataMoel = this.getModel();
        Object appidObj = dataMoel.getValue("appid", rowIndex);
        if (appidObj instanceof DynamicObject) {
            map.put("appid", ((DynamicObject)appidObj).get("id"));
        } else {
            map.put("appid", appidObj);
        }
        map.put("bussiness", dataMoel.getValue("bussiness", rowIndex));
        map.put("oper", dataMoel.getValue("oper", rowIndex));
        map.put("datafilter", dataMoel.getValue("datafilter", rowIndex));
        if (String.valueOf(dataMoel.getValue("datafilter_tag")).length() == 0) {
            map.put("datafilter_tag", dataMoel.getValue("datafilter", rowIndex));
        } else {
            map.put("datafilter", dataMoel.getValue("datafilter_tag", rowIndex));
        }
        map.put("remark", dataMoel.getValue("remark", rowIndex));
        map.put("issingle", dataMoel.getValue("issingle", rowIndex));
        map.put("eachbatchsize", dataMoel.getValue("eachbatchsize", rowIndex));
        map.put("groupbyscoll", dataMoel.getValue("groupbyscoll", rowIndex));
        Object paramObj = dataMoel.getValue("param", rowIndex);
        if (!StringUtils.isBlank((Object)paramObj)) {
            map.put("param", JSONObject.parseObject((String)paramObj.toString(), Map.class));
        }
        return map;
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        if (e.getReturnData() == null) {
            return;
        }
        IDataModel dataModel = this.getModel();
        if (e.getActionId().equals("newoper")) {
            int rowIndex = this.getModel().createNewEntryRow("operationentry");
            Map op = (Map)e.getReturnData();
            this.putOperRowData(rowIndex, op);
        } else if (!e.getActionId().equals("editoper")) {
            if (e.getActionId().equals("addorg")) {
                Object[] pk = this.getSelectedEntryPK(e);
                int i = 0;
                DynamicObject orgIndex = (DynamicObject)dataModel.getValue(KEY_ORG, 0);
                if (orgIndex == null || orgIndex.getLong("id") == 0L) {
                    dataModel.deleteEntryData("orgentryentity");
                }
                int count = dataModel.getEntryRowCount("orgentryentity");
                HashMap filterMap = new HashMap();
                while (i < count) {
                    DynamicObject org = (DynamicObject)dataModel.getValue(KEY_ORG, i);
                    if (org != null) {
                        filterMap.put(org.get("id"), null);
                    }
                    ++i;
                }
                ArrayList<Object> newOrgList = new ArrayList<Object>();
                for (i = 0; i < pk.length; ++i) {
                    if (filterMap.containsKey(pk[i])) continue;
                    newOrgList.add(pk[i]);
                }
                if (newOrgList.size() == 0) {
                    return;
                }
                int[] rowIndexs = dataModel.batchCreateNewEntryRow("orgentryentity", newOrgList.size());
                for (i = 0; i < rowIndexs.length; ++i) {
                    dataModel.setValue(KEY_ORG, newOrgList.get(i), rowIndexs[i]);
                }
            } else if (e.getActionId().equals("newshedule")) {
                Object rtn = e.getReturnData();
                if (rtn != null) {
                    DynamicObject scheduleInfo = (DynamicObject)rtn;
                    Date endtime = scheduleInfo.getDate("endtime");
                    String planid = (String)scheduleInfo.get("id");
                    this.getModel().setValue("sheduleplanid", (Object)planid);
                    String txtdesc = (String)scheduleInfo.get("txtdesc");
                    if (StringUtils.isNotEmpty((CharSequence)txtdesc) && txtdesc.length() > 153) {
                        txtdesc = txtdesc.substring(0, 150) + "...";
                    }
                    this.getModel().setValue("exceplan", (Object)txtdesc);
                    LocaleString localeString = new LocaleString(txtdesc);
                    localeString.setLocaleValue_zh_TW(STConverter.sc2tc((String)txtdesc));
                    this.getModel().setValue("exceplanlang", (Object)localeString);
                    this.getModel().setValue("endtime", (Object)endtime);
                    this.getModel().setValue(STOPTIMERANGE_STARTTIME, (Object)scheduleInfo.getInt(STOPTIMERANGE_STARTTIME));
                    this.getModel().setValue(STOPTIMERANGE_ENDTIME, (Object)scheduleInfo.getInt(STOPTIMERANGE_ENDTIME));
                    this.getModel().setValue(FAIL_RETRY_STRATEGY_KEY, (Object)scheduleInfo.getString(FAIL_RETRY_STRATEGY_KEY));
                }
            } else if ("modifyoper".equals(e.getActionId())) {
                int rowIndex = this.getModel().getEntryCurrentRowIndex("operationentry");
                Map op = (Map)e.getReturnData();
                this.putOperRowData(rowIndex, op);
            }
        }
    }

    private void putOperRowData(int rowIndex, Map<String, Object> op) {
        IDataModel dataModel = this.getModel();
        String appid = (String)op.get("bizapp");
        dataModel.setValue("appid", (Object)appid, rowIndex);
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"orgtoolbarap"});
        this.getView().setEnable(Boolean.valueOf(true), new String[]{"advconap1"});
        String[] bussiness = (String[])op.get("bussiness");
        if (bussiness != null && bussiness.length == 3) {
            dataModel.setValue("bussiness", (Object)bussiness[0], rowIndex);
            dataModel.setValue("entity", (Object)bussiness[1], rowIndex);
            dataModel.setValue("bussinessname", (Object)bussiness[2], rowIndex);
        }
        Map operValueMap = (Map)op.get("oper");
        for (Map.Entry entry : operValueMap.entrySet()) {
            dataModel.setValue("oper", entry.getKey(), rowIndex);
            dataModel.setValue("opername", entry.getValue(), rowIndex);
        }
        dataModel.setValue("opertitle", dataModel.getValue("opername", rowIndex), rowIndex);
        dataModel.setValue("datafilter_tag", op.get("datafilter"), rowIndex);
        dataModel.setValue("remark", op.get("remark"), rowIndex);
        dataModel.setValue("issingle", op.get("issingle"), rowIndex);
        dataModel.setValue("eachbatchsize", op.get("eachbatchsize"), rowIndex);
        dataModel.setValue("groupbyscoll", op.get("groupbyscoll"), rowIndex);
        Object paramObj = op.get("operParam");
        if (paramObj != null) {
            Map operParam = (Map)paramObj;
            dataModel.setValue("param", (Object)JSONObject.toJSONString((Object)operParam), rowIndex);
        }
    }

    private Object[] getSelectedEntryPK(ClosedCallBackEvent e) {
        ListSelectedRowCollection rowDataCol = (ListSelectedRowCollection)e.getReturnData();
        Object[] pk = new Object[rowDataCol.size()];
        for (int i = 0; i < rowDataCol.size(); ++i) {
            ListSelectedRow selectrow = rowDataCol.get(i);
            if (StringUtils.isBlank((Object)selectrow.getPrimaryKeyValue())) continue;
            pk[i] = selectrow.getPrimaryKeyValue();
        }
        return pk;
    }

    protected void initUserInfo() {
        long id = (Long)this.getModel().getValue("id");
        DynamicObject user = null;
        if (id != 0L) {
            user = (DynamicObject)this.getModel().getValue("modifier");
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"creatoravatar"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"modifieravatar"});
        } else {
            user = (DynamicObject)this.getModel().getValue("creator");
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"creatoravatar"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"modifieravatar"});
        }
        if (user == null) {
            return;
        }
        DynamicObjectCollection cols = QueryServiceHelper.query((String)"gl.GLIndexPlugin.getMyVoucher", (String)"bos_user", (String)"id,name,phone,picturefield,entryentity.dpt.id,entryentity.dpt.name", (QFilter[])new QFilter[]{new QFilter("id", "=", user.get("id"))}, null);
        if (cols == null || cols.isEmpty()) {
            return;
        }
        DynamicObject userInfo = (DynamicObject)cols.get(0);
        ((Label)this.getControl("personname")).setText(userInfo.getString("name"));
        ((Label)this.getControl("persondpt")).setText(userInfo.getString("entryentity.dpt.name"));
        ((Label)this.getControl("personphone")).setText(userInfo.getString("phone"));
        int count = GLFabulousOperation.getFabulousOne(userInfo.getLong("id"), null, false, true);
        ((Label)this.getControl("fabulous")).setText(count + "");
        if (!GLFabulousOperation.isThumbUp(userInfo.getLong("id"), "gl_intellexecschema")) {
            ((Image)this.getControl("fabulousimage")).setUrl("/icons/pc/state/praised.png");
        }
    }

    private void doFabulous() {
        DynamicObject user = (DynamicObject)this.getModel().getValue("creator");
        if (user == null) {
            return;
        }
        long userid = user.getLong("id");
        if (GLFabulousOperation.isCanThumbUp(userid, "gl_intellexecschema")) {
            GLFabulousOperation.createFabulous(userid, "gl_intellexecschema");
            int count = GLFabulousOperation.getFabulousOne(userid, "gl_intellexecschema", false, true);
            ((Label)this.getControl("fabulous")).setText(count + "");
            ((Image)this.getControl("fabulousimage")).setUrl("/icons/pc/state/praised.png");
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        if (KEY_ORG.equals(name)) {
            ListShowParameter showParam = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            showParam.setMultiSelect(Boolean.TRUE.booleanValue());
            showParam.setCustomParam("orgFuncId", (Object)this.getBillsMainOrgFunc());
            showParam.getListFilterParameter().getQFilters().add(this.getSelectOrg());
        }
    }

    private QFilter getSelectOrg() {
        DynamicObjectCollection orgInfo = this.getModel().getEntryEntity("orgentryentity");
        ArrayList<Object> list = new ArrayList<Object>(orgInfo.size());
        for (int i = 0; i < orgInfo.size(); ++i) {
            list.add(((DynamicObject)orgInfo.get(i)).get("orgid_id"));
        }
        return new QFilter("id", "not in", list);
    }

    private boolean checkScheduleOrTips(Long id, String scheduleId) {
        if (!OpenBillUtils.isExistSchedule(id, scheduleId)) {
            String msg = ResManager.loadKDString((String)"\u667a\u80fd\u65b9\u6848\u4f9d\u8d56\u7684\u8c03\u5ea6\u8ba1\u5212\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u8c03\u5ea6\u8ba1\u5212\u3002", (String)"IntellExceSchemaEdit_10", (String)"fi-iep-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(msg);
            return true;
        }
        return false;
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        IDataModel dataModel = this.getModel();
        this.setCardTitleName(dataModel);
        this.initNotificationTypes();
        this.initUserInfo();
        Object executorId = dataModel.getValue("executor_id");
        this.getPageCache().put("executorId", StringUtils.isBlank((Object)executorId) ? "0" : executorId.toString());
        LicenseCheckResult result = LicenseServiceHelper.checkPerformGroup((String)"PRO_IEP");
        if (!result.getHasLicense().booleanValue()) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"conentpanel", "titleapanel"});
            this.getView().showMessage(result.getMsg());
        }
        if (this.getModel().getEntryRowEntity("operationentry", 0) == null) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"advconap1"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"orgtoolbarap"});
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"orgtoolbarap"});
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"advconap1"});
        }
        if (SingleOrgContextHelper.isSingleOrgManageMode()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"advconap1"});
        }
    }

    private void initNotificationTypes() {
        Map msgChanelsMap = BusinessDataServiceHelper.loadFromCache((String)"msg_channel", (String)"id,number,name,enable", null);
        ArrayList<ComboItem> list = new ArrayList<ComboItem>(msgChanelsMap.size() + 1);
        msgChanelsMap.values().forEach(msgChanel -> {
            if (msgChanel.getBoolean("enable") && !"sysnotice".equalsIgnoreCase(msgChanel.getString("number"))) {
                ComboItem comboItem = new ComboItem();
                comboItem.setValue(msgChanel.getString("number"));
                comboItem.setCaption(new LocaleString(msgChanel.getString("name")));
                list.add(comboItem);
            }
        });
        list.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u6d88\u606f\u4e2d\u5fc3", (String)"IntellExceSchemaEdit_11", (String)"fi-iep-formplugin", (Object[])new Object[0])), "mcenter"));
        list.sort(Comparator.comparing(ComboItem::getValue));
        ComboEdit combo = (ComboEdit)this.getView().getControl(KEY_MSG_SENDTYPES);
        combo.setComboItems(list);
    }
}

