/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.iep.formplugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dataentity.utils.Uuid16;
import kd.bos.dlock.DLock;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.license.api.LicenseCheckResult;
import kd.bos.list.BillList;
import kd.bos.list.DateListColumn;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.schedule.executor.JobClient;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.fi.iep.dao.IntellAccountSchemaExecLogDao;
import kd.fi.iep.info.IntellSchemeExecInfo;
import kd.fi.iep.util.ContextUtil;
import kd.fi.iep.util.LogORMHelper;

public class IntellExceSchemaList
extends AbstractListPlugin {
    private static final String LOCK_KEY_PRE = "IntellExecPlanKey";

    public void initialize() {
        super.initialize();
        this.addItemClickListeners(new String[]{"executeschema", "stopexecute", "clearcache"});
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        String formatStr = InteServiceHelper.getDateFormat((Long)Long.valueOf(RequestContext.get().getUserId()));
        DateListColumn column = (DateListColumn)args.getListColumn("endtime");
        column.setDisplayFormatString(formatStr);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        String appId = AppMetadataCache.getAppInfo((String)"iep").getId();
        if ("executeschema".equals(key)) {
            HasPermOrgResult res = PermissionServiceHelper.getAllPermOrgs((Long)ContextUtil.getUserId(), (String)appId, (String)"gl_intellexecschema", (String)"/KT5ME2G3V98");
            if (!res.hasAllOrgPerm() && res.getHasPermOrgs().isEmpty()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u64cd\u4f5c\u6743\u9650\u3002", (String)"IntellExceSchemaList_0", (String)"fi-iep-formplugin", (Object[])new Object[0]));
                return;
            }
            ListSelectedRowCollection selectedRows = ((BillList)this.getControl("billlistap")).getSelectedRows();
            if (selectedRows.size() < 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u65b9\u6848\u6267\u884c\u3002", (String)"IntellExceSchemaList_1", (String)"fi-iep-formplugin", (Object[])new Object[0]));
                return;
            }
            StringBuilder buf = new StringBuilder();
            HashSet<DynamicObject> schemaDyns = new HashSet<DynamicObject>(selectedRows.size());
            for (ListSelectedRow selectedRow : selectedRows) {
                long primaryKey = (Long)selectedRow.getPrimaryKeyValue();
                DynamicObject data = BusinessDataServiceHelper.loadSingle((Object)primaryKey, (String)"gl_intellexecschema");
                String enable = data.getString("enable");
                if (enable == null || "0".equals(enable)) {
                    String name = data.getString("name");
                    buf.append(name);
                    buf.append('\u3001');
                    continue;
                }
                schemaDyns.add(data);
            }
            String errorInfo = buf.toString();
            if (!"".equals(errorInfo)) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u6267\u884c\u65b9\u6848\u5931\u8d25: %s \u4e3a\u7981\u7528\u72b6\u6001", (String)"IntellExceSchemaList_2", (String)"fi-iep-formplugin", (Object[])new Object[0]), errorInfo.substring(0, errorInfo.length() - 1)));
                return;
            }
            for (DynamicObject dyn : schemaDyns) {
                this.excutePlanAsyn(dyn);
            }
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6210\u529f\uff0c\u65b9\u6848\u5df2\u7ecf\u5f00\u59cb\u6267\u884c", (String)"IntellExceSchemaList_4", (String)"fi-iep-formplugin", (Object[])new Object[0]));
            return;
        } else if ("stopexecute".equals(key)) {
            ListSelectedRowCollection selectedRows = ((BillList)this.getControl("billlistap")).getSelectedRows();
            if (selectedRows.size() != 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u65b9\u6848\u6682\u505c\u3002", (String)"IntellExceSchemaList_5", (String)"fi-iep-formplugin", (Object[])new Object[0]));
                return;
            }
            long schemaId = (Long)selectedRows.get(0).getPrimaryKeyValue();
            HashMap<String, Object> processMap = new HashMap<String, Object>();
            this.setStopFlag(schemaId);
            if (this.isExecute(schemaId, processMap)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u6267\u884c\u4e2d\u6b62\u64cd\u4f5c\uff0c\u5728\u672c\u6279\u6b21\u6267\u884c\u5b8c\u540e\uff0c\u5c06\u4e2d\u6b62\u667a\u80fd\u65b9\u6848\u6267\u884c\u3002", (String)"IntellExceSchemaList_11", (String)"fi-iep-formplugin", (Object[])new Object[0]));
                try (DLock lock = DLock.create((String)(LOCK_KEY_PRE + schemaId)).fastMode();){
                    if (!lock.tryLock()) return;
                    IntellSchemeExecInfo.removeIntellExecInfo((long)schemaId);
                    IntellAccountSchemaExecLogDao.uptateSchemaSumLog(processMap);
                    return;
                }
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u65b9\u6848\u5df2\u6267\u884c\u5b8c\u6210\u3002", (String)"IntellExceSchemaList_6", (String)"fi-iep-formplugin", (Object[])new Object[0]));
            }
            return;
        } else {
            if (!"tbldel".equals(key)) return;
            HasPermOrgResult res = PermissionServiceHelper.getAllPermOrgs((Long)ContextUtil.getUserId(), (String)appId, (String)"gl_intellexecschema", (String)"4715e1f1000000ac");
            if (!res.hasAllOrgPerm() && res.getHasPermOrgs().isEmpty()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u64cd\u4f5c\u6743\u9650\u3002", (String)"IntellExceSchemaList_0", (String)"fi-iep-formplugin", (Object[])new Object[0]));
                return;
            }
            IListView listView = (IListView)this.getView();
            ListSelectedRowCollection selectedRows = listView.getSelectedRows();
            if (selectedRows.size() < 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e00\u6761\u65b9\u6848", (String)"IntellExceSchemaList_7", (String)"fi-iep-formplugin", (Object[])new Object[0]));
                return;
            }
            if (this.isSchemeRuning(selectedRows)) {
                return;
            }
            ConfirmCallBackListener confirmCallBacks1 = new ConfirmCallBackListener("tbldel", (IFormPlugin)this);
            String strDeleteConfirmTip = String.format(ResManager.loadKDString((String)"\u5220\u9664\u9009\u4e2d\u7684%d\u6761\u8bb0\u5f55\u540e\u5c06\u65e0\u6cd5\u6062\u590d\uff0c\u786e\u5b9a\u8981\u5220\u9664\u8be5\u8bb0\u5f55\u5417\uff1f", (String)"IntellExceSchemaList_8", (String)"fi-iep-formplugin", (Object[])new Object[0]), selectedRows.size());
            this.getView().showConfirm(strDeleteConfirmTip, MessageBoxOptions.OKCancel, ConfirmTypes.Delete, confirmCallBacks1);
        }
    }

    private boolean isSchemeRuning(ListSelectedRowCollection selectedRows) {
        StringBuilder error = new StringBuilder();
        for (ListSelectedRow row : selectedRows) {
            Long primaryKeyValue = (Long)row.getPrimaryKeyValue();
            DLock lock = DLock.create((String)(LOCK_KEY_PRE + primaryKeyValue)).fastMode();
            Throwable throwable = null;
            try {
                if (lock.tryLock()) continue;
                error.append(row.getName()).append(',');
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (lock == null) continue;
                if (throwable != null) {
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                lock.close();
            }
        }
        if (error.length() > 1) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\uff1a\u8be5\u667a\u80fd\u65b9\u6848\u6b63\u5728\u6267\u884c\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"IntellExceSchemaList_12", (String)"fi-iep-formplugin", (Object[])new Object[0]), error.substring(0, error.toString().length() - 1)));
            return true;
        }
        return false;
    }

    public void confirmCallBack(MessageBoxClosedEvent arg0) {
        super.confirmCallBack(arg0);
        if ("tbldel".equalsIgnoreCase(arg0.getCallBackId()) && MessageBoxResult.Yes.equals((Object)arg0.getResult())) {
            StringBuilder error = new StringBuilder();
            ListSelectedRowCollection selectedRows = ((BillList)this.getControl("billlistap")).getSelectedRows();
            OperationResult resultAll = new OperationResult();
            resultAll.setBillCount(selectedRows.size());
            for (ListSelectedRow singleRow : selectedRows) {
                long schemaId = (Long)singleRow.getPrimaryKeyValue();
                DynamicObject singleRowDb = BusinessDataServiceHelper.loadSingle((Object)schemaId, (String)"gl_intellexecschema");
                if ("0".equals(singleRowDb.getString("enable"))) {
                    error.append(singleRowDb.getString("number"));
                    error.append(',');
                    continue;
                }
                QFilter idListFilter = new QFilter("intelschemaid", "=", (Object)schemaId);
                QFilter[] filters = new QFilter[]{idListFilter};
                DeleteServiceHelper.delete((String)"gl_intellopersumlog", (QFilter[])filters);
                DeleteServiceHelper.delete((String)"gl_intelschemasumlog", (QFilter[])filters);
                LogORMHelper.delete((String)"iep_intellexecdetaillog", (QFilter[])filters);
                QFilter filterLog = new QFilter("entryentity.intelschemaid", "=", (Object)schemaId);
                DeleteServiceHelper.delete((String)"iep_todaycomplete", (QFilter[])filterLog.toArray());
                Object sheduleplanid = singleRowDb.get("sheduleplanid");
                OperationResult result = OperationServiceHelper.executeOperate((String)"delete", (String)"gl_intellexecschema", (Object[])new Object[]{schemaId}, (OperateOption)OperateOption.create());
                if (result.isSuccess()) {
                    this.deleteSch(sheduleplanid);
                    this.setStopFlag(schemaId);
                    resultAll.getSuccessPkIds().add(schemaId);
                    continue;
                }
                resultAll.getAllErrorInfo().addAll(result.getAllErrorInfo());
            }
            if (resultAll.getAllErrorInfo().size() > 0) {
                this.getView().showOperationResult(resultAll);
            } else if (error.length() <= 0) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f", (String)"IntellExceSchemaList_9", (String)"fi-iep-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\uff1a\u6570\u636e\u5df2\u7ecf\u7981\u7528\uff0c\u4e0d\u80fd\u88ab\u5220\u9664\u3002", (String)"IntellExceSchemaList_10", (String)"fi-iep-formplugin", (Object[])new Object[0]), error.toString().substring(0, error.toString().length() - 1)));
            }
            IListView listView = (IListView)this.getView();
            BillList list = (BillList)this.getControl("billlistap");
            listView.refresh();
            list.clearSelection();
        }
    }

    private void deleteSch(Object sheduleplanid) {
        QFilter qf = new QFilter("id", "=", sheduleplanid);
        DynamicObjectCollection jobColl = QueryServiceHelper.query((String)"sch_schedule", (String)"job", (QFilter[])new QFilter[]{qf});
        OperationServiceHelper.executeOperate((String)"delete", (String)"sch_schedule", (Object[])new Object[]{sheduleplanid}, null);
        for (DynamicObject jobDb : jobColl) {
            OperationServiceHelper.executeOperate((String)"delete", (String)"sch_job", (Object[])new Object[]{jobDb.getString("job")}, null);
        }
    }

    private void excutePlanAsyn(DynamicObject dyn) {
        RequestContext rc = RequestContext.get();
        ArrayList<Long> schemaIdListNew = new ArrayList<Long>();
        schemaIdListNew.add(dyn.getLong("id"));
        DynamicObject schemaDb = dyn.getDynamicObject("executor");
        JobInfo job = new JobInfo();
        job.setRunByLang(rc.getLang());
        job.setJobType(JobType.BIZ);
        job.setName(rc.getUserName() + " execute job");
        job.setId(Uuid16.create().toString());
        if (schemaDb == null || schemaDb.getLong("id") == 0L) {
            job.setRunByUserId(Long.parseLong(rc.getUserId()));
        } else {
            job.setRunByUserId(schemaDb.getLong("id"));
        }
        job.setTaskClassname("kd.fi.iep.task.IntellExceTask");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("intellSchemaidList", this.createJobParam(schemaIdListNew));
        params.put("type", "1");
        job.setParams(params);
        DynamicObject operDyn = (DynamicObject)dyn.getDynamicObjectCollection("operationentry").get(0);
        String number = "iep";
        if (null != operDyn) {
            number = ((DynamicObject)operDyn.get("appid")).getString("number");
        }
        job.setAppId(number);
        job.setRunConcurrently(false);
        JobClient.dispatch((JobInfo)job);
    }

    private List<Object> createJobParam(List<Long> schemaIdList) {
        ArrayList<Object> list = new ArrayList<Object>(schemaIdList.size());
        for (Long id : schemaIdList) {
            HashMap<String, Long> map = new HashMap<String, Long>();
            map.put("Id", id);
            list.add(map);
        }
        return list;
    }

    private boolean isExecute(long schemaId, Map<String, Object> processMap) {
        QFilter statusFilter = new QFilter("execstatus", "=", (Object)"1");
        QFilter idFilter = new QFilter("intelschemaid", "=", (Object)schemaId);
        QFilter[] filters = new QFilter[]{statusFilter, idFilter};
        DynamicObjectCollection processSchemaList = QueryServiceHelper.query((String)"gl_intelschemasumlog", (String)"id,intelschemaid", (QFilter[])filters);
        if (processSchemaList != null && !processSchemaList.isEmpty()) {
            QFilter schemasumlogidFilter = new QFilter("schemasumlogid", "=", ((DynamicObject)processSchemaList.get(0)).get("id"));
            QFilter[] operFilters = new QFilter[]{statusFilter, schemasumlogidFilter};
            DynamicObjectCollection processOperList = QueryServiceHelper.query((String)"gl_intellopersumlog", (String)"sum(billqty) billsumqty,sum(successbillqty) successbillsumqty,sum(failbillqty) failbillsumqty", (QFilter[])operFilters);
            processMap.put("billqty", ((DynamicObject)processOperList.get(0)).get("billsumqty"));
            processMap.put("successbillqty", ((DynamicObject)processOperList.get(0)).get("successbillsumqty"));
            processMap.put("failbillqty", ((DynamicObject)processOperList.get(0)).get("failbillsumqty"));
            processMap.put("schemasumlogid", ((DynamicObject)processSchemaList.get(0)).get("id"));
            return true;
        }
        return false;
    }

    private void setStopFlag(long schemaId) {
        IAppCache cache = AppCache.get((String)"iep");
        cache.put(this.getCacheKey(schemaId), (Object)"stop");
    }

    private String getCacheKey(long schemaId) {
        return "iep-intllaccountschema-" + schemaId + "stop-flag";
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof AbstractOperate) {
            LicenseCheckResult result;
            AbstractOperate oper = (AbstractOperate)args.getSource();
            if (oper.getOperateKey().equals("delete")) {
                MainEntityType type;
                ListSelectedRowCollection selectedRows = ((BillList)this.getControl("billlistap")).getSelectedRows();
                Object id = selectedRows.get(0).getPrimaryKeyValue();
                DynamicObject[] dobjs = BusinessDataServiceHelper.load((Object[])new Object[]{id}, (DynamicObjectType)(type = EntityMetadataCache.getDataEntityType((String)oper.getEntityId())));
                if (dobjs == null || dobjs.length <= 0) {
                    return;
                }
                Object sheduleplanid = dobjs[0].get("sheduleplanid");
                BusinessDataWriter.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"sch_schedule"), (Object[])new Object[]{sheduleplanid});
            } else if ((oper.getOperateKey().equals("new") || oper.getOperateKey().equals("copy")) && !(result = LicenseServiceHelper.checkPerformGroup((String)"PRO_IEP")).getHasLicense().booleanValue()) {
                String msg = result.getMsg();
                this.getView().showMessage(msg);
                args.cancel = true;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        String operateKey = evt.getOperateKey();
        if ("disable".equals(operateKey) || "enable".equals(operateKey)) {
            this.handleScheduleAndJobStatus(evt, operateKey);
        }
    }

    private void handleScheduleAndJobStatus(AfterDoOperationEventArgs evt, String operateKey) {
        List successPkIds = evt.getOperationResult().getSuccessPkIds();
        if (successPkIds != null && !successPkIds.isEmpty()) {
            HashSet<String> scheduleIds = new HashSet<String>(10);
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)"fi_iep_intellaccountschema", (String)"gl_intellexecschema", (String)"id,sheduleplanid", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)successPkIds)}, null);){
                for (Row row : ds) {
                    String scheduId = row.getString("sheduleplanid");
                    if (!StringUtils.isNotEmpty((CharSequence)scheduId)) continue;
                    scheduleIds.add(scheduId);
                }
            }
            if (!scheduleIds.isEmpty()) {
                MainEntityType type = EntityMetadataCache.getDataEntityType((String)"sch_schedule");
                DynamicObject[] dySchedules = BusinessDataServiceHelper.load((Object[])scheduleIds.toArray(), (DynamicObjectType)type);
                String status = "enable".equals(operateKey) ? "1" : "0";
                for (DynamicObject dySchedule : dySchedules) {
                    dySchedule.set("status", (Object)status);
                    ScheduleManager scheduleManager = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
                    boolean isEnable = "enable".equals(operateKey);
                    String scheduleId = (String)dySchedule.getPkValue();
                    if (isEnable) {
                        scheduleManager.enableSchedule(scheduleId);
                        continue;
                    }
                    scheduleManager.disableSchedule(scheduleId);
                }
                OperationServiceHelper.executeOperate((String)"save", (String)"sch_schedule", (DynamicObject[])dySchedules, (OperateOption)OperateOption.create());
            }
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        LicenseCheckResult result = LicenseServiceHelper.checkPerformGroup((String)"PRO_IEP");
        if (!result.getHasLicense().booleanValue()) {
            String msg = result.getMsg();
            this.getView().showMessage(msg);
            e.getQFilters().add(new QFilter("1", "!=", (Object)"1"));
        }
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        LicenseCheckResult result = LicenseServiceHelper.checkPerformGroup((String)"PRO_IEP");
        if (!result.getHasLicense().booleanValue()) {
            String msg = result.getMsg();
            e.setCancel(true);
            e.setCancelMessage(msg);
            e.setCancelFormShowParameter(result.getCancelFormShowParameter());
        } else {
            super.preOpenForm(e);
        }
    }
}

