/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.iep.formplugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.filter.events.SetFilterContainerBaseDataSearchClosedEvent;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.iep.util.IntellSchemaAndDetailsProvider;
import kd.fi.iep.util.LogORMHelper;
import kd.fi.iep.util.OpenBillUtils;

public class IntellExcelSumLogListPlugin
extends AbstractListPlugin {
    private Map<String, Integer> newestRowindex = new HashMap<String, Integer>(1);
    private static final String newestRowindexCache = "newestRowindexCache";
    private static final String KEY_FILTER = "filter";

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        args.setCancel(true);
        String fieldName = args.getFieldName();
        Long id = (Long)((BillList)this.getControl("billlistap")).getFocusRowPkId();
        DynamicObject dyn = BusinessDataServiceHelper.loadSingle((Object)id, (String)"gl_intelschemasumlog");
        this.openFormByField(fieldName, dyn);
    }

    private void openFormByField(String fieldId, DynamicObject dyn) {
        IFormView view = this.getView();
        HashMap<String, BiConsumer<IFormView, DynamicObject>> map = new HashMap<String, BiConsumer<IFormView, DynamicObject>>(4);
        map.put("intelschemaid_number", OpenBillUtils::openSchema);
        map.put("quantity", OpenBillUtils::openExecOperLog);
        map.put("execstatus", OpenBillUtils::openExecOperDetailLog);
        map.put("failsumquantity", OpenBillUtils::openExecDetailLog);
        ((BiConsumer)map.get(fieldId)).accept(view, dyn);
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new IntellSchemaAndDetailsProvider());
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate fp = (FormOperate)args.getSource();
        String operateKey = fp.getOperateKey();
        if ("refresh".equals(operateKey)) {
            AbstractGrid.GridState entryState = ((BillList)this.getControl("billlistap")).getEntryState();
            entryState.setCurrentPageIndex(Integer.valueOf(0));
            this.getView().getPageCache().remove(newestRowindexCache);
        }
    }

    public void filterContainerSetBaseDataSearchClosed(SetFilterContainerBaseDataSearchClosedEvent args) {
        super.filterContainerSetBaseDataSearchClosed(args);
        this.getView().getPageCache().remove(newestRowindexCache);
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        if (this.getView().getPageCache().get(KEY_FILTER) == null) {
            this.getView().getPageCache().put(KEY_FILTER, "true");
        }
    }

    public void packageData(PackageDataEvent e) {
        Integer newestRowIndex;
        int startRow;
        super.packageData(e);
        String intelschemaid = String.valueOf(e.getRowData().get("intelschemaid.id"));
        Integer rowIndex = (Integer)e.getRowData().get(0);
        AbstractGrid.GridState entryState = ((BillList)this.getControl("billlistap")).getEntryState();
        int n = startRow = entryState.getCurrentPageIndex() <= 1 ? 0 : (entryState.getCurrentPageIndex() - 1) * entryState.getPageRows();
        if (startRow + 1 == rowIndex) {
            String chace;
            if (startRow == 0 && "true".equals(this.getView().getPageCache().get(KEY_FILTER))) {
                this.getView().getPageCache().remove(newestRowindexCache);
            }
            if (Objects.nonNull(chace = this.getView().getPageCache().get(newestRowindexCache))) {
                this.newestRowindex = (Map)SerializationUtils.fromJsonString((String)chace, Map.class);
            }
        }
        if (Objects.isNull(newestRowIndex = this.newestRowindex.get(intelschemaid))) {
            this.newestRowindex.put(intelschemaid, rowIndex);
        }
        if (!rowIndex.equals(this.newestRowindex.get(intelschemaid))) {
            e.getRowData().set("failsumquantity", null);
        }
        if (((BillList)this.getControl("billlistap")).getPageRow() == rowIndex.intValue()) {
            this.getView().getPageCache().put(newestRowindexCache, SerializationUtils.toJsonString(this.newestRowindex));
            this.getView().getPageCache().remove(KEY_FILTER);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"btn_repair"});
        this.setShortCuts();
    }

    private void setShortCuts() {
        JSONArray arrayItem = new JSONArray();
        JSONObject item = new JSONObject();
        item.put("type", (Object)"keyUp");
        item.put("shortCuts", (Object)"shift+m");
        arrayItem.add((Object)item);
        IFormView formView = this.getView();
        IClientViewProxy clientViewProxy = (IClientViewProxy)formView.getService(IClientViewProxy.class);
        JSONArray action = new JSONArray();
        action.add((Object)arrayItem);
        clientViewProxy.addAction("setShortCuts", (Object)action);
    }

    public void customEvent(CustomEventArgs e) {
        String key;
        super.customEvent(e);
        if (e.getEventName().equalsIgnoreCase("shortCuts") && "[16,77]".equals(key = e.getEventArgs())) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"btn_repair"});
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if ("btn_repair".equals(key)) {
            DynamicObject[] dynUpdates;
            ListSelectedRowCollection listSelectedRows = ((ListView)this.getView()).getSelectedRows();
            if (listSelectedRows.size() != 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"IntellExcelSumLogListPlugin_0", (String)"fi-iep-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject dynSelect = BusinessDataServiceHelper.loadSingleFromCache((Object)listSelectedRows.get(0).getPrimaryKeyValue(), (String)"gl_intelschemasumlog");
            long intelschemaid = dynSelect.getLong("intelschemaid.id");
            int count = LogORMHelper.count((String)"iep_intellexecdetaillog", (QFilter[])new QFilter[]{new QFilter("intelschemaid", "=", (Object)intelschemaid), new QFilter("srcbillid", ">", (Object)0)});
            for (DynamicObject dynUpdate : dynUpdates = BusinessDataServiceHelper.load((String)"gl_intelschemasumlog", (String)"id,failsumquantity", (QFilter[])new QFilter[]{new QFilter("intelschemaid", "=", (Object)intelschemaid)}, (String)"execstartdate desc", (int)1)) {
                dynUpdate.set("failsumquantity", (Object)count);
            }
            SaveServiceHelper.save((DynamicObject[])dynUpdates);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u65b9\u6848\u7d2f\u8ba1\u9519\u8bef\u6570\u636e\u4fee\u6b63\u6210\u529f\u3002", (String)"IntellExcelSumLogListPlugin_1", (String)"fi-iep-formplugin", (Object[])new Object[0]));
        }
    }
}

