/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.iep.formplugin;

import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.filter.FilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.license.api.LicenseCheckResult;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.fi.iep.util.BussinessAndOperProviderNew;
import kd.fi.iep.util.LogORMHelper;

public class IntellExecDetailLogList
extends AbstractListPlugin {
    public void initialize() {
        super.initialize();
        this.addItemClickListeners(new String[]{"executeschema", "stopexecute"});
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        Object intelschemaid;
        super.filterContainerInit(args);
        String firstEntryFlag = this.getView().getPageCache().get("firstEntryFlag");
        if (Objects.isNull(firstEntryFlag) && Objects.nonNull(intelschemaid = this.getView().getFormShowParameter().getCustomParams().get("intelschemaid"))) {
            List commonFilterColumns = args.getCommonFilterColumns();
            for (FilterColumn column : commonFilterColumns) {
                String fieldName = column.getFieldName();
                if (!fieldName.startsWith("intelschemaid")) continue;
                column.setDefaultValue(String.valueOf(intelschemaid));
            }
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        this.getView().getPageCache().put("firstEntryFlag", "true");
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new BussinessAndOperProviderNew(this.getView()));
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        if ("execbillope".equals(operateKey)) {
            this.getView().invokeOperation("refresh");
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs e) {
        super.billListHyperLinkClick(e);
        e.setCancel(true);
        Long id = (Long)((BillList)this.getControl("billlistap")).getFocusRowPkId();
        DynamicObjectCollection dyns = LogORMHelper.query((String)"iep_intellexecdetaillog", (String)"id,intelschemanumber,targetbillnumber,srcbillnumber,srcbillid,bussiness,intelschemaid", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)}, (int)1, (int)0);
        if (dyns == null || dyns.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u6765\u6e90\u5355\u636e\u4e0d\u5b58\u5728", (String)"IntellExecDetailLogList_4", (String)"fi-iep-formplugin", (Object[])new Object[0]));
            return;
        }
        this.openFormByField(e.getHyperLinkClickEvent().getFieldName(), (DynamicObject)dyns.get(0));
    }

    private void openFormByField(String fieldId, DynamicObject dyn) {
        HashMap<String, Consumer<DynamicObject>> map = new HashMap<String, Consumer<DynamicObject>>();
        map.put("srcbillnumber", this::openSrcBill);
        map.put("targetbillnumber", this::openTargetBill);
        map.put("intelschemanumber", this::openSchemaNew);
        ((Consumer)map.get(fieldId)).accept(dyn);
    }

    private void openSrcBill(DynamicObject dyn) {
        String billno = dyn.getString("srcbillnumber");
        String bussiness = dyn.getString("bussiness");
        Set fieldsSet = EntityMetadataCache.getDataEntityType((String)bussiness).getAllFields().keySet();
        String number = "";
        if (fieldsSet.contains("billno")) {
            number = "billno";
        } else if (fieldsSet.contains("number")) {
            number = "number";
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u8be5\u6765\u6e90\u5355\u636e\u7f16\u7801\u5b57\u6bb5", (String)"IntellExecDetailLogList_5", (String)"fi-iep-formplugin", (Object[])new Object[0]));
            return;
        }
        QFilter filter = new QFilter(number, "=", (Object)billno);
        filter.and(new QFilter("id", "=", dyn.get("srcbillid")));
        DynamicObject[] objs = BusinessDataServiceHelper.load((String)bussiness, (String)("id," + number), (QFilter[])filter.toArray());
        if (objs == null || objs.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u8be5\u6765\u6e90\u5355\u636e\u7f16\u7801\u5b57\u6bb5", (String)"IntellExecDetailLogList_5", (String)"fi-iep-formplugin", (Object[])new Object[0]));
            return;
        }
        this.openFormByPKId(objs[0].get("id"), bussiness);
    }

    private void openTargetBill(DynamicObject dyn) {
        String billno = dyn.getString("targetbillnumber");
        String bussiness = "gl_voucher";
        Set fieldsSet = EntityMetadataCache.getDataEntityType((String)bussiness).getAllFields().keySet();
        String number = "";
        if (fieldsSet.contains("billno")) {
            number = "billno";
        } else if (fieldsSet.contains("number")) {
            number = "number";
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u8be5\u76ee\u6807\u5355\u636e\u7f16\u7801\u5b57\u6bb5", (String)"IntellExecDetailLogList_6", (String)"fi-iep-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject[] objs = BusinessDataServiceHelper.load((String)bussiness, (String)("id," + number), (QFilter[])new QFilter[]{new QFilter(number, "=", (Object)billno)});
        if (objs == null || objs.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u8be5\u76ee\u6807\u5355\u636e\u7f16\u7801\u5b57\u6bb5", (String)"IntellExecDetailLogList_6", (String)"fi-iep-formplugin", (Object[])new Object[0]));
            return;
        }
        this.openFormByPKId(objs[0].get("id"), bussiness);
    }

    private void openSchema(DynamicObject dyn) {
        this.openFormByPKId(dyn.getDynamicObject("intelschemaid").getLong("id"), "gl_intellexecschema");
    }

    private void openSchemaNew(DynamicObject dyn) {
        this.openFormByPKId(dyn.getLong("intelschemaid"), "gl_intellexecschema");
    }

    private void openFormByPKId(Object pkId, String bussiness) {
        BillShowParameter parameter = new BillShowParameter();
        parameter.setFormId(bussiness);
        parameter.setPkId(pkId);
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.getOpenStyle().setTargetKey("_submaintab_");
        parameter.setStatus(OperationStatus.EDIT);
        this.getView().showForm((FormShowParameter)parameter);
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        LicenseCheckResult result = LicenseServiceHelper.checkPerformGroup((String)"PRO_IEP");
        if (!result.getHasLicense().booleanValue()) {
            String msg = result.getMsg();
            e.setCancel(true);
            e.setCancelMessage(msg);
            e.setCancelFormShowParameter(result.getCancelFormShowParameter());
        } else {
            super.preOpenForm(e);
        }
    }

    public void setFilter(SetFilterEvent e) {
        LicenseCheckResult result;
        super.setFilter(e);
        String firstEntryFlag = this.getView().getPageCache().get("firstEntryFlag");
        Object intelschemasumlogid = this.getView().getFormShowParameter().getCustomParams().get("intelschemasumlogid");
        if (null != intelschemasumlogid && Objects.isNull(firstEntryFlag)) {
            QFilter filter = new QFilter("schemasumlogid", "=", intelschemasumlogid);
            e.getQFilters().add(filter);
        }
        if (!(result = LicenseServiceHelper.checkPerformGroup((String)"PRO_IEP")).getHasLicense().booleanValue()) {
            String msg = result.getMsg();
            this.getView().showMessage(msg);
            e.getQFilters().add(new QFilter("1", "!=", (Object)"1"));
        }
    }
}

