/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.iep.formplugin;

import java.text.Format;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.format.FormatFactory;
import kd.bos.entity.format.FormatObject;
import kd.bos.entity.format.FormatTypes;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.control.ImageAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.fi.iep.dao.FormDesignDao;
import kd.fi.iep.dao.IntellAccountSchemaExecLogDao;
import kd.fi.iep.info.IntellAcaountExeInfo;
import kd.fi.iep.info.IntellSchemeExecInfo;
import kd.fi.iep.util.DateUtil;
import kd.fi.iep.util.IntelAccountingConstant;
import kd.fi.iep.util.IntelExecShemaCalculate;

public class IntellIndexPlugin
extends AbstractFormPlugin
implements ProgresssListener {
    private static final Log logger = LogFactory.getLog(IntellIndexPlugin.class);
    private static final String PROGRESS_NAME = "progressbarap";
    private static final String FLEX_NAME = "flexprogress";
    private static final Integer FLEX_COUNT = 5;
    private static final String PROGRESS_LABEL_NAME = "progresslabel";
    private static final String FINISH_IMG_KEY = "/icons/pc/state/completed_13_13.png";
    private static final String SELECT_IMG_KEY = "/icons/pc/state/selected_13_13.png";
    private static final String NO_START_IMG_KEY = "/icons/pc/state/not_passing_13_13.png";
    private static final Integer COLUMN_COUNT = 8;
    private static final Integer SHOWSIZE = 5;
    private AtomicInteger nostartCount = new AtomicInteger(0);
    private static final List<BetweenHour> CARD_SUFFIX_ARRAY = new LinkedList<BetweenHour>();

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ProgressBar bar = (ProgressBar)this.getControl(PROGRESS_NAME);
        bar.addProgressListener((ProgresssListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        this.getModel().setValue("userinfo", (Object)new Long[]{userId});
        this.loadIntellData();
        ProgressBar bar = (ProgressBar)this.getControl(PROGRESS_NAME);
        bar.start();
    }

    public void onProgress(ProgressEvent arg0) {
        this.loadIntellData();
    }

    private void loadIntellData() {
        this.updateTimeLabel();
        Long[] userinfo = this.getUserInfoIds();
        Calendar instance = Calendar.getInstance();
        Set<Long> idSet = this.getAccomplishSchema(userinfo);
        int finishCount = 0;
        LinkedList<Map<String, Object>> operFinishList = new LinkedList<Map<String, Object>>();
        HashMap<String, Set> intellFinishHour = new HashMap<String, Set>();
        HashMap<Integer, List<IntellAcaountExeInfo>> execInfoMap = new HashMap<Integer, List<IntellAcaountExeInfo>>();
        QFilter filter = new QFilter("id", "in", idSet);
        filter.and("lastexectime", ">=", (Object)DateUtil.getDateFormat((Date)new Date(), (boolean)true));
        HashSet<Long> intellFinishCount = new HashSet<Long>(idSet.size());
        String sqlSelect = "id,compcount,lastexectime,entryentity.businessname,entryentity.opername,entryentity.execcount,entryentity.execcomptime,entryentity.business,entryentity.opernumber";
        DataSet todayExecInfo = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"iep_todaycomplete", (String)sqlSelect, (QFilter[])filter.toArray(), (String)"entryentity.execcomptime desc");
        for (Row row : todayExecInfo) {
            if (!intellFinishCount.contains(row.getLong("id"))) {
                intellFinishCount.add(row.getLong("id"));
                finishCount += row.getInteger("compcount").intValue();
            }
            HashMap<String, Object> finishScheme = new HashMap<String, Object>(6);
            finishScheme.put("business", row.getString("entryentity.business"));
            finishScheme.put("oper", row.getString("entryentity.opernumber"));
            finishScheme.put("enddate", row.getDate("entryentity.execcomptime"));
            finishScheme.put("execcount", row.getString("entryentity.execcount"));
            if (operFinishList.size() < SHOWSIZE) {
                operFinishList.add(finishScheme);
            }
            instance.setTime(row.getDate("entryentity.execcomptime"));
            Integer indexHour = this.getIndexByCurHour(instance.get(11));
            boolean isAdd = intellFinishHour.computeIfAbsent(row.getLong("id") + "" + indexHour, v -> new HashSet()).add(indexHour);
            if (!isAdd) continue;
            IntellAcaountExeInfo exeInfo = new IntellAcaountExeInfo(row.getLong("id").longValue(), row.getDate("entryentity.execcomptime"), "");
            execInfoMap.computeIfAbsent(indexHour, v -> new LinkedList()).add(exeInfo);
        }
        ArrayList<IntellSchemeExecInfo> pgsLst = new ArrayList<IntellSchemeExecInfo>(16);
        int processingCount = 0;
        for (Long schemaId : idSet) {
            IntellSchemeExecInfo execInfo;
            if (schemaId == 0L || !Objects.nonNull(execInfo = IntellSchemeExecInfo.getInstance((long)schemaId)) || !execInfo.isProgress()) continue;
            ++processingCount;
            if (pgsLst.size() >= SHOWSIZE) continue;
            pgsLst.add(execInfo);
        }
        this.processOperationTotal(pgsLst);
        this.finishSchemaTotal(operFinishList);
        this.todayExplanTotal(execInfoMap, idSet);
        this.todayProfileTotal(finishCount, processingCount, this.nostartCount.get());
    }

    private int getIndexByCurHour(int curHour) {
        for (BetweenHour betweenHour : CARD_SUFFIX_ARRAY) {
            if (!betweenHour.inHours(curHour)) continue;
            return betweenHour.index;
        }
        return 0;
    }

    private Long[] getUserInfoIds() {
        DynamicObjectCollection userInfos = (DynamicObjectCollection)this.getModel().getValue("userinfo");
        int size = userInfos.size();
        Long[] userInfoIds = new Long[size];
        for (int i = 0; i < size; ++i) {
            DynamicObject userInfo = (DynamicObject)userInfos.get(i);
            userInfoIds[i] = userInfo.getLong("fbasedataid_id");
        }
        return userInfoIds;
    }

    private void todayExplanTotal(Map<Integer, List<IntellAcaountExeInfo>> execInfoMap, Set<Long> idSet) {
        this.todayExplan(execInfoMap, idSet);
    }

    private Format initFormat() {
        FormatObject fobj = InteServiceHelper.getUserFormat((Long)Long.valueOf(RequestContext.get().getUserId()));
        Format timeFormat = FormatFactory.get((FormatTypes)FormatTypes.Time).getFormat(fobj);
        return timeFormat;
    }

    private void finishSchemaTotal(List<Map<String, Object>> operFinishList) {
        if (operFinishList != null) {
            this.getModel().deleteEntryData("entryentity");
            Format timeFormat = this.initFormat();
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            model.beginInit();
            TableValueSetter vs = new TableValueSetter(new String[0]);
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            HashMap<String, String> businessNameMap = new HashMap<String, String>(SHOWSIZE);
            HashMap<String, String> operNameMap = new HashMap<String, String>(SHOWSIZE);
            for (Map<String, Object> singleMap : operFinishList) {
                vs.addField("exeinfo", new Object[0]);
                vs.addField("dateinfo", new Object[0]);
                vs.addField("exenum", new Object[0]);
                String business = (String)singleMap.get("business");
                String oper = (String)singleMap.get("oper");
                if (!businessNameMap.containsKey(business)) {
                    String businessname = FormDesignDao.getFormName(business);
                    businessNameMap.put(business, StringUtils.isEmpty((CharSequence)businessname) ? business : businessname);
                }
                if (!operNameMap.containsKey(business + "_" + oper)) {
                    String operName = FormDesignDao.getOperationNameWithVoucher(business, oper);
                    operNameMap.put(business + "_" + oper, StringUtils.isEmpty((CharSequence)operName) ? oper : operName);
                }
                try {
                    Date enddate = formatter.parse(String.valueOf(singleMap.get("enddate")));
                    vs.addRow(new Object[]{String.format(ResManager.loadKDString((String)"%1$s,%2$s\u5b8c\u6210", (String)"IntellIndexPlugin_0", (String)"fi-iep-formplugin", (Object[])new Object[0]), businessNameMap.get(business), operNameMap.get(business + "_" + oper)), timeFormat.format(enddate), singleMap.get("execcount")});
                }
                catch (ParseException e) {
                    logger.error("finishSchemaTotal-2-" + e);
                }
            }
            model.batchCreateNewEntryRow("entryentity", vs);
            model.endInit();
        }
        this.getView().updateView("entryentity");
    }

    private void processOperationTotal(List<IntellSchemeExecInfo> pgsLst) {
        int count = 0;
        for (int i = 0; i < FLEX_COUNT; ++i) {
            this.getView().setVisible(Boolean.FALSE, new String[]{FLEX_NAME + i});
        }
        for (IntellSchemeExecInfo execInfo : pgsLst) {
            ++count;
            long intelschemaId = execInfo.getSchemaId();
            DLock dLock = DLock.create((String)IntelAccountingConstant.getIntellSchemaExecutingKey((Long)intelschemaId)).fastMode();
            Throwable throwable = null;
            try {
                if (dLock.tryLock()) {
                    IntellSchemeExecInfo.removeIntellExecInfo((long)intelschemaId);
                    IntellAccountSchemaExecLogDao.updateAllProcessingSchemaFail((Long)intelschemaId, (Long)0L);
                    continue;
                }
                int countLab = count - 1;
                int percent = execInfo.getPercent();
                if (percent >= 100) continue;
                ((ProgressBar)this.getControl(PROGRESS_NAME + countLab)).setPercent(percent, String.valueOf(percent));
                this.getModel().setValue(PROGRESS_LABEL_NAME + countLab, (Object)intelschemaId);
                this.setVisibleProgress(count);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (dLock == null) continue;
                if (throwable != null) {
                    try {
                        dLock.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                dLock.close();
            }
        }
    }

    private void todayProfileTotal(int finishCount, int processingCount, int nostartCount) {
        ((Label)this.getControl("processingnum")).setText(String.valueOf(nostartCount));
        int total = finishCount + processingCount + nostartCount;
        ((Label)this.getControl("accomplishandall")).setText(String.format(ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u5df2\u5b8c\u6210%1$d/\u8fd0\u884c\u4e2d%2$d/\u603b\u6570%3$d", (String)"IntellIndexPlugin_1", (String)"fi-iep-formplugin", (Object[])new Object[0]), (String)"IntellIndexPlugin_1", (String)"fi-iep-formplugin", (Object[])new Object[0]), finishCount, processingCount, total));
    }

    private void todayExplan(Map<Integer, List<IntellAcaountExeInfo>> execInfoMap, Set<Long> idSet) {
        this.createEntityCard(execInfoMap, idSet);
    }

    private void createEntityCard(Map<Integer, List<IntellAcaountExeInfo>> execInfoMap, Set<Long> idSet) {
        this.clearCardEntry();
        int indexHour = this.checkWhereTime();
        Map<Long, DynamicObject> shedulePlanMap = this.getShedulePlanMapBySchemaIds(idSet);
        for (int i = 0; i < CARD_SUFFIX_ARRAY.size(); ++i) {
            List<IntellAcaountExeInfo> infos = execInfoMap.get(i);
            if (i < indexHour && Objects.nonNull(infos)) {
                this.createFinishColumn(i, infos);
                continue;
            }
            if (i == indexHour) {
                this.createProcessingColumn(i, idSet, shedulePlanMap);
                continue;
            }
            if (i <= indexHour) continue;
            this.createNoStartColumn(i, idSet, shedulePlanMap);
        }
    }

    private void createNoStartColumn(int i, Set<Long> idSet, Map<Long, DynamicObject> shedulePlanMap) {
        BetweenHour betweenHour = CARD_SUFFIX_ARRAY.get(i);
        ArrayList<IntellAcaountExeInfo> list3 = new ArrayList<IntellAcaountExeInfo>();
        Calendar instance = Calendar.getInstance();
        for (Long id : idSet) {
            List<IntellAcaountExeInfo> allTodayWait = this.execShemaCalculate(i, id, shedulePlanMap.get(id));
            this.nostartCount.getAndAdd(allTodayWait.size());
            ArrayList<IntellAcaountExeInfo> list2 = new ArrayList<IntellAcaountExeInfo>();
            for (IntellAcaountExeInfo info : allTodayWait) {
                instance.setTime(info.getExecDate());
                int hours = instance.get(11);
                if (list2.size() != 0 || hours < betweenHour.beginHour || hours >= betweenHour.endHour) continue;
                list2.add(info);
            }
            list3.addAll(list2);
        }
        if (list3.size() > 0) {
            this.writePlanCardEntry(list3, i);
        }
    }

    private void createProcessingColumn(int i, Set<Long> idSet, Map<Long, DynamicObject> shedulePlanMap) {
        LinkedList<IntellAcaountExeInfo> planInfo = new LinkedList<IntellAcaountExeInfo>();
        idSet.forEach(v -> this.createPlanExecInfo((List<IntellAcaountExeInfo>)planInfo, (Long)v, i, (DynamicObject)shedulePlanMap.get(v)));
        this.nostartCount.getAndAdd(planInfo.size());
        if (planInfo.size() > 0) {
            this.writePlanCardEntry(planInfo, i);
        }
    }

    private void createPlanExecInfo(List<IntellAcaountExeInfo> dataList, Long id, int i, DynamicObject shedulePlan) {
        IntellAcaountExeInfo intellAcaountExePlanInfo = this.addPlanExeInfo(i, id, shedulePlan);
        if (intellAcaountExePlanInfo != null) {
            Date exeDate = intellAcaountExePlanInfo.getExecDate();
            Calendar instance = Calendar.getInstance();
            instance.setTime(exeDate);
            int indexHour = instance.get(11);
            BetweenHour betweenHour = CARD_SUFFIX_ARRAY.get(i);
            if (indexHour >= betweenHour.beginHour && indexHour < betweenHour.endHour) {
                dataList.add(intellAcaountExePlanInfo);
            }
        }
    }

    private void createFinishColumn(int i, List<IntellAcaountExeInfo> exeInfos) {
        if (exeInfos != null && exeInfos.size() > 0) {
            this.writePlanCardEntry(exeInfos, i);
        }
    }

    private void writePlanCardEntry(List<IntellAcaountExeInfo> execInfo, int index) {
        int indexHour = this.checkWhereTime();
        if (index == indexHour) {
            Collections.sort(execInfo, (o1, o2) -> {
                if (o1.getExecstatus().equals(o2.getExecstatus())) {
                    return o1.getExecDate().compareTo(o2.getExecDate());
                }
                return 1;
            });
        } else if (index < indexHour) {
            execInfo.sort(Comparator.comparing(IntellAcaountExeInfo::getExecDate).reversed());
            Collections.sort(execInfo, (o1, o2) -> o2.getExecDate().compareTo(o1.getExecDate()));
        } else {
            Collections.sort(execInfo, Comparator.comparing(IntellAcaountExeInfo::getExecDate));
        }
        String suffix = CARD_SUFFIX_ARRAY.get(index).column;
        String entryEntityName = "explan" + suffix;
        SimpleDateFormat dateFormater = new SimpleDateFormat("HH:mm");
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("schema" + suffix, new Object[0]);
        vs.addField("cardtime" + suffix, new Object[0]);
        IDataModel dataModel = this.getModel();
        AbstractFormDataModel model = (AbstractFormDataModel)dataModel;
        model.beginInit();
        int processingCount = 0;
        int columnCount = execInfo.size() > 9 ? COLUMN_COUNT.intValue() : execInfo.size();
        for (int i = 0; i < columnCount; ++i) {
            IntellAcaountExeInfo obj = execInfo.get(i);
            if ("1".equals(obj.getExecstatus())) {
                ++processingCount;
            }
            vs.addRow(new Object[]{obj.getId(), dateFormater.format(obj.getExecDate())});
        }
        model.batchCreateNewEntryRow(entryEntityName, vs);
        model.endInit();
        this.getView().updateView(entryEntityName);
        EntryGrid grid = (EntryGrid)this.getControl("explan" + suffix);
        int[] rowIndex = new int[processingCount];
        for (int i = 0; i < processingCount; ++i) {
            rowIndex[i] = i;
        }
        grid.selectRows(rowIndex, 0);
    }

    private IntellAcaountExeInfo addPlanExeInfo(int i, Long id, DynamicObject shedulePlan) {
        List<IntellAcaountExeInfo> singleResult = this.execShemaCalculate(i, id, shedulePlan);
        if (singleResult.size() > 0) {
            return singleResult.get(0);
        }
        return null;
    }

    private void clearCardEntry() {
        IDataModel dataModel = this.getModel();
        for (BetweenHour betweenHour : CARD_SUFFIX_ARRAY) {
            String cardentryName = "explan" + betweenHour.column;
            dataModel.deleteEntryData(cardentryName);
        }
    }

    private List<IntellAcaountExeInfo> execShemaCalculate(int indexHour, long schemaId, DynamicObject shedulePlan) {
        if (shedulePlan == null) {
            return new ArrayList<IntellAcaountExeInfo>();
        }
        HashSet<Long> schemaIdSet = new HashSet<Long>(Collections.singleton(schemaId));
        IntelExecShemaCalculate intellCal = new IntelExecShemaCalculate(schemaIdSet);
        List<Date> intellExecuteDateList = intellCal.parserSehedulePlan(shedulePlan.getString("plan"), null, shedulePlan.getDate("starttime"));
        if (intellExecuteDateList == null || intellExecuteDateList.isEmpty()) {
            return new ArrayList<IntellAcaountExeInfo>();
        }
        Date begintime = shedulePlan.getDate("starttime");
        Date endtime = shedulePlan.getDate("endtime");
        Date nowtime = new Date();
        ArrayList<IntellAcaountExeInfo> dataList = new ArrayList<IntellAcaountExeInfo>(intellExecuteDateList.size());
        Date rangBeginTime = new Date();
        for (Date date : intellExecuteDateList) {
            if (nowtime.compareTo(date) > 0 || date.compareTo(endtime) >= 0) continue;
            BetweenHour curBetweenHour = CARD_SUFFIX_ARRAY.get(indexHour);
            int curHour = date.getHours();
            rangBeginTime.setHours(curHour);
            if (rangBeginTime.compareTo(begintime) <= 0 || curHour < curBetweenHour.beginHour || curHour >= curBetweenHour.endHour) continue;
            dataList.add(new IntellAcaountExeInfo(schemaId, date, "0"));
        }
        return dataList;
    }

    private Map<Long, DynamicObject> getShedulePlanMapBySchemaIds(Set<Long> idSet) {
        Map colsMap = BusinessDataServiceHelper.loadFromCache((String)"gl_intellexecschema", (String)"id,sheduleplanid", (QFilter[])new QFilter[]{new QFilter("id", "in", idSet)});
        Set sheduleplanidSet = colsMap.values().stream().map(v -> v.getString("sheduleplanid")).collect(Collectors.toSet());
        Map shedulePlanMap = BusinessDataServiceHelper.loadFromCache((String)"sch_schedule", (String)"id,plan,starttime,endtime", (QFilter[])new QFilter[]{new QFilter("id", "in", sheduleplanidSet)});
        HashMap<Long, DynamicObject> resultMap = new HashMap<Long, DynamicObject>(colsMap.size());
        colsMap.values().forEach(col -> {
            Long id = col.getLong("id");
            String sheduleplanid = col.getString("sheduleplanid");
            resultMap.put(id, (DynamicObject)shedulePlanMap.get(sheduleplanid));
        });
        return resultMap;
    }

    private Set<Long> getAccomplishSchema(Long[] userinfo) {
        HashMap<String, Long> schemaMap = new HashMap<String, Long>();
        Set<DynamicObject> mapdyb = this.getSchemaDataSet(userinfo);
        for (DynamicObject dyb : mapdyb) {
            String sheduleplanid = dyb.getString("sheduleplanid");
            if (!StringUtils.isNotBlank((CharSequence)sheduleplanid)) continue;
            schemaMap.put(sheduleplanid, dyb.getLong("id"));
        }
        if (!schemaMap.isEmpty()) {
            QFilter idFilter = new QFilter("id", "in", schemaMap.keySet());
            Date endTime = DateUtil.getCurrentDayStart((Date)new Date());
            QFilter dateFilter = new QFilter("endtime", "<", (Object)endTime);
            QFilter[] schFiltrs = new QFilter[]{idFilter, dateFilter};
            DataSet endSchDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"sch_schedule", (String)"id", (QFilter[])schFiltrs, null);
            for (Row dyb : endSchDataSet) {
                Long schemaId = (Long)schemaMap.get(dyb.getString("id"));
                if (!Objects.nonNull(schemaId) || !Objects.isNull(IntellSchemeExecInfo.getInstance((long)schemaId))) continue;
                schemaMap.remove(dyb.getString("id"));
            }
        }
        Set set = schemaMap.entrySet();
        HashSet<Long> schemaIdSet = new HashSet<Long>(set.size());
        for (Map.Entry explan : set) {
            Long schemaId = (Long)schemaMap.get(explan.getKey());
            schemaIdSet.add(schemaId);
        }
        return schemaIdSet;
    }

    private Set<DynamicObject> getSchemaDataSet(Long[] userinfo) {
        QFilter userFilter = new QFilter("modifier", "in", (Object)userinfo);
        QFilter statusFilter = new QFilter("enable", "=", (Object)"1");
        QFilter[] qfiltrs = new QFilter[]{userFilter, statusFilter};
        Map map = BusinessDataServiceHelper.loadFromCache((String)"gl_intellexecschema", (String)"id,creator,enable,sheduleplanid", (QFilter[])qfiltrs);
        return new HashSet<DynamicObject>(map.values());
    }

    private void hideLeftEntity() {
        int count = this.getModel().getEntryRowCount("entryentity");
        if (0 == count) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap12"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap12"});
        }
    }

    private void updateTimeLabel() {
        int i;
        int indexHour = this.checkWhereTime();
        for (i = 0; i < indexHour; ++i) {
            String imgKey = "timeimg" + i;
            this.updateImgControl(FINISH_IMG_KEY, imgKey);
        }
        this.updateImgControl(SELECT_IMG_KEY, "timeimg" + indexHour);
        for (i = indexHour + 1; i < CARD_SUFFIX_ARRAY.size() + 1; ++i) {
            this.updateImgControl(NO_START_IMG_KEY, "timeimg" + i);
        }
        BetweenHour curBetweenHour = CARD_SUFFIX_ARRAY.get(indexHour);
        for (BetweenHour betweenHour : CARD_SUFFIX_ARRAY) {
            LabelAp label;
            int beginHour = betweenHour.beginHour;
            if (betweenHour == curBetweenHour) {
                label = new LabelAp();
                label.setForeColor("#FF9400");
                label.setName(new LocaleString(beginHour + ":00"));
                label.setFontSize(18);
                label.setKey("timelabel" + beginHour);
                this.getView().updateControlMetadata("timelabel" + beginHour, label.createControl());
                continue;
            }
            label = new LabelAp();
            label.setForeColor("#999999");
            label.setName(new LocaleString(beginHour + ":00"));
            label.setFontSize(18);
            label.setKey("timelabel" + beginHour);
            this.getView().updateControlMetadata("timelabel" + beginHour, label.createControl());
        }
    }

    private int checkWhereTime() {
        int curHour = LocalTime.now().getHour();
        for (BetweenHour betweenHour : CARD_SUFFIX_ARRAY) {
            if (!betweenHour.inHours(curHour)) continue;
            LocalTime now = LocalTime.now();
            int todySecond = now.getHour() * 60 * 60 + now.getMinute() * 60 + now.getSecond();
            int precent = todySecond * 100 / 86400;
            ((ProgressBar)this.getControl("progressbarap5")).setPercent(precent);
            return betweenHour.index;
        }
        return 0;
    }

    private void updateImgControl(String finishImgKey, String imgKey) {
        ImageAp img = new ImageAp();
        img.setKey(imgKey);
        img.setImageKey(finishImgKey);
        img.setImageHoverKey(finishImgKey);
        this.getView().updateControlMetadata(imgKey, img.createControl());
    }

    private void setVisibleProgress(int size) {
        int i;
        for (i = 0; i < size; ++i) {
            this.getView().setVisible(Boolean.TRUE, new String[]{FLEX_NAME + i});
        }
        for (i = size; i < FLEX_COUNT; ++i) {
            this.getView().setVisible(Boolean.FALSE, new String[]{FLEX_NAME + i});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if ("userinfo".equals(e.getProperty().getName())) {
            this.loadIntellData();
        }
    }

    static {
        CARD_SUFFIX_ARRAY.add(new BetweenHour("first", 0, 0, 4));
        CARD_SUFFIX_ARRAY.add(new BetweenHour("second", 1, 4, 8));
        CARD_SUFFIX_ARRAY.add(new BetweenHour("third", 2, 8, 12));
        CARD_SUFFIX_ARRAY.add(new BetweenHour("fourth", 3, 12, 16));
        CARD_SUFFIX_ARRAY.add(new BetweenHour("fifth", 4, 16, 20));
        CARD_SUFFIX_ARRAY.add(new BetweenHour("sixth", 5, 20, 24));
    }

    private static class BetweenHour {
        private String column;
        private int index;
        private int beginHour;
        private int endHour;

        BetweenHour(String column, int index, int beginHour, int endHour) {
            this.column = column;
            this.index = index;
            this.beginHour = beginHour;
            this.endHour = endHour;
        }

        public boolean inHours(int curHour) {
            return curHour >= this.beginHour && curHour < this.endHour;
        }
    }
}

