/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.iep.formplugin;

import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.Tips;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.property.ComboProp;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.entity.commonfield.ComboField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.form.control.FieldAp;
import kd.fi.iep.enums.FailRetryStrategy;

public class SchScheduleRetryPlugin
extends AbstractFormPlugin {
    private static final String FAIL_RETRY_STRATEGY_KEY = "failretrystrategy";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.buildComboField();
    }

    private void buildComboField() {
        Container container = (Container)this.getControl("fieldsetpanelap");
        FieldAp retryAp = new FieldAp();
        retryAp.setKey(FAIL_RETRY_STRATEGY_KEY);
        retryAp.setFieldId(FAIL_RETRY_STRATEGY_KEY);
        retryAp.setName(new LocaleString(ResManager.loadKDString((String)"\u65b9\u6848\u91cd\u8bd5\u7b56\u7565", (String)"SchScheduleRetryPlugin_0", (String)"fi-iep-formplugin", (Object[])new Object[0])));
        retryAp.setCtlTips(new Tips("text", null, new LocaleString(ResManager.loadKDString((String)"\u91cd\u8bd5\u95f4\u9694\u65f6\u95f4\u5206\u522b\u4e3a\uff1a1h\u30015h\u300112h\uff0c\u6bcf\u6b21\u95f4\u9694\u65f6\u95f4\u662f\u76f8\u8f83\u4e8e\u4e0a\u6b21\u6267\u884c\u5931\u8d25\u7684\u65f6\u95f4\u5f00\u59cb\u7b97\u8d77", (String)"SchScheduleRetryPlugin_4", (String)"fi-iep-formplugin", (Object[])new Object[0])), false, null));
        ComboField comboField = new ComboField();
        comboField.setKey(FAIL_RETRY_STRATEGY_KEY);
        comboField.setMustInput(true);
        retryAp.setField((Field)comboField);
        container.insertControls(6, Collections.singletonList(retryAp.createControl()));
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String strategyValue = StringUtils.isBlank(customParams.get(FAIL_RETRY_STRATEGY_KEY)) ? FailRetryStrategy.IGNORE.getValue() : String.valueOf(customParams.get(FAIL_RETRY_STRATEGY_KEY));
        this.getModel().setValue(FAIL_RETRY_STRATEGY_KEY, (Object)strategyValue);
        this.getView().updateView(FAIL_RETRY_STRATEGY_KEY);
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        super.getEntityType(e);
        if (Objects.nonNull(e.getNewEntityType())) {
            MainEntityType newEntityType = e.getNewEntityType();
            ComboProp comboProp = new ComboProp();
            comboProp.setName(FAIL_RETRY_STRATEGY_KEY);
            comboProp.setDbIgnore(true);
            comboProp.setAlias(FAIL_RETRY_STRATEGY_KEY);
            newEntityType.registerSimpleProperty((DynamicSimpleProperty)comboProp);
            e.setNewEntityType(newEntityType);
        }
    }

    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
        String key = e.getKey();
        if (FAIL_RETRY_STRATEGY_KEY.equals(key)) {
            ComboEdit comboEdit = new ComboEdit();
            comboEdit.setKey(FAIL_RETRY_STRATEGY_KEY);
            comboEdit.setView(this.getView());
            comboEdit.setModel(this.getModel());
            comboEdit.setComboItems(Arrays.asList(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u76f4\u63a5\u6302\u8d77", (String)"SchScheduleRetryPlugin_1", (String)"fi-iep-formplugin", (Object[])new Object[0])), FailRetryStrategy.IGNORE.getValue()), new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u91cd\u8bd51\u6b21\u6302\u8d77", (String)"SchScheduleRetryPlugin_2", (String)"fi-iep-formplugin", (Object[])new Object[0])), FailRetryStrategy.TRYAGAIN.getValue()), new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u91cd\u8bd53\u6b21\u6302\u8d77", (String)"SchScheduleRetryPlugin_3", (String)"fi-iep-formplugin", (Object[])new Object[0])), FailRetryStrategy.TRYAGAINTHREE.getValue())));
            e.setControl((Control)comboEdit);
        }
    }
}

