/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.iep.formplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.PrintServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.iep.info.FilingDataModel;
import kd.fi.iep.util.DataSetHelper;
import kd.fi.iep.util.DateUtils;
import kd.fi.iep.util.GLDataUtil;
import kd.fi.iep.util.GLUtil;
import kd.fi.iep.util.IEPDataUtil;

public class VoucherFilingListFormPlugin
extends AbstractFormPlugin {
    public static final String ENTRYKEY = "entryentity";
    public static final String VOUFILINGDATA = "gl_filingdata";
    public static final String FILING = "1";
    public static final String UNFILING = "2";
    private static final String updateSql = "update t_gl_filingdata set fvoucherid = ?,fsendvoucherid = ? where fid = ?";
    private static final String filingSql = "update t_gl_filingdata set ffilingdate = ?,ffilingpersonid = ?, ffilingstatus = ? where fid = ?";
    private static final String KEY_VOUCHER_NO = "voucherno";
    private static final String KEY_BILL_NO = "billno";
    private static final List<String> HYPER_LINK_FIELDS = Arrays.asList("voucherno", "billno");
    public static final String ISSHOWTODAYSCAN = "isshowtodayscan";

    public void initialize() {
        EntryGrid list = (EntryGrid)this.getView().getControl(ENTRYKEY);
        list.addHyperClickListener(evt -> {
            String clickFieldName = evt.getFieldName();
            if (HYPER_LINK_FIELDS.contains(clickFieldName)) {
                int rowIndex = this.getModel().getEntryCurrentRowIndex(ENTRYKEY);
                DynamicObject rowData = this.getModel().getEntryRowEntity(ENTRYKEY, rowIndex);
                if (KEY_VOUCHER_NO.equals(clickFieldName)) {
                    BillShowParameter showParameter = new BillShowParameter();
                    showParameter.setFormId("gl_voucher");
                    showParameter.setPkId(rowData.get("voucherid"));
                    showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                    showParameter.setStatus(OperationStatus.VIEW);
                    this.getView().showForm((FormShowParameter)showParameter);
                } else if (KEY_BILL_NO.equals(clickFieldName)) {
                    String billEntityNumber = ((DynamicObject)rowData.get("billtype")).getString("number");
                    BillShowParameter showParameter = new BillShowParameter();
                    showParameter.setFormId(billEntityNumber);
                    showParameter.setPkId(rowData.get("billid"));
                    showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                    showParameter.setStatus(OperationStatus.VIEW);
                    this.getView().showForm((FormShowParameter)showParameter);
                }
            }
        });
        this.refreshTodayFiledCount();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if (evt.getItemKey().equals("print")) {
            EntryGrid entry = (EntryGrid)this.getControl(ENTRYKEY);
            int[] selRows = entry.getSelectRows();
            if (selRows.length <= 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"VoucherFilingListFormPlugin_0", (String)"fi-iep-formplugin", (Object[])new Object[0]));
                return;
            }
            ArrayList<Long> vouPks = new ArrayList<Long>();
            for (int row : selRows) {
                long voucherId = (Long)this.getModel().getValue("voucherid", row);
                if (voucherId == 0L) continue;
                vouPks.add(voucherId);
            }
            if (vouPks.size() > 0) {
                String url = PrintServiceHelper.createPdfUrl((String)this.getView().getPageId(), (String)"gl_voucher", (String)"gl_voucher_default_prt_s", (Object[])vouPks.toArray(new Object[0]));
                FormShowParameter para = new FormShowParameter();
                para.setFormId("bos_printpreview");
                para.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                para.setCustomParam("src", (Object)url);
                this.getView().showForm(para);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u9700\u8981\u6253\u5370\u7684\u51ed\u8bc1\u3002", (String)"VoucherFilingListFormPlugin_1", (String)"fi-iep-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if (name.equals("input")) {
            String imageNum = (String)e.getChangeSet()[0].getNewValue();
            this.getModel().setValue("input", (Object)"");
            if (StringUtils.isNotEmpty((String)imageNum)) {
                if (this.isExist(imageNum)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u7f16\u7801\u5df2\u626b\u63cf\u8fc7\u3002", (String)"VoucherFilingListFormPlugin_2", (String)"fi-iep-formplugin", (Object[])new Object[0]));
                    return;
                }
                String[] res = this.queryBillIdByImageNum(imageNum);
                if (null == res) {
                    return;
                }
                String billType = res[0];
                try {
                    long id = Long.parseLong(res[1]);
                    this.showData(id, billType, imageNum);
                }
                catch (NumberFormatException exp) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u7cfb\u7edf\u627e\u4e0d\u5230\u8be5\u5355\u636e\uff0c\u8bf7\u68c0\u67e5\u5355\u636e\u662f\u5426\u6765\u81ea\u7b2c\u4e09\u65b9\u7cfb\u7edf\u3002", (String)"VoucherFilingListFormPlugin_3", (String)"fi-iep-formplugin", (Object[])new Object[0]));
                }
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        Map formCustParams = this.getView().getFormShowParameter().getCustomParams();
        if (Boolean.TRUE == formCustParams.get(ISSHOWTODAYSCAN)) {
            this.updateList(this.getTodayScanFilingdata(Long.parseLong(RequestContext.getOrCreate().getUserId())));
        }
    }

    private boolean isExist(String imageNum) {
        IDataModel model = this.getModel();
        String entryKey = ENTRYKEY;
        for (int i = 0; i < model.getEntryRowCount(entryKey); ++i) {
            if (!imageNum.equals(model.getEntryRowEntity(entryKey, i).getString("imagenum"))) continue;
            return true;
        }
        return false;
    }

    private String[] queryBillIdByImageNum(String imageNum) {
        DynamicObject billimagemap = QueryServiceHelper.queryOne((String)"task_billimagemap", (String)"billtype, billid, imagenumber", (QFilter[])new QFilter[]{new QFilter("imagenumber", "=", (Object)imageNum)});
        if (billimagemap == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u5bf9\u5e94\u5355\u636e\u3002", (String)"VoucherFilingListFormPlugin_4", (String)"fi-iep-formplugin", (Object[])new Object[0]));
            return null;
        }
        String billTypeId = billimagemap.getString("billtype");
        String billId = billimagemap.getString("billid");
        String billType = null;
        try {
            long bid = Long.parseLong(billTypeId);
            DynamicObject taskBill = QueryServiceHelper.queryOne((String)"task_taskbill", (String)"bindbill.number", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)bid)});
            if (taskBill == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u5bf9\u5e94\u5355\u636e\u3002", (String)"VoucherFilingListFormPlugin_4", (String)"fi-iep-formplugin", (Object[])new Object[0]));
                return null;
            }
            billType = taskBill.getString("bindbill.number");
        }
        catch (Exception e) {
            billType = billTypeId;
        }
        return new String[]{billType, billId};
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate s = (FormOperate)args.getSource();
        String key = s.getOperateKey();
        EntryGrid entry = (EntryGrid)this.getControl(ENTRYKEY);
        int[] selRows = entry.getSelectRows();
        if (("filing".equals(key) || "unfiling".equals(key) || "relationvoucher".equals(key)) && selRows.length <= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"VoucherFilingListFormPlugin_0", (String)"fi-iep-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        FormOperate s = (FormOperate)afterDoOperationEventArgs.getSource();
        String key = s.getOperateKey();
        IDataModel m = this.getModel();
        EntryGrid entry = (EntryGrid)this.getControl(ENTRYKEY);
        int[] selRows = entry.getSelectRows();
        int index = m.getEntryCurrentRowIndex(ENTRYKEY);
        switch (key) {
            case "filing": {
                Date now = new Date();
                long userId = Long.parseLong(RequestContext.getOrCreate().getUserId());
                ArrayList<Integer> succ = new ArrayList<Integer>();
                StringBuilder errstr = new StringBuilder();
                ArrayList<Object[]> list = new ArrayList<Object[]>();
                for (int row : selRows) {
                    String status = (String)m.getValue("isfiling", row);
                    if (FILING.equals(status)) {
                        errstr.append(String.format(ResManager.loadKDString((String)"%1$s:\u5355\u636e\u5df2\u5f52\u6863\u3002", (String)"VoucherFilingListFormPlugin_5", (String)"fi-iep-formplugin", (Object[])new Object[0]), m.getValue(KEY_BILL_NO, row))).append("\n");
                        continue;
                    }
                    long voucherId = (Long)this.getModel().getValue("voucherid", row);
                    if (voucherId == 0L) {
                        errstr.append(String.format(ResManager.loadKDString((String)"%1$s:\u5355\u636e\u672a\u5173\u8054\u51ed\u8bc1\u3002", (String)"VoucherFilingListFormPlugin_6", (String)"fi-iep-formplugin", (Object[])new Object[0]), m.getValue(KEY_BILL_NO, row))).append("\n");
                        continue;
                    }
                    if (!QueryServiceHelper.exists((String)"gl_voucher", (Object)voucherId)) {
                        errstr.append(m.getValue(KEY_BILL_NO, row)).append(String.format(ResManager.loadKDString((String)"\u8be5\u5355\u636e\u5173\u8054\u603b\u8d26\u51ed\u8bc1\u8bb0\u5f55\u4e0d\u5b58\u5728[ID=%s]\uff0c\u53ef\u80fd\u51ed\u8bc1\u8bb0\u5f55\u5df2\u7ecf\u88ab\u5220\u9664\u3002", (String)"VoucherFilingListFormPlugin_20", (String)"fi-iep-formplugin", (Object[])new Object[0]), voucherId));
                        continue;
                    }
                    succ.add(row);
                    list.add(new Object[]{now, userId, FILING, m.getValue("id", row)});
                }
                if (!succ.isEmpty()) {
                    DB.executeBatch((DBRoute)DBRoute.of((String)"gl"), (String)filingSql, list);
                    int[] succRows = succ.stream().mapToInt(Integer::valueOf).toArray();
                    this.updateList(succRows, now, userId, m, FILING);
                }
                if (errstr.toString().length() <= 0) {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5f52\u6863\u6210\u529f\u3002", (String)"VoucherFilingListFormPlugin_7", (String)"fi-iep-formplugin", (Object[])new Object[0]));
                    break;
                }
                this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u5f52\u6863\u6210\u529f%1$s\u6761\uff0c\u5931\u8d25%2$s\u6761\u3002", (String)"VoucherFilingListFormPlugin_8", (String)"fi-iep-formplugin", (Object[])new Object[0]), succ.size(), selRows.length - succ.size()), errstr.toString(), MessageTypes.Default);
                break;
            }
            case "unfiling": {
                ArrayList<Integer> succ = new ArrayList<Integer>();
                StringBuilder errstr = new StringBuilder();
                ArrayList<Object[]> list2 = new ArrayList<Object[]>();
                for (int row : selRows) {
                    String status = (String)m.getValue("isfiling", row);
                    if (UNFILING.equals(status)) {
                        errstr.append(String.format(ResManager.loadKDString((String)"%1$s:\u5355\u636e\u672a\u8fdb\u884c\u5f52\u6863\u3002", (String)"VoucherFilingListFormPlugin_10", (String)"fi-iep-formplugin", (Object[])new Object[0]), m.getValue(KEY_BILL_NO, row))).append("\n");
                        continue;
                    }
                    succ.add(row);
                    list2.add(new Object[]{null, 0, UNFILING, m.getValue("id", row)});
                }
                if (!succ.isEmpty()) {
                    DB.executeBatch((DBRoute)DBRoute.of((String)"gl"), (String)filingSql, list2);
                    int[] succRows = succ.stream().mapToInt(Integer::valueOf).toArray();
                    this.updateList(succRows, null, null, m, UNFILING);
                }
                if (errstr.toString().length() <= 0) {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53cd\u5f52\u6863\u6210\u529f\u3002", (String)"VoucherFilingListFormPlugin_11", (String)"fi-iep-formplugin", (Object[])new Object[0]));
                    break;
                }
                this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u53cd\u5f52\u6863\u6210\u529f%1$s\u6761\uff0c\u5931\u8d25%2$s\u6761\u3002", (String)"VoucherFilingListFormPlugin_9", (String)"fi-iep-formplugin", (Object[])new Object[0]), succ.size(), selRows.length - succ.size()), errstr.toString(), MessageTypes.Default);
                break;
            }
            case "relationvoucher": {
                if (selRows.length > 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u6279\u91cf\u5173\u8054\u51ed\u8bc1\uff0c\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"VoucherFilingListFormPlugin_12", (String)"fi-iep-formplugin", (Object[])new Object[0]));
                    return;
                }
                String filingStatus = (String)m.getValue("isfiling", index);
                if (FILING.equals(filingStatus)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5f52\u6863\u7684\u5355\u636e\u4e0d\u5141\u8bb8\u4fee\u6539\u5173\u8054\u51ed\u8bc1\u3002", (String)"VoucherFilingListFormPlugin_13", (String)"fi-iep-formplugin", (Object[])new Object[0]));
                    return;
                }
                Object relateVoucherId = m.getValue("voucherid", index);
                if (Objects.nonNull(relateVoucherId) && !relateVoucherId.toString().equals("0")) {
                    try {
                        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)relateVoucherId, (String)"gl_voucher");
                        if (!"0".equals(dynamicObject.getString("sourcetype"))) {
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u5df2\u7ecf\u751f\u6210\u51ed\u8bc1\uff0c\u4e0d\u652f\u6301\u5173\u8054\u51ed\u8bc1\u3002", (String)"VoucherFilingListFormPlugin_14", (String)"fi-iep-formplugin", (Object[])new Object[0]));
                            return;
                        }
                    }
                    catch (Exception dynamicObject) {
                        // empty catch block
                    }
                }
                if (!Objects.nonNull(m.getValue("billtype", index))) break;
                String billType = ((DynamicObject)m.getValue("billtype", index)).getString("number");
                long billId = (Long)m.getValue("billid", index);
                this.relationVoucher(billType, billId, relateVoucherId);
                break;
            }
        }
        this.refreshTodayFiledCount();
    }

    private void updateList(int[] selRows, Date now, Long userId, IDataModel m, String status) {
        for (int row : selRows) {
            m.setValue("isfiling", (Object)status, row);
            m.setValue("fileperson", (Object)userId, row);
            m.setValue("filedate", (Object)now, row);
        }
    }

    private void relationVoucher(String billType, long billId, Object relateVoucherId) {
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)billType);
        String mainOrgField = mainEntityType.getMainOrg();
        DynamicObject billObj = QueryServiceHelper.queryOne((String)billType, (String)(mainOrgField + "," + mainOrgField + ".fisaccounting"), (QFilter[])new QFilter("id", "=", (Object)billId).toArray());
        long orgid = billObj.getLong(mainOrgField);
        QFilter fitler = new QFilter("bizorgentry.bizorg", "=", (Object)orgid);
        DynamicObjectCollection orgCol = QueryServiceHelper.query((String)"bd_accountingsys", (String)"bizorgentry.bizacctorg", (QFilter[])new QFilter[]{fitler});
        Set bizOrgIds = orgCol.parallelStream().map(o -> o.getLong("bizorgentry.bizacctorg")).collect(Collectors.toSet());
        if (billObj.getBoolean(mainOrgField + ".fisaccounting")) {
            bizOrgIds.add(orgid);
        }
        ListShowParameter show = ShowFormHelper.createShowListForm((String)"gl_voucherf7list", (boolean)false, (int)2, (boolean)true);
        show.setShowFilter(true);
        show.setShowQuickFilter(true);
        show.getListFilterParameter().getQFilters().add(new QFilter("sourcetype", "=", (Object)"0"));
        show.getListFilterParameter().getQFilters().add(new QFilter("org", "in", bizOrgIds));
        if (Objects.nonNull(relateVoucherId) && !relateVoucherId.toString().equals("0")) {
            show.getListFilterParameter().getQFilters().add(new QFilter("id", "!=", relateVoucherId));
        }
        show.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "voucher"));
        this.getView().showForm((FormShowParameter)show);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId;
        super.closedCallBack(evt);
        switch (actionId = evt.getActionId()) {
            case "voucher": {
                ListSelectedRowCollection rows = (ListSelectedRowCollection)evt.getReturnData();
                if (null == rows || rows.size() == 0) {
                    return;
                }
                IDataModel m = this.getModel();
                int index = m.getEntryCurrentRowIndex(ENTRYKEY);
                long id = (Long)rows.get(0).getPrimaryKeyValue();
                boolean isExist = QueryServiceHelper.exists((String)VOUFILINGDATA, (QFilter[])new QFilter[]{new QFilter("voucherid", "=", (Object)id)});
                if (isExist) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u51ed\u8bc1\u5df2\u88ab\u5173\u8054\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"VoucherFilingListFormPlugin_15", (String)"fi-iep-formplugin", (Object[])new Object[0]));
                    return;
                }
                DynamicObject vou = this.queryVoucher(id);
                this.updateVoucherInfo(vou, index, m);
                break;
            }
        }
    }

    private void updateVoucherInfo(DynamicObject vou, int index, IDataModel m) {
        DynamicObject acVou;
        m.setValue("period", (Object)vou.getLong("period"), index);
        m.setValue("vouchertype", (Object)vou.getLong("vouchertype"), index);
        m.setValue("org", (Object)vou.getLong("org"), index);
        m.setValue("vdesc", (Object)vou.getString("vdescription"), index);
        m.setValue(KEY_VOUCHER_NO, (Object)vou.getString(KEY_BILL_NO), index);
        m.setValue("voucherid", (Object)vou.getLong("id"), index);
        long acVouId = this.getVoucerSendId(vou.getLong("id"));
        if (acVouId != 0L && (acVou = this.queryVoucher(acVouId)) != null) {
            m.setValue("voucherrealtion", (Object)acVou.getString(KEY_BILL_NO), index);
        }
        long id = (Long)m.getValue("id", index);
        this.updateVoucherInfo(vou.getLong("id"), acVouId, id);
    }

    private void updateVoucherInfo(long voucherId, long sendVoucherId, long filingDataId) {
        Object[] params = new Object[]{voucherId, sendVoucherId, filingDataId};
        DB.execute((DBRoute)DBRoute.of((String)"gl"), (String)updateSql, (Object[])params);
    }

    private void showData(long billId, String billType, String imageNumber) {
        if (billId == 0L || StringUtils.isEmpty((String)billType)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5355\u636e\u4e8c\u7ef4\u7801\u4fe1\u606f\u4e0d\u5b8c\u6574\uff0c\u65e0\u6cd5\u67e5\u627e\u6570\u636e\u3002", (String)"VoucherFilingListFormPlugin_16", (String)"fi-iep-formplugin", (Object[])new Object[0]));
            return;
        }
        QFilter fbillType = new QFilter("billtype", "=", (Object)billType);
        QFilter fbillid = new QFilter("billid", "=", (Object)billId);
        DynamicObject obj = QueryServiceHelper.queryOne((String)VOUFILINGDATA, (String)"id,billid,billtype,voucherid,sendvoucherid,filingperson,filingdate,filingstatus,scanperson", (QFilter[])new QFilter[]{fbillType, fbillid});
        if (null != obj) {
            this.checkAndReRelateVoucher(obj.getLong("id"));
            obj = QueryServiceHelper.queryOne((String)VOUFILINGDATA, (String)"id,billid,billtype,voucherid,sendvoucherid,filingperson,filingdate,filingstatus,scanperson", (QFilter[])new QFilter[]{fbillType, fbillid});
            List<FilingDataModel> data = this.dataConversion(obj, imageNumber);
            Long scanPersonId = data.get(0).getScanperson();
            if (UNFILING.equals(data.get(0).isFiling())) {
                this.updateFilingDataScanDate(obj.getLong("id"));
            }
            this.updateList(data);
            DB.execute((DBRoute)DBRoute.of((String)"gl"), (String)"update t_gl_filingdata set fcreatetime = ? where fid = ? ", (Object[])new Object[]{new Date(), obj.getLong("id")});
        } else {
            DynamicObjectCollection dap = VoucherFilingListFormPlugin.queryDAPRelation(billId, billType);
            String billNo = this.getBillNo(billId, billType);
            if (null == billNo) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u5355\u636e\u3002", (String)"VoucherFilingListFormPlugin_19", (String)"fi-iep-formplugin", (Object[])new Object[0]));
                return;
            }
            ArrayList<FilingDataModel> data = new ArrayList<FilingDataModel>();
            if (dap.size() == 0) {
                FilingDataModel m = this.getFilingDataModel(billId, billType, billNo, imageNumber);
                long id = this.saveData(billId, billType);
                m.setId(id);
                data.add(m);
            } else {
                for (DynamicObject dy : dap) {
                    long vchId = dy.getLong("voucherid");
                    DynamicObject vou = this.queryVoucher(vchId);
                    if (vchId > 0L && Objects.isNull(vou)) {
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8be5\u5355\u636e\u5173\u8054\u603b\u8d26\u51ed\u8bc1\u8bb0\u5f55\u4e0d\u5b58\u5728[ID=%s]\uff0c\u53ef\u80fd\u51ed\u8bc1\u8bb0\u5f55\u5df2\u7ecf\u88ab\u5220\u9664\u3002", (String)"VoucherFilingListFormPlugin_20", (String)"fi-iep-formplugin", (Object[])new Object[0]), vchId));
                        return;
                    }
                    this.dataConversion(billNo, billId, billType, imageNumber, vou, data);
                }
            }
            this.updateList(data);
        }
    }

    private FilingDataModel getFilingDataModel(long billId, String billType, String billNo, String imageNumber) {
        FilingDataModel m = new FilingDataModel();
        m.setBillId(billId);
        m.setBillNo(billNo);
        m.setBillType(billType);
        m.setFiling(UNFILING);
        m.setImageNumber(imageNumber);
        return m;
    }

    private void checkAndReRelateVoucher(long fillingDataId) {
        DynamicObjectCollection dap;
        DynamicObject fillingDataDy = QueryServiceHelper.queryOne((String)VOUFILINGDATA, (String)"id,billid,billtype,voucherid,filingstatus", (QFilter[])new QFilter("id", "=", (Object)fillingDataId).toArray());
        String fillingStatus = fillingDataDy.getString("filingstatus");
        if (UNFILING.equals(fillingStatus) && fillingDataDy.getLong("voucherid") == 0L && (dap = VoucherFilingListFormPlugin.queryDAPRelation(fillingDataDy.getLong("billid"), fillingDataDy.getString("billtype"))).size() > 0) {
            long vchId = ((DynamicObject)dap.get(0)).getLong("voucherid");
            long acVouId = this.getVoucerSendId(vchId);
            this.updateVoucherInfo(vchId, acVouId, fillingDataId);
        }
    }

    private static DynamicObjectCollection queryDAPRelation(long billId, String billType) {
        QFilter fbillId = new QFilter("sourcebillid", "=", (Object)billId);
        QFilter fbillType = new QFilter("billtype", "=", (Object)billType);
        QFilter validFilter = new QFilter("voucherid", ">", (Object)0L);
        return QueryServiceHelper.query((String)"ai_daptracker", (String)"sourcebillid, voucherid", (QFilter[])new QFilter[]{fbillId, fbillType, validFilter});
    }

    private List<FilingDataModel> dataConversion(DynamicObject obj, String imageNumber) {
        DynamicObject vou;
        ArrayList<FilingDataModel> list = new ArrayList<FilingDataModel>();
        FilingDataModel m = null;
        m = new FilingDataModel();
        m.setId(obj.getLong("id"));
        long billId = obj.getLong("billid");
        String billType = obj.getString("billtype");
        m.setBillId(billId);
        String billNo = this.getBillNo(billId, billType);
        m.setBillNo(billNo);
        m.setBillType(billType);
        m.setFiling(obj.getString("filingstatus"));
        m.setFilingPerson(obj.getLong("filingperson"));
        m.setFilingDate(obj.getDate("filingdate"));
        m.setScanperson(obj.getLong("scanperson"));
        long voucherId = obj.getLong("voucherid");
        if (voucherId != 0L && null != (vou = this.queryVoucher(voucherId))) {
            DynamicObject sendVou;
            m.setVoucherNo(vou.getString(KEY_BILL_NO));
            m.setPeriod(vou.getLong("period"));
            m.setOrgId(vou.getLong("org"));
            m.setVdesc(vou.getString("vdescription"));
            m.setVoucherType(vou.getLong("vouchertype"));
            m.setVoucherId(voucherId);
            long sendVoucherId = obj.getLong("sendvoucherid");
            if (sendVoucherId != 0L && null != (sendVou = this.queryVoucher(sendVoucherId))) {
                m.setVoucherSendNo(sendVou.getString(KEY_BILL_NO));
            }
        }
        m.setImageNumber(imageNumber);
        list.add(m);
        return list;
    }

    private DynamicObject queryVoucher(long id) {
        QFilter fvouId = new QFilter("id", "=", (Object)id);
        DynamicObject vou = QueryServiceHelper.queryOne((String)"gl_voucher", (String)"id, billno,org,vdescription, vouchertype, period", (QFilter[])fvouId.toArray());
        return vou;
    }

    private void dataConversion(String billNo, long billId, String billType, String imageNumber, DynamicObject vou, List<FilingDataModel> data) {
        DynamicObject acVch;
        FilingDataModel m = this.getFilingDataModel(billId, billType, billNo, imageNumber);
        m.setVoucherNo(vou.getString(KEY_BILL_NO));
        m.setVoucherType(vou.getLong("vouchertype"));
        m.setVdesc(vou.getString("vdescription"));
        m.setOrgId(vou.getLong("org"));
        m.setPeriod(vou.getLong("period"));
        m.setVoucherId(vou.getLong("id"));
        m.setImageNumber(imageNumber);
        long acVchId = this.getVoucerSendId(vou.getLong("id"));
        if (acVchId != 0L && (acVch = this.queryVoucher(acVchId)) != null) {
            m.setVoucherSendNo(acVch.getString(KEY_BILL_NO));
        }
        DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)VOUFILINGDATA);
        obj.set("billid", (Object)billId);
        obj.set("billtype", (Object)billType);
        obj.set("voucherid", (Object)vou.getLong("id"));
        obj.set("sendvoucherid", (Object)acVchId);
        obj.set("filingstatus", (Object)UNFILING);
        obj.set("createtime", (Object)new Date());
        obj.set("scanperson", (Object)Long.parseLong(RequestContext.getOrCreate().getUserId()));
        Object[] objs = SaveServiceHelper.save((IDataEntityType)obj.getDataEntityType(), (Object[])new DynamicObject[]{obj});
        m.setId(((DynamicObject)objs[0]).getLong("id"));
        data.add(m);
    }

    private long getVoucerSendId(long vouId) {
        DynamicObject acnotice = QueryServiceHelper.queryOne((String)"gl_acnotice", (String)"id", (QFilter[])new QFilter("voucher", "=", (Object)vouId).toArray());
        long acVchId = 0L;
        if (acnotice != null) {
            long acId = acnotice.getLong("id");
            QFilter fsid = new QFilter("sourcebillid", "=", (Object)acId);
            DynamicObject dap = QueryServiceHelper.queryOne((String)"ai_daptracker", (String)"voucherid", (QFilter[])new QFilter[]{fsid});
            if (dap != null) {
                acVchId = dap.getLong("voucherid");
            }
        }
        return acVchId;
    }

    private long saveData(long billId, String billType) {
        DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)VOUFILINGDATA);
        obj.set("billid", (Object)billId);
        obj.set("billtype", (Object)billType);
        obj.set("createtime", (Object)new Date());
        obj.set("filingstatus", (Object)UNFILING);
        obj.set("scanperson", (Object)Long.parseLong(RequestContext.getOrCreate().getUserId()));
        Object[] objs = SaveServiceHelper.save((IDataEntityType)obj.getDataEntityType(), (Object[])new DynamicObject[]{obj});
        return ((DynamicObject)objs[0]).getLong("id");
    }

    private String getBillNo(long billId, String billType) {
        QFilter fid = new QFilter("id", "=", (Object)billId);
        DynamicObject bill = QueryServiceHelper.queryOne((String)billType, (String)KEY_BILL_NO, (QFilter[])new QFilter[]{fid});
        if (bill != null) {
            return bill.getString(KEY_BILL_NO);
        }
        return null;
    }

    private void updateList(List<FilingDataModel> data) {
        IDataModel m = this.getModel();
        for (FilingDataModel fd : data) {
            int i = m.insertEntryRow(ENTRYKEY, 0);
            m.setValue("isfiling", (Object)fd.isFiling(), i);
            m.setValue("billtype", (Object)fd.getBillType(), i);
            m.setValue(KEY_BILL_NO, (Object)fd.getBillNo(), i);
            m.setValue("org", (Object)fd.getOrgId(), i);
            m.setValue("vouchertype", (Object)fd.getVoucherType(), i);
            m.setValue("vdesc", (Object)fd.getVdesc(), i);
            m.setValue("voucherrealtion", (Object)fd.getVoucherSendNo(), i);
            m.setValue(KEY_VOUCHER_NO, (Object)fd.getVoucherNo(), i);
            m.setValue("period", (Object)fd.getPeriod(), i);
            m.setValue("fileperson", (Object)fd.getFilingPerson(), i);
            m.setValue("filedate", (Object)fd.getFilingDate(), i);
            m.setValue("id", (Object)fd.getId(), i);
            m.setValue("billid", (Object)fd.getBillId(), i);
            m.setValue("voucherid", (Object)fd.getVoucherId(), i);
            m.setValue("imagenum", (Object)fd.getImageNumber(), i);
        }
    }

    private void refreshTodayFiledCount() {
        Label count = (Label)this.getControl("todayaccfiledcnt");
        count.setText(String.valueOf(IEPDataUtil.countTodayFiledData((long)Long.parseLong(RequestContext.getOrCreate().getUserId()))));
    }

    private void updateFilingDataScanDate(Long filingDataId) {
        Objects.requireNonNull(filingDataId);
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        list.add(new Object[]{new Date(), filingDataId});
        DB.executeBatch((DBRoute)DBRoute.of((String)"gl"), (String)"update t_gl_filingdata set fcreatetime = ? where fid = ?", list);
    }

    private List<FilingDataModel> getTodayScanFilingdata(long userId) {
        ArrayList<FilingDataModel> resultList = new ArrayList<FilingDataModel>(16);
        Date now = new Date();
        String filingDataSchema = "id fillid,billid,billtype,voucherid,sendvoucherid,filingperson,filingstatus,createtime,filingdate";
        QFilter scanEndFilter = new QFilter("createtime", "<", (Object)DateUtils.getDataFormat((Date)now, (boolean)false));
        QFilter scanStartFilter = new QFilter("createtime", ">=", (Object)DateUtils.getDataFormat((Date)now, (boolean)true));
        QFilter scanOwnerFilter = new QFilter("scanperson", "=", (Object)userId);
        try (DataSet todayFilingIds = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)VOUFILINGDATA, (String)"id", (QFilter[])new QFilter[]{scanEndFilter, scanStartFilter, scanOwnerFilter}, (String)"createtime desc");){
            while (todayFilingIds.hasNext()) {
                this.checkAndReRelateVoucher(todayFilingIds.next().getLong("id"));
            }
        }
        var10_9 = null;
        try (DataSet filingDataDs = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)VOUFILINGDATA, (String)filingDataSchema, (QFilter[])new QFilter[]{scanEndFilter, scanStartFilter, scanOwnerFilter}, (String)"createtime desc");){
            List voucherIds = DataSetHelper.extractLongColumnValues((DataSet)filingDataDs, (String)"voucherid", (boolean)true);
            String voucherSelect = "id voucherid,org.id orgid, period.id periodid,vouchertype.id vouchertypeid,billno vouchernumber,book.basecurrency bookcurrency, vdescription vouchersummary";
            DataSet voucherInfoDs = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"gl_voucher", (String)voucherSelect, (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)voucherIds)}, null);
            DataSet billInfoDs = filingDataDs.leftJoin(voucherInfoDs).on("voucherid", "voucherid").select(GLUtil.getDataSetCols((DataSet)filingDataDs).toArray(new String[0]), GLUtil.getDataSetCols((DataSet)voucherInfoDs, (String[])new String[]{"voucherid"}).toArray(new String[0])).finish();
            DataSet noticeVoucherIdEnhanceDs = billInfoDs.leftJoin(GLDataUtil.buildNoticeVoucherDataset((List)voucherIds)).on("voucherid", "voucherid").select(GLUtil.getDataSetCols((DataSet)billInfoDs).toArray(new String[0]), new String[]{"noticevoucherid"}).finish();
            List noticeVoucherIds = DataSetHelper.extractLongColumnValues((DataSet)noticeVoucherIdEnhanceDs, (String)"noticevoucherid", (boolean)true);
            DataSet noticeInfoDs = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"gl_voucher", (String)"id voucherid, billno noticevouchernumber", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)noticeVoucherIds)}, null);
            DataSet billImageInfoDs = GLDataUtil.queryAllBillFromImageShareCenter(DataSetHelper.extractLongColumnValues((DataSet)filingDataDs, (String)"billid", (boolean)false).stream().map(Object::toString).collect(Collectors.toList()));
            DataSet billNoDs = IEPDataUtil.buildBillNumberDs((DataSet)noticeVoucherIdEnhanceDs);
            DataSet noticeVoucherNumberEnhanceDs = noticeVoucherIdEnhanceDs.leftJoin(noticeInfoDs).on("noticevoucherid", "voucherid").select(GLUtil.getDataSetCols((DataSet)noticeVoucherIdEnhanceDs).toArray(new String[0]), new String[]{"noticevouchernumber"}).finish();
            try (DataSet targetDs = noticeVoucherNumberEnhanceDs.leftJoin(billImageInfoDs).on("billid", "billid").select(GLUtil.getDataSetCols((DataSet)noticeVoucherNumberEnhanceDs).toArray(new String[0]), new String[]{"imagenumber"}).finish().leftJoin(billNoDs).on("billid", "billid").select(GLUtil.getDataSetColsAdd((DataSet)noticeVoucherNumberEnhanceDs, (String[])new String[]{"imagenumber"}).toArray(new String[0]), new String[]{KEY_BILL_NO}).finish().orderBy(new String[]{"createtime asc"});){
                targetDs.forEach(row -> {
                    Long voucherId;
                    Long orgId;
                    FilingDataModel m = new FilingDataModel();
                    resultList.add(m);
                    m.setId(row.getLong("fillid"));
                    m.setBillId(row.getLong("billid"));
                    m.setBillNo(row.getString(KEY_BILL_NO));
                    m.setImageNumber(row.getString("imagenumber"));
                    m.setBillType(row.getString("billtype"));
                    m.setFiling(row.getString("filingstatus"));
                    m.setFilingPerson(row.getLong("filingperson"));
                    m.setFilingDate(row.getDate("filingdate"));
                    m.setVoucherNo(row.getString("vouchernumber"));
                    Long periodId = row.getLong("periodid");
                    if (Objects.nonNull(periodId)) {
                        m.setPeriod(periodId);
                    }
                    if (Objects.nonNull(orgId = row.getLong("orgid"))) {
                        m.setOrgId(orgId);
                    }
                    m.setVdesc(row.getString("vouchersummary"));
                    Long voucherTypeId = row.getLong("vouchertypeid");
                    if (Objects.nonNull(voucherTypeId)) {
                        m.setVoucherType(voucherTypeId);
                    }
                    if (Objects.nonNull(voucherId = row.getLong("voucherid"))) {
                        m.setVoucherId(voucherId);
                    }
                    m.setVoucherSendNo(row.getString("noticevouchernumber"));
                });
            }
        }
        catch (Throwable throwable) {
            var10_9 = throwable;
            throw throwable;
        }
        return resultList;
    }
}

