/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.iep.task;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.fi.iep.util.LogORMHelper;

public class ClearDayLogTask
extends AbstractTask {
    private static final int PAST = 2;
    private static final int SINGLECOUNT = 1000;
    private static final int PAGESIZE = 1000;
    private static final Log logger = LogFactory.getLog((String)"ClearDayLogTask");
    private static final String ENTITY_IEP_SCHEMESUMLOG = "gl_intelschemasumlog";
    private static final String ENTITY_IEP_INTELOPERSUMLOG = "gl_intellopersumlog";
    private static final String ENTITY_IEP_INTELEXECDETAIL = "gl_intellexecdetaillog";
    private static final String ENTITY_IEP_INTELEXECDETAILNEW = "iep_intellexecdetaillog";

    public void execute(RequestContext arg0, Map<String, Object> arg1) throws KDException {
        try {
            long schemeSumLogSize;
            String currentLogDate = ClearDayLogTask.getPastDate(0);
            logger.info(String.format("ClearDayLogTask-\u7cfb\u7edf\u4e8e[%s]\u5f00\u59cb\u6267\u884c\u8c03\u5ea6\u8ba1\u5212\u6e05\u7406\u667a\u80fd\u6838\u7b97\u65e5\u5fd7", currentLogDate));
            Calendar calendar = Calendar.getInstance();
            calendar.set(6, calendar.get(6) - 2);
            Date today = calendar.getTime();
            Set<Long> schemeSumLogSet = ClearDayLogTask.getClearSchemeSumLogId(today);
            Map<Long, Set<Long>> opeaLogIdMap = ClearDayLogTask.getClearOperateLogId(schemeSumLogSet);
            long totalCount = schemeSumLogSize = (long)schemeSumLogSet.size();
            String startRecordDate = ClearDayLogTask.getPastDate(0);
            logger.info(String.format(ResManager.loadKDString((String)"ClearDayLogTask-\u7cfb\u7edf\u4e8e[%1$s]\u5171\u83b7\u53d6\u9700\u8981\u5220\u9664\u667a\u80fd\u6838\u7b97\u65e5\u5fd7\u6570\u636e:[%2$s]\u6761", (String)"ClearDayLogTask_0", (String)"fi-iep-formplugin", (Object[])new Object[0]), startRecordDate, schemeSumLogSize));
            Iterator<Long> iter = schemeSumLogSet.iterator();
            HashSet<Long> shemeIdCache = new HashSet<Long>();
            HashSet<Long> operateIdCache = new HashSet<Long>();
            long count = 0L;
            HashMap<Long, Integer> deleteOperateDetail = new HashMap<Long, Integer>(16);
            while (iter != null && iter.hasNext()) {
                Long shemeId = iter.next();
                shemeIdCache.add(shemeId);
                Set<Long> operaLogs = opeaLogIdMap.get(shemeId);
                if (operaLogs != null && !operaLogs.isEmpty()) {
                    operateIdCache.addAll(operaLogs);
                }
                if (1000L == ++count || schemeSumLogSize == count) {
                    try (TXHandle tx = TX.requiresNew((String)"fi.iep.cleardaylog");){
                        try {
                            this.deleteOperateDetailLogBatch(operateIdCache, shemeIdCache, deleteOperateDetail);
                            this.deleteOperateLogBatch(operateIdCache);
                            DeleteServiceHelper.delete((String)ENTITY_IEP_SCHEMESUMLOG, (QFilter[])new QFilter[]{new QFilter("id", "in", shemeIdCache)});
                            shemeIdCache.clear();
                            operateIdCache.clear();
                            logger.info(String.format(ResManager.loadKDString((String)"ClearDayLogTask-\u7cfb\u7edf\u4e8e[%1$s]\u5df2\u6267\u884c\u667a\u80fd\u6838\u7b97\u65e5\u5fd7\u6e05\u7406\uff0c\u5df2\u6e05\u7406\u667a\u80fd\u6838\u7b97\u65b9\u6848\u65e5\u5fd7[gl_intelschemasumlog]\uff1a[%2$s]\u6761", (String)"ClearDayLogTask_1", (String)"fi-iep-formplugin", (Object[])new Object[0]), ClearDayLogTask.getPastDate(0), count));
                        }
                        catch (Exception e) {
                            tx.markRollback();
                            startRecordDate = ClearDayLogTask.getPastDate(0);
                            logger.error(String.format(ResManager.loadKDString((String)"ClearDayLogTask-\u7cfb\u7edf\u4e8e[%1$s]\u5220\u9664\u667a\u80fd\u6838\u7b97\u65e5\u5fd7\u6570\u636e\u51fa\u9519\uff0c\u539f\u56e0\uff1a%2$s", (String)"ClearDayLogTask_2", (String)"fi-iep-formplugin", (Object[])new Object[0]), startRecordDate, e));
                        }
                    }
                }
                if (schemeSumLogSize != count) continue;
                schemeSumLogSet = ClearDayLogTask.getClearSchemeSumLogId(today);
                opeaLogIdMap = ClearDayLogTask.getClearOperateLogId(schemeSumLogSet);
                schemeSumLogSize = schemeSumLogSet.size();
                totalCount += schemeSumLogSize;
                iter = schemeSumLogSet.iterator();
                count = 0L;
                startRecordDate = ClearDayLogTask.getPastDate(0);
                logger.info(String.format("ClearDayLogTask-\u7cfb\u7edf\u4e8e[%s]\u5171\u83b7\u53d6\u9700\u8981\u5220\u9664\u667a\u80fd\u6838\u7b97\u65e5\u5fd7\u6570\u636e:[%s]\u6761", startRecordDate, schemeSumLogSize));
            }
            List params = deleteOperateDetail.entrySet().stream().filter(v -> (Integer)v.getValue() > 0).map(v -> new Object[]{v.getValue(), v.getKey(), today}).collect(Collectors.toList());
            if (params.size() > 0) {
                DB.executeBatch((DBRoute)DBRoute.of((String)"fi"), (String)"update t_gl_intellschemasumlog set ffailsumquantity = ffailsumquantity - ? where fintelschemaId = ? and fexecenddate >= ? and ffailsumquantity > 0;", params.stream().distinct().collect(Collectors.toList()));
            }
            String endLogDate = ClearDayLogTask.getPastDate(0);
            logger.info(String.format("ClearDayLogTask-\u7cfb\u7edf\u4e8e[%s]\u7ed3\u675f\u6267\u884c\u667a\u80fd\u6838\u7b97\u65e5\u5fd7\u6e05\u7406\uff0c\u7d2f\u8ba1\u6e05\u7406\u6838\u7b97\u65e5\u5fd7\uff1a[%s]\u6761", endLogDate, totalCount));
        }
        catch (Exception e) {
            logger.error(String.format("ClearDayLogTask-\u7cfb\u7edf\u6267\u884c\u667a\u80fd\u6838\u7b97\u65e5\u5fd7\u6e05\u7406\u51fa\u9519\uff0c\u539f\u56e0\uff1a%s", e), (Throwable)e);
            throw e;
        }
    }

    private void deleteOperateLogBatch(Set<Long> operateIdCache) {
        try {
            HashSet<Long> leftCache = new HashSet<Long>();
            leftCache.addAll(operateIdCache);
            HashSet<Long> operIdCache = new HashSet<Long>();
            Set<Long> singleBatchSet = ClearDayLogTask.getClearOperateLogIdBatch(leftCache);
            int singleBatchSize = singleBatchSet.size();
            Iterator<Long> logIter = singleBatchSet.iterator();
            int count = 0;
            while (logIter != null && logIter.hasNext()) {
                Long logId = logIter.next();
                operIdCache.add(logId);
                if (1000 == ++count || singleBatchSize == count) {
                    try (TXHandle detalTx = TX.requiresNew((String)"fi.iep.gl_intellopersumlog");){
                        try {
                            DeleteServiceHelper.delete((String)ENTITY_IEP_INTELOPERSUMLOG, (QFilter[])new QFilter[]{new QFilter("id", "in", operIdCache)});
                            operIdCache.clear();
                            logger.info(String.format(ResManager.loadKDString((String)"ClearDayLogTask-\u7cfb\u7edf\u4e8e[%1$s]\u6267\u884c\u667a\u80fd\u6838\u7b97\u65e5\u5fd7\u6e05\u7406\uff0c\u5df2\u6e05\u7406\u667a\u80fd\u6838\u7b97\u64cd\u4f5c\u65e5\u5fd7[gl_intellopersumlog]\uff1a[%2$s]\u6761", (String)"ClearDayLogTask_3", (String)"fi-iep-formplugin", (Object[])new Object[0]), ClearDayLogTask.getPastDate(0), count));
                        }
                        catch (Exception e) {
                            detalTx.markRollback();
                            logger.info(String.format(ResManager.loadKDString((String)"ClearDayLogTask-\u7cfb\u7edf\u4e8e[%1$s]\u5220\u9664\u667a\u80fd\u6838\u7b97\u64cd\u4f5c\u65e5\u5fd7\u6570\u636e\u51fa\u9519\uff0c\u539f\u56e0\uff1a%2$s", (String)"ClearDayLogTask_4", (String)"fi-iep-formplugin", (Object[])new Object[0]), ClearDayLogTask.getPastDate(0), e));
                        }
                    }
                }
                if (singleBatchSize != count) continue;
                leftCache.removeAll(singleBatchSet);
                singleBatchSet = ClearDayLogTask.getClearOperateLogIdBatch(leftCache);
                singleBatchSize = singleBatchSet.size();
                logIter = singleBatchSet.iterator();
                count = 0;
            }
        }
        catch (Exception e) {
            logger.info(String.format("ClearDayLogTask-\u7cfb\u7edf\u4e8e[%s]\u5220\u9664\u667a\u80fd\u6838\u7b97\u64cd\u4f5c\u65e5\u5fd7\u6570\u636e\u51fa\u9519\uff0c\u539f\u56e0\uff1a%s", ClearDayLogTask.getPastDate(0), e));
            throw e;
        }
    }

    private void deleteOperateDetailLogBatch(Set<Long> operateIdCache, Set<Long> shemeIdCache, Map<Long, Integer> deleteOperateDetail) {
        try {
            HashSet<Long> operDtailIdCache = new HashSet<Long>();
            Map<Long, Long> singleBatchMap = ClearDayLogTask.getClearOperateDetailLogIdBatchs(operateIdCache, shemeIdCache);
            int singleBatchSize = singleBatchMap.size();
            Iterator<Map.Entry<Long, Long>> detialIter = singleBatchMap.entrySet().iterator();
            int count = 0;
            while (detialIter != null && detialIter.hasNext()) {
                Map.Entry<Long, Long> entry = detialIter.next();
                Long intellSchemaId = entry.getValue();
                Long detailId = entry.getKey();
                operDtailIdCache.add(detailId);
                int size = deleteOperateDetail.getOrDefault(intellSchemaId, 0);
                deleteOperateDetail.put(intellSchemaId, size + 1);
                if (1000 == ++count || singleBatchSize == count) {
                    try (TXHandle detalTx = TX.requiresNew((String)"fi.iep.iep_intellexecdetaillog");){
                        try {
                            LogORMHelper.delete((String)ENTITY_IEP_INTELEXECDETAILNEW, (QFilter[])new QFilter[]{new QFilter("id", "in", operDtailIdCache)});
                            operDtailIdCache.clear();
                            logger.info(String.format(ResManager.loadKDString((String)"ClearDayLogTask-\u7cfb\u7edf\u4e8e[%1$s]\u6267\u884c\u667a\u80fd\u6838\u7b97\u65e5\u5fd7\u6e05\u7406\uff0c\u5df2\u6e05\u7406\u667a\u80fd\u6838\u7b97\u64cd\u4f5c\u65e5\u5fd7\u660e\u7ec6\u6570\u636e[gl_intellexecdetaillog]\uff1a[%2$s]\u6761", (String)"ClearDayLogTask_5", (String)"fi-iep-formplugin", (Object[])new Object[0]), ClearDayLogTask.getPastDate(0), count));
                        }
                        catch (Exception e) {
                            detalTx.markRollback();
                            String startRecordDate = ClearDayLogTask.getPastDate(0);
                            logger.error(String.format(ResManager.loadKDString((String)"ClearDayLogTask-\u7cfb\u7edf\u4e8e[%1$s]\u5220\u9664\u667a\u80fd\u6838\u7b97\u64cd\u4f5c\u65e5\u5fd7\u660e\u7ec6\u6570\u636e\u51fa\u9519\uff0c\u539f\u56e0\uff1a%2$s", (String)"ClearDayLogTask_6", (String)"fi-iep-formplugin", (Object[])new Object[0]), startRecordDate, e));
                        }
                    }
                }
                if (singleBatchSize != count) continue;
                singleBatchMap = ClearDayLogTask.getClearOperateDetailLogIdBatchs(operateIdCache, shemeIdCache);
                singleBatchSize = singleBatchMap.size();
                detialIter = singleBatchMap.entrySet().iterator();
                count = 0;
            }
        }
        catch (Exception e) {
            String startRecordDate = ClearDayLogTask.getPastDate(0);
            logger.error(String.format("ClearDayLogTask-\u7cfb\u7edf\u4e8e[%s]\u5220\u9664\u667a\u80fd\u6838\u7b97\u64cd\u4f5c\u65e5\u5fd7\u660e\u7ec6\u6570\u636e\u51fa\u9519\uff0c\u539f\u56e0\uff1a%s", startRecordDate, e));
            throw e;
        }
    }

    private static String getPastDate(int past) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(6, calendar.get(6) - past);
        Date today = calendar.getTime();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return df.format(today);
    }

    public static Set<Long> getClearSchemeSumLogId(Date today) {
        HashSet<Long> ret = new HashSet<Long>();
        QFilter timeFilter = new QFilter("execenddate", "<", (Object)today);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"ClearDayLogTask.getClearSchemeSumLogId", (String)ENTITY_IEP_SCHEMESUMLOG, (String)"id", (QFilter[])new QFilter[]{timeFilter}, null, (int)1000);){
            Iterator iter = ds.iterator();
            while (iter != null && iter.hasNext()) {
                Row row = (Row)iter.next();
                ret.add(row.getLong("id"));
            }
        }
        return ret;
    }

    public static Map<Long, Set<Long>> getClearOperateLogId(Set<Long> sumLogIds) {
        HashMap<Long, Set<Long>> ret = new HashMap<Long, Set<Long>>();
        QFilter idFilter = new QFilter("schemasumlogid", "in", sumLogIds);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"ClearDayLogTask.getClearOperateLogId", (String)ENTITY_IEP_INTELOPERSUMLOG, (String)"id,schemasumlogid", (QFilter[])new QFilter[]{idFilter}, null);){
            Iterator iter = ds.iterator();
            while (iter != null && iter.hasNext()) {
                Row row = (Row)iter.next();
                Long schemasumlogid = row.getLong("schemasumlogid");
                Long id = row.getLong("id");
                ret.computeIfAbsent(schemasumlogid, p -> new HashSet()).add(id);
            }
        }
        return ret;
    }

    public static Set<Long> getClearOperateLogIdBatch(Set<Long> operateLogIds) {
        HashSet<Long> ret = new HashSet<Long>();
        Iterator<Long> iter = operateLogIds.iterator();
        for (int count = 0; iter != null && iter.hasNext() && count != 1000; ++count) {
            ret.add(iter.next());
        }
        return ret;
    }

    public static Set<Long> getClearOperateDetailLogIdBatch(Set<Long> operateIdCache, Set<Long> shemeIdCache) {
        HashSet<Long> ret = new HashSet<Long>();
        QFilter execschemaFilter = new QFilter("schemasumlogid", "in", shemeIdCache);
        QFilter execOperFilter = new QFilter("opersumlogid", "in", operateIdCache);
        try (DataSet detalDs = LogORMHelper.queryDataSet((String)ENTITY_IEP_INTELEXECDETAILNEW, (String)"id", (QFilter[])new QFilter[]{execschemaFilter, execOperFilter}, (int)1000, (int)0);){
            Iterator iter = detalDs.iterator();
            while (iter != null && iter.hasNext()) {
                ret.add(((Row)iter.next()).getLong("id"));
            }
        }
        return ret;
    }

    public static Map<Long, Long> getClearOperateDetailLogIdBatchs(Set<Long> operateIdCache, Set<Long> shemeIdCache) {
        HashMap<Long, Long> retMap = new HashMap<Long, Long>(16);
        QFilter execschemaFilter = new QFilter("schemasumlogid", "in", shemeIdCache);
        QFilter execOperFilter = new QFilter("opersumlogid", "in", operateIdCache);
        try (DataSet detalDs = LogORMHelper.queryDataSet((String)ENTITY_IEP_INTELEXECDETAILNEW, (String)"id,intelschemaid", (QFilter[])new QFilter[]{execschemaFilter, execOperFilter}, (int)1000, (int)0);){
            for (Row detal : detalDs) {
                retMap.put(detal.getLong("id"), detal.getLong("intelschemaid"));
            }
        }
        return retMap;
    }
}

